/*
 * Decompiled with CFR 0.152.
 */
package com.android.mkstubs;

import com.android.mkstubs.AsmAnalyzer;
import com.android.mkstubs.Filter;
import com.android.mkstubs.SourceGenerator;
import com.android.mkstubs.StubGenerator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import org.objectweb.asm.ClassReader;

public class Main {
    public static void main(String[] args) {
        Main m = new Main();
        try {
            Params p = m.processArgs(args);
            m.process(p);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Params processArgs(String[] args) throws IOException {
        Params p = new Params();
        for (String arg : args) {
            if (arg.startsWith("--")) {
                if (arg.startsWith("--v")) {
                    p.setVerbose();
                    continue;
                }
                if (arg.startsWith("--s")) {
                    p.setDumpSource();
                    continue;
                }
                if (arg.startsWith("--h")) {
                    this.usage(null);
                    continue;
                }
                this.usage("Unknown argument: " + arg);
                continue;
            }
            if (p.getInputJarPath() == null) {
                p.setInputJarPath(arg);
                continue;
            }
            if (p.getOutputJarPath() == null) {
                p.setOutputJarPath(arg);
                continue;
            }
            this.addString(p, arg);
        }
        if (p.getInputJarPath() == null && p.getOutputJarPath() == null) {
            this.usage("Missing input or output JAR.");
        }
        return p;
    }

    private void addString(Params p, String s) throws IOException {
        if (s == null) {
            return;
        }
        if ((s = s.trim()).length() < 2) {
            return;
        }
        char mode = s.charAt(0);
        s = s.substring(1).trim();
        if (mode == '@') {
            this.addStringsFromFile(p, s);
        } else if (mode == '-') {
            if ((s = s.replace('.', '/')).endsWith("*")) {
                p.getFilter().getExcludePrefix().add(s.substring(0, s.length() - 1));
            } else {
                p.getFilter().getExcludeFull().add(s);
            }
        } else if (mode == '+') {
            if ((s = s.replace('.', '/')).endsWith("*")) {
                p.getFilter().getIncludePrefix().add(s.substring(0, s.length() - 1));
            } else {
                p.getFilter().getIncludeFull().add(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStringsFromFile(Params p, String osFilePath) throws IOException {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(osFilePath));
            while ((line = br.readLine()) != null) {
                this.addString(p, line);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    private void usage(String error) {
        if (error != null) {
            System.out.println("ERROR: " + error);
        }
        System.out.println("Usage: mkstub [--h|--s|--v] input.jar output.jar [excluded-class @excluded-classes-file ...]");
        System.out.println("Options:\n --h | --help    : print this usage.\n --v | --verbose : verbose mode.\n --s | --source  : dump source equivalent to modified byte code.\n\n");
        System.out.println("Include syntax:\n+com.package.* : whole package, with glob\n+com.package.Class[$Inner] or ...Class*: whole classes with optional glob\nInclusion is not supported at method/field level.\n\n");
        System.out.println("Exclude syntax:\n-com.package.* : whole package, with glob\n-com.package.Class[$Inner] or ...Class*: whole classes with optional glob\n-com.package.Class#method: whole method or field\n-com.package.Class#method(IILjava/lang/String;)V: specific method with signature.\n\n");
        System.exit(1);
    }

    private void process(Params p) throws IOException {
        AsmAnalyzer aa = new AsmAnalyzer();
        Map<String, ClassReader> classes = aa.parseInputJar(p.getInputJarPath());
        Logger log = new Logger(p.isVerbose());
        log.info("Classes loaded: %d", classes.size());
        aa.filter(classes, p.getFilter(), log);
        log.info("Classes filtered: %d", classes.size());
        if (p.isDumpSource()) {
            SourceGenerator src_gen = new SourceGenerator(log);
            File dst_src_dir = new File(p.getOutputJarPath() + "_sources");
            dst_src_dir.mkdir();
            src_gen.generateSource(dst_src_dir, classes, p.getFilter());
        }
        StubGenerator stub_gen = new StubGenerator(log);
        File dst_jar = new File(p.getOutputJarPath());
        stub_gen.generateStubbedJar(dst_jar, classes, p.getFilter());
    }

    static class Logger {
        private final boolean mVerbose;

        public Logger(boolean verbose) {
            this.mVerbose = verbose;
        }

        public void debug(String msg, Object ... params) {
            if (this.mVerbose) {
                System.out.println(String.format(msg, params));
            }
        }

        public void info(String msg, Object ... params) {
            System.out.println(String.format(msg, params));
        }
    }

    static class Params {
        private String mInputJarPath;
        private String mOutputJarPath;
        private Filter mFilter = new Filter();
        private boolean mVerbose;
        private boolean mDumpSource;

        public void setInputJarPath(String inputJarPath) {
            this.mInputJarPath = inputJarPath;
        }

        public void setOutputJarPath(String outputJarPath) {
            this.mOutputJarPath = outputJarPath;
        }

        public String getInputJarPath() {
            return this.mInputJarPath;
        }

        public String getOutputJarPath() {
            return this.mOutputJarPath;
        }

        public Filter getFilter() {
            return this.mFilter;
        }

        public void setVerbose() {
            this.mVerbose = true;
        }

        public boolean isVerbose() {
            return this.mVerbose;
        }

        public void setDumpSource() {
            this.mDumpSource = true;
        }

        public boolean isDumpSource() {
            return this.mDumpSource;
        }
    }
}

