/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.dict;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeBinaryDictionary {
    public static final int ALPHA_SIZE = 256;
    public static final String TAG_WORD = "w";
    public static final String ATTR_FREQ = "f";
    private static final int FLAG_ADDRESS_MASK = 0x400000;
    private static final int FLAG_TERMINAL_MASK = 0x800000;
    private static final int ADDRESS_MASK = 0x3FFFFF;
    public static final CharNode EMPTY_NODE = new CharNode();
    List<CharNode> roots;
    Map<String, Integer> mDictionary;
    int mWordCount;
    byte[] dict;
    int dictSize;
    static final int CHAR_WIDTH = 8;
    static final int FLAGS_WIDTH = 1;
    static final int ADDR_WIDTH = 23;
    static final int FREQ_WIDTH_BYTES = 1;
    static final int COUNT_WIDTH_BYTES = 1;
    int nullChildrenCount = 0;
    int notTerminalCount = 0;

    public static void usage() {
        System.err.println("Usage: makedict <src.xml> <dest.dict>");
        System.exit(-1);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            MakeBinaryDictionary.usage();
        } else {
            new MakeBinaryDictionary(args[0], args[1]);
        }
    }

    public MakeBinaryDictionary(String srcFilename, String destFilename) {
        this.populateDictionary(srcFilename);
        this.writeToDict(destFilename);
    }

    private void populateDictionary(String filename) {
        this.roots = new ArrayList<CharNode>();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(new File(filename), new DefaultHandler(){
                boolean inWord;
                int freq;
                StringBuilder wordBuilder = new StringBuilder(48);

                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    if (qName.equals(MakeBinaryDictionary.TAG_WORD)) {
                        this.inWord = true;
                        this.freq = Integer.parseInt(attributes.getValue(0));
                        this.wordBuilder.setLength(0);
                    }
                }

                public void characters(char[] data, int offset, int length) {
                    if (!this.inWord) {
                        return;
                    }
                    this.wordBuilder.append(data, offset, length);
                }

                public void endElement(String uri, String localName, String qName) {
                    if (qName.equals(MakeBinaryDictionary.TAG_WORD)) {
                        if (this.wordBuilder.length() > 1) {
                            MakeBinaryDictionary.this.addWordTop(this.wordBuilder.toString(), this.freq);
                            ++MakeBinaryDictionary.this.mWordCount;
                        }
                        this.inWord = false;
                    }
                }
            });
        }
        catch (Exception ioe) {
            System.err.println("Exception in parsing\n" + ioe);
            ioe.printStackTrace();
        }
        System.out.println("Nodes = " + CharNode.sNodes);
    }

    private int indexOf(List<CharNode> children, char c) {
        if (children == null) {
            return -1;
        }
        for (int i = 0; i < children.size(); ++i) {
            if (children.get((int)i).data != c) continue;
            return i;
        }
        return -1;
    }

    private void addWordTop(String word, int occur) {
        char firstChar;
        int index;
        if (occur > 255) {
            occur = 255;
        }
        if ((index = this.indexOf(this.roots, firstChar = word.charAt(0))) == -1) {
            CharNode newNode = new CharNode();
            newNode.data = firstChar;
            newNode.freq = occur;
            index = this.roots.size();
            this.roots.add(newNode);
        } else {
            this.roots.get((int)index).freq += occur;
        }
        if (word.length() > 1) {
            this.addWordRec(this.roots.get(index), word, 1, occur);
        } else {
            this.roots.get((int)index).terminal = true;
        }
    }

    private void addWordRec(CharNode parent, String word, int charAt, int occur) {
        CharNode child = null;
        char data = word.charAt(charAt);
        if (parent.children == null) {
            parent.children = new ArrayList<CharNode>();
        } else {
            for (int i = 0; i < parent.children.size(); ++i) {
                CharNode node = parent.children.get(i);
                if (node.data != data) continue;
                child = node;
                break;
            }
        }
        if (child == null) {
            child = new CharNode();
            parent.children.add(child);
        }
        child.data = data;
        if (child.freq == 0) {
            child.freq = occur;
        }
        if (word.length() > charAt + 1) {
            this.addWordRec(child, word, charAt + 1, occur);
        } else {
            child.terminal = true;
            child.freq = occur;
        }
    }

    private void addCount(int count) {
        this.dict[this.dictSize++] = (byte)(0xFF & count);
    }

    private void addNode(CharNode node) {
        int charData = 0xFFFF & node.data;
        if (charData > 254) {
            this.dict[this.dictSize++] = -1;
            this.dict[this.dictSize++] = (byte)(node.data >> 8 & 0xFF);
            this.dict[this.dictSize++] = (byte)(node.data & 0xFF);
        } else {
            this.dict[this.dictSize++] = (byte)(0xFF & node.data);
        }
        this.dictSize = node.children != null ? (this.dictSize += 3) : ++this.dictSize;
        if ((0xFFFFFF & node.freq) > 255) {
            node.freq = 255;
        }
        if (node.terminal) {
            byte freq = (byte)(0xFF & node.freq);
            this.dict[this.dictSize++] = freq;
        }
    }

    private void updateNodeAddress(int nodeAddress, CharNode node, int childrenAddress) {
        if ((this.dict[nodeAddress] & 0xFF) == 255) {
            nodeAddress += 2;
        }
        if ((childrenAddress = 0x3FFFFF & childrenAddress) == 0) {
            ++this.nullChildrenCount;
        } else {
            childrenAddress |= 0x400000;
        }
        if (node.terminal) {
            childrenAddress |= 0x800000;
        } else {
            ++this.notTerminalCount;
        }
        this.dict[nodeAddress + 1] = (byte)(childrenAddress >> 16);
        if ((childrenAddress & 0x400000) != 0) {
            this.dict[nodeAddress + 2] = (byte)((childrenAddress & 0xFF00) >> 8);
            this.dict[nodeAddress + 3] = (byte)(childrenAddress & 0xFF);
        }
    }

    void writeWordsRec(List<CharNode> children) {
        CharNode node;
        int j;
        if (children == null || children.size() == 0) {
            return;
        }
        int childCount = children.size();
        this.addCount(childCount);
        int[] childrenAddresses = new int[childCount];
        for (j = 0; j < childCount; ++j) {
            node = children.get(j);
            childrenAddresses[j] = this.dictSize;
            this.addNode(node);
        }
        for (j = 0; j < childCount; ++j) {
            node = children.get(j);
            int nodeAddress = childrenAddresses[j];
            int cacheDictSize = this.dictSize;
            this.writeWordsRec(node.children);
            this.updateNodeAddress(nodeAddress, node, node.children != null ? cacheDictSize : 0);
        }
    }

    void writeToDict(String dictFilename) {
        this.dict = new byte[0x400000];
        this.dictSize = 0;
        this.writeWordsRec(this.roots);
        System.out.println("Dict Size = " + this.dictSize);
        try {
            FileOutputStream fos = new FileOutputStream(dictFilename);
            fos.write(this.dict, 0, this.dictSize);
            fos.close();
        }
        catch (IOException ioe) {
            System.err.println("Error writing dict file:" + ioe);
        }
    }

    void traverseDict(int pos, char[] word, int depth) {
        int count = this.dict[pos++] & 0xFF;
        for (int i = 0; i < count; ++i) {
            char c;
            if ((c = (char)(this.dict[pos++] & 0xFF)) == '\u00ff') {
                c = (char)((this.dict[pos] & 0xFF) << 8 | this.dict[pos + 1] & 0xFF);
                pos += 2;
            }
            word[depth] = c;
            boolean terminal = (this.dict[pos] & 0x80) > 0;
            int address = 0;
            if ((this.dict[pos] & 0x40) > 0) {
                address = (this.dict[pos + 0] & 0x40) << 16 | (this.dict[pos + 1] & 0xFF) << 8 | this.dict[pos + 2] & 0xFF;
                pos += 2;
            }
            ++pos;
            if (terminal) {
                this.showWord(word, depth + 1, this.dict[pos] & 0xFF);
                ++pos;
            }
            if (address == 0) continue;
            this.traverseDict(address, word, depth + 1);
        }
    }

    void showWord(char[] word, int size, int freq) {
        System.out.print(new String(word, 0, size) + " " + freq + "\n");
    }

    static class CharNode {
        char data;
        int freq;
        boolean terminal;
        List<CharNode> children;
        static int sNodes;

        public CharNode() {
            ++sNodes;
        }
    }
}

