/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.layoutlib.create;

import com.android.tools.layoutlib.create.Log;
import com.android.tools.layoutlib.create.StubMethodAdapter;
import java.util.Set;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransformClassAdapter
extends ClassAdapter {
    private final boolean mStubAll;
    private boolean mIsInterface;
    private final String mClassName;
    private final Log mLog;
    private final Set<String> mStubMethods;
    private Set<String> mDeleteReturns;

    public TransformClassAdapter(Log logger, Set<String> stubMethods, Set<String> deleteReturns, String className, ClassVisitor cv, boolean stubNativesOnly, boolean hasNative) {
        super(cv);
        this.mLog = logger;
        this.mStubMethods = stubMethods;
        this.mClassName = className;
        this.mStubAll = !stubNativesOnly;
        this.mIsInterface = false;
        this.mDeleteReturns = deleteReturns;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        name = this.mClassName;
        access &= 0xFFFFFFF9;
        access |= 1;
        this.mIsInterface = ((access &= 0xFFFFFFEF) & 0x200) != 0;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        access &= 0xFFFFFFF9;
        access |= 1;
        super.visitInnerClass(name, outerName, innerName, access &= 0xFFFFFFEF);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String returnType;
        Type t;
        if (this.mDeleteReturns != null && (t = Type.getReturnType(desc)).getSort() == 10 && (returnType = t.getInternalName()) != null && this.mDeleteReturns.contains(returnType)) {
            return null;
        }
        String methodSignature = this.mClassName.replace('/', '.') + "#" + name;
        access &= 0xFFFFFFF9;
        access |= 1;
        if (!this.mIsInterface && ((access &= 0xFFFFFFEF) & 0x500) != 1024 && (this.mStubAll || (access & 0x100) != 0) || this.mStubMethods.contains(methodSignature)) {
            boolean isStatic = (access & 8) != 0;
            boolean isNative = (access & 0x100) != 0;
            String invokeSignature = methodSignature + desc;
            this.mLog.debug("  Stub: %s (%s)", invokeSignature, isNative ? "native" : "");
            MethodVisitor mw = super.visitMethod(access &= 0xFFFFFAEF, name, desc, signature, exceptions);
            return new StubMethodAdapter(mw, name, this.returnType(desc), invokeSignature, isStatic, isNative);
        }
        this.mLog.debug("  Keep: %s %s", name, desc);
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        access &= 0xFFFFFFF9;
        return super.visitField(access |= 1, name, desc, signature, value);
    }

    Type returnType(String desc) {
        if (desc != null) {
            try {
                return Type.getReturnType(desc);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }
}

