/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.layoutlib.create;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class StubMethodAdapter
implements MethodVisitor {
    private static String CONSTRUCTOR = "<init>";
    private static String CLASS_INIT = "<clinit>";
    private MethodVisitor mParentVisitor;
    private Type mReturnType;
    private String mInvokeSignature;
    private boolean mOutputFirstLineNumber = true;
    private boolean mIsInitMethod = false;
    private boolean mMessageGenerated;
    private final boolean mIsStatic;
    private final boolean mIsNative;

    public StubMethodAdapter(MethodVisitor mv, String methodName, Type returnType, String invokeSignature, boolean isStatic, boolean isNative) {
        this.mParentVisitor = mv;
        this.mReturnType = returnType;
        this.mInvokeSignature = invokeSignature;
        this.mIsStatic = isStatic;
        this.mIsNative = isNative;
        if (CONSTRUCTOR.equals(methodName) || CLASS_INIT.equals(methodName)) {
            this.mIsInitMethod = true;
        }
    }

    private void generateInvoke() {
        this.mParentVisitor.visitLdcInsn(this.mInvokeSignature);
        this.mParentVisitor.visitInsn(this.mIsNative ? 4 : 3);
        if (this.mIsStatic) {
            this.mParentVisitor.visitInsn(1);
        } else {
            this.mParentVisitor.visitVarInsn(25, 0);
        }
        int sort = this.mReturnType != null ? this.mReturnType.getSort() : 0;
        switch (sort) {
            case 0: {
                this.mParentVisitor.visitMethodInsn(184, "com/android/tools/layoutlib/create/OverrideMethod", "invokeV", "(Ljava/lang/String;ZLjava/lang/Object;)V");
                this.mParentVisitor.visitInsn(177);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.mParentVisitor.visitMethodInsn(184, "com/android/tools/layoutlib/create/OverrideMethod", "invokeI", "(Ljava/lang/String;ZLjava/lang/Object;)I");
                switch (sort) {
                    case 1: {
                        Label l1 = new Label();
                        this.mParentVisitor.visitJumpInsn(153, l1);
                        this.mParentVisitor.visitInsn(4);
                        this.mParentVisitor.visitInsn(172);
                        this.mParentVisitor.visitLabel(l1);
                        this.mParentVisitor.visitInsn(3);
                        break;
                    }
                    case 2: {
                        this.mParentVisitor.visitInsn(146);
                        break;
                    }
                    case 3: {
                        this.mParentVisitor.visitInsn(145);
                        break;
                    }
                    case 4: {
                        this.mParentVisitor.visitInsn(147);
                    }
                }
                this.mParentVisitor.visitInsn(172);
                break;
            }
            case 7: {
                this.mParentVisitor.visitMethodInsn(184, "com/android/tools/layoutlib/create/OverrideMethod", "invokeL", "(Ljava/lang/String;ZLjava/lang/Object;)J");
                this.mParentVisitor.visitInsn(173);
                break;
            }
            case 6: {
                this.mParentVisitor.visitMethodInsn(184, "com/android/tools/layoutlib/create/OverrideMethod", "invokeF", "(Ljava/lang/String;ZLjava/lang/Object;)F");
                this.mParentVisitor.visitInsn(174);
                break;
            }
            case 8: {
                this.mParentVisitor.visitMethodInsn(184, "com/android/tools/layoutlib/create/OverrideMethod", "invokeD", "(Ljava/lang/String;ZLjava/lang/Object;)D");
                this.mParentVisitor.visitInsn(175);
                break;
            }
            case 9: 
            case 10: {
                this.mParentVisitor.visitMethodInsn(184, "com/android/tools/layoutlib/create/OverrideMethod", "invokeA", "(Ljava/lang/String;ZLjava/lang/Object;)Ljava/lang/Object;");
                this.mParentVisitor.visitTypeInsn(192, this.mReturnType.getInternalName());
                this.mParentVisitor.visitInsn(176);
            }
        }
    }

    private void generatePop() {
        switch (this.mReturnType != null ? this.mReturnType.getSort() : 0) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                this.mParentVisitor.visitInsn(87);
                break;
            }
            case 7: 
            case 8: {
                this.mParentVisitor.visitInsn(88);
            }
        }
    }

    public void visitCode() {
        this.mParentVisitor.visitCode();
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        if (!this.mIsInitMethod && !this.mMessageGenerated) {
            this.generateInvoke();
            this.mMessageGenerated = true;
        }
        this.mParentVisitor.visitMaxs(maxStack, maxLocals);
    }

    public void visitEnd() {
        if (!this.mIsInitMethod && !this.mMessageGenerated) {
            this.generateInvoke();
            this.mMessageGenerated = true;
            this.mParentVisitor.visitMaxs(1, 1);
        }
        this.mParentVisitor.visitEnd();
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return this.mParentVisitor.visitAnnotation(desc, visible);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return this.mParentVisitor.visitAnnotationDefault();
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return this.mParentVisitor.visitParameterAnnotation(parameter, desc, visible);
    }

    public void visitAttribute(Attribute attr) {
        this.mParentVisitor.visitAttribute(attr);
    }

    public void visitLineNumber(int line, Label start) {
        if (this.mIsInitMethod || this.mOutputFirstLineNumber) {
            this.mParentVisitor.visitLineNumber(line, start);
            this.mOutputFirstLineNumber = false;
        }
    }

    public void visitInsn(int opcode) {
        if (this.mIsInitMethod) {
            switch (opcode) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    this.generatePop();
                    this.generateInvoke();
                    this.mMessageGenerated = true;
                }
            }
            this.mParentVisitor.visitInsn(opcode);
        }
    }

    public void visitLabel(Label label) {
        if (this.mIsInitMethod) {
            this.mParentVisitor.visitLabel(label);
        }
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (this.mIsInitMethod) {
            this.mParentVisitor.visitTryCatchBlock(start, end, handler, type);
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (this.mIsInitMethod) {
            this.mParentVisitor.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (this.mIsInitMethod) {
            this.mParentVisitor.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        if (this.mIsInitMethod) {
            this.mParentVisitor.visitFrame(type, nLocal, local, nStack, stack);
        }
    }

    public void visitIincInsn(int var, int increment) {
        if (this.mIsInitMethod) {
            this.mParentVisitor.visitIincInsn(var, increment);
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        if (this.mIsInitMethod) {
            this.mParentVisitor.visitIntInsn(opcode, operand);
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (this.mIsInitMethod) {
            this.mParentVisitor.visitJumpInsn(opcode, label);
        }
    }

    public void visitLdcInsn(Object cst) {
        if (this.mIsInitMethod) {
            this.mParentVisitor.visitLdcInsn(cst);
        }
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (this.mIsInitMethod) {
            this.mParentVisitor.visitLocalVariable(name, desc, signature, start, end, index);
        }
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        if (this.mIsInitMethod) {
            this.mParentVisitor.visitLookupSwitchInsn(dflt, keys, labels);
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        if (this.mIsInitMethod) {
            this.mParentVisitor.visitMultiANewArrayInsn(desc, dims);
        }
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        if (this.mIsInitMethod) {
            this.mParentVisitor.visitTableSwitchInsn(min, max, dflt, labels);
        }
    }

    public void visitTypeInsn(int opcode, String type) {
        if (this.mIsInitMethod) {
            this.mParentVisitor.visitTypeInsn(opcode, type);
        }
    }

    public void visitVarInsn(int opcode, int var) {
        if (this.mIsInitMethod) {
            this.mParentVisitor.visitVarInsn(opcode, var);
        }
    }
}

