/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.layoutlib.create;

import java.io.PrintWriter;
import java.io.StringWriter;

public class Log {
    private boolean mVerbose = false;

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    public void debug(String format, Object ... args) {
        if (this.mVerbose) {
            this.info(format, args);
        }
    }

    public void info(String format, Object ... args) {
        String s = String.format(format, args);
        this.outPrintln(s);
    }

    public void error(String format, Object ... args) {
        String s = String.format(format, args);
        this.errPrintln(s);
    }

    public void exception(Throwable t, String format, Object ... args) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        this.error(format + "\n" + sw.toString(), args);
    }

    protected void errPrintln(String msg) {
        System.err.println(msg);
    }

    protected void outPrintln(String msg) {
        System.out.println(msg);
    }
}

