/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.layoutlib.create;

import com.android.tools.layoutlib.create.ClassHasNativeVisitor;
import com.android.tools.layoutlib.create.DelegateClassAdapter;
import com.android.tools.layoutlib.create.ICreateInfo;
import com.android.tools.layoutlib.create.Log;
import com.android.tools.layoutlib.create.RenameClassAdapter;
import com.android.tools.layoutlib.create.TransformClassAdapter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmGenerator {
    private final Log mLog;
    private final String mOsDestJar;
    private final Class<?>[] mInjectClasses;
    private final Set<String> mStubMethods;
    private Map<String, ClassReader> mKeep;
    private Map<String, ClassReader> mDeps;
    private int mRenameCount;
    private final HashMap<String, String> mRenameClasses;
    private HashSet<String> mClassesNotRenamed;
    private HashMap<String, Set<String>> mDeleteReturns;
    private final HashMap<String, Set<String>> mDelegateMethods;

    public AsmGenerator(Log log, String osDestJar, ICreateInfo createInfo) {
        this.mLog = log;
        this.mOsDestJar = osDestJar;
        this.mInjectClasses = createInfo.getInjectedClasses();
        this.mStubMethods = new HashSet<String>(Arrays.asList(createInfo.getOverriddenMethods()));
        this.mDelegateMethods = new HashMap();
        for (String signature : createInfo.getDelegateMethods()) {
            int pos = signature.indexOf(35);
            if (pos <= 0 || pos >= signature.length() - 1) continue;
            String className = this.binaryToInternalClassName(signature.substring(0, pos));
            String methodName = signature.substring(pos + 1);
            Set<String> methods = this.mDelegateMethods.get(className);
            if (methods == null) {
                methods = new HashSet<String>();
                this.mDelegateMethods.put(className, methods);
            }
            methods.add(methodName);
        }
        for (String className : createInfo.getDelegateClassNatives()) {
            Set<String> methods = this.mDelegateMethods.get(className = this.binaryToInternalClassName(className));
            if (methods == null) {
                methods = new HashSet<String>();
                this.mDelegateMethods.put(className, methods);
            }
            methods.add("<<all_natives>>");
        }
        this.mRenameClasses = new HashMap();
        this.mClassesNotRenamed = new HashSet();
        String[] renameClasses = createInfo.getRenamedClasses();
        int n = renameClasses.length;
        for (int i = 0; i < n; i += 2) {
            assert (i + 1 < n);
            String oldFqcn = this.binaryToInternalClassName(renameClasses[i]);
            String newFqcn = this.binaryToInternalClassName(renameClasses[i + 1]);
            this.mRenameClasses.put(oldFqcn, newFqcn);
            this.mClassesNotRenamed.add(oldFqcn);
        }
        this.mDeleteReturns = new HashMap();
        String[] deleteReturns = createInfo.getDeleteReturns();
        HashSet<String> returnTypes = null;
        String renamedClass = null;
        for (String className : deleteReturns) {
            if (className == null) {
                if (returnTypes != null) {
                    this.mDeleteReturns.put(renamedClass, returnTypes);
                }
                renamedClass = null;
                continue;
            }
            if (renamedClass == null) {
                renamedClass = this.binaryToInternalClassName(className);
                continue;
            }
            if (returnTypes == null) {
                returnTypes = new HashSet<String>();
            }
            returnTypes.add(this.binaryToInternalClassName(className));
        }
    }

    public Set<String> getClassesNotRenamed() {
        return this.mClassesNotRenamed;
    }

    String binaryToInternalClassName(String className) {
        if (className == null) {
            return null;
        }
        return className.replace('.', '/');
    }

    public void setKeep(Map<String, ClassReader> keep) {
        this.mKeep = keep;
    }

    public void setDeps(Map<String, ClassReader> deps) {
        this.mDeps = deps;
    }

    public Map<String, ClassReader> getKeep() {
        return this.mKeep;
    }

    public Map<String, ClassReader> getDeps() {
        return this.mDeps;
    }

    public void generate() throws FileNotFoundException, IOException {
        byte[] b;
        String name;
        TreeMap<String, byte[]> all = new TreeMap<String, byte[]>();
        for (Class<?> clazz : this.mInjectClasses) {
            name = this.classToEntryPath(clazz);
            InputStream is = ClassLoader.getSystemResourceAsStream(name);
            ClassReader cr = new ClassReader(is);
            byte[] b2 = this.transform(cr, true);
            name = this.classNameToEntryPath(this.transformName(cr.getClassName()));
            all.put(name, b2);
        }
        for (Map.Entry<String, ClassReader> entry : this.mDeps.entrySet()) {
            ClassReader cr = entry.getValue();
            b = this.transform(cr, true);
            name = this.classNameToEntryPath(this.transformName(cr.getClassName()));
            all.put(name, b);
        }
        for (Map.Entry<String, ClassReader> entry : this.mKeep.entrySet()) {
            ClassReader cr = entry.getValue();
            b = this.transform(cr, true);
            name = this.classNameToEntryPath(this.transformName(cr.getClassName()));
            all.put(name, b);
        }
        this.mLog.info("# deps classes: %d", this.mDeps.size());
        this.mLog.info("# keep classes: %d", this.mKeep.size());
        this.mLog.info("# renamed     : %d", this.mRenameCount);
        this.createJar(new FileOutputStream(this.mOsDestJar), all);
        this.mLog.info("Created JAR file %s", this.mOsDestJar);
    }

    void createJar(FileOutputStream outStream, Map<String, byte[]> all) throws IOException {
        JarOutputStream jar = new JarOutputStream(outStream);
        for (Map.Entry<String, byte[]> entry : all.entrySet()) {
            String name = entry.getKey();
            JarEntry jar_entry = new JarEntry(name);
            jar.putNextEntry(jar_entry);
            jar.write(entry.getValue());
            jar.closeEntry();
        }
        jar.flush();
        jar.close();
    }

    String classNameToEntryPath(String className) {
        return className.replaceAll("\\.", "/").concat(".class");
    }

    private String classToEntryPath(Class<?> clazz) {
        Class<?> parent;
        String name = "";
        while ((parent = clazz.getEnclosingClass()) != null) {
            name = "$" + clazz.getSimpleName() + name;
            clazz = parent;
        }
        return this.classNameToEntryPath(clazz.getCanonicalName() + name);
    }

    byte[] transform(ClassReader cr, boolean stubNativesOnly) {
        ClassWriter cw;
        boolean hasNativeMethods = this.hasNativeMethods(cr);
        String className = cr.getClassName();
        String newName = this.transformName(className);
        if (newName != className) {
            ++this.mRenameCount;
            this.mClassesNotRenamed.remove(className);
        }
        this.mLog.debug("Transform %s%s%s%s", className, newName == className ? "" : " (renamed to " + newName + ")", hasNativeMethods ? " -- has natives" : "", stubNativesOnly ? " -- stub natives only" : "");
        ClassVisitor rv = cw = new ClassWriter(1);
        if (newName != className) {
            rv = new RenameClassAdapter(cw, className, newName);
        }
        ClassAdapter cv = new TransformClassAdapter(this.mLog, this.mStubMethods, this.mDeleteReturns.get(className), newName, rv, stubNativesOnly, stubNativesOnly || hasNativeMethods);
        Set<String> delegateMethods = this.mDelegateMethods.get(className);
        if (!(delegateMethods == null || delegateMethods.isEmpty() || !hasNativeMethods && delegateMethods.size() == 1 && delegateMethods.contains("<<all_natives>>"))) {
            cv = new DelegateClassAdapter(this.mLog, cv, className, delegateMethods);
        }
        cr.accept(cv, 0);
        return cw.toByteArray();
    }

    String transformName(String className) {
        String base;
        String newName = this.mRenameClasses.get(className);
        if (newName != null) {
            return newName;
        }
        int pos = className.indexOf(36);
        if (pos > 0 && (newName = this.mRenameClasses.get(base = className.substring(0, pos))) != null) {
            return newName + className.substring(pos);
        }
        return className;
    }

    boolean hasNativeMethods(ClassReader cr) {
        ClassHasNativeVisitor cv = new ClassHasNativeVisitor();
        cr.accept(cv, 0);
        return cv.hasNativeMethods();
    }
}

