/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.harmony.xnet.provider.jsse.CertificateMessage;
import org.apache.harmony.xnet.provider.jsse.CertificateRequest;
import org.apache.harmony.xnet.provider.jsse.CertificateVerify;
import org.apache.harmony.xnet.provider.jsse.CipherSuite;
import org.apache.harmony.xnet.provider.jsse.ClientHello;
import org.apache.harmony.xnet.provider.jsse.ClientKeyExchange;
import org.apache.harmony.xnet.provider.jsse.DHParameters;
import org.apache.harmony.xnet.provider.jsse.DelegatedTask;
import org.apache.harmony.xnet.provider.jsse.DigitalSignature;
import org.apache.harmony.xnet.provider.jsse.Finished;
import org.apache.harmony.xnet.provider.jsse.HandshakeProtocol;
import org.apache.harmony.xnet.provider.jsse.ProtocolVersion;
import org.apache.harmony.xnet.provider.jsse.SSLSessionImpl;
import org.apache.harmony.xnet.provider.jsse.SSLv3Constants;
import org.apache.harmony.xnet.provider.jsse.ServerHello;
import org.apache.harmony.xnet.provider.jsse.ServerHelloDone;
import org.apache.harmony.xnet.provider.jsse.ServerKeyExchange;

public class ServerHandshakeImpl
extends HandshakeProtocol {
    public PrivateKey privKey;

    public ServerHandshakeImpl(Object owner) {
        super(owner);
        this.status = 1;
    }

    public void start() {
        if (this.session == null) {
            this.status = 1;
            return;
        }
        if (this.clientHello != null && this.status != 3) {
            return;
        }
        this.sendHelloRequest();
        this.status = 1;
    }

    /*
     * Unable to fully structure code
     */
    public void unwrap(byte[] bytes) {
        this.io_stream.append(bytes);
        block19: while (this.io_stream.available() > 0) {
            this.io_stream.mark();
            try {
                handshakeType = this.io_stream.read();
                length = this.io_stream.readUint24();
                if (this.io_stream.available() < length) {
                    this.io_stream.reset();
                    return;
                }
                switch (handshakeType) {
                    case 1: {
                        if (this.clientHello != null && this.status != 3) {
                            this.unexpectedMessage();
                            return;
                        }
                        this.needSendHelloRequest = false;
                        this.clientHello = new ClientHello(this.io_stream, length);
                        if (this.nonBlocking) {
                            this.delegatedTasks.add(new DelegatedTask(new PrivilegedExceptionAction<Void>(){

                                @Override
                                public Void run() throws Exception {
                                    ServerHandshakeImpl.this.processClientHello();
                                    return null;
                                }
                            }, this, AccessController.getContext()));
                            return;
                        }
                        this.processClientHello();
                        break;
                    }
                    case 11: {
                        if (this.isResuming || this.certificateRequest == null || this.serverHelloDone == null || this.clientCert != null) {
                            this.unexpectedMessage();
                            return;
                        }
                        this.clientCert = new CertificateMessage(this.io_stream, length);
                        if (this.clientCert.certs.length == 0) {
                            if (!this.parameters.getNeedClientAuth()) continue block19;
                            this.fatalAlert((byte)40, "HANDSHAKE FAILURE: no client certificate received");
                            break;
                        }
                        authType = this.clientCert.getAuthType();
                        try {
                            this.parameters.getTrustManager().checkClientTrusted(this.clientCert.certs, authType);
                        }
                        catch (CertificateException e) {
                            this.fatalAlert((byte)42, "Untrusted Client Certificate ", e);
                        }
                        this.session.peerCertificates = this.clientCert.certs;
                        break;
                    }
                    case 15: {
                        if (this.isResuming || this.clientKeyExchange == null || this.clientCert == null || this.clientKeyExchange.isEmpty() || this.certificateVerify != null || this.changeCipherSpecReceived) {
                            this.unexpectedMessage();
                            return;
                        }
                        this.certificateVerify = new CertificateVerify(this.io_stream, length);
                        authType = this.clientCert.getAuthType();
                        ds = new DigitalSignature(authType);
                        ds.init(this.clientCert.certs[0]);
                        md5_hash = null;
                        sha_hash = null;
                        if ("RSA".equals(authType)) {
                            md5_hash = this.io_stream.getDigestMD5withoutLast();
                            sha_hash = this.io_stream.getDigestSHAwithoutLast();
                        } else if ("DSA".equals(authType)) {
                            sha_hash = this.io_stream.getDigestSHAwithoutLast();
                        }
                        ds.setMD5(md5_hash);
                        ds.setSHA(sha_hash);
                        if (ds.verifySignature(this.certificateVerify.signedHash)) continue block19;
                        this.fatalAlert((byte)51, "DECRYPT ERROR: CERTIFICATE_VERIFY incorrect signature");
                        break;
                    }
                    case 16: {
                        if (this.isResuming || this.serverHelloDone == null || this.clientKeyExchange != null || this.clientCert == null && this.parameters.getNeedClientAuth()) {
                            this.unexpectedMessage();
                            return;
                        }
                        if (this.session.cipherSuite.keyExchange != 1 && this.session.cipherSuite.keyExchange != 2) ** GOTO lbl80
                        this.clientKeyExchange = new ClientKeyExchange(this.io_stream, length, this.serverHello.server_version[1] == 1, true);
                        c = null;
                        try {
                            c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                            c.init(2, this.privKey);
                            this.preMasterSecret = c.doFinal(this.clientKeyExchange.exchange_keys);
                            if (this.preMasterSecret.length != 48 || this.preMasterSecret[0] != this.clientHello.client_version[0] || this.preMasterSecret[1] != this.clientHello.client_version[1]) {
                                this.preMasterSecret = new byte[48];
                                this.parameters.getSecureRandom().nextBytes(this.preMasterSecret);
                            }
                            ** GOTO lbl105
                        }
                        catch (Exception e) {
                            this.fatalAlert((byte)80, "INTERNAL ERROR", e);
                        }
                        ** GOTO lbl105
lbl80:
                        // 1 sources

                        this.clientKeyExchange = new ClientKeyExchange(this.io_stream, length, this.serverHello.server_version[1] == 1, false);
                        if (this.clientKeyExchange.isEmpty()) {
                            this.preMasterSecret = ((DHPublicKey)this.clientCert.certs[0].getPublicKey()).getY().toByteArray();
                        } else {
                            try {
                                kf = null;
                                try {
                                    kf = KeyFactory.getInstance("DH");
                                }
                                catch (NoSuchAlgorithmException ee) {
                                    kf = KeyFactory.getInstance("DiffieHellman");
                                }
                                try {
                                    agreement = KeyAgreement.getInstance("DH");
                                }
                                catch (NoSuchAlgorithmException ee) {
                                    agreement = KeyAgreement.getInstance("DiffieHellman");
                                }
                                clientPublic = kf.generatePublic(new DHPublicKeySpec(new BigInteger(1, this.clientKeyExchange.exchange_keys), this.serverKeyExchange.par1, this.serverKeyExchange.par2));
                                agreement.init(this.privKey);
                                agreement.doPhase(clientPublic, true);
                                this.preMasterSecret = agreement.generateSecret();
                            }
                            catch (Exception e) {
                                this.fatalAlert((byte)80, "INTERNAL ERROR", e);
                                return;
                            }
                        }
lbl105:
                        // 5 sources

                        this.computerMasterSecret();
                        break;
                    }
                    case 20: {
                        if (!this.isResuming && !this.changeCipherSpecReceived) {
                            this.unexpectedMessage();
                            return;
                        }
                        this.clientFinished = new Finished(this.io_stream, length);
                        this.verifyFinished(this.clientFinished.getData());
                        this.session.context = this.parameters.getServerSessionContext();
                        this.parameters.getServerSessionContext().putSession(this.session);
                        if (!this.isResuming) {
                            this.sendChangeCipherSpec();
                            break;
                        }
                        this.session.lastAccessedTime = System.currentTimeMillis();
                        this.status = 3;
                        break;
                    }
                    default: {
                        this.unexpectedMessage();
                        return;
                    }
                }
            }
            catch (IOException e) {
                this.io_stream.reset();
                return;
            }
        }
    }

    public void unwrapSSLv2(byte[] bytes) {
        this.io_stream.append(bytes);
        this.io_stream.mark();
        try {
            this.clientHello = new ClientHello(this.io_stream);
        }
        catch (IOException e) {
            this.io_stream.reset();
            return;
        }
        if (this.nonBlocking) {
            this.delegatedTasks.add(new DelegatedTask(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    ServerHandshakeImpl.this.processClientHello();
                    return null;
                }
            }, this, AccessController.getContext()));
            return;
        }
        this.processClientHello();
    }

    /*
     * Unable to fully structure code
     */
    public void processClientHello() {
        block53: {
            block52: {
                block51: {
                    block54: {
                        block50: {
                            for (i = 0; i < this.clientHello.compression_methods.length; ++i) {
                                if (this.clientHello.compression_methods[i] != 0) {
                                    continue;
                                }
                                break block50;
                            }
                            this.fatalAlert((byte)40, "HANDSHAKE FAILURE. Incorrect client hello message");
                        }
                        if (!ProtocolVersion.isSupported(this.clientHello.client_version)) {
                            this.fatalAlert((byte)70, "PROTOCOL VERSION. Unsupported client version " + this.clientHello.client_version[0] + this.clientHello.client_version[1]);
                        }
                        this.isResuming = false;
                        if (this.clientHello.session_id.length == 0) break block54;
                        reuseCurrent = false;
                        if (this.session == null || !Arrays.equals(this.session.id, this.clientHello.session_id)) ** GOTO lbl17
                        if (this.session.isValid()) {
                            this.isResuming = true;
                        } else {
                            reuseCurrent = true;
lbl17:
                            // 2 sources

                            if ((sessionToResume = this.findSessionToResume(this.clientHello.session_id)) == null || !sessionToResume.isValid()) {
                                if (!this.parameters.getEnableSessionCreation()) {
                                    if (reuseCurrent) {
                                        this.sendWarningAlert((byte)100);
                                        this.status = 2;
                                        this.clearMessages();
                                        return;
                                    }
                                    this.fatalAlert((byte)40, "SSL Session may not be created");
                                }
                                this.session = null;
                            } else {
                                this.session = (SSLSessionImpl)sessionToResume.clone();
                                this.isResuming = true;
                            }
                        }
                    }
                    if (this.isResuming) {
                        cipher_suite = this.session.cipherSuite;
                        for (i = 0; i < this.clientHello.cipher_suites.length; ++i) {
                            if (!cipher_suite.equals(this.clientHello.cipher_suites[i])) {
                                continue;
                            }
                            break block51;
                        }
                        this.fatalAlert((byte)40, "HANDSHAKE FAILURE. Incorrect client hello message");
                    } else {
                        cipher_suite = this.selectSuite(this.clientHello.cipher_suites);
                        if (cipher_suite == null) {
                            this.fatalAlert((byte)40, "HANDSHAKE FAILURE. NO COMMON SUITE");
                        }
                        if (!this.parameters.getEnableSessionCreation()) {
                            this.fatalAlert((byte)40, "SSL Session may not be created");
                        }
                        this.session = new SSLSessionImpl(cipher_suite, this.parameters.getSecureRandom());
                        if (this.engineOwner != null) {
                            this.session.setPeer(this.engineOwner.getPeerHost(), this.engineOwner.getPeerPort());
                        } else {
                            this.session.setPeer(this.socketOwner.getInetAddress().getHostName(), this.socketOwner.getPort());
                        }
                    }
                }
                this.recordProtocol.setVersion(this.clientHello.client_version);
                this.session.protocol = ProtocolVersion.getByVersion(this.clientHello.client_version);
                this.session.clientRandom = this.clientHello.random;
                this.serverHello = new ServerHello(this.parameters.getSecureRandom(), this.clientHello.client_version, this.session.getId(), cipher_suite, 0);
                this.session.serverRandom = this.serverHello.random;
                this.send(this.serverHello);
                if (this.isResuming) {
                    this.sendChangeCipherSpec();
                    return;
                }
                if (!cipher_suite.isAnonymous()) {
                    certs = null;
                    certType = null;
                    switch (cipher_suite.keyExchange) {
                        case 1: 
                        case 2: 
                        case 5: 
                        case 6: {
                            certType = "RSA";
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 11: {
                            certType = "DSA";
                            break;
                        }
                        case 7: {
                            certType = "DH_DSA";
                            break;
                        }
                        case 8: {
                            certType = "DH_RSA";
                            break;
                        }
                        default: {
                            this.fatalAlert((byte)40, "NO CERT TYPE FOR " + cipher_suite.getName());
                        }
                    }
                    alias = null;
                    km = this.parameters.getKeyManager();
                    if (km instanceof X509ExtendedKeyManager) {
                        ekm = (X509ExtendedKeyManager)km;
                        alias = this.socketOwner != null ? ekm.chooseServerAlias(certType, null, this.socketOwner) : ekm.chooseEngineServerAlias(certType, null, this.engineOwner);
                        if (alias != null) {
                            certs = ekm.getCertificateChain(alias);
                        }
                    } else {
                        alias = km.chooseServerAlias(certType, null, this.socketOwner);
                        if (alias != null) {
                            certs = km.getCertificateChain(alias);
                        }
                    }
                    if (certs == null) {
                        this.fatalAlert((byte)40, "NO SERVER CERTIFICATE FOUND");
                        return;
                    }
                    this.session.localCertificates = certs;
                    this.serverCert = new CertificateMessage(certs);
                    this.privKey = km.getPrivateKey(alias);
                    this.send(this.serverCert);
                }
                rsakey = null;
                dhkeySpec = null;
                hash = null;
                p = null;
                g = null;
                kpg = null;
                try {
                    if (cipher_suite.keyExchange == 2) {
                        pk = this.serverCert.certs[0].getPublicKey();
                        if (ServerHandshakeImpl.getRSAKeyLength(pk) > 512) {
                            kpg = KeyPairGenerator.getInstance("RSA");
                            kpg.initialize(512);
                        }
                        break block52;
                    }
                    if (cipher_suite.keyExchange != 3 && cipher_suite.keyExchange != 4 && cipher_suite.keyExchange != 5 && cipher_suite.keyExchange != 6 && cipher_suite.keyExchange != 9 && cipher_suite.keyExchange != 10) break block52;
                    try {
                        kpg = KeyPairGenerator.getInstance("DH");
                    }
                    catch (NoSuchAlgorithmException ee) {
                        kpg = KeyPairGenerator.getInstance("DiffieHellman");
                    }
                    p = new BigInteger(1, DHParameters.getPrime());
                    g = new BigInteger("2");
                    spec = new DHParameterSpec(p, g);
                    kpg.initialize(spec);
                }
                catch (Exception e) {
                    this.fatalAlert((byte)80, "INTERNAL ERROR", e);
                }
            }
            if (kpg != null) {
                ds = new DigitalSignature(cipher_suite.authType);
                kp = null;
                try {
                    kp = kpg.genKeyPair();
                    if (cipher_suite.keyExchange == 2) {
                        rsakey = (RSAPublicKey)kp.getPublic();
                    } else {
                        dhkey = (DHPublicKey)kp.getPublic();
                        kf = null;
                        try {
                            kf = KeyFactory.getInstance("DH");
                        }
                        catch (NoSuchAlgorithmException e) {
                            kf = KeyFactory.getInstance("DiffieHellman");
                        }
                        dhkeySpec = kf.getKeySpec(dhkey, DHPublicKeySpec.class);
                    }
                    if (!cipher_suite.isAnonymous()) {
                        ds.init(this.privKey);
                        this.privKey = kp.getPrivate();
                        ds.update(this.clientHello.getRandom());
                        ds.update(this.serverHello.getRandom());
                        tmpLength = new byte[2];
                        if (cipher_suite.keyExchange == 2) {
                            tmp = ServerKeyExchange.toUnsignedByteArray(rsakey.getModulus());
                            tmpLength[0] = (byte)((tmp.length & 65280) >>> 8);
                            tmpLength[1] = (byte)(tmp.length & 255);
                            ds.update(tmpLength);
                            ds.update(tmp);
                            tmp = ServerKeyExchange.toUnsignedByteArray(rsakey.getPublicExponent());
                            tmpLength[0] = (byte)((tmp.length & 65280) >>> 8);
                            tmpLength[1] = (byte)(tmp.length & 255);
                            ds.update(tmpLength);
                            ds.update(tmp);
                        } else {
                            tmp = ServerKeyExchange.toUnsignedByteArray(dhkeySpec.getP());
                            tmpLength[0] = (byte)((tmp.length & 65280) >>> 8);
                            tmpLength[1] = (byte)(tmp.length & 255);
                            ds.update(tmpLength);
                            ds.update(tmp);
                            tmp = ServerKeyExchange.toUnsignedByteArray(dhkeySpec.getG());
                            tmpLength[0] = (byte)((tmp.length & 65280) >>> 8);
                            tmpLength[1] = (byte)(tmp.length & 255);
                            ds.update(tmpLength);
                            ds.update(tmp);
                            tmp = ServerKeyExchange.toUnsignedByteArray(dhkeySpec.getY());
                            tmpLength[0] = (byte)((tmp.length & 65280) >>> 8);
                            tmpLength[1] = (byte)(tmp.length & 255);
                            ds.update(tmpLength);
                            ds.update(tmp);
                        }
                        hash = ds.sign();
                    } else {
                        this.privKey = kp.getPrivate();
                    }
                }
                catch (Exception e) {
                    this.fatalAlert((byte)80, "INTERNAL ERROR", e);
                }
                this.serverKeyExchange = cipher_suite.keyExchange == 2 ? new ServerKeyExchange(rsakey.getModulus(), rsakey.getPublicExponent(), null, hash) : new ServerKeyExchange(p, g, dhkeySpec.getY(), hash);
                this.send(this.serverKeyExchange);
            }
            if (this.parameters.getWantClientAuth() || this.parameters.getNeedClientAuth()) {
                try {
                    tm = this.parameters.getTrustManager();
                    accepted = tm.getAcceptedIssuers();
                }
                catch (ClassCastException e) {
                    break block53;
                }
                requestedClientCertTypes = new byte[]{1, 2};
                this.certificateRequest = new CertificateRequest(requestedClientCertTypes, accepted);
                this.send(this.certificateRequest);
            }
        }
        this.serverHelloDone = new ServerHelloDone();
        this.send(this.serverHelloDone);
        this.status = 1;
    }

    public void makeFinished() {
        byte[] verify_data;
        boolean isTLS;
        boolean bl = isTLS = this.serverHello.server_version[1] == 1;
        if (isTLS) {
            verify_data = new byte[12];
            this.computerVerifyDataTLS("server finished", verify_data);
        } else {
            verify_data = new byte[36];
            this.computerVerifyDataSSLv3(SSLv3Constants.server, verify_data);
        }
        this.serverFinished = new Finished(verify_data);
        this.send(this.serverFinished);
        if (this.isResuming) {
            if (isTLS) {
                this.computerReferenceVerifyDataTLS("client finished");
            } else {
                this.computerReferenceVerifyDataSSLv3(SSLv3Constants.client);
            }
            this.status = 1;
        } else {
            this.session.lastAccessedTime = System.currentTimeMillis();
            this.status = 3;
        }
    }

    public SSLSessionImpl findSessionToResume(byte[] session_id) {
        return (SSLSessionImpl)this.parameters.getServerSessionContext().getSession(session_id);
    }

    public CipherSuite selectSuite(CipherSuite[] client_suites) {
        for (int i = 0; i < client_suites.length; ++i) {
            if (!client_suites[i].supported) continue;
            for (int j = 0; j < this.parameters.getEnabledCipherSuitesMember().length; ++j) {
                if (!client_suites[i].equals(this.parameters.getEnabledCipherSuitesMember()[j])) continue;
                return client_suites[i];
            }
        }
        return null;
    }

    public void receiveChangeCipherSpec() {
        if (this.isResuming) {
            if (this.serverFinished == null) {
                this.unexpectedMessage();
            } else {
                this.changeCipherSpecReceived = true;
            }
        } else {
            if (this.parameters.getNeedClientAuth() && this.clientCert == null || this.clientKeyExchange == null || this.clientCert != null && !this.clientKeyExchange.isEmpty() && this.certificateVerify == null) {
                this.unexpectedMessage();
            } else {
                this.changeCipherSpecReceived = true;
            }
            if (this.serverHello.server_version[1] == 1) {
                this.computerReferenceVerifyDataTLS("client finished");
            } else {
                this.computerReferenceVerifyDataSSLv3(SSLv3Constants.client);
            }
        }
    }
}

