/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.Socket;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.SSLException;

public class NativeCrypto {
    public static final int RAND_SEED_LENGTH_IN_BYTES = 1024;
    public static final Field JAVA_NET_SOCKET_IMPL;
    public static final Field JAVA_NET_SOCKETIMPL_FD;
    public static final String SUPPORTED_PROTOCOL_SSLV3 = "SSLv3";
    public static final String SUPPORTED_PROTOCOL_TLSV1 = "TLSv1";
    public static final Map<String, String> OPENSSL_TO_STANDARD_CIPHER_SUITES;
    public static final Map<String, String> STANDARD_TO_OPENSSL_CIPHER_SUITES;
    public static final String[] SUPPORTED_CIPHER_SUITES;
    public static long SSL_MODE_HANDSHAKE_CUTTHROUGH;
    public static long SSL_OP_NO_TICKET;
    public static long SSL_OP_NO_COMPRESSION;
    public static long SSL_OP_NO_SSLv3;
    public static long SSL_OP_NO_TLSv1;
    public static final String[] KEY_TYPES;
    public static final String SUPPORTED_COMPRESSION_METHOD_ZLIB = "ZLIB";
    public static final String SUPPORTED_COMPRESSION_METHOD_NULL = "NULL";
    public static final String[] SUPPORTED_COMPRESSION_METHODS;
    public static final int SSL_VERIFY_NONE = 0;
    public static final int SSL_VERIFY_PEER = 1;
    public static final int SSL_VERIFY_FAIL_IF_NO_PEER_CERT = 2;

    public static void clinit() {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#clinit()V", true, null);
    }

    public static int EVP_PKEY_new_DSA(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.NativeCrypto#EVP_PKEY_new_DSA([B[B[B[B[B)I", true, null);
    }

    public static int EVP_PKEY_new_RSA(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.NativeCrypto#EVP_PKEY_new_RSA([B[B[B[B[B)I", true, null);
    }

    public static void EVP_PKEY_free(int n) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#EVP_PKEY_free(I)V", true, null);
    }

    public static int EVP_MD_CTX_create() {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.NativeCrypto#EVP_MD_CTX_create()I", true, null);
    }

    public static void EVP_MD_CTX_destroy(int n) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#EVP_MD_CTX_destroy(I)V", true, null);
    }

    public static int EVP_MD_CTX_copy(int n) {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.NativeCrypto#EVP_MD_CTX_copy(I)I", true, null);
    }

    public static void EVP_DigestInit(int n, String string2) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#EVP_DigestInit(ILjava/lang/String;)V", true, null);
    }

    public static void EVP_DigestUpdate(int n, byte[] byArray, int n2, int n3) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#EVP_DigestUpdate(I[BII)V", true, null);
    }

    public static int EVP_DigestFinal(int n, byte[] byArray, int n2) {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.NativeCrypto#EVP_DigestFinal(I[BI)I", true, null);
    }

    public static int EVP_MD_CTX_size(int n) {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.NativeCrypto#EVP_MD_CTX_size(I)I", true, null);
    }

    public static int EVP_MD_CTX_block_size(int n) {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.NativeCrypto#EVP_MD_CTX_block_size(I)I", true, null);
    }

    public static void EVP_VerifyInit(int n, String string2) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#EVP_VerifyInit(ILjava/lang/String;)V", true, null);
    }

    public static void EVP_VerifyUpdate(int n, byte[] byArray, int n2, int n3) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#EVP_VerifyUpdate(I[BII)V", true, null);
    }

    public static int EVP_VerifyFinal(int n, byte[] byArray, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.NativeCrypto#EVP_VerifyFinal(I[BIII)I", true, null);
    }

    public static boolean verifySignature(byte[] message, byte[] signature, String algorithm, RSAPublicKey key) {
        byte[] exponent;
        byte[] modulus = key.getModulus().toByteArray();
        return NativeCrypto.verifySignature(message, signature, algorithm, modulus, exponent = key.getPublicExponent().toByteArray()) == 1;
    }

    public static int verifySignature(byte[] byArray, byte[] byArray2, String string2, byte[] byArray3, byte[] byArray4) {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.NativeCrypto#verifySignature([B[BLjava/lang/String;[B[B)I", true, null);
    }

    public static void RAND_seed(byte[] byArray) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#RAND_seed([B)V", true, null);
    }

    public static int RAND_load_file(String string2, long l) {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.NativeCrypto#RAND_load_file(Ljava/lang/String;J)I", true, null);
    }

    public static FileDescriptor getFileDescriptor(Socket socket) {
        try {
            SocketImpl socketImpl = (SocketImpl)JAVA_NET_SOCKET_IMPL.get(socket);
            FileDescriptor fd = (FileDescriptor)JAVA_NET_SOCKETIMPL_FD.get(socketImpl);
            return fd;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void add(String standard, String openssl) {
        OPENSSL_TO_STANDARD_CIPHER_SUITES.put(openssl, standard);
        STANDARD_TO_OPENSSL_CIPHER_SUITES.put(standard, openssl);
    }

    public static int SSL_CTX_new() {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_CTX_new()I", true, null);
    }

    public static String[] getDefaultCipherSuites() {
        return new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"};
    }

    public static String[] getSupportedCipherSuites() {
        return (String[])SUPPORTED_CIPHER_SUITES.clone();
    }

    public static void SSL_CTX_free(int n) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_CTX_free(I)V", true, null);
    }

    public static int SSL_new(int n) throws SSLException {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_new(I)I", true, null);
    }

    public static String keyType(int keyType) {
        switch (keyType) {
            case 1: {
                return "RSA";
            }
            case 2: {
                return "DSA";
            }
            case 3: {
                return "DH_RSA";
            }
            case 4: {
                return "DH_DSA";
            }
            case 64: {
                return "EC";
            }
        }
        return null;
    }

    public static byte[][] encodeCertificates(Certificate[] certificates) throws CertificateEncodingException {
        byte[][] certificateBytes = new byte[certificates.length][];
        for (int i = 0; i < certificates.length; ++i) {
            certificateBytes[i] = certificates[i].getEncoded();
        }
        return certificateBytes;
    }

    public static void SSL_use_certificate(int n, byte[][] byArray) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_use_certificate(I[[B)V", true, null);
    }

    public static void SSL_use_PrivateKey(int n, byte[] byArray) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_use_PrivateKey(I[B)V", true, null);
    }

    public static void SSL_check_private_key(int n) throws SSLException {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_check_private_key(I)V", true, null);
    }

    public static byte[][] encodeIssuerX509Principals(X509Certificate[] certificates) throws CertificateEncodingException {
        byte[][] principalBytes = new byte[certificates.length][];
        for (int i = 0; i < certificates.length; ++i) {
            principalBytes[i] = certificates[i].getIssuerX500Principal().getEncoded();
        }
        return principalBytes;
    }

    public static void SSL_set_client_CA_list(int n, byte[][] byArray) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_set_client_CA_list(I[[B)V", true, null);
    }

    public static long SSL_get_mode(int n) {
        return OverrideMethod.invokeL("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_get_mode(I)J", true, null);
    }

    public static long SSL_set_mode(int n, long l) {
        return OverrideMethod.invokeL("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_set_mode(IJ)J", true, null);
    }

    public static long SSL_clear_mode(int n, long l) {
        return OverrideMethod.invokeL("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_clear_mode(IJ)J", true, null);
    }

    public static long SSL_get_options(int n) {
        return OverrideMethod.invokeL("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_get_options(I)J", true, null);
    }

    public static long SSL_set_options(int n, long l) {
        return OverrideMethod.invokeL("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_set_options(IJ)J", true, null);
    }

    public static long SSL_clear_options(int n, long l) {
        return OverrideMethod.invokeL("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_clear_options(IJ)J", true, null);
    }

    public static String[] getSupportedProtocols() {
        return new String[]{SUPPORTED_PROTOCOL_SSLV3, SUPPORTED_PROTOCOL_TLSV1};
    }

    public static void setEnabledProtocols(int ssl, String[] protocols) {
        NativeCrypto.checkEnabledProtocols(protocols);
        long optionsToSet = SSL_OP_NO_SSLv3 | SSL_OP_NO_TLSv1;
        long optionsToClear = 0L;
        for (int i = 0; i < protocols.length; ++i) {
            String protocol = protocols[i];
            if (protocol.equals(SUPPORTED_PROTOCOL_SSLV3)) {
                optionsToSet &= SSL_OP_NO_SSLv3 ^ 0xFFFFFFFFFFFFFFFFL;
                optionsToClear |= SSL_OP_NO_SSLv3;
                continue;
            }
            if (protocol.equals(SUPPORTED_PROTOCOL_TLSV1)) {
                optionsToSet &= SSL_OP_NO_TLSv1 ^ 0xFFFFFFFFFFFFFFFFL;
                optionsToClear |= SSL_OP_NO_TLSv1;
                continue;
            }
            throw new IllegalStateException();
        }
        NativeCrypto.SSL_set_options(ssl, optionsToSet);
        NativeCrypto.SSL_clear_options(ssl, optionsToClear);
    }

    public static String[] checkEnabledProtocols(String[] protocols) {
        if (protocols == null) {
            throw new IllegalArgumentException("protocols == null");
        }
        for (int i = 0; i < protocols.length; ++i) {
            String protocol = protocols[i];
            if (protocol == null) {
                throw new IllegalArgumentException("protocols[" + i + "] == null");
            }
            if (protocol.equals(SUPPORTED_PROTOCOL_SSLV3) || protocol.equals(SUPPORTED_PROTOCOL_TLSV1)) continue;
            throw new IllegalArgumentException("protocol " + protocol + " is not supported");
        }
        return protocols;
    }

    public static void SSL_set_cipher_lists(int n, String[] stringArray) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_set_cipher_lists(I[Ljava/lang/String;)V", true, null);
    }

    public static void setEnabledCipherSuites(int ssl, String[] cipherSuites) {
        NativeCrypto.checkEnabledCipherSuites(cipherSuites);
        ArrayList<String> opensslSuites = new ArrayList<String>();
        for (int i = 0; i < cipherSuites.length; ++i) {
            String cipherSuite = cipherSuites[i];
            String openssl = STANDARD_TO_OPENSSL_CIPHER_SUITES.get(cipherSuite);
            String cs2 = openssl == null ? cipherSuite : openssl;
            opensslSuites.add(cs2);
        }
        NativeCrypto.SSL_set_cipher_lists(ssl, opensslSuites.toArray(new String[opensslSuites.size()]));
    }

    public static String[] checkEnabledCipherSuites(String[] cipherSuites) {
        if (cipherSuites == null) {
            throw new IllegalArgumentException("cipherSuites == null");
        }
        for (int i = 0; i < cipherSuites.length; ++i) {
            String cipherSuite = cipherSuites[i];
            if (cipherSuite == null) {
                throw new IllegalArgumentException("cipherSuites[" + i + "] == null");
            }
            if (STANDARD_TO_OPENSSL_CIPHER_SUITES.containsKey(cipherSuite) || OPENSSL_TO_STANDARD_CIPHER_SUITES.containsKey(cipherSuite)) continue;
            throw new IllegalArgumentException("cipherSuite " + cipherSuite + " is not supported.");
        }
        return cipherSuites;
    }

    public static String[] getSupportedCompressionMethods() {
        return (String[])SUPPORTED_COMPRESSION_METHODS.clone();
    }

    public static String[] getDefaultCompressionMethods() {
        return new String[]{SUPPORTED_COMPRESSION_METHOD_NULL};
    }

    public static String[] checkEnabledCompressionMethods(String[] methods) {
        if (methods == null) {
            throw new IllegalArgumentException("methods == null");
        }
        if (methods.length < 1 && !methods[methods.length - 1].equals(SUPPORTED_COMPRESSION_METHOD_NULL)) {
            throw new IllegalArgumentException("last method must be NULL");
        }
        for (int i = 0; i < methods.length; ++i) {
            String method = methods[i];
            if (method == null) {
                throw new IllegalArgumentException("methods[" + i + "] == null");
            }
            if (method.equals(SUPPORTED_COMPRESSION_METHOD_ZLIB) || method.equals(SUPPORTED_COMPRESSION_METHOD_NULL)) continue;
            throw new IllegalArgumentException("method " + method + " is not supported");
        }
        return methods;
    }

    public static void setEnabledCompressionMethods(int ssl, String[] methods) {
        NativeCrypto.checkEnabledCompressionMethods(methods);
        long optionsToSet = SSL_OP_NO_COMPRESSION;
        long optionsToClear = 0L;
        for (int i = 0; i < methods.length; ++i) {
            String method = methods[i];
            if (method.equals(SUPPORTED_COMPRESSION_METHOD_NULL)) continue;
            if (method.equals(SUPPORTED_COMPRESSION_METHOD_ZLIB)) {
                optionsToSet &= SSL_OP_NO_COMPRESSION ^ 0xFFFFFFFFFFFFFFFFL;
                optionsToClear |= SSL_OP_NO_COMPRESSION;
                continue;
            }
            throw new IllegalStateException();
        }
        NativeCrypto.SSL_set_options(ssl, optionsToSet);
        NativeCrypto.SSL_clear_options(ssl, optionsToClear);
    }

    public static void SSL_set_verify(int n, int n2) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_set_verify(II)V", true, null);
    }

    public static void SSL_set_session(int n, int n2) throws SSLException {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_set_session(II)V", true, null);
    }

    public static void SSL_set_session_creation_enabled(int n, boolean bl) throws SSLException {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_set_session_creation_enabled(IZ)V", true, null);
    }

    public static void SSL_set_tlsext_host_name(int n, String string2) throws SSLException {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_set_tlsext_host_name(ILjava/lang/String;)V", true, null);
    }

    public static String SSL_get_servername(int n) {
        return (String)OverrideMethod.invokeA("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_get_servername(I)Ljava/lang/String;", true, null);
    }

    public static int SSL_do_handshake(int n, FileDescriptor fileDescriptor, SSLHandshakeCallbacks sSLHandshakeCallbacks, int n2, boolean bl) throws SSLException, SocketTimeoutException, CertificateException {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_do_handshake(ILjava/io/FileDescriptor;Lorg/apache/harmony/xnet/provider/jsse/NativeCrypto$SSLHandshakeCallbacks;IZ)I", true, null);
    }

    public static void SSL_renegotiate(int n) throws SSLException {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_renegotiate(I)V", true, null);
    }

    public static byte[][] SSL_get_certificate(int n) {
        return (byte[][])OverrideMethod.invokeA("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_get_certificate(I)[[B", true, null);
    }

    public static byte[][] SSL_get_peer_cert_chain(int n) {
        return (byte[][])OverrideMethod.invokeA("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_get_peer_cert_chain(I)[[B", true, null);
    }

    public static int SSL_read_byte(int n, FileDescriptor fileDescriptor, SSLHandshakeCallbacks sSLHandshakeCallbacks, int n2) throws IOException {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_read_byte(ILjava/io/FileDescriptor;Lorg/apache/harmony/xnet/provider/jsse/NativeCrypto$SSLHandshakeCallbacks;I)I", true, null);
    }

    public static int SSL_read(int n, FileDescriptor fileDescriptor, SSLHandshakeCallbacks sSLHandshakeCallbacks, byte[] byArray, int n2, int n3, int n4) throws IOException {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_read(ILjava/io/FileDescriptor;Lorg/apache/harmony/xnet/provider/jsse/NativeCrypto$SSLHandshakeCallbacks;[BIII)I", true, null);
    }

    public static void SSL_write_byte(int n, FileDescriptor fileDescriptor, SSLHandshakeCallbacks sSLHandshakeCallbacks, int n2) throws IOException {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_write_byte(ILjava/io/FileDescriptor;Lorg/apache/harmony/xnet/provider/jsse/NativeCrypto$SSLHandshakeCallbacks;I)V", true, null);
    }

    public static void SSL_write(int n, FileDescriptor fileDescriptor, SSLHandshakeCallbacks sSLHandshakeCallbacks, byte[] byArray, int n2, int n3) throws IOException {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_write(ILjava/io/FileDescriptor;Lorg/apache/harmony/xnet/provider/jsse/NativeCrypto$SSLHandshakeCallbacks;[BII)V", true, null);
    }

    public static void SSL_interrupt(int n) throws IOException {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_interrupt(I)V", true, null);
    }

    public static void SSL_shutdown(int n, FileDescriptor fileDescriptor, SSLHandshakeCallbacks sSLHandshakeCallbacks) throws IOException {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_shutdown(ILjava/io/FileDescriptor;Lorg/apache/harmony/xnet/provider/jsse/NativeCrypto$SSLHandshakeCallbacks;)V", true, null);
    }

    public static void SSL_free(int n) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_free(I)V", true, null);
    }

    public static byte[] SSL_SESSION_session_id(int n) {
        return (byte[])OverrideMethod.invokeA("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_SESSION_session_id(I)[B", true, null);
    }

    public static long SSL_SESSION_get_time(int n) {
        return OverrideMethod.invokeL("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_SESSION_get_time(I)J", true, null);
    }

    public static String SSL_SESSION_get_version(int n) {
        return (String)OverrideMethod.invokeA("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_SESSION_get_version(I)Ljava/lang/String;", true, null);
    }

    public static String SSL_SESSION_cipher(int n) {
        return (String)OverrideMethod.invokeA("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_SESSION_cipher(I)Ljava/lang/String;", true, null);
    }

    public static String SSL_SESSION_compress_meth(int n, int n2) {
        return (String)OverrideMethod.invokeA("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_SESSION_compress_meth(II)Ljava/lang/String;", true, null);
    }

    public static void SSL_SESSION_free(int n) {
        OverrideMethod.invokeV("org.apache.harmony.xnet.provider.jsse.NativeCrypto#SSL_SESSION_free(I)V", true, null);
    }

    public static byte[] i2d_SSL_SESSION(int n) {
        return (byte[])OverrideMethod.invokeA("org.apache.harmony.xnet.provider.jsse.NativeCrypto#i2d_SSL_SESSION(I)[B", true, null);
    }

    public static int d2i_SSL_SESSION(byte[] byArray) {
        return OverrideMethod.invokeI("org.apache.harmony.xnet.provider.jsse.NativeCrypto#d2i_SSL_SESSION([B)I", true, null);
    }

    static {
        NativeCrypto.clinit();
        try {
            JAVA_NET_SOCKET_IMPL = Socket.class.getDeclaredField("impl");
            JAVA_NET_SOCKET_IMPL.setAccessible(true);
            JAVA_NET_SOCKETIMPL_FD = SocketImpl.class.getDeclaredField("fd");
            JAVA_NET_SOCKETIMPL_FD.setAccessible(true);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        OPENSSL_TO_STANDARD_CIPHER_SUITES = new HashMap<String, String>();
        STANDARD_TO_OPENSSL_CIPHER_SUITES = new LinkedHashMap<String, String>();
        NativeCrypto.add("SSL_RSA_WITH_RC4_128_MD5", "RC4-MD5");
        NativeCrypto.add("SSL_RSA_WITH_RC4_128_SHA", "RC4-SHA");
        NativeCrypto.add("TLS_RSA_WITH_AES_128_CBC_SHA", "AES128-SHA");
        NativeCrypto.add("TLS_RSA_WITH_AES_256_CBC_SHA", "AES256-SHA");
        NativeCrypto.add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "DHE-RSA-AES128-SHA");
        NativeCrypto.add("TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "DHE-RSA-AES256-SHA");
        NativeCrypto.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "DHE-DSS-AES128-SHA");
        NativeCrypto.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "DHE-DSS-AES256-SHA");
        NativeCrypto.add("SSL_RSA_WITH_3DES_EDE_CBC_SHA", "DES-CBC3-SHA");
        NativeCrypto.add("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "EDH-RSA-DES-CBC3-SHA");
        NativeCrypto.add("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "EDH-DSS-DES-CBC3-SHA");
        NativeCrypto.add("SSL_RSA_WITH_DES_CBC_SHA", "DES-CBC-SHA");
        NativeCrypto.add("SSL_DHE_RSA_WITH_DES_CBC_SHA", "EDH-RSA-DES-CBC-SHA");
        NativeCrypto.add("SSL_DHE_DSS_WITH_DES_CBC_SHA", "EDH-DSS-DES-CBC-SHA");
        NativeCrypto.add("SSL_RSA_EXPORT_WITH_RC4_40_MD5", "EXP-RC4-MD5");
        NativeCrypto.add("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "EXP-DES-CBC-SHA");
        NativeCrypto.add("SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "EXP-EDH-RSA-DES-CBC-SHA");
        NativeCrypto.add("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "EXP-EDH-DSS-DES-CBC-SHA");
        NativeCrypto.add("SSL_RSA_WITH_NULL_MD5", "NULL-MD5");
        NativeCrypto.add("SSL_RSA_WITH_NULL_SHA", "NULL-SHA");
        NativeCrypto.add("SSL_DH_anon_WITH_RC4_128_MD5", "ADH-RC4-MD5");
        NativeCrypto.add("TLS_DH_anon_WITH_AES_128_CBC_SHA", "ADH-AES128-SHA");
        NativeCrypto.add("TLS_DH_anon_WITH_AES_256_CBC_SHA", "ADH-AES256-SHA");
        NativeCrypto.add("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "ADH-DES-CBC3-SHA");
        NativeCrypto.add("SSL_DH_anon_WITH_DES_CBC_SHA", "ADH-DES-CBC-SHA");
        NativeCrypto.add("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "EXP-ADH-RC4-MD5");
        NativeCrypto.add("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "EXP-ADH-DES-CBC-SHA");
        SUPPORTED_CIPHER_SUITES = STANDARD_TO_OPENSSL_CIPHER_SUITES.keySet().toArray(new String[0]);
        SSL_MODE_HANDSHAKE_CUTTHROUGH = 64L;
        SSL_OP_NO_TICKET = 16384L;
        SSL_OP_NO_COMPRESSION = 131072L;
        SSL_OP_NO_SSLv3 = 0x2000000L;
        SSL_OP_NO_TLSv1 = 0x4000000L;
        KEY_TYPES = new String[]{"RSA", "DSA", "DH_RSA", "DH_DSA", "EC"};
        SUPPORTED_COMPRESSION_METHODS = new String[]{SUPPORTED_COMPRESSION_METHOD_ZLIB, SUPPORTED_COMPRESSION_METHOD_NULL};
    }

    public static interface SSLHandshakeCallbacks {
        public void verifyCertificateChain(byte[][] var1, String var2) throws CertificateException;

        public void clientCertificateRequested(byte[] var1, byte[][] var2) throws CertificateEncodingException, SSLException;

        public void handshakeCompleted();
    }
}

