/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.provider.cert;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.harmony.security.utils.AlgNameMapper;
import org.apache.harmony.security.x509.Certificate;
import org.apache.harmony.security.x509.Extension;
import org.apache.harmony.security.x509.Extensions;
import org.apache.harmony.security.x509.TBSCertificate;
import org.apache.harmony.xnet.provider.jsse.NativeCrypto;

public class X509CertImpl
extends X509Certificate {
    public static final long serialVersionUID = 2972248729446736154L;
    public final Certificate certificate;
    public final TBSCertificate tbsCert;
    public final Extensions extensions;
    public volatile long notBefore = -1L;
    public volatile long notAfter = -1L;
    public volatile BigInteger serialNumber;
    public volatile X500Principal issuer;
    public volatile X500Principal subject;
    public volatile byte[] tbsCertificate;
    public volatile byte[] signature;
    public volatile String sigAlgName;
    public volatile String sigAlgOID;
    public volatile byte[] sigAlgParams;
    public volatile boolean nullSigAlgParams;
    public volatile PublicKey publicKey;
    public volatile byte[] encoding;

    public X509CertImpl(InputStream in) throws CertificateException {
        try {
            this.certificate = (Certificate)Certificate.ASN1.decode(in);
            this.tbsCert = this.certificate.getTbsCertificate();
            this.extensions = this.tbsCert.getExtensions();
        }
        catch (IOException e) {
            throw new CertificateException(e);
        }
    }

    public X509CertImpl(Certificate certificate) {
        this.certificate = certificate;
        this.tbsCert = certificate.getTbsCertificate();
        this.extensions = this.tbsCert.getExtensions();
    }

    public X509CertImpl(byte[] encoding) throws IOException {
        this((Certificate)Certificate.ASN1.decode(encoding));
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(System.currentTimeMillis());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(date.getTime());
    }

    public void checkValidity(long time) throws CertificateExpiredException, CertificateNotYetValidException {
        if (time < this.getNotBeforeInternal()) {
            throw new CertificateNotYetValidException("current time: " + new Date(time) + ", validation time: " + new Date(this.getNotBeforeInternal()));
        }
        if (time > this.getNotAfterInternal()) {
            throw new CertificateExpiredException("current time: " + new Date(time) + ", expiration time: " + new Date(this.getNotAfterInternal()));
        }
    }

    public int getVersion() {
        return this.tbsCert.getVersion() + 1;
    }

    public BigInteger getSerialNumber() {
        BigInteger result = this.serialNumber;
        if (result == null) {
            this.serialNumber = result = this.tbsCert.getSerialNumber();
        }
        return result;
    }

    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    public X500Principal getIssuerX500Principal() {
        X500Principal result = this.issuer;
        if (result == null) {
            this.issuer = result = this.tbsCert.getIssuer().getX500Principal();
        }
        return result;
    }

    public Principal getSubjectDN() {
        return this.getSubjectX500Principal();
    }

    public X500Principal getSubjectX500Principal() {
        X500Principal result = this.subject;
        if (result == null) {
            this.subject = result = this.tbsCert.getSubject().getX500Principal();
        }
        return result;
    }

    public Date getNotBefore() {
        return new Date(this.getNotBeforeInternal());
    }

    public long getNotBeforeInternal() {
        long result = this.notBefore;
        if (result == -1L) {
            this.notBefore = result = this.tbsCert.getValidity().getNotBefore().getTime();
        }
        return result;
    }

    public Date getNotAfter() {
        return new Date(this.getNotAfterInternal());
    }

    public long getNotAfterInternal() {
        long result = this.notAfter;
        if (result == -1L) {
            this.notAfter = result = this.tbsCert.getValidity().getNotAfter().getTime();
        }
        return result;
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return (byte[])this.getTbsCertificateInternal().clone();
    }

    public byte[] getTbsCertificateInternal() {
        byte[] result = this.tbsCertificate;
        if (result == null) {
            this.tbsCertificate = result = this.tbsCert.getEncoded();
        }
        return result;
    }

    public byte[] getSignature() {
        return (byte[])this.getSignatureInternal().clone();
    }

    public byte[] getSignatureInternal() {
        byte[] result = this.signature;
        if (result == null) {
            this.signature = result = this.certificate.getSignatureValue();
        }
        return result;
    }

    public String getSigAlgName() {
        String result = this.sigAlgName;
        if (result == null) {
            String sigAlgOIDLocal = this.getSigAlgOID();
            result = AlgNameMapper.map2AlgName(sigAlgOIDLocal);
            if (result == null) {
                result = sigAlgOIDLocal;
            }
            this.sigAlgName = result;
        }
        return result;
    }

    public String getSigAlgOID() {
        String result = this.sigAlgOID;
        if (result == null) {
            this.sigAlgOID = result = this.tbsCert.getSignature().getAlgorithm();
        }
        return result;
    }

    public byte[] getSigAlgParams() {
        if (this.nullSigAlgParams) {
            return null;
        }
        byte[] result = this.sigAlgParams;
        if (result == null) {
            result = this.tbsCert.getSignature().getParameters();
            if (result == null) {
                this.nullSigAlgParams = true;
                return null;
            }
            this.sigAlgParams = result;
        }
        return result;
    }

    public boolean[] getIssuerUniqueID() {
        return this.tbsCert.getIssuerUniqueID();
    }

    public boolean[] getSubjectUniqueID() {
        return this.tbsCert.getSubjectUniqueID();
    }

    public boolean[] getKeyUsage() {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.valueOfKeyUsage();
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        if (this.extensions == null) {
            return null;
        }
        try {
            return this.extensions.valueOfExtendedKeyUsage();
        }
        catch (IOException e) {
            throw new CertificateParsingException(e);
        }
    }

    public int getBasicConstraints() {
        if (this.extensions == null) {
            return Integer.MAX_VALUE;
        }
        return this.extensions.valueOfBasicConstrains();
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        if (this.extensions == null) {
            return null;
        }
        try {
            return this.extensions.valueOfSubjectAlternativeName();
        }
        catch (IOException e) {
            throw new CertificateParsingException(e);
        }
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        if (this.extensions == null) {
            return null;
        }
        try {
            return this.extensions.valueOfIssuerAlternativeName();
        }
        catch (IOException e) {
            throw new CertificateParsingException(e);
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return (byte[])this.getEncodedInternal().clone();
    }

    public byte[] getEncodedInternal() throws CertificateEncodingException {
        byte[] result = this.encoding;
        if (this.encoding == null) {
            this.encoding = result = this.certificate.getEncoded();
        }
        return result;
    }

    public PublicKey getPublicKey() {
        PublicKey result = this.publicKey;
        if (result == null) {
            this.publicKey = result = this.tbsCert.getSubjectPublicKeyInfo().getPublicKey();
        }
        return result;
    }

    public String toString() {
        return this.certificate.toString();
    }

    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (this.getSigAlgName().endsWith("withRSA")) {
            this.fastVerify(key);
            return;
        }
        Signature signature = Signature.getInstance(this.getSigAlgName());
        signature.initVerify(key);
        byte[] tbsCertificateLocal = this.getTbsCertificateInternal();
        signature.update(tbsCertificateLocal, 0, tbsCertificateLocal.length);
        if (!signature.verify(this.certificate.getSignatureValue())) {
            throw new SignatureException("Signature was not verified");
        }
    }

    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (this.getSigAlgName().endsWith("withRSA")) {
            this.fastVerify(key);
            return;
        }
        Signature signature = Signature.getInstance(this.getSigAlgName(), sigProvider);
        signature.initVerify(key);
        byte[] tbsCertificateLocal = this.getTbsCertificateInternal();
        signature.update(tbsCertificateLocal, 0, tbsCertificateLocal.length);
        if (!signature.verify(this.certificate.getSignatureValue())) {
            throw new SignatureException("Signature was not verified");
        }
    }

    public void fastVerify(PublicKey key) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        byte[] sig;
        if (!(key instanceof RSAPublicKey)) {
            throw new InvalidKeyException("key is not an instance of RSAPublicKey");
        }
        RSAPublicKey rsaKey = (RSAPublicKey)key;
        String algorithm = this.getSigAlgName();
        if ("MD2withRSA".equalsIgnoreCase(algorithm) || "MD2withRSAEncryption".equalsIgnoreCase(algorithm) || "1.2.840.113549.1.1.2".equalsIgnoreCase(algorithm) || "MD2/RSA".equalsIgnoreCase(algorithm)) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        int i = algorithm.indexOf("with");
        algorithm = algorithm.substring(i + 4) + "-" + algorithm.substring(0, i);
        byte[] tbsCertificateLocal = this.getTbsCertificateInternal();
        if (!NativeCrypto.verifySignature(tbsCertificateLocal, sig = this.certificate.getSignatureValue(), algorithm, rsaKey)) {
            throw new SignatureException("Signature was not verified");
        }
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.getNonCriticalExtensions();
    }

    public Set getCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.getCriticalExtensions();
    }

    public byte[] getExtensionValue(String oid) {
        if (this.extensions == null) {
            return null;
        }
        Extension ext = this.extensions.getExtensionByOID(oid);
        return ext == null ? null : ext.getRawExtnValue();
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (this.extensions == null) {
            return false;
        }
        return this.extensions.hasUnsupportedCritical();
    }
}

