/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import java.nio.charset.Charsets;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;

public abstract class ASN1StringType
extends ASN1Type {
    public static final ASN1StringType BMPSTRING = new ASN1StringType(30){};
    public static final ASN1StringType IA5STRING = new ASN1StringType(22){};
    public static final ASN1StringType GENERALSTRING = new ASN1StringType(27){};
    public static final ASN1StringType PRINTABLESTRING = new ASN1StringType(19){};
    public static final ASN1StringType TELETEXSTRING = new ASN1StringType(20){};
    public static final ASN1StringType UNIVERSALSTRING = new ASN1StringType(28){};
    public static final ASN1StringType UTF8STRING = new ASN1StringType(12){

        public Object getDecodedObject(BerInputStream in) throws IOException {
            return new String(in.buffer, in.contentOffset, in.length, Charsets.UTF_8);
        }

        public void setEncodingContent(BerOutputStream out) {
            byte[] bytes = ((String)out.content).getBytes(Charsets.UTF_8);
            out.content = bytes;
            out.length = bytes.length;
        }
    };

    public ASN1StringType(int tagNumber) {
        super(tagNumber);
    }

    public boolean checkTag(int identifier) {
        return this.id == identifier || this.constrId == identifier;
    }

    public Object decode(BerInputStream in) throws IOException {
        in.readString(this);
        if (in.isVerify) {
            return null;
        }
        return this.getDecodedObject(in);
    }

    public Object getDecodedObject(BerInputStream in) throws IOException {
        return new String(in.buffer, in.contentOffset, in.length, Charsets.ISO_8859_1);
    }

    public void encodeASN(BerOutputStream out) {
        out.encodeTag(this.id);
        this.encodeContent(out);
    }

    public void encodeContent(BerOutputStream out) {
        out.encodeString();
    }

    public void setEncodingContent(BerOutputStream out) {
        byte[] bytes = ((String)out.content).getBytes(Charsets.UTF_8);
        out.content = bytes;
        out.length = bytes.length;
    }
}

