/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class SamplingProfiler {
    public int nextThreadId = 200001;
    public int nextTraceId = 300001;
    public int nextObjectId = 1;
    public final Map<Thread, Integer> threadIds = new HashMap<Thread, Integer>();
    public final List<ThreadEvent> threadHistory = new ArrayList<ThreadEvent>();
    public final Map<Trace, int[]> traces = new HashMap<Trace, int[]>();
    public final Timer timer = new Timer("SamplingProfiler", true);
    public TimerTask sampler;
    public final int depth;
    public final ThreadSet threadSet;

    public SamplingProfiler(int depth, ThreadSet threadSet) {
        this.depth = depth;
        this.threadSet = threadSet;
    }

    public static ThreadSet newArrayThreadSet(Thread ... threads) {
        return new ArrayThreadSet(threads);
    }

    public static ThreadSet newThreadGroupTheadSet(ThreadGroup threadGroup) {
        return new ThreadGroupThreadSet(threadGroup);
    }

    public void start(int samplesPerSecond) {
        if (samplesPerSecond < 1) {
            throw new IllegalArgumentException("samplesPerSecond < 1");
        }
        if (this.sampler != null) {
            throw new IllegalStateException("profiling already started");
        }
        this.sampler = new Sampler(null);
        this.timer.scheduleAtFixedRate(this.sampler, 0L, (long)(1000 / samplesPerSecond));
    }

    public void stop() {
        if (this.sampler == null) {
            return;
        }
        this.sampler.cancel();
        this.sampler = null;
    }

    public void shutdown() {
        this.stop();
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHprofData(File file) throws IOException {
        PrintStream out = null;
        try {
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
            this.writeHprofData(out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeHprofData(PrintStream out) {
        if (this.sampler != null) {
            throw new IllegalStateException("cannot print hprof data while sampling");
        }
        for (ThreadEvent e : this.threadHistory) {
            out.println(e);
        }
        ArrayList<Map.Entry<Trace, int[]>> samples = new ArrayList<Map.Entry<Trace, int[]>>(this.traces.entrySet());
        Collections.sort(samples, SampleComparator.INSTANCE);
        int total = 0;
        for (Map.Entry entry : samples) {
            Trace trace = (Trace)entry.getKey();
            int count = ((int[])entry.getValue())[0];
            total += count;
            out.printf("TRACE %d: (thread=%d)\n", trace.traceId, trace.threadId);
            for (StackTraceElement e : trace.stack) {
                out.printf("\t%s\n", e);
            }
        }
        Date now = new Date();
        out.printf("CPU SAMPLES BEGIN (total = %d) %ta %tb %td %tT %tY\n", total, now, now, now, now, now);
        out.printf("rank   self  accum   count trace method\n", new Object[0]);
        boolean bl = false;
        double accum = 0.0;
        for (Map.Entry entry : samples) {
            void var5_8;
            Trace trace = (Trace)entry.getKey();
            int count = ((int[])entry.getValue())[0];
            double self = (double)count / (double)total;
            out.printf("% 4d% 6.2f%%% 6.2f%% % 7d % 5d %s.%s\n", (int)(++var5_8), self * 100.0, (accum += self) * 100.0, count, trace.traceId, trace.stack[0].getClassName(), trace.stack[0].getMethodName());
        }
        out.printf("CPU SAMPLES END\n", new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SampleComparator
    implements Comparator<Map.Entry<Trace, int[]>> {
        public static final SampleComparator INSTANCE = new SampleComparator();

        @Override
        public int compare(Map.Entry<Trace, int[]> e1, Map.Entry<Trace, int[]> e2) {
            return e2.getValue()[0] - e1.getValue()[0];
        }
    }

    public static class Trace {
        public final int traceId;
        public int threadId;
        public StackTraceElement[] stack;

        public Trace() {
            this.traceId = -1;
        }

        public Trace(int traceId, Trace mutableTrace) {
            this.traceId = traceId;
            this.threadId = mutableTrace.threadId;
            this.stack = mutableTrace.stack;
        }

        public int getThreadId() {
            return this.threadId;
        }

        public StackTraceElement[] getStack() {
            return this.stack;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.getThreadId();
            result = 31 * result + Arrays.hashCode(this.getStack());
            return result;
        }

        public boolean equals(Object o) {
            Trace s = (Trace)o;
            return this.getThreadId() == s.getThreadId() && Arrays.equals(this.getStack(), s.getStack());
        }

        public /* synthetic */ Trace(1 x0) {
            this();
        }

        public static /* synthetic */ StackTraceElement[] access$602(Trace x0, StackTraceElement[] x1) {
            x0.stack = x1;
            return x1;
        }

        public /* synthetic */ Trace(int x0, Trace x1, 1 x2) {
            this(x0, x1);
        }
    }

    public static class ThreadEvent {
        public final ThreadEventType type;
        public final int objectId;
        public final int threadId;
        public final String threadName;
        public final String groupName;

        public static ThreadEvent start(int objectId, int threadId, Thread thread) {
            return new ThreadEvent(ThreadEventType.START, objectId, threadId, thread);
        }

        public static ThreadEvent stop(int threadId) {
            return new ThreadEvent(ThreadEventType.STOP, threadId);
        }

        public ThreadEvent(ThreadEventType type, int objectId, int threadId, Thread thread) {
            this.type = ThreadEventType.START;
            this.objectId = objectId;
            this.threadId = threadId;
            this.threadName = thread.getName();
            this.groupName = thread.getThreadGroup().getName();
        }

        public ThreadEvent(ThreadEventType type, int threadId) {
            this.type = ThreadEventType.STOP;
            this.objectId = -1;
            this.threadId = threadId;
            this.threadName = null;
            this.groupName = null;
        }

        public String toString() {
            switch (this.type) {
                case START: {
                    return String.format("THREAD START (obj=%d, id = %d, name=\"%s\", group=\"%s\")", this.objectId, this.threadId, this.threadName, this.groupName);
                }
                case STOP: {
                    return String.format("THREAD END (id = %d)", this.threadId);
                }
            }
            throw new IllegalStateException(this.type.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ThreadEventType {
        START,
        STOP;

    }

    public class Sampler
    extends TimerTask {
        public Thread timerThread;
        public Thread[] currentThreads = new Thread[0];
        public final Trace mutableTrace = new Trace(null);

        public Sampler() {
        }

        public void run() {
            Object[] newThreads;
            if (this.timerThread == null) {
                this.timerThread = Thread.currentThread();
            }
            if (!Arrays.equals(this.currentThreads, newThreads = SamplingProfiler.this.threadSet.threads())) {
                this.updateThreadHistory(this.currentThreads, (Thread[])newThreads);
                this.currentThreads = (Thread[])newThreads.clone();
            }
            for (Thread thread : this.currentThreads) {
                if (thread == null) break;
                if (thread == this.timerThread) continue;
                StackTraceElement[] stack = thread.getStackTrace();
                if (stack.length > SamplingProfiler.this.depth) {
                    stack = Arrays.copyOfRange(stack, 0, SamplingProfiler.this.depth);
                }
                this.mutableTrace.threadId = (Integer)SamplingProfiler.this.threadIds.get(thread);
                Trace.access$602(this.mutableTrace, stack);
                int[] count = (int[])SamplingProfiler.this.traces.get(this.mutableTrace);
                if (count == null) {
                    Trace trace = new Trace(SamplingProfiler.this.nextTraceId++, this.mutableTrace, null);
                    count = new int[1];
                    SamplingProfiler.this.traces.put(trace, count);
                }
                count[0] = count[0] + 1;
            }
        }

        public void updateThreadHistory(Thread[] oldThreads, Thread[] newThreads) {
            ThreadEvent event;
            int threadId;
            HashSet<Thread> n = new HashSet<Thread>(Arrays.asList(newThreads));
            HashSet<Thread> o = new HashSet<Thread>(Arrays.asList(oldThreads));
            HashSet<Thread> added = new HashSet<Thread>(n);
            added.removeAll(o);
            HashSet<Thread> removed = new HashSet<Thread>(o);
            removed.removeAll(n);
            for (Thread thread : added) {
                if (thread == null || thread == this.timerThread) continue;
                threadId = SamplingProfiler.this.nextThreadId++;
                SamplingProfiler.this.threadIds.put(thread, threadId);
                event = ThreadEvent.start(SamplingProfiler.this.nextObjectId++, threadId, thread);
                SamplingProfiler.this.threadHistory.add(event);
            }
            for (Thread thread : removed) {
                if (thread == null || thread == this.timerThread) continue;
                threadId = (Integer)SamplingProfiler.this.threadIds.remove(thread);
                event = ThreadEvent.stop(threadId);
                SamplingProfiler.this.threadHistory.add(event);
            }
        }

        public /* synthetic */ Sampler(1 x1) {
            this();
        }
    }

    public static class ThreadGroupThreadSet
    implements ThreadSet {
        public final ThreadGroup threadGroup;
        public Thread[] threads;
        public int lastThread;

        public ThreadGroupThreadSet(ThreadGroup threadGroup) {
            if (threadGroup == null) {
                throw new NullPointerException("threadGroup == null");
            }
            this.threadGroup = threadGroup;
            this.resize();
        }

        public void resize() {
            int count = this.threadGroup.activeCount();
            this.threads = new Thread[count * 2];
            this.lastThread = 0;
        }

        public Thread[] threads() {
            int threadCount;
            while ((threadCount = this.threadGroup.enumerate(this.threads)) == this.threads.length) {
                this.resize();
            }
            if (threadCount < this.lastThread) {
                Arrays.fill(this.threads, threadCount, this.lastThread, null);
            }
            this.lastThread = threadCount;
            return this.threads;
        }
    }

    public static class ArrayThreadSet
    implements ThreadSet {
        public final Thread[] threads;

        public ArrayThreadSet(Thread ... threads) {
            if (threads == null) {
                throw new NullPointerException("threads == null");
            }
            this.threads = threads;
        }

        public Thread[] threads() {
            return this.threads;
        }
    }

    public static interface ThreadSet {
        public Thread[] threads();
    }
}

