/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import dalvik.system.DexFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathClassLoader
extends ClassLoader {
    public final String path;
    public final String libPath;
    public final String[] mPaths;
    public final File[] mFiles;
    public final ZipFile[] mZips;
    public final DexFile[] mDexs;
    public final List<String> libraryPathElements;

    public PathClassLoader(String path, ClassLoader parent) {
        this(path, null, parent);
    }

    public PathClassLoader(String path, String libPath, ClassLoader parent) {
        super(parent);
        String systemLibraryPath;
        if (path == null) {
            throw new NullPointerException();
        }
        this.path = path;
        this.libPath = libPath;
        this.mPaths = path.split(":");
        int length = this.mPaths.length;
        this.mFiles = new File[length];
        this.mZips = new ZipFile[length];
        this.mDexs = new DexFile[length];
        boolean wantDex = System.getProperty("android.vm.dexfile", "").equals("true");
        for (int i = 0; i < length; ++i) {
            File pathFile;
            this.mFiles[i] = pathFile = new File(this.mPaths[i]);
            if (!pathFile.isFile()) continue;
            try {
                this.mZips[i] = new ZipFile(pathFile);
            }
            catch (IOException ioex) {
                // empty catch block
            }
            if (!wantDex) continue;
            try {
                this.mDexs[i] = new DexFile(pathFile);
                continue;
            }
            catch (IOException ioex) {
                // empty catch block
            }
        }
        this.libraryPathElements = new ArrayList<String>();
        if (libPath != null) {
            for (String pathElement : libPath.split(File.pathSeparator)) {
                this.libraryPathElements.add(this.cleanupPathElement(pathElement));
            }
        }
        if (!(systemLibraryPath = System.getProperty("java.library.path", ".")).isEmpty()) {
            for (String pathElement : systemLibraryPath.split(File.pathSeparator)) {
                this.libraryPathElements.add(this.cleanupPathElement(pathElement));
            }
        }
    }

    public String cleanupPathElement(String path) {
        return path.endsWith(File.separator) ? path : path + File.separator;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] data = null;
        int length = this.mPaths.length;
        for (int i = 0; i < length; ++i) {
            if (this.mDexs[i] != null) {
                Class clazz = this.mDexs[i].loadClassBinaryName(name, this);
                if (clazz == null) continue;
                return clazz;
            }
            if (this.mZips[i] != null) {
                String fileName = name.replace('.', '/') + ".class";
                data = this.loadFromArchive(this.mZips[i], fileName);
                continue;
            }
            File pathFile = this.mFiles[i];
            if (!pathFile.isDirectory()) continue;
            String fileName = this.mPaths[i] + "/" + name.replace('.', '/') + ".class";
            data = this.loadFromDirectory(fileName);
        }
        throw new ClassNotFoundException(name + " in loader " + this);
    }

    @Override
    public URL findResource(String name) {
        int length = this.mPaths.length;
        for (int i = 0; i < length; ++i) {
            URL result = this.findResource(name, i);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String resName) {
        int length = this.mPaths.length;
        ArrayList<URL> results = new ArrayList<URL>();
        for (int i = 0; i < length; ++i) {
            URL result = this.findResource(resName, i);
            if (result == null) continue;
            results.add(result);
        }
        return new EnumerateListArray<URL>(results);
    }

    public URL findResource(String name, int i) {
        File pathFile = this.mFiles[i];
        ZipFile zip = this.mZips[i];
        if (zip != null) {
            if (this.isInArchive(zip, name)) {
                try {
                    return new URL("jar:" + pathFile.toURL() + "!/" + name);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (pathFile.isDirectory()) {
            File dataFile = new File(this.mPaths[i] + "/" + name);
            if (dataFile.exists()) {
                try {
                    return dataFile.toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (!pathFile.isFile()) {
            System.err.println("PathClassLoader: can't find '" + this.mPaths[i] + "'");
        }
        return null;
    }

    public byte[] loadFromDirectory(String path) {
        byte[] fileData;
        RandomAccessFile raf;
        try {
            raf = new RandomAccessFile(path, "r");
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
        try {
            fileData = new byte[(int)raf.length()];
            raf.read(fileData);
            raf.close();
        }
        catch (IOException ioe) {
            System.err.println("Error reading from " + path);
            fileData = null;
        }
        return fileData;
    }

    public byte[] loadFromArchive(ZipFile zip, String name) {
        ByteArrayOutputStream byteStream;
        ZipEntry entry = zip.getEntry(name);
        if (entry == null) {
            return null;
        }
        try {
            int count;
            InputStream stream = zip.getInputStream(entry);
            byteStream = new ByteArrayOutputStream((int)entry.getSize());
            byte[] buf = new byte[4096];
            while ((count = stream.read(buf)) > 0) {
                byteStream.write(buf, 0, count);
            }
            stream.close();
        }
        catch (IOException ioex) {
            return null;
        }
        return byteStream.toByteArray();
    }

    public boolean isInArchive(ZipFile zip, String name) {
        return zip.getEntry(name) != null;
    }

    @Override
    public String findLibrary(String libname) {
        String fileName = System.mapLibraryName(libname);
        for (String pathElement : this.libraryPathElements) {
            String pathName = pathElement + fileName;
            File test = new File(pathName);
            if (!test.exists()) continue;
            return pathName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package getPackage(String name) {
        if (name != null && !name.isEmpty()) {
            PathClassLoader pathClassLoader = this;
            synchronized (pathClassLoader) {
                Package pack = super.getPackage(name);
                if (pack == null) {
                    pack = this.definePackage(name, "Unknown", "0.0", "Unknown", "Unknown", "0.0", "Unknown", null);
                }
                return pack;
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.path + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerateListArray<T>
    implements Enumeration<T> {
        public final ArrayList mList;
        public int i = 0;

        public EnumerateListArray(ArrayList list) {
            this.mList = list;
        }

        @Override
        public boolean hasMoreElements() {
            return this.i < this.mList.size();
        }

        @Override
        public T nextElement() {
            if (this.i >= this.mList.size()) {
                throw new NoSuchElementException();
            }
            return (T)this.mList.get(this.i++);
        }
    }
}

