/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl.binding;

import android.database.DataSetObserver;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.DataBindingItem;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BaseAdapter {
    private final AdapterBinding mBinding;
    private final IProjectCallback mCallback;
    private final ResourceReference mAdapterRef;
    private boolean mSkipCallbackParser = false;
    protected final List<AdapterItem> mItems = new ArrayList<AdapterItem>();

    protected BaseAdapter(ResourceReference adapterRef, AdapterBinding binding, IProjectCallback callback) {
        this.mAdapterRef = adapterRef;
        this.mBinding = binding;
        this.mCallback = callback;
    }

    public boolean areAllItemsEnabled() {
        return true;
    }

    public boolean hasStableIds() {
        return true;
    }

    public boolean isEmpty() {
        return this.mItems.size() == 0;
    }

    public void registerDataSetObserver(DataSetObserver observer) {
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
    }

    protected AdapterBinding getBinding() {
        return this.mBinding;
    }

    protected View getView(AdapterItem item, AdapterItem parentItem, View convertView, ViewGroup parent) {
        DataBindingItem dataBindingItem = item.getDataBindingItem();
        BridgeContext context = RenderAction.getCurrentContext();
        Pair<View, Boolean> pair = context.inflateView(dataBindingItem.getViewReference(), parent, false, this.mSkipCallbackParser);
        View view = (View)pair.getFirst();
        this.mSkipCallbackParser |= ((Boolean)pair.getSecond()).booleanValue();
        if (view != null) {
            this.fillView(context, view, item, parentItem);
        } else {
            TextView tv = new TextView(context);
            tv.setText("Unable to find layout: " + dataBindingItem.getViewReference().getName());
            view = tv;
        }
        return view;
    }

    private void fillView(BridgeContext context, View view, AdapterItem item, AdapterItem parentItem) {
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.fillView(context, group.getChildAt(i), item, parentItem);
            }
        } else {
            ResourceReference resolvedRef;
            int id2 = view.getId();
            if (id2 != 0 && (resolvedRef = context.resolveId(id2)) != null) {
                Object value;
                int parentPositionPerType;
                int fullPosition = item.getFullPosition();
                int positionPerType = item.getPositionPerType();
                int fullParentPosition = parentItem != null ? parentItem.getFullPosition() : 0;
                int n = parentPositionPerType = parentItem != null ? parentItem.getPositionPerType() : 0;
                if (view instanceof TextView) {
                    TextView tv = (TextView)view;
                    value = this.mCallback.getAdapterItemValue(this.mAdapterRef, context.getViewKey(view), item.getDataBindingItem().getViewReference(), fullPosition, positionPerType, fullParentPosition, parentPositionPerType, resolvedRef, IProjectCallback.ViewAttribute.TEXT, (Object)((Object)tv.getText()).toString());
                    if (value != null) {
                        if (value.getClass() != IProjectCallback.ViewAttribute.TEXT.getAttributeClass()) {
                            Bridge.getLog().error("broken", String.format("Wrong Adapter Item value class for TEXT. Expected String, got %s", value.getClass().getName()), null);
                        } else {
                            tv.setText((String)value);
                        }
                    }
                }
                if (view instanceof Checkable) {
                    Checkable cb = (Checkable)((Object)view);
                    value = this.mCallback.getAdapterItemValue(this.mAdapterRef, context.getViewKey(view), item.getDataBindingItem().getViewReference(), fullPosition, positionPerType, fullParentPosition, parentPositionPerType, resolvedRef, IProjectCallback.ViewAttribute.IS_CHECKED, (Object)cb.isChecked());
                    if (value != null) {
                        if (value.getClass() != IProjectCallback.ViewAttribute.IS_CHECKED.getAttributeClass()) {
                            Bridge.getLog().error("broken", String.format("Wrong Adapter Item value class for TEXT. Expected Boolean, got %s", value.getClass().getName()), null);
                        } else {
                            cb.setChecked((Boolean)value);
                        }
                    }
                }
                if (view instanceof ImageView) {
                    ImageView iv = (ImageView)view;
                    value = this.mCallback.getAdapterItemValue(this.mAdapterRef, context.getViewKey(view), item.getDataBindingItem().getViewReference(), fullPosition, positionPerType, fullParentPosition, parentPositionPerType, resolvedRef, IProjectCallback.ViewAttribute.SRC, (Object)iv.getDrawable());
                    if (value != null && value.getClass() != IProjectCallback.ViewAttribute.SRC.getAttributeClass()) {
                        Bridge.getLog().error("broken", String.format("Wrong Adapter Item value class for TEXT. Expected Boolean, got %s", value.getClass().getName()), null);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class AdapterItem {
        private final DataBindingItem mItem;
        private final int mType;
        private final int mFullPosition;
        private final int mPositionPerType;
        private List<AdapterItem> mChildren;

        protected AdapterItem(DataBindingItem item, int type, int fullPosition, int positionPerType) {
            this.mItem = item;
            this.mType = type;
            this.mFullPosition = fullPosition;
            this.mPositionPerType = positionPerType;
        }

        void addChild(AdapterItem child) {
            if (this.mChildren == null) {
                this.mChildren = new ArrayList<AdapterItem>();
            }
            this.mChildren.add(child);
        }

        List<AdapterItem> getChildren() {
            if (this.mChildren != null) {
                return this.mChildren;
            }
            return Collections.emptyList();
        }

        int getType() {
            return this.mType;
        }

        int getFullPosition() {
            return this.mFullPosition;
        }

        int getPositionPerType() {
            return this.mPositionPerType;
        }

        DataBindingItem getDataBindingItem() {
            return this.mItem;
        }
    }
}

