/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.os.HandlerThread_Delegate;
import android.util.DisplayMetrics;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderParams;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.Result;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.resources.ResourceType;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RenderAction<T extends RenderParams>
extends RenderResources.FrameworkResourceIdProvider {
    private static BridgeContext sCurrentContext = null;
    private final T mParams;
    private BridgeContext mContext;

    protected RenderAction(T params) {
        this.mParams = params;
    }

    public Result init(long timeout) {
        Result result = this.acquireLock(timeout);
        if (result != null) {
            return result;
        }
        DisplayMetrics metrics = new DisplayMetrics();
        metrics.densityDpi = this.mParams.getDensity().getDpiValue();
        metrics.scaledDensity = metrics.density = (float)metrics.densityDpi / 160.0f;
        metrics.widthPixels = this.mParams.getScreenWidth();
        metrics.heightPixels = this.mParams.getScreenHeight();
        metrics.xdpi = this.mParams.getXdpi();
        metrics.ydpi = this.mParams.getYdpi();
        RenderResources resources = this.mParams.getResources();
        this.mContext = new BridgeContext(this.mParams.getProjectKey(), metrics, resources, this.mParams.getProjectCallback(), this.mParams.getTargetSdkVersion());
        this.setUp();
        return Result.Status.SUCCESS.createResult();
    }

    public Result acquire(long timeout) {
        if (this.mContext == null) {
            throw new IllegalStateException("After scene creation, #init() must be called");
        }
        Result result = this.acquireLock(timeout);
        if (result != null) {
            return result;
        }
        this.setUp();
        return Result.Status.SUCCESS.createResult();
    }

    private Result acquireLock(long timeout) {
        block5: {
            ReentrantLock lock = Bridge.getLock();
            if (!lock.isHeldByCurrentThread()) {
                try {
                    boolean acquired = lock.tryLock(timeout, TimeUnit.MILLISECONDS);
                    if (!acquired) {
                        return Result.Status.ERROR_TIMEOUT.createResult();
                    }
                    break block5;
                }
                catch (InterruptedException e) {
                    return Result.Status.ERROR_LOCK_INTERRUPTED.createResult();
                }
            }
            if (this.mContext != sCurrentContext) {
                throw new IllegalStateException("Acquiring different scenes from same thread without releases");
            }
            return Result.Status.SUCCESS.createResult();
        }
        return null;
    }

    public void release() {
        ReentrantLock lock = Bridge.getLock();
        if (lock.isHeldByCurrentThread()) {
            this.tearDown();
            lock.unlock();
        }
    }

    private void setUp() {
        this.mContext.initResources();
        sCurrentContext = this.mContext;
        LayoutLog currentLog = this.mParams.getLog();
        Bridge.setLog(currentLog);
        this.mContext.getRenderResources().setFrameworkResourceIdProvider((RenderResources.FrameworkResourceIdProvider)this);
        this.mContext.getRenderResources().setLogger(currentLog);
    }

    private void tearDown() {
        this.mContext.disposeResources();
        HandlerThread_Delegate.cleanUp(sCurrentContext);
        sCurrentContext = null;
        Bridge.setLog(null);
        this.mContext.getRenderResources().setFrameworkResourceIdProvider(null);
        this.mContext.getRenderResources().setLogger(null);
    }

    public static BridgeContext getCurrentContext() {
        return sCurrentContext;
    }

    protected T getParams() {
        return this.mParams;
    }

    protected BridgeContext getContext() {
        return this.mContext;
    }

    public LayoutLog getLog() {
        if (this.mParams != null) {
            return this.mParams.getLog();
        }
        return null;
    }

    protected void checkLock() {
        ReentrantLock lock = Bridge.getLock();
        if (!lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("scene must be acquired first. see #acquire(long)");
        }
        if (sCurrentContext != this.mContext) {
            throw new IllegalStateException("Thread acquired a scene but is rendering a different one");
        }
    }

    public Integer getId(ResourceType resType, String resName) {
        return Bridge.getResourceId(resType, resName);
    }
}

