/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import java.io.IOException;
import java.io.InputStream;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

abstract class CustomBar
extends LinearLayout {
    protected abstract TextView getStyleableTextView();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CustomBar(Context context, Density density, String layoutPath) throws XmlPullParserException {
        super(context);
        this.setOrientation(0);
        this.setGravity(16);
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        KXmlParser parser = new KXmlParser();
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        parser.setInput(this.getClass().getResourceAsStream(layoutPath), "UTF8");
        BridgeXmlBlockParser bridgeParser = new BridgeXmlBlockParser((XmlPullParser)parser, (BridgeContext)context, false);
        try {
            inflater.inflate(bridgeParser, (ViewGroup)this, true);
        }
        finally {
            bridgeParser.ensurePopped();
        }
    }

    private InputStream getIcon(String iconName, Density[] densityInOut, String[] pathOut, boolean tryOtherDensities) {
        Density density = densityInOut[0];
        pathOut[0] = "/bars/" + density.getResourceValue() + "/" + iconName;
        InputStream stream = this.getClass().getResourceAsStream(pathOut[0]);
        if (stream == null && tryOtherDensities) {
            for (Density d : Density.values()) {
                if (d == density) continue;
                densityInOut[0] = d;
                stream = this.getIcon(iconName, densityInOut, pathOut, false);
                if (stream == null) continue;
                return stream;
            }
        }
        return stream;
    }

    protected void loadIcon(int index, String iconName, Density density) {
        View child = this.getChildAt(index);
        if (child instanceof ImageView) {
            ImageView imageView = (ImageView)child;
            String[] pathOut = new String[1];
            Density[] densityInOut = new Density[]{density};
            InputStream stream = this.getIcon(iconName, densityInOut, pathOut, true);
            density = densityInOut[0];
            if (stream != null) {
                Bitmap bitmap = Bridge.getCachedBitmap(pathOut[0], true);
                if (bitmap == null) {
                    try {
                        bitmap = Bitmap_Delegate.createBitmap(stream, false, density);
                        Bridge.setCachedBitmap(pathOut[0], bitmap, true);
                    }
                    catch (IOException e) {
                        return;
                    }
                }
                if (bitmap != null) {
                    BitmapDrawable drawable2 = new BitmapDrawable(this.getContext().getResources(), bitmap);
                    imageView.setBackgroundDrawable(drawable2);
                }
            }
        }
    }

    protected void loadIcon(int index, String iconReference) {
        ResourceValue value = this.getResourceValue(iconReference);
        if (value != null) {
            this.loadIcon(index, value);
        }
    }

    protected Drawable loadIcon(int index, ResourceType type, String name) {
        BridgeContext bridgeContext = (BridgeContext)this.mContext;
        RenderResources res = bridgeContext.getRenderResources();
        ResourceValue value = res.getFrameworkResource(type, name);
        value = res.resolveResValue(value);
        return this.loadIcon(index, value);
    }

    private Drawable loadIcon(int index, ResourceValue value) {
        View child = this.getChildAt(index);
        if (child instanceof ImageView) {
            ImageView imageView = (ImageView)child;
            Drawable drawable2 = ResourceHelper.getDrawable(value, (BridgeContext)this.mContext);
            if (drawable2 != null) {
                imageView.setBackgroundDrawable(drawable2);
            }
            return drawable2;
        }
        return null;
    }

    protected TextView setText(int index, String stringReference) {
        View child = this.getChildAt(index);
        if (child instanceof TextView) {
            TextView textView = (TextView)child;
            ResourceValue value = this.getResourceValue(stringReference);
            if (value != null) {
                textView.setText(value.getValue());
            } else {
                textView.setText(stringReference);
            }
            return textView;
        }
        return null;
    }

    protected void setStyle(String themeEntryName) {
        TextView textView;
        Drawable d;
        BridgeContext bridgeContext = (BridgeContext)this.mContext;
        RenderResources res = bridgeContext.getRenderResources();
        ResourceValue value = res.findItemInTheme(themeEntryName);
        if (!((value = res.resolveResValue(value)) instanceof StyleResourceValue)) {
            return;
        }
        StyleResourceValue style2 = (StyleResourceValue)value;
        ResourceValue backgroundValue = res.findItemInStyle(style2, "background");
        if ((backgroundValue = res.resolveResValue(backgroundValue)) != null && (d = ResourceHelper.getDrawable(backgroundValue, bridgeContext)) != null) {
            this.setBackgroundDrawable(d);
        }
        if ((textView = this.getStyleableTextView()) != null) {
            ResourceValue textStyleValue = res.findItemInStyle(style2, "titleTextStyle");
            if ((textStyleValue = res.resolveResValue(textStyleValue)) instanceof StyleResourceValue) {
                ColorStateList stateList;
                StyleResourceValue textStyle = (StyleResourceValue)textStyleValue;
                ResourceValue textSize = res.findItemInStyle(textStyle, "textSize");
                if ((textSize = res.resolveResValue(textSize)) != null) {
                    TypedValue out = new TypedValue();
                    if (ResourceHelper.stringToFloat(textSize.getValue(), out)) {
                        textView.setTextSize(out.getDimension(bridgeContext.getResources().mMetrics));
                    }
                }
                ResourceValue textColor = res.findItemInStyle(textStyle, "textColor");
                if ((textColor = res.resolveResValue(textColor)) != null && (stateList = ResourceHelper.getColorStateList(textColor, bridgeContext)) != null) {
                    textView.setTextColor(stateList);
                }
            }
        }
    }

    private ResourceValue getResourceValue(String reference) {
        BridgeContext bridgeContext = (BridgeContext)this.mContext;
        RenderResources res = bridgeContext.getRenderResources();
        ResourceValue value = res.findResValue(reference, false);
        return res.resolveResValue(value);
    }
}

