/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge;

import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.Typeface_Delegate;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.android.ide.common.rendering.api.Capability;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.internal.R;
import com.android.layoutlib.bridge.BridgeRenderSession;
import com.android.layoutlib.bridge.android.BridgeAssetManager;
import com.android.layoutlib.bridge.impl.FontLoader;
import com.android.layoutlib.bridge.impl.RenderDrawable;
import com.android.layoutlib.bridge.impl.RenderSessionImpl;
import com.android.ninepatch.NinePatchChunk;
import com.android.resources.ResourceType;
import com.android.tools.layoutlib.create.MethodAdapter;
import com.android.tools.layoutlib.create.OverrideMethod;
import com.android.util.Pair;
import java.io.File;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Bridge
extends com.android.ide.common.rendering.api.Bridge {
    private static final ReentrantLock sLock = new ReentrantLock();
    private static final Map<Integer, Pair<ResourceType, String>> sRMap = new HashMap<Integer, Pair<ResourceType, String>>();
    private static final Map<IntArray, String> sRArrayMap = new HashMap<IntArray, String>();
    private static final Map<ResourceType, Map<String, Integer>> sRFullMap = new EnumMap<ResourceType, Map<String, Integer>>(ResourceType.class);
    private static final Map<Object, Map<String, SoftReference<Bitmap>>> sProjectBitmapCache = new HashMap<Object, Map<String, SoftReference<Bitmap>>>();
    private static final Map<Object, Map<String, SoftReference<NinePatchChunk>>> sProject9PatchCache = new HashMap<Object, Map<String, SoftReference<NinePatchChunk>>>();
    private static final Map<String, SoftReference<Bitmap>> sFrameworkBitmapCache = new HashMap<String, SoftReference<Bitmap>>();
    private static final Map<String, SoftReference<NinePatchChunk>> sFramework9PatchCache = new HashMap<String, SoftReference<NinePatchChunk>>();
    private static Map<String, Map<String, Integer>> sEnumValueMap;
    private static Map<String, String> sPlatformProperties;
    private static final IntArray sIntArrayWrapper;
    private static final LayoutLog sDefaultLog;
    private static LayoutLog sCurrentLog;
    private EnumSet<Capability> mCapabilities;

    public int getApiLevel() {
        return 6;
    }

    public EnumSet<Capability> getCapabilities() {
        return this.mCapabilities;
    }

    public boolean init(Map<String, String> platformProperties, File fontLocation, Map<String, Map<String, Integer>> enumValueMap, LayoutLog log) {
        FontLoader fontLoader;
        sPlatformProperties = platformProperties;
        sEnumValueMap = enumValueMap;
        this.mCapabilities = EnumSet.of(Capability.UNBOUND_RENDERING, new Capability[]{Capability.CUSTOM_BACKGROUND_COLOR, Capability.RENDER, Capability.LAYOUT_ONLY, Capability.EMBEDDED_LAYOUT, Capability.VIEW_MANIPULATION, Capability.ADAPTER_BINDING, Capability.EXTENDED_VIEWINFO});
        BridgeAssetManager.initSystem();
        final String debug = System.getenv("DEBUG_LAYOUT");
        if (debug != null && !debug.equals("0") && !debug.equals("false")) {
            OverrideMethod.setDefaultListener(new MethodAdapter(){

                public void onInvokeV(String signature, boolean isNative, Object caller) {
                    sDefaultLog.error(null, "Missing Stub: " + signature + (isNative ? " (native)" : ""), null);
                    if (debug.equalsIgnoreCase("throw")) {
                        throw new StaticMethodNotImplementedException(signature);
                    }
                }
            });
        }
        if ((fontLoader = FontLoader.create(fontLocation.getAbsolutePath())) == null) {
            return false;
        }
        Typeface_Delegate.init(fontLoader);
        try {
            Class<R> r = R.class;
            for (Class<?> inner : r.getDeclaredClasses()) {
                String resTypeName = inner.getSimpleName();
                ResourceType resType = ResourceType.getEnum((String)resTypeName);
                if (resType == null) continue;
                HashMap<String, Integer> fullMap = new HashMap<String, Integer>();
                sRFullMap.put(resType, fullMap);
                for (Field f : inner.getDeclaredFields()) {
                    int modifiers = f.getModifiers();
                    if (!Modifier.isStatic(modifiers)) continue;
                    Class<?> type = f.getType();
                    if (type.isArray() && type.getComponentType() == Integer.TYPE) {
                        sRArrayMap.put(new IntArray((int[])f.get(null)), f.getName());
                        continue;
                    }
                    if (type == Integer.TYPE) {
                        Integer value = (Integer)f.get(null);
                        sRMap.put(value, (Pair<ResourceType, String>)Pair.of((Object)resType, (Object)f.getName()));
                        fullMap.put(f.getName(), value);
                        continue;
                    }
                    assert (false);
                }
            }
        }
        catch (Throwable throwable) {
            if (log != null) {
                log.error("broken", "Failed to load com.android.internal.R from the layout library jar", (Object)throwable);
            }
            return false;
        }
        return true;
    }

    public boolean dispose() {
        BridgeAssetManager.clearSystem();
        Typeface.sDefaults = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderSession createSession(SessionParams params) {
        try {
            Result lastResult = Result.Status.SUCCESS.createResult();
            RenderSessionImpl scene = new RenderSessionImpl(params);
            try {
                Bridge.prepareThread();
                lastResult = scene.init(params.getTimeout());
                if (lastResult.isSuccess() && (lastResult = scene.inflate()).isSuccess()) {
                    lastResult = scene.render(true);
                }
            }
            finally {
                scene.release();
                Bridge.cleanupThread();
            }
            return new BridgeRenderSession(scene, lastResult);
        }
        catch (Throwable t) {
            Throwable t2 = t;
            while (t2.getCause() != null) {
                t2 = t.getCause();
            }
            return new BridgeRenderSession(null, Result.Status.ERROR_UNKNOWN.createResult(t2.getMessage(), t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result renderDrawable(DrawableParams params) {
        try {
            Result lastResult = Result.Status.SUCCESS.createResult();
            RenderDrawable action = new RenderDrawable(params);
            try {
                Bridge.prepareThread();
                lastResult = action.init(params.getTimeout());
                if (lastResult.isSuccess()) {
                    lastResult = action.render();
                }
            }
            finally {
                action.release();
                Bridge.cleanupThread();
            }
            return lastResult;
        }
        catch (Throwable t) {
            Throwable t2 = t;
            while (t2.getCause() != null) {
                t2 = t.getCause();
            }
            return Result.Status.ERROR_UNKNOWN.createResult(t2.getMessage(), t);
        }
    }

    public void clearCaches(Object projectKey) {
        if (projectKey != null) {
            sProjectBitmapCache.remove(projectKey);
            sProject9PatchCache.remove(projectKey);
        }
    }

    public Result getViewParent(Object viewObject) {
        if (viewObject instanceof View) {
            return Result.Status.SUCCESS.createResult((Object)((View)viewObject).getParent());
        }
        throw new IllegalArgumentException("viewObject is not a View");
    }

    public Result getViewIndex(Object viewObject) {
        if (viewObject instanceof View) {
            View view = (View)viewObject;
            ViewParent parentView = view.getParent();
            if (parentView instanceof ViewGroup) {
                Result.Status.SUCCESS.createResult((Object)((ViewGroup)parentView).indexOfChild(view));
            }
            return Result.Status.SUCCESS.createResult();
        }
        throw new IllegalArgumentException("viewObject is not a View");
    }

    public static ReentrantLock getLock() {
        return sLock;
    }

    public static void prepareThread() {
        if (Looper.myLooper() == null) {
            Looper.prepare();
        }
    }

    public static void cleanupThread() {
        Looper.sThreadLocal.remove();
    }

    public static LayoutLog getLog() {
        return sCurrentLog;
    }

    public static void setLog(LayoutLog log) {
        if (!sLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("scene must be acquired first. see #acquire(long)");
        }
        sCurrentLog = log != null ? log : sDefaultLog;
    }

    public static Pair<ResourceType, String> resolveResourceId(int value) {
        return sRMap.get(value);
    }

    public static String resolveResourceId(int[] array2) {
        Bridge.sIntArrayWrapper.set(array2);
        return sRArrayMap.get(sIntArrayWrapper);
    }

    public static Integer getResourceId(ResourceType type, String name) {
        Map<String, Integer> map = sRFullMap.get(type);
        if (map != null) {
            return map.get(name);
        }
        return null;
    }

    public static Map<String, Integer> getEnumValues(String attributeName) {
        if (sEnumValueMap != null) {
            return sEnumValueMap.get(attributeName);
        }
        return null;
    }

    public static Map<String, String> getPlatformProperties() {
        return sPlatformProperties;
    }

    public static Bitmap getCachedBitmap(String value, Object projectKey) {
        if (projectKey != null) {
            SoftReference<Bitmap> ref;
            Map<String, SoftReference<Bitmap>> map = sProjectBitmapCache.get(projectKey);
            if (map != null && (ref = map.get(value)) != null) {
                return ref.get();
            }
        } else {
            SoftReference<Bitmap> ref = sFrameworkBitmapCache.get(value);
            if (ref != null) {
                return ref.get();
            }
        }
        return null;
    }

    public static void setCachedBitmap(String value, Bitmap bmp, Object projectKey) {
        if (projectKey != null) {
            Map<String, SoftReference<Bitmap>> map = sProjectBitmapCache.get(projectKey);
            if (map == null) {
                map = new HashMap<String, SoftReference<Bitmap>>();
                sProjectBitmapCache.put(projectKey, map);
            }
            map.put(value, new SoftReference<Bitmap>(bmp));
        } else {
            sFrameworkBitmapCache.put(value, new SoftReference<Bitmap>(bmp));
        }
    }

    public static NinePatchChunk getCached9Patch(String value, Object projectKey) {
        if (projectKey != null) {
            SoftReference<NinePatchChunk> ref;
            Map<String, SoftReference<NinePatchChunk>> map = sProject9PatchCache.get(projectKey);
            if (map != null && (ref = map.get(value)) != null) {
                return ref.get();
            }
        } else {
            SoftReference<NinePatchChunk> ref = sFramework9PatchCache.get(value);
            if (ref != null) {
                return ref.get();
            }
        }
        return null;
    }

    public static void setCached9Patch(String value, NinePatchChunk ninePatch, Object projectKey) {
        if (projectKey != null) {
            Map<String, SoftReference<NinePatchChunk>> map = sProject9PatchCache.get(projectKey);
            if (map == null) {
                map = new HashMap<String, SoftReference<NinePatchChunk>>();
                sProject9PatchCache.put(projectKey, map);
            }
            map.put(value, new SoftReference<NinePatchChunk>(ninePatch));
        } else {
            sFramework9PatchCache.put(value, new SoftReference<NinePatchChunk>(ninePatch));
        }
    }

    static {
        sIntArrayWrapper = new IntArray();
        sCurrentLog = sDefaultLog = new LayoutLog(){

            public void error(String tag, String message, Object data) {
                System.err.println(message);
            }

            public void error(String tag, String message, Throwable throwable, Object data) {
                System.err.println(message);
            }

            public void warning(String tag, String message, Object data) {
                System.out.println(message);
            }
        };
    }

    private static final class IntArray {
        private int[] mArray;

        private IntArray() {
        }

        private IntArray(int[] a) {
            this.mArray = a;
        }

        private void set(int[] a) {
            this.mArray = a;
        }

        public int hashCode() {
            return Arrays.hashCode(this.mArray);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IntArray other = (IntArray)obj;
            return Arrays.equals(this.mArray, other.mArray);
        }
    }

    public static class StaticMethodNotImplementedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public StaticMethodNotImplementedException(String msg) {
            super(msg);
        }
    }
}

