/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;

public class NetworkInfo
implements Parcelable {
    public String operatorAlphaLong;
    public String operatorAlphaShort;
    public String operatorNumeric;
    public State state = State.UNKNOWN;
    public static final Parcelable.Creator<NetworkInfo> CREATOR = new Parcelable.Creator<NetworkInfo>(){

        @Override
        public NetworkInfo createFromParcel(Parcel in) {
            NetworkInfo netInfo = new NetworkInfo(in.readString(), in.readString(), in.readString(), (State)((Object)in.readSerializable()));
            return netInfo;
        }

        public NetworkInfo[] newArray(int size) {
            return new NetworkInfo[size];
        }
    };

    public String getOperatorAlphaLong() {
        return this.operatorAlphaLong;
    }

    public String getOperatorAlphaShort() {
        return this.operatorAlphaShort;
    }

    public String getOperatorNumeric() {
        return this.operatorNumeric;
    }

    public State getState() {
        return this.state;
    }

    public NetworkInfo(String operatorAlphaLong, String operatorAlphaShort, String operatorNumeric, State state) {
        this.operatorAlphaLong = operatorAlphaLong;
        this.operatorAlphaShort = operatorAlphaShort;
        this.operatorNumeric = operatorNumeric;
        this.state = state;
    }

    public NetworkInfo(String operatorAlphaLong, String operatorAlphaShort, String operatorNumeric, String stateString) {
        this(operatorAlphaLong, operatorAlphaShort, operatorNumeric, NetworkInfo.rilStateToState(stateString));
    }

    public static State rilStateToState(String s) {
        if (s.equals("unknown")) {
            return State.UNKNOWN;
        }
        if (s.equals("available")) {
            return State.AVAILABLE;
        }
        if (s.equals("current")) {
            return State.CURRENT;
        }
        if (s.equals("forbidden")) {
            return State.FORBIDDEN;
        }
        throw new RuntimeException("RIL impl error: Invalid network state '" + s + "'");
    }

    public String toString() {
        return "NetworkInfo " + this.operatorAlphaLong + "/" + this.operatorAlphaShort + "/" + this.operatorNumeric + "/" + (Object)((Object)this.state);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.operatorAlphaLong);
        dest.writeString(this.operatorAlphaShort);
        dest.writeString(this.operatorNumeric);
        dest.writeSerializable((Serializable)((Object)this.state));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNKNOWN,
        AVAILABLE,
        CURRENT,
        FORBIDDEN;

    }
}

