/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.webkit.CookieManager;
import android.webkit.WebSyncManager;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieSyncManager
extends WebSyncManager {
    public static CookieSyncManager sRef;
    public long mLastUpdate;

    public CookieSyncManager(Context context) {
        super(context, "CookieSyncManager");
    }

    public static synchronized CookieSyncManager getInstance() {
        if (sRef == null) {
            throw new IllegalStateException("CookieSyncManager::createInstance() needs to be called before CookieSyncManager::getInstance()");
        }
        return sRef;
    }

    public static synchronized CookieSyncManager createInstance(Context context) {
        if (sRef == null) {
            sRef = new CookieSyncManager(context.getApplicationContext());
        }
        return sRef;
    }

    public ArrayList<CookieManager.Cookie> getCookiesForDomain(String domain) {
        if (this.mDataBase == null) {
            return new ArrayList<CookieManager.Cookie>();
        }
        return this.mDataBase.getCookiesForDomain(domain);
    }

    public void clearAllCookies() {
        if (this.mDataBase == null) {
            return;
        }
        this.mDataBase.clearCookies();
    }

    public boolean hasCookies() {
        if (this.mDataBase == null) {
            return false;
        }
        return this.mDataBase.hasCookies();
    }

    public void clearSessionCookies() {
        if (this.mDataBase == null) {
            return;
        }
        this.mDataBase.clearSessionCookies();
    }

    public void clearExpiredCookies(long now) {
        if (this.mDataBase == null) {
            return;
        }
        this.mDataBase.clearExpiredCookies(now);
    }

    @Override
    public void syncFromRamToFlash() {
        if (!CookieManager.getInstance().acceptCookie()) {
            return;
        }
        ArrayList<CookieManager.Cookie> cookieList = CookieManager.getInstance().getUpdatedCookiesSince(this.mLastUpdate);
        this.mLastUpdate = System.currentTimeMillis();
        this.syncFromRamToFlash(cookieList);
        ArrayList<CookieManager.Cookie> lruList = CookieManager.getInstance().deleteLRUDomain();
        this.syncFromRamToFlash(lruList);
    }

    public void syncFromRamToFlash(ArrayList<CookieManager.Cookie> list) {
        for (CookieManager.Cookie cookie : list) {
            if (cookie.mode == 1) continue;
            if (cookie.mode != 0) {
                this.mDataBase.deleteCookies(cookie.domain, cookie.path, cookie.name);
            }
            if (cookie.mode != 2) {
                this.mDataBase.addCookie(cookie);
                CookieManager.getInstance().syncedACookie(cookie);
                continue;
            }
            CookieManager.getInstance().deleteACookie(cookie);
        }
    }
}

