/*
 * Decompiled with CFR 0.152.
 */
package android.text.util;

import android.text.Spannable;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.text.util.LinkSpec;
import android.util.Patterns;
import android.webkit.WebView;
import android.widget.TextView;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Linkify {
    public static final int WEB_URLS = 1;
    public static final int EMAIL_ADDRESSES = 2;
    public static final int PHONE_NUMBERS = 4;
    public static final int MAP_ADDRESSES = 8;
    public static final int ALL = 15;
    public static final int PHONE_NUMBER_MINIMUM_DIGITS = 5;
    public static final MatchFilter sUrlMatchFilter = new MatchFilter(){

        public boolean acceptMatch(CharSequence s, int start, int end) {
            if (start == 0) {
                return true;
            }
            return s.charAt(start - 1) != '@';
        }
    };
    public static final MatchFilter sPhoneNumberMatchFilter = new MatchFilter(){

        public boolean acceptMatch(CharSequence s, int start, int end) {
            int digitCount = 0;
            for (int i = start; i < end; ++i) {
                if (!Character.isDigit(s.charAt(i)) || ++digitCount < 5) continue;
                return true;
            }
            return false;
        }
    };
    public static final TransformFilter sPhoneNumberTransformFilter = new TransformFilter(){

        public String transformUrl(Matcher match, String url) {
            return Patterns.digitsAndPlusOnly(match);
        }
    };

    public static boolean addLinks(Spannable text, int mask) {
        if (mask == 0) {
            return false;
        }
        URLSpan[] old = text.getSpans(0, text.length(), URLSpan.class);
        for (int i = old.length - 1; i >= 0; --i) {
            text.removeSpan(old[i]);
        }
        ArrayList<LinkSpec> links = new ArrayList<LinkSpec>();
        if ((mask & 1) != 0) {
            Linkify.gatherLinks(links, text, Patterns.WEB_URL, new String[]{"http://", "https://", "rtsp://"}, sUrlMatchFilter, null);
        }
        if ((mask & 2) != 0) {
            Linkify.gatherLinks(links, text, Patterns.EMAIL_ADDRESS, new String[]{"mailto:"}, null, null);
        }
        if ((mask & 4) != 0) {
            Linkify.gatherLinks(links, text, Patterns.PHONE, new String[]{"tel:"}, sPhoneNumberMatchFilter, sPhoneNumberTransformFilter);
        }
        if ((mask & 8) != 0) {
            Linkify.gatherMapLinks(links, text);
        }
        Linkify.pruneOverlaps(links);
        if (links.size() == 0) {
            return false;
        }
        for (LinkSpec link : links) {
            Linkify.applyLink(link.url, link.start, link.end, text);
        }
        return true;
    }

    public static boolean addLinks(TextView text, int mask) {
        if (mask == 0) {
            return false;
        }
        CharSequence t = text.getText();
        if (t instanceof Spannable) {
            if (Linkify.addLinks((Spannable)t, mask)) {
                Linkify.addLinkMovementMethod(text);
                return true;
            }
            return false;
        }
        SpannableString s = SpannableString.valueOf(t);
        if (Linkify.addLinks(s, mask)) {
            Linkify.addLinkMovementMethod(text);
            text.setText(s);
            return true;
        }
        return false;
    }

    public static void addLinkMovementMethod(TextView t) {
        MovementMethod m = t.getMovementMethod();
        if ((m == null || !(m instanceof LinkMovementMethod)) && t.getLinksClickable()) {
            t.setMovementMethod(LinkMovementMethod.getInstance());
        }
    }

    public static void addLinks(TextView text, Pattern pattern, String scheme) {
        Linkify.addLinks(text, pattern, scheme, null, null);
    }

    public static void addLinks(TextView text, Pattern p, String scheme, MatchFilter matchFilter, TransformFilter transformFilter) {
        SpannableString s = SpannableString.valueOf(text.getText());
        if (Linkify.addLinks(s, p, scheme, matchFilter, transformFilter)) {
            text.setText(s);
            Linkify.addLinkMovementMethod(text);
        }
    }

    public static boolean addLinks(Spannable text, Pattern pattern, String scheme) {
        return Linkify.addLinks(text, pattern, scheme, null, null);
    }

    public static boolean addLinks(Spannable s, Pattern p, String scheme, MatchFilter matchFilter, TransformFilter transformFilter) {
        boolean hasMatches = false;
        String prefix = scheme == null ? "" : scheme.toLowerCase();
        Matcher m = p.matcher(s);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            boolean allowed = true;
            if (matchFilter != null) {
                allowed = matchFilter.acceptMatch(s, start, end);
            }
            if (!allowed) continue;
            String url = Linkify.makeUrl(m.group(0), new String[]{prefix}, m, transformFilter);
            Linkify.applyLink(url, start, end, s);
            hasMatches = true;
        }
        return hasMatches;
    }

    public static void applyLink(String url, int start, int end, Spannable text) {
        URLSpan span = new URLSpan(url);
        text.setSpan(span, start, end, 33);
    }

    public static String makeUrl(String url, String[] prefixes, Matcher m, TransformFilter filter) {
        if (filter != null) {
            url = filter.transformUrl(m, url);
        }
        boolean hasPrefix = false;
        for (int i = 0; i < prefixes.length; ++i) {
            if (!url.regionMatches(true, 0, prefixes[i], 0, prefixes[i].length())) continue;
            hasPrefix = true;
            if (url.regionMatches(false, 0, prefixes[i], 0, prefixes[i].length())) break;
            url = prefixes[i] + url.substring(prefixes[i].length());
            break;
        }
        if (!hasPrefix) {
            url = prefixes[0] + url;
        }
        return url;
    }

    public static void gatherLinks(ArrayList<LinkSpec> links, Spannable s, Pattern pattern, String[] schemes, MatchFilter matchFilter, TransformFilter transformFilter) {
        Matcher m = pattern.matcher(s);
        while (m.find()) {
            String url;
            int start = m.start();
            int end = m.end();
            if (matchFilter != null && !matchFilter.acceptMatch(s, start, end)) continue;
            LinkSpec spec = new LinkSpec();
            spec.url = url = Linkify.makeUrl(m.group(0), schemes, m, transformFilter);
            spec.start = start;
            spec.end = end;
            links.add(spec);
        }
    }

    public static void gatherMapLinks(ArrayList<LinkSpec> links, Spannable s) {
        int start;
        String address;
        String string2 = s.toString();
        int base = 0;
        while ((address = WebView.findAddress(string2)) != null && (start = string2.indexOf(address)) >= 0) {
            LinkSpec spec = new LinkSpec();
            int length = address.length();
            int end = start + length;
            spec.start = base + start;
            spec.end = base + end;
            string2 = string2.substring(end);
            base += end;
            String encodedAddress = null;
            try {
                encodedAddress = URLEncoder.encode(address, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                continue;
            }
            spec.url = "geo:0,0?q=" + encodedAddress;
            links.add(spec);
        }
    }

    public static void pruneOverlaps(ArrayList<LinkSpec> links) {
        Comparator<LinkSpec> c = new Comparator<LinkSpec>(){

            @Override
            public int compare(LinkSpec a, LinkSpec b) {
                if (a.start < b.start) {
                    return -1;
                }
                if (a.start > b.start) {
                    return 1;
                }
                if (a.end < b.end) {
                    return 1;
                }
                if (a.end > b.end) {
                    return -1;
                }
                return 0;
            }

            @Override
            public boolean equals(Object o) {
                return false;
            }
        };
        Collections.sort(links, c);
        int len = links.size();
        int i = 0;
        while (i < len - 1) {
            LinkSpec a = links.get(i);
            LinkSpec b = links.get(i + 1);
            int remove = -1;
            if (a.start <= b.start && a.end > b.start) {
                if (b.end <= a.end) {
                    remove = i + 1;
                } else if (a.end - a.start > b.end - b.start) {
                    remove = i + 1;
                } else if (a.end - a.start < b.end - b.start) {
                    remove = i;
                }
                if (remove != -1) {
                    links.remove(remove);
                    --len;
                    continue;
                }
            }
            ++i;
        }
    }

    public static interface TransformFilter {
        public String transformUrl(Matcher var1, String var2);
    }

    public static interface MatchFilter {
        public boolean acceptMatch(CharSequence var1, int var2, int var3);
    }
}

