/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Editable;
import android.text.Layout;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.TextUtils;
import android.text.method.KeyListener;
import android.text.method.MetaKeyKeyListener;
import android.text.method.TextKeyListener;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;

public abstract class BaseKeyListener
extends MetaKeyKeyListener
implements KeyListener {
    public static final Object OLD_SEL_START = new NoCopySpan.Concrete();

    public boolean backspace(View view, Editable content, int keyCode, KeyEvent event) {
        int selEnd;
        int b;
        boolean result = true;
        int a = Selection.getSelectionStart(content);
        int selStart = Math.min(a, b = Selection.getSelectionEnd(content));
        if (selStart != (selEnd = Math.max(a, b))) {
            content.delete(selStart, selEnd);
        } else if (this.altBackspace(view, content, keyCode, event)) {
            result = true;
        } else {
            int to = TextUtils.getOffsetBefore(content, selEnd);
            if (to != selEnd) {
                content.delete(Math.min(to, selEnd), Math.max(to, selEnd));
            } else {
                result = false;
            }
        }
        if (result) {
            BaseKeyListener.adjustMetaAfterKeypress(content);
        }
        return result;
    }

    public boolean altBackspace(View view, Editable content, int keyCode, KeyEvent event) {
        if (BaseKeyListener.getMetaState(content, 2) != 1) {
            return false;
        }
        if (!(view instanceof TextView)) {
            return false;
        }
        Layout layout2 = ((TextView)view).getLayout();
        if (layout2 == null) {
            return false;
        }
        int l = layout2.getLineForOffset(Selection.getSelectionStart(content));
        int start = layout2.getLineStart(l);
        int end = layout2.getLineEnd(l);
        if (end == start) {
            return false;
        }
        content.delete(start, end);
        return true;
    }

    public static int makeTextContentType(TextKeyListener.Capitalize caps, boolean autoText) {
        int contentType = 1;
        switch (caps) {
            case CHARACTERS: {
                contentType |= 0x1000;
                break;
            }
            case WORDS: {
                contentType |= 0x2000;
                break;
            }
            case SENTENCES: {
                contentType |= 0x4000;
            }
        }
        if (autoText) {
            contentType |= 0x8000;
        }
        return contentType;
    }

    public boolean onKeyDown(View view, Editable content, int keyCode, KeyEvent event) {
        if (keyCode == 67) {
            this.backspace(view, content, keyCode, event);
            return true;
        }
        return super.onKeyDown(view, content, keyCode, event);
    }

    public boolean onKeyOther(View view, Editable content, KeyEvent event) {
        if (event.getAction() != 2 || event.getKeyCode() != 0) {
            return false;
        }
        int a = Selection.getSelectionStart(content);
        int b = Selection.getSelectionEnd(content);
        int selStart = Math.min(a, b);
        int selEnd = Math.max(a, b);
        String text = event.getCharacters();
        if (text == null) {
            return false;
        }
        content.replace(selStart, selEnd, text);
        return true;
    }
}

