/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.telephony.CellLocation;
import android.telephony.NeighboringCellInfo;
import android.telephony.PhoneStateListener;
import com.android.internal.telephony.IPhoneSubInfo;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TelephonyManager {
    public static final String TAG = "TelephonyManager";
    public Context mContext;
    public ITelephonyRegistry mRegistry;
    public static TelephonyManager sInstance = new TelephonyManager();
    public static final String ACTION_PHONE_STATE_CHANGED = "android.intent.action.PHONE_STATE";
    public static final String EXTRA_STATE = "state";
    public static final String EXTRA_STATE_IDLE = Phone.State.IDLE.toString();
    public static final String EXTRA_STATE_RINGING = Phone.State.RINGING.toString();
    public static final String EXTRA_STATE_OFFHOOK = Phone.State.OFFHOOK.toString();
    public static final String EXTRA_INCOMING_NUMBER = "incoming_number";
    public static final int PHONE_TYPE_NONE = 0;
    public static final int PHONE_TYPE_GSM = 1;
    public static final int PHONE_TYPE_CDMA = 2;
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int NETWORK_TYPE_GPRS = 1;
    public static final int NETWORK_TYPE_EDGE = 2;
    public static final int NETWORK_TYPE_UMTS = 3;
    public static final int NETWORK_TYPE_CDMA = 4;
    public static final int NETWORK_TYPE_EVDO_0 = 5;
    public static final int NETWORK_TYPE_EVDO_A = 6;
    public static final int NETWORK_TYPE_1xRTT = 7;
    public static final int NETWORK_TYPE_HSDPA = 8;
    public static final int NETWORK_TYPE_HSUPA = 9;
    public static final int NETWORK_TYPE_HSPA = 10;
    public static final int NETWORK_TYPE_IDEN = 11;
    public static final int NETWORK_TYPE_EVDO_B = 12;
    public static final int NETWORK_TYPE_LTE = 13;
    public static final int NETWORK_TYPE_EHRPD = 14;
    public static final int SIM_STATE_UNKNOWN = 0;
    public static final int SIM_STATE_ABSENT = 1;
    public static final int SIM_STATE_PIN_REQUIRED = 2;
    public static final int SIM_STATE_PUK_REQUIRED = 3;
    public static final int SIM_STATE_NETWORK_LOCKED = 4;
    public static final int SIM_STATE_READY = 5;
    public static final int CALL_STATE_IDLE = 0;
    public static final int CALL_STATE_RINGING = 1;
    public static final int CALL_STATE_OFFHOOK = 2;
    public static final int DATA_ACTIVITY_NONE = 0;
    public static final int DATA_ACTIVITY_IN = 1;
    public static final int DATA_ACTIVITY_OUT = 2;
    public static final int DATA_ACTIVITY_INOUT = 3;
    public static final int DATA_ACTIVITY_DORMANT = 4;
    public static final int DATA_DISCONNECTED = 0;
    public static final int DATA_CONNECTING = 1;
    public static final int DATA_CONNECTED = 2;
    public static final int DATA_SUSPENDED = 3;

    public TelephonyManager(Context context) {
        this.mContext = context;
        this.mRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
    }

    public TelephonyManager() {
    }

    public static TelephonyManager getDefault() {
        return sInstance;
    }

    public String getDeviceSoftwareVersion() {
        try {
            return this.getSubscriberInfo().getDeviceSvn();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getDeviceId() {
        try {
            return this.getSubscriberInfo().getDeviceId();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public CellLocation getCellLocation() {
        try {
            Bundle bundle = this.getITelephony().getCellLocation();
            CellLocation cl = CellLocation.newFromBundle(bundle);
            if (cl.isEmpty()) {
                return null;
            }
            return cl;
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public void enableLocationUpdates() {
        try {
            this.getITelephony().enableLocationUpdates();
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void disableLocationUpdates() {
        try {
            this.getITelephony().disableLocationUpdates();
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public List<NeighboringCellInfo> getNeighboringCellInfo() {
        try {
            return this.getITelephony().getNeighboringCellInfo();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public int getPhoneType() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getActivePhoneType();
            }
            return this.getPhoneTypeFromProperty();
        }
        catch (RemoteException ex) {
            return this.getPhoneTypeFromProperty();
        }
        catch (NullPointerException ex) {
            return this.getPhoneTypeFromProperty();
        }
    }

    public int getPhoneTypeFromProperty() {
        int type = SystemProperties.getInt("gsm.current.phone-type", this.getPhoneTypeFromNetworkType());
        return type;
    }

    public int getPhoneTypeFromNetworkType() {
        int mode = SystemProperties.getInt("ro.telephony.default_network", -1);
        if (mode == -1) {
            return 0;
        }
        return PhoneFactory.getPhoneType(mode);
    }

    public String getNetworkOperatorName() {
        return SystemProperties.get("gsm.operator.alpha");
    }

    public String getNetworkOperator() {
        return SystemProperties.get("gsm.operator.numeric");
    }

    public boolean isNetworkRoaming() {
        return "true".equals(SystemProperties.get("gsm.operator.isroaming"));
    }

    public String getNetworkCountryIso() {
        return SystemProperties.get("gsm.operator.iso-country");
    }

    public int getNetworkType() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getNetworkType();
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public String getNetworkTypeName() {
        switch (this.getNetworkType()) {
            case 1: {
                return "GPRS";
            }
            case 2: {
                return "EDGE";
            }
            case 3: {
                return "UMTS";
            }
            case 8: {
                return "HSDPA";
            }
            case 9: {
                return "HSUPA";
            }
            case 10: {
                return "HSPA";
            }
            case 4: {
                return "CDMA";
            }
            case 5: {
                return "CDMA - EvDo rev. 0";
            }
            case 6: {
                return "CDMA - EvDo rev. A";
            }
            case 12: {
                return "CDMA - EvDo rev. B";
            }
            case 7: {
                return "CDMA - 1xRTT";
            }
        }
        return "UNKNOWN";
    }

    public boolean hasIccCard() {
        try {
            return this.getITelephony().hasIccCard();
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    public int getSimState() {
        String prop = SystemProperties.get("gsm.sim.state");
        if ("ABSENT".equals(prop)) {
            return 1;
        }
        if ("PIN_REQUIRED".equals(prop)) {
            return 2;
        }
        if ("PUK_REQUIRED".equals(prop)) {
            return 3;
        }
        if ("NETWORK_LOCKED".equals(prop)) {
            return 4;
        }
        if ("READY".equals(prop)) {
            return 5;
        }
        return 0;
    }

    public String getSimOperator() {
        return SystemProperties.get("gsm.sim.operator.numeric");
    }

    public String getSimOperatorName() {
        return SystemProperties.get("gsm.sim.operator.alpha");
    }

    public String getSimCountryIso() {
        return SystemProperties.get("gsm.sim.operator.iso-country");
    }

    public String getSimSerialNumber() {
        try {
            return this.getSubscriberInfo().getIccSerialNumber();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getSubscriberId() {
        try {
            return this.getSubscriberInfo().getSubscriberId();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getLine1Number() {
        try {
            return this.getSubscriberInfo().getLine1Number();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getLine1AlphaTag() {
        try {
            return this.getSubscriberInfo().getLine1AlphaTag();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getVoiceMailNumber() {
        try {
            return this.getSubscriberInfo().getVoiceMailNumber();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getCompleteVoiceMailNumber() {
        try {
            return this.getSubscriberInfo().getCompleteVoiceMailNumber();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public int getVoiceMessageCount() {
        try {
            return this.getITelephony().getVoiceMessageCount();
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public String getVoiceMailAlphaTag() {
        try {
            return this.getSubscriberInfo().getVoiceMailAlphaTag();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public IPhoneSubInfo getSubscriberInfo() {
        return IPhoneSubInfo.Stub.asInterface(ServiceManager.getService("iphonesubinfo"));
    }

    public int getCallState() {
        try {
            return this.getITelephony().getCallState();
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getDataActivity() {
        try {
            return this.getITelephony().getDataActivity();
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getDataState() {
        try {
            return this.getITelephony().getDataState();
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public ITelephony getITelephony() {
        return ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
    }

    public void listen(PhoneStateListener listener, int events) {
        String pkgForDebug = this.mContext != null ? this.mContext.getPackageName() : "<unknown>";
        try {
            Boolean notifyNow = this.getITelephony() != null;
            this.mRegistry.listen(pkgForDebug, listener.callback, events, notifyNow);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
    }

    public int getCdmaEriIconIndex() {
        try {
            return this.getITelephony().getCdmaEriIconIndex();
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    public int getCdmaEriIconMode() {
        try {
            return this.getITelephony().getCdmaEriIconMode();
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    public String getCdmaEriText() {
        try {
            return this.getITelephony().getCdmaEriText();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }
}

