/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;

public class WorkSource
implements Parcelable {
    public int mNum;
    public int[] mUids;
    public static final WorkSource sTmpWorkSource = new WorkSource(0);
    public static WorkSource sNewbWork;
    public static WorkSource sGoneWork;
    public static final Parcelable.Creator<WorkSource> CREATOR;

    public WorkSource() {
        this.mNum = 0;
    }

    public WorkSource(WorkSource orig) {
        if (orig == null) {
            this.mNum = 0;
            return;
        }
        this.mNum = orig.mNum;
        this.mUids = (int[])(orig.mUids != null ? (int[])orig.mUids.clone() : null);
    }

    public WorkSource(int uid) {
        this.mNum = 1;
        this.mUids = new int[]{uid, 0};
    }

    public WorkSource(Parcel in) {
        this.mNum = in.readInt();
        this.mUids = in.createIntArray();
    }

    public int size() {
        return this.mNum;
    }

    public int get(int index) {
        return this.mUids[index];
    }

    public void clear() {
        this.mNum = 0;
    }

    public boolean diff(WorkSource other) {
        int N = this.mNum;
        if (N != other.mNum) {
            return true;
        }
        int[] uids1 = this.mUids;
        int[] uids2 = other.mUids;
        for (int i = 0; i < N; ++i) {
            if (uids1[i] == uids2[i]) continue;
            return true;
        }
        return false;
    }

    public void set(WorkSource other) {
        if (other == null) {
            this.mNum = 0;
            return;
        }
        this.mNum = other.mNum;
        if (other.mUids != null) {
            if (this.mUids != null && this.mUids.length >= this.mNum) {
                System.arraycopy(other.mUids, 0, this.mUids, 0, this.mNum);
            } else {
                this.mUids = (int[])other.mUids.clone();
            }
        } else {
            this.mUids = null;
        }
    }

    public void set(int uid) {
        this.mNum = 1;
        if (this.mUids == null) {
            this.mUids = new int[2];
        }
        this.mUids[0] = uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkSource[] setReturningDiffs(WorkSource other) {
        WorkSource workSource = sTmpWorkSource;
        synchronized (workSource) {
            sNewbWork = null;
            sGoneWork = null;
            this.updateLocked(other, true, true);
            if (sNewbWork != null || sGoneWork != null) {
                WorkSource[] diffs = new WorkSource[]{sNewbWork, sGoneWork};
                return diffs;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(WorkSource other) {
        WorkSource workSource = sTmpWorkSource;
        synchronized (workSource) {
            return this.updateLocked(other, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkSource addReturningNewbs(WorkSource other) {
        WorkSource workSource = sTmpWorkSource;
        synchronized (workSource) {
            sNewbWork = null;
            this.updateLocked(other, false, true);
            return sNewbWork;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(int uid) {
        WorkSource workSource = sTmpWorkSource;
        synchronized (workSource) {
            WorkSource.sTmpWorkSource.mUids[0] = uid;
            return this.updateLocked(sTmpWorkSource, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkSource addReturningNewbs(int uid) {
        WorkSource workSource = sTmpWorkSource;
        synchronized (workSource) {
            sNewbWork = null;
            WorkSource.sTmpWorkSource.mUids[0] = uid;
            this.updateLocked(sTmpWorkSource, false, true);
            return sNewbWork;
        }
    }

    public boolean remove(WorkSource other) {
        int N1 = this.mNum;
        int[] uids1 = this.mUids;
        int N2 = other.mNum;
        int[] uids2 = other.mUids;
        boolean changed = false;
        int i1 = 0;
        for (int i2 = 0; i2 < N2 && i1 < N1; ++i2) {
            if (uids2[i2] == uids1[i1] && i1 < --N1) {
                System.arraycopy(uids1, i1 + 1, uids1, i1, N1 - i1);
            }
            while (i1 < N1 && uids2[i2] > uids1[i1]) {
                ++i1;
            }
        }
        this.mNum = N1;
        return changed;
    }

    public boolean updateLocked(WorkSource other, boolean set, boolean returnNewbs) {
        int N1 = this.mNum;
        int[] uids1 = this.mUids;
        int N2 = other.mNum;
        int[] uids2 = other.mUids;
        boolean changed = false;
        int i1 = 0;
        for (int i2 = 0; i2 < N2; ++i2) {
            if (i1 >= N1 || uids2[i2] < uids1[i1]) {
                changed = true;
                if (uids1 == null) {
                    uids1 = new int[4];
                    uids1[0] = uids2[i2];
                } else if (i1 >= uids1.length) {
                    int[] newuids = new int[uids1.length * 3 / 2];
                    if (i1 > 0) {
                        System.arraycopy(uids1, 0, newuids, 0, i1);
                    }
                    if (i1 < N1) {
                        System.arraycopy(uids1, i1, newuids, i1 + 1, N1 - i1);
                    }
                    uids1 = newuids;
                    uids1[i1] = uids2[i2];
                } else {
                    if (i1 < N1) {
                        System.arraycopy(uids1, i1, uids1, i1 + 1, N1 - i1);
                    }
                    uids1[i1] = uids2[i2];
                }
                if (returnNewbs) {
                    if (sNewbWork == null) {
                        sNewbWork = new WorkSource(uids2[i2]);
                    } else {
                        sNewbWork.addLocked(uids2[i2]);
                    }
                }
                ++N1;
                ++i1;
                continue;
            }
            if (!set) {
                while (++i1 < N1 && uids2[i2] >= uids1[i1]) {
                }
                continue;
            }
            int start = i1;
            while (i1 < N1 && uids2[i2] > uids1[i1]) {
                if (sGoneWork == null) {
                    sGoneWork = new WorkSource(uids1[i1]);
                } else {
                    sGoneWork.addLocked(uids1[i1]);
                }
                ++i1;
            }
            if (start < i1) {
                System.arraycopy(uids1, i1, uids1, start, i1 - start);
                N1 -= i1 - start;
                i1 = start;
            }
            if (i1 >= N1 || uids2[i1] != uids1[i1]) continue;
            ++i1;
        }
        this.mNum = N1;
        this.mUids = uids1;
        return changed;
    }

    public void addLocked(int uid) {
        if (this.mUids == null) {
            this.mUids = new int[4];
            this.mUids[0] = uid;
            this.mNum = 1;
            return;
        }
        if (this.mNum >= this.mUids.length) {
            int[] newuids = new int[this.mNum * 3 / 2];
            System.arraycopy(this.mUids, 0, newuids, 0, this.mNum);
            this.mUids = newuids;
        }
        this.mUids[this.mNum] = uid;
        ++this.mNum;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mNum);
        dest.writeIntArray(this.mUids);
    }

    static {
        CREATOR = new Parcelable.Creator<WorkSource>(){

            @Override
            public WorkSource createFromParcel(Parcel in) {
                return new WorkSource(in);
            }

            public WorkSource[] newArray(int size) {
                return new WorkSource[size];
            }
        };
    }
}

