/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Gradient_Delegate;
import com.android.layoutlib.bridge.Bridge;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;

public class SweepGradient_Delegate
extends Gradient_Delegate {
    private Paint mJavaPaint;

    public Paint getJavaPaint() {
        return this.mJavaPaint;
    }

    @LayoutlibDelegate
    static int nativeCreate1(float x, float y, int[] colors, float[] positions) {
        SweepGradient_Delegate newDelegate = new SweepGradient_Delegate(x, y, colors, positions);
        return sManager.addNewDelegate(newDelegate);
    }

    @LayoutlibDelegate
    static int nativeCreate2(float x, float y, int color0, int color1) {
        return SweepGradient_Delegate.nativeCreate1(x, y, new int[]{color0, color1}, null);
    }

    private SweepGradient_Delegate(float cx, float cy, int[] colors, float[] positions) {
        super(colors, positions);
        this.mJavaPaint = new SweepGradientPaint(cx, cy, this.mColors, this.mPositions);
    }

    private class SweepGradientPaint
    extends Gradient_Delegate.GradientPaint {
        private final float mCx;
        private final float mCy;

        public SweepGradientPaint(float cx, float cy, int[] colors, float[] positions) {
            super(colors, positions, null);
            this.mCx = cx;
            this.mCy = cy;
        }

        public PaintContext createContext(ColorModel colorModel, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
            AffineTransform canvasMatrix;
            this.precomputeGradientColors();
            try {
                canvasMatrix = xform.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                Bridge.getLog().fidelityWarning("matrix.inverse", "Unable to inverse matrix in SweepGradient", (Throwable)e, null);
                canvasMatrix = new AffineTransform();
            }
            AffineTransform localMatrix = SweepGradient_Delegate.this.getLocalMatrix();
            try {
                localMatrix = localMatrix.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                Bridge.getLog().fidelityWarning("matrix.inverse", "Unable to inverse matrix in SweepGradient", (Throwable)e, null);
                localMatrix = new AffineTransform();
            }
            return new SweepGradientPaintContext(canvasMatrix, localMatrix, colorModel);
        }

        private class SweepGradientPaintContext
        implements PaintContext {
            private final AffineTransform mCanvasMatrix;
            private final AffineTransform mLocalMatrix;
            private final ColorModel mColorModel;

            public SweepGradientPaintContext(AffineTransform canvasMatrix, AffineTransform localMatrix, ColorModel colorModel) {
                this.mCanvasMatrix = canvasMatrix;
                this.mLocalMatrix = localMatrix;
                this.mColorModel = colorModel;
            }

            public void dispose() {
            }

            public ColorModel getColorModel() {
                return this.mColorModel;
            }

            public Raster getRaster(int x, int y, int w, int h) {
                BufferedImage image = new BufferedImage(w, h, 2);
                int[] data = new int[w * h];
                int index = 0;
                float[] pt1 = new float[2];
                float[] pt2 = new float[2];
                for (int iy = 0; iy < h; ++iy) {
                    for (int ix = 0; ix < w; ++ix) {
                        float angle;
                        pt1[0] = x + ix;
                        pt1[1] = y + iy;
                        this.mCanvasMatrix.transform(pt1, 0, pt2, 0, 1);
                        pt1[0] = pt2[0] - SweepGradientPaint.this.mCx;
                        pt1[1] = pt2[1] - SweepGradientPaint.this.mCy;
                        this.mLocalMatrix.transform(pt1, 0, pt2, 0, 1);
                        float dx = pt2[0];
                        float dy = pt2[1];
                        if (dx == 0.0f) {
                            angle = (float)(dy < 0.0f ? 4.71238898038469 : 1.5707963267948966);
                        } else if (dy == 0.0f) {
                            angle = (float)(dx < 0.0f ? Math.PI : 0.0);
                        } else {
                            angle = (float)Math.atan(dy / dx);
                            if (dx > 0.0f) {
                                if (dy < 0.0f) {
                                    angle = (float)((double)angle + Math.PI * 2);
                                }
                            } else {
                                angle = (float)((double)angle + Math.PI);
                            }
                        }
                        data[index++] = SweepGradientPaint.this.getGradientColor((float)((double)angle / (Math.PI * 2)));
                    }
                }
                image.setRGB(0, 0, w, h, data, 0, w);
                return image.getRaster();
            }
        }
    }
}

