/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix_Delegate;
import android.graphics.Shader;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Paint;
import java.awt.geom.AffineTransform;

public abstract class Shader_Delegate {
    protected static final DelegateManager<Shader_Delegate> sManager = new DelegateManager<Shader_Delegate>(Shader_Delegate.class);
    private Matrix_Delegate mLocalMatrix = null;

    public static Shader_Delegate getDelegate(int nativeShader) {
        return sManager.getDelegate(nativeShader);
    }

    public static Shader.TileMode getTileMode(int tileMode) {
        for (Shader.TileMode tm : Shader.TileMode.values()) {
            if (tm.nativeInt != tileMode) continue;
            return tm;
        }
        assert (false);
        return Shader.TileMode.CLAMP;
    }

    public abstract Paint getJavaPaint();

    public abstract boolean isSupported();

    public abstract String getSupportMessage();

    public boolean isValid() {
        return this.mLocalMatrix == null || this.mLocalMatrix.getAffineTransform().getDeterminant() != 0.0;
    }

    @LayoutlibDelegate
    static void nativeDestructor(int native_shader) {
        sManager.removeJavaReferenceFor(native_shader);
    }

    @LayoutlibDelegate
    static boolean nativeGetLocalMatrix(int native_shader, int matrix_instance) {
        Shader_Delegate shaderDelegate = sManager.getDelegate(native_shader);
        if (shaderDelegate == null) {
            return false;
        }
        Matrix_Delegate outMatrixDelegate = Matrix_Delegate.getDelegate(matrix_instance);
        if (shaderDelegate.mLocalMatrix == null || shaderDelegate.mLocalMatrix.isIdentity()) {
            if (outMatrixDelegate != null) {
                outMatrixDelegate.reset();
            }
            return false;
        }
        if (outMatrixDelegate != null) {
            outMatrixDelegate.set(shaderDelegate.mLocalMatrix);
        }
        return true;
    }

    @LayoutlibDelegate
    static void nativeSetLocalMatrix(int native_shader, int matrix_instance) {
        Shader_Delegate shaderDelegate = sManager.getDelegate(native_shader);
        if (shaderDelegate == null) {
            return;
        }
        shaderDelegate.mLocalMatrix = Matrix_Delegate.getDelegate(matrix_instance);
    }

    protected AffineTransform getLocalMatrix() {
        if (this.mLocalMatrix != null) {
            return this.mLocalMatrix.getAffineTransform();
        }
        return new AffineTransform();
    }
}

