/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap_Delegate;
import android.graphics.Shader;
import android.graphics.Shader_Delegate;
import com.android.layoutlib.bridge.Bridge;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;

public class BitmapShader_Delegate
extends Shader_Delegate {
    private Paint mJavaPaint;

    public Paint getJavaPaint() {
        return this.mJavaPaint;
    }

    public boolean isSupported() {
        return true;
    }

    public String getSupportMessage() {
        return null;
    }

    @LayoutlibDelegate
    static int nativeCreate(int native_bitmap, int shaderTileModeX, int shaderTileModeY) {
        Bitmap_Delegate bitmap = Bitmap_Delegate.getDelegate(native_bitmap);
        if (bitmap == null) {
            return 0;
        }
        BitmapShader_Delegate newDelegate = new BitmapShader_Delegate(bitmap.getImage(), Shader_Delegate.getTileMode(shaderTileModeX), Shader_Delegate.getTileMode(shaderTileModeY));
        return sManager.addNewDelegate(newDelegate);
    }

    private BitmapShader_Delegate(BufferedImage image, Shader.TileMode tileModeX, Shader.TileMode tileModeY) {
        this.mJavaPaint = new BitmapShaderPaint(image, tileModeX, tileModeY);
    }

    private class BitmapShaderPaint
    implements Paint {
        private final BufferedImage mImage;
        private final Shader.TileMode mTileModeX;
        private final Shader.TileMode mTileModeY;

        BitmapShaderPaint(BufferedImage image, Shader.TileMode tileModeX, Shader.TileMode tileModeY) {
            this.mImage = image;
            this.mTileModeX = tileModeX;
            this.mTileModeY = tileModeY;
        }

        public PaintContext createContext(ColorModel colorModel, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
            AffineTransform canvasMatrix;
            try {
                canvasMatrix = xform.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                Bridge.getLog().fidelityWarning("matrix.inverse", "Unable to inverse matrix in BitmapShader", (Throwable)e, null);
                canvasMatrix = new AffineTransform();
            }
            AffineTransform localMatrix = BitmapShader_Delegate.this.getLocalMatrix();
            try {
                localMatrix = localMatrix.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                Bridge.getLog().fidelityWarning("matrix.inverse", "Unable to inverse matrix in BitmapShader", (Throwable)e, null);
                localMatrix = new AffineTransform();
            }
            return new BitmapShaderContext(canvasMatrix, localMatrix, colorModel);
        }

        private int getColor(float fx, float fy) {
            int x = this.getCoordinate(Math.round(fx), this.mImage.getWidth(), this.mTileModeX);
            int y = this.getCoordinate(Math.round(fy), this.mImage.getHeight(), this.mTileModeY);
            return this.mImage.getRGB(x, y);
        }

        private int getCoordinate(int i, int size, Shader.TileMode mode) {
            if (i < 0) {
                switch (mode) {
                    case CLAMP: {
                        i = 0;
                        break;
                    }
                    case REPEAT: {
                        i = size - 1 - -i % size;
                        break;
                    }
                    case MIRROR: {
                        i = -i;
                        int count = i / size;
                        i %= size;
                        if (count % 2 != 1) break;
                        i = size - 1 - i;
                    }
                }
            } else if (i >= size) {
                switch (mode) {
                    case CLAMP: {
                        i = size - 1;
                        break;
                    }
                    case REPEAT: {
                        i %= size;
                        break;
                    }
                    case MIRROR: {
                        int count = i / size;
                        i %= size;
                        if (count % 2 != 1) break;
                        i = size - 1 - i;
                    }
                }
            }
            return i;
        }

        public int getTransparency() {
            return 3;
        }

        private class BitmapShaderContext
        implements PaintContext {
            private final AffineTransform mCanvasMatrix;
            private final AffineTransform mLocalMatrix;
            private final ColorModel mColorModel;

            public BitmapShaderContext(AffineTransform canvasMatrix, AffineTransform localMatrix, ColorModel colorModel) {
                this.mCanvasMatrix = canvasMatrix;
                this.mLocalMatrix = localMatrix;
                this.mColorModel = colorModel;
            }

            public void dispose() {
            }

            public ColorModel getColorModel() {
                return this.mColorModel;
            }

            public Raster getRaster(int x, int y, int w, int h) {
                BufferedImage image = new BufferedImage(w, h, 2);
                int[] data = new int[w * h];
                int index = 0;
                float[] pt1 = new float[2];
                float[] pt2 = new float[2];
                for (int iy = 0; iy < h; ++iy) {
                    for (int ix = 0; ix < w; ++ix) {
                        pt1[0] = x + ix;
                        pt1[1] = y + iy;
                        this.mCanvasMatrix.transform(pt1, 0, pt2, 0, 1);
                        pt1[0] = pt2[0];
                        pt1[1] = pt2[1];
                        this.mLocalMatrix.transform(pt1, 0, pt2, 0, 1);
                        data[index++] = BitmapShaderPaint.this.getColor(pt2[0], pt2[1]);
                    }
                }
                image.setRGB(0, 0, w, h, data, 0, w);
                return image.getRaster();
            }
        }
    }
}

