/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteCompiledSql;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDebug;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.Map;

public abstract class SQLiteProgram
extends SQLiteClosable {
    public static final String TAG = "SQLiteProgram";
    @Deprecated
    public SQLiteDatabase mDatabase;
    public final String mSql;
    @Deprecated
    public int nHandle = 0;
    public SQLiteCompiledSql mCompiledSql;
    @Deprecated
    public int nStatement = 0;

    public SQLiteProgram(SQLiteDatabase db, String sql) {
        this.mDatabase = db;
        this.mSql = sql.trim();
        db.acquireReference();
        db.addSQLiteClosable(this);
        this.nHandle = db.mNativeHandle;
        String prefixSql = this.mSql.substring(0, 6);
        if (!(prefixSql.equalsIgnoreCase("INSERT") || prefixSql.equalsIgnoreCase("UPDATE") || prefixSql.equalsIgnoreCase("REPLAC") || prefixSql.equalsIgnoreCase("DELETE") || prefixSql.equalsIgnoreCase("SELECT"))) {
            this.mCompiledSql = new SQLiteCompiledSql(db, sql);
            this.nStatement = this.mCompiledSql.nStatement;
            return;
        }
        this.mCompiledSql = db.getCompiledStatementForSql(sql);
        if (this.mCompiledSql == null) {
            this.mCompiledSql = new SQLiteCompiledSql(db, sql);
            this.mCompiledSql.acquire();
            db.addToCompiledQueries(sql, this.mCompiledSql);
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                Log.v(TAG, "Created DbObj (id#" + this.mCompiledSql.nStatement + ") for sql: " + sql);
            }
        } else if (!this.mCompiledSql.acquire()) {
            int last = this.mCompiledSql.nStatement;
            this.mCompiledSql = new SQLiteCompiledSql(db, sql);
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                Log.v(TAG, "** possible bug ** Created NEW DbObj (id#" + this.mCompiledSql.nStatement + ") because the previously created DbObj (id#" + last + ") was not released for sql:" + sql);
            }
        }
        this.nStatement = this.mCompiledSql.nStatement;
    }

    public void onAllReferencesReleased() {
        this.releaseCompiledSqlIfNotInCache();
        this.mDatabase.releaseReference();
        this.mDatabase.removeSQLiteClosable(this);
    }

    public void onAllReferencesReleasedFromContainer() {
        this.releaseCompiledSqlIfNotInCache();
        this.mDatabase.releaseReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCompiledSqlIfNotInCache() {
        if (this.mCompiledSql == null) {
            return;
        }
        Map<String, SQLiteCompiledSql> map = this.mDatabase.mCompiledQueries;
        synchronized (map) {
            if (!this.mDatabase.mCompiledQueries.containsValue(this.mCompiledSql)) {
                this.mCompiledSql.releaseSqlStatement();
                this.mCompiledSql = null;
                this.nStatement = 0;
            } else {
                this.mCompiledSql.release();
            }
        }
    }

    public int getUniqueId() {
        return this.nStatement;
    }

    public String getSqlString() {
        return this.mSql;
    }

    @Deprecated
    public void compile(String sql, boolean forceCompilation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindNull(int index) {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        this.acquireReference();
        try {
            this.native_bind_null(index);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindLong(int index, long value) {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        this.acquireReference();
        try {
            this.native_bind_long(index, value);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindDouble(int index, double value) {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        this.acquireReference();
        try {
            this.native_bind_double(index, value);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindString(int index, String value) {
        if (value == null) {
            throw new IllegalArgumentException("the bind value at index " + index + " is null");
        }
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        this.acquireReference();
        try {
            this.native_bind_string(index, value);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindBlob(int index, byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("the bind value at index " + index + " is null");
        }
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        this.acquireReference();
        try {
            this.native_bind_blob(index, value);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBindings() {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        this.acquireReference();
        try {
            this.native_clear_bindings();
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.mDatabase.isOpen()) {
            return;
        }
        this.mDatabase.lock();
        try {
            this.releaseReference();
        }
        finally {
            this.mDatabase.unlock();
        }
    }

    @Deprecated
    public void native_compile(String string2) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteProgram#native_compile(Ljava/lang/String;)V", true, this);
    }

    @Deprecated
    public void native_finalize() {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteProgram#native_finalize()V", true, this);
    }

    public void native_bind_null(int n) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteProgram#native_bind_null(I)V", true, this);
    }

    public void native_bind_long(int n, long l) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteProgram#native_bind_long(IJ)V", true, this);
    }

    public void native_bind_double(int n, double d) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteProgram#native_bind_double(ID)V", true, this);
    }

    public void native_bind_string(int n, String string2) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteProgram#native_bind_string(ILjava/lang/String;)V", true, this);
    }

    public void native_bind_blob(int n, byte[] byArray) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteProgram#native_bind_blob(I[B)V", true, this);
    }

    public void native_clear_bindings() {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteProgram#native_clear_bindings()V", true, this);
    }
}

