/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jdiff.APIDiff;
import jdiff.ClassDiff;
import jdiff.CompareClassPdiffs;
import jdiff.ComparePkgPdiffs;
import jdiff.HTMLReportGenerator;
import jdiff.PackageDiff;

public class HTMLStatistics {
    private HTMLReportGenerator h_ = null;

    public HTMLStatistics(HTMLReportGenerator h) {
        this.h_ = h;
    }

    public void emitStatistics(String filename, APIDiff apiDiff) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            HTMLReportGenerator.reportFile = new PrintWriter(fos);
            this.h_.writeStartHTMLHeader();
            String oldAPIName = "Old API";
            if (APIDiff.oldAPIName_ != null) {
                oldAPIName = APIDiff.oldAPIName_;
            }
            String newAPIName = "New API";
            if (APIDiff.newAPIName_ != null) {
                newAPIName = APIDiff.newAPIName_;
            }
            this.h_.writeHTMLTitle("API Change Statistics");
            this.h_.writeStyleSheetRef();
            this.h_.writeText("</HEAD>");
            this.h_.writeText("<body class=\"gc-documentation\">");
            this.h_.writeText("<!-- Start of nav bar -->");
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH:mm");
            Date day = new Date();
            this.h_.writeText("<div id=\"gc-container\" style=\"padding-left:1em;padding-right:1em;\">");
            this.h_.writeText("<a name=\"top\"></a>");
            this.h_.writeText("<div id=\"gc-header\">");
            this.h_.writeText("  <div id=\"logo\" style=\"padding-left:1em;\">");
            this.h_.writeText("    <a href=\"../../../documentation.html\" target=\"_top\"><img style=\"border: 0;\" src=\"../../../assets-google/android-logo-sm.gif\" \"/></a>");
            this.h_.writeText("  </div> <!-- End logo -->");
            this.h_.writeText("<div class=\"and-diff-id\">");
            this.h_.writeText("<table class=\"diffspectable\">");
            this.h_.writeText("<tr>");
            this.h_.writeText("  <td colspan=\"2\" class=\"diffspechead\">API Diff Specification</td>");
            this.h_.writeText("</tr>");
            this.h_.writeText("      <tr>");
            this.h_.writeText("        <td class=\"diffspec\">To Version:</td>");
            this.h_.writeText("        <td class=\"diffvaluenew\">" + newAPIName + "</td>");
            this.h_.writeText("      </tr>");
            this.h_.writeText("      <tr>");
            this.h_.writeText("        <td class=\"diffspec\">From Version:</td>");
            this.h_.writeText("        <td class=\"diffvalueold\">" + oldAPIName + "</td>");
            this.h_.writeText("      </tr>");
            this.h_.writeText("<tr>");
            this.h_.writeText("  <td class=\"diffspec\">Generated</td>");
            this.h_.writeText("  <td class=\"diffvalue\">" + formatter.format(day) + "</td>");
            this.h_.writeText("</tr>");
            this.h_.writeText("</table>");
            this.h_.writeText("  </div> <!-- End and-diff-id -->");
            this.h_.writeText("  <div class=\"and-diff-id\">");
            this.h_.writeText("    <table class=\"diffspectable\">");
            this.h_.writeText("      <tr>");
            this.h_.writeText("        <td class=\"diffspec\" colspan=\"2\"><a href=\"../changes.html\" target=\"_top\">Top of Report</a></div>");
            this.h_.writeText("      </tr>");
            this.h_.writeText("    </table>");
            this.h_.writeText("  </div> <!-- End and-diff-id -->");
            this.h_.writeText("</div> <!-- End gc-header -->");
            this.h_.writeText("<div id=\"codesiteContent\" style=\"margin-top: 70px;margin-bottom:80px;\">");
            this.h_.writeText("<div style=\"xborder:1px solid yellow;vertical-align:top;padding:1em;margin-left:0;text-align:left;\">");
            this.h_.writeText(" <H1 class=\"pagecontenth1\">API&nbsp;Change&nbsp;Statistics</H1>");
            this.h_.writeText("</div>");
            this.h_.writeText("<p>");
            this.h_.writeText("The percent change statistic reported for all elements in each API is defined recursively as follows:</p>");
            this.h_.writeText("<pre>");
            this.h_.writeText("Percentage difference = 100 * (added + removed + 2*changed)");
            this.h_.writeText("                        -----------------------------------");
            this.h_.writeText("                        sum of public elements in BOTH APIs");
            this.h_.writeText("</pre>");
            this.h_.writeText("<p>where <code>added</code> is the number of packages added, <code>removed</code> is the number of packages removed, and <code>changed</code> is the number of packages changed.");
            this.h_.writeText("This definition is applied recursively for the classes and their program elements, so the value for a changed package will be less than 1, unless every class in that package has changed.");
            this.h_.writeText("The definition ensures that if all packages are removed and all new packages are");
            this.h_.writeText("added, the change will be 100%. Values are rounded here, so a value of 0% indicates a percentage difference of less than 0.5%.</p>");
            this.h_.writeText("<p>The overall difference between the two APIs is approximately <span style=\"color:222;font-weight:bold;\">" + (int)apiDiff.pdiff + "%</span>.");
            this.h_.writeText("</p>");
            this.h_.writeText("<br><h2 class=\"pagecontenth2\">Contents</h2>");
            this.h_.writeText("<dl><dt><a href=\"#packages\">Changed Packages</a></dt> <dd>Sorted by percentage difference</dd>");
            this.h_.writeText("<dt><a href=\"#classes\">Changed Classes and <i>Interfaces</i></a></dt><dd>Sorted by percentage difference</dd>");
            this.h_.writeText("<dt><a href=\"#numbers\">Total of Differences</a></dt><dd>Listed by number and type</dd></dl>");
            this.h_.writeText("<br>");
            this.h_.writeText("<a name=\"packages\"></a>");
            this.h_.writeText("<h2 class=\"pagecontenth2\">Changed Packages, Sorted by Percentage Difference</h2>");
            this.emitPackagesByDiff(apiDiff);
            this.h_.writeText("<br>");
            this.h_.writeText("<a name=\"classes\"></a>");
            this.h_.writeText("<h2 class=\"pagecontenth2\">Changed Classes and <i>Interfaces</i>, Sorted by Percentage Difference</h2>");
            this.emitClassesByDiff(apiDiff);
            this.h_.writeText("<br>");
            this.h_.writeText("<a name=\"numbers\"></a>");
            this.h_.writeText("<h2 class=\"pagecontenth2\">Total of Differences, by Number and Type</h2>");
            this.h_.writeText("<p>");
            this.h_.writeText("The table below lists the numbers of program elements (packages, classes, constructors, methods, and fields) that were removed, added or changed. The table includes only the highest-level program elements &mdash; that is, if a class with two methods was added, the number of methods added does not include those two methods, but the number of classes added does include that class.");
            this.h_.writeText("</p>");
            this.emitNumbersByElement(apiDiff);
            this.h_.writeText("</div><!-- end codesitecontent -->");
            this.h_.writeText("<div style=\"padding-left: 10px; padding-right: 10px; margin-top: 0; padding-bottom: 15px;\">");
            this.h_.writeText("  <table style=\"width: 100%; border: none;\"><tr>");
            this.h_.writeText("    <td style=\"text-align:center;font-size: 10pt; border: none; color: ccc;\"> ");
            this.h_.writeText("      <span>&copy;2008 Google - ");
            this.h_.writeText("            <a href=\"http://code.google.com\">Code Home</a> - ");
            this.h_.writeText("            <a href=\"http://www.google.com/accounts/TOS\">Site Terms of Sservice</a> - ");
            this.h_.writeText("            <a href=\"http://www.google.com/privacy.html\">Privacy Policy</a> ");
            this.h_.writeText("      </span>");
            this.h_.writeText("      <div style=\"xborder 1px solid red;position:relative;margin-top:-2em;");
            this.h_.writeText("        font-size:8pt;color:aaa;text-align:right;\">");
            this.h_.writeText("        <em>Generated by <a href=\"http://www.jdiff.org/\">JDiff</a></em><br><img ");
            this.h_.writeText("        align=\"right\" src=\"../../../assets/jdiff_logo.gif\">");
            this.h_.writeText("      </span>");
            this.h_.writeText("    </td>");
            this.h_.writeText(" </tr></table>");
            this.h_.writeText("</div>");
            this.h_.writeText("</div><!-- end gc-containter -->");
            this.h_.writeText("<script src=\"http://www.google-analytics.com/ga.js\" type=\"text/javascript\">");
            this.h_.writeText("</script>");
            this.h_.writeText("<script type=\"text/javascript\">");
            this.h_.writeText("  try {");
            this.h_.writeText("    var pageTracker = _gat._getTracker(\"UA-18071-1\");");
            this.h_.writeText("    pageTracker._setAllowAnchor(true);");
            this.h_.writeText("    pageTracker._initData();");
            this.h_.writeText("    pageTracker._trackPageview();");
            this.h_.writeText("  } catch(e) {}");
            this.h_.writeText("</script>");
            this.h_.writeText("</BODY></HTML>");
            HTMLReportGenerator.reportFile.close();
        }
        catch (IOException e) {
            System.out.println("IO Error while attempting to create " + filename);
            System.out.println("Error: " + e.getMessage());
            System.exit(1);
        }
    }

    public void emitPackagesByDiff(APIDiff apiDiff) {
        Collections.sort(apiDiff.packagesChanged, new ComparePkgPdiffs());
        this.h_.writeText("<TABLE summary=\"Packages sorted by percentage difference\" BORDER=\"1\" WIDTH=\"100%\" cellspacing=\"0\" cellpadding=\"0\">");
        this.h_.writeText("<TR WIDTH=\"20%\">");
        this.h_.writeText("  <TH>Percentage<br>Difference</TH>");
        this.h_.writeText("  <TH>Package</TH>");
        this.h_.writeText("</TR>");
        int[] hist = new int[101];
        for (int i = 0; i < 101; ++i) {
            hist[i] = 0;
        }
        for (PackageDiff pkg : apiDiff.packagesChanged) {
            int bucket;
            int n = bucket = (int)pkg.pdiff;
            hist[n] = hist[n] + 1;
            this.h_.writeText("<TR>");
            if (bucket != 0) {
                this.h_.writeText("  <TD ALIGN=\"center\">" + bucket + "</TD>");
            } else {
                this.h_.writeText("  <TD ALIGN=\"center\">&lt;1</TD>");
            }
            this.h_.writeText("  <TD><A HREF=\"pkg_" + pkg.name_ + HTMLReportGenerator.reportFileExt + "\">" + pkg.name_ + "</A></TD>");
            this.h_.writeText("</TR>");
        }
        this.h_.writeText("</TABLE>");
    }

    public void emitClassesByDiff(APIDiff apiDiff) {
        ArrayList allChangedClasses = new ArrayList();
        for (PackageDiff pkg : apiDiff.packagesChanged) {
            if (pkg.classesChanged == null) continue;
            ArrayList cc = new ArrayList(pkg.classesChanged);
            for (ClassDiff classDiff : cc) {
                classDiff.name_ = pkg.name_ + "." + classDiff.name_;
            }
            allChangedClasses.addAll(cc);
        }
        Collections.sort(allChangedClasses, new CompareClassPdiffs());
        this.h_.writeText("<TABLE summary=\"Classes sorted by percentage difference\" BORDER=\"1\" WIDTH=\"100%\" cellspacing=\"0\" cellpadding=\"0\">");
        this.h_.writeText("<TR WIDTH=\"20%\">");
        this.h_.writeText("  <TH><b>Percentage<br>Difference</b></TH>");
        this.h_.writeText("  <TH><b>Class or <i>Interface</i></b></TH>");
        this.h_.writeText("</TR>");
        int[] hist = new int[101];
        for (int i = 0; i < 101; ++i) {
            hist[i] = 0;
        }
        for (ClassDiff classDiff : allChangedClasses) {
            int bucket;
            int n = bucket = (int)classDiff.pdiff;
            hist[n] = hist[n] + 1;
            this.h_.writeText("<TR>");
            if (bucket != 0) {
                this.h_.writeText("  <TD ALIGN=\"center\">" + bucket + "</TD>");
            } else {
                this.h_.writeText("  <TD ALIGN=\"center\">&lt;1</TD>");
            }
            this.h_.writeText("  <TD><A HREF=\"" + classDiff.name_ + HTMLReportGenerator.reportFileExt + "\">");
            if (classDiff.isInterface_) {
                this.h_.writeText("<i>" + classDiff.name_ + "</i></A></TD>");
            } else {
                this.h_.writeText(classDiff.name_ + "</A></TD>");
            }
            this.h_.writeText("</TR>");
        }
        this.h_.writeText("</TABLE>");
    }

    public void emitNumbersByElement(APIDiff apiDiff) {
        int numPackagesRemoved = apiDiff.packagesRemoved.size();
        int numPackagesAdded = apiDiff.packagesAdded.size();
        int numPackagesChanged = apiDiff.packagesChanged.size();
        int numClassesRemoved = 0;
        int numClassesAdded = 0;
        int numClassesChanged = 0;
        int numCtorsRemoved = 0;
        int numCtorsAdded = 0;
        int numCtorsChanged = 0;
        int numMethodsRemoved = 0;
        int numMethodsAdded = 0;
        int numMethodsChanged = 0;
        int numFieldsRemoved = 0;
        int numFieldsAdded = 0;
        int numFieldsChanged = 0;
        int numRemoved = 0;
        int numAdded = 0;
        int numChanged = 0;
        for (PackageDiff pkg : apiDiff.packagesChanged) {
            numClassesRemoved += pkg.classesRemoved.size();
            numClassesAdded += pkg.classesAdded.size();
            numClassesChanged += pkg.classesChanged.size();
            for (ClassDiff classDiff : pkg.classesChanged) {
                numCtorsRemoved += classDiff.ctorsRemoved.size();
                numCtorsAdded += classDiff.ctorsAdded.size();
                numCtorsChanged += classDiff.ctorsChanged.size();
                numMethodsRemoved += classDiff.methodsRemoved.size();
                numMethodsAdded += classDiff.methodsAdded.size();
                numMethodsChanged += classDiff.methodsChanged.size();
                numFieldsRemoved += classDiff.fieldsRemoved.size();
                numFieldsAdded += classDiff.fieldsAdded.size();
                numFieldsChanged += classDiff.fieldsChanged.size();
            }
        }
        this.h_.writeText("<TABLE summary=\"Number of differences\" BORDER=\"1\" WIDTH=\"100%\" cellspacing=\"0\" cellpadding=\"0\">");
        this.h_.writeText("<TR>");
        this.h_.writeText("  <TH COLSPAN=5 NOWRAP>");
        this.h_.writeText("  Number of Differences</TH>");
        this.h_.writeText("</TR>");
        this.h_.writeText("<TR>");
        this.h_.writeText("  <TH>&nbsp;</TD>");
        this.h_.writeText("  <TH ALIGN=\"center\"><b>Removals</b></TH>");
        this.h_.writeText("  <TH ALIGN=\"center\"><b>Additions</b></TH>");
        this.h_.writeText("  <TH ALIGN=\"center\"><b>Changes</b></TH>");
        this.h_.writeText("  <TH ALIGN=\"center\"><b>Total</b></TH>");
        this.h_.writeText("</TR>");
        this.h_.writeText("<TR>");
        this.h_.writeText("  <TD>Packages</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numPackagesRemoved + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numPackagesAdded + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numPackagesChanged + "</TD>");
        int numPackages = numPackagesRemoved + numPackagesAdded + numPackagesChanged;
        this.h_.writeText("  <TD ALIGN=\"right\">" + numPackages + "</TD>");
        this.h_.writeText("</TR>");
        numRemoved += numPackagesRemoved;
        numAdded += numPackagesAdded;
        numChanged += numPackagesChanged;
        this.h_.writeText("<TR>");
        this.h_.writeText("  <TD>Classes and <i>Interfaces</i></TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numClassesRemoved + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numClassesAdded + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numClassesChanged + "</TD>");
        int numClasses = numClassesRemoved + numClassesAdded + numClassesChanged;
        this.h_.writeText("  <TD ALIGN=\"right\">" + numClasses + "</TD>");
        this.h_.writeText("</TR>");
        numRemoved += numClassesRemoved;
        numAdded += numClassesAdded;
        numChanged += numClassesChanged;
        this.h_.writeText("<TR>");
        this.h_.writeText("  <TD>Constructors</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numCtorsRemoved + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numCtorsAdded + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numCtorsChanged + "</TD>");
        int numCtors = numCtorsRemoved + numCtorsAdded + numCtorsChanged;
        this.h_.writeText("  <TD ALIGN=\"right\">" + numCtors + "</TD>");
        this.h_.writeText("</TR>");
        numRemoved += numCtorsRemoved;
        numAdded += numCtorsAdded;
        numChanged += numCtorsChanged;
        this.h_.writeText("<TR>");
        this.h_.writeText("  <TD>Methods</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numMethodsRemoved + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numMethodsAdded + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numMethodsChanged + "</TD>");
        int numMethods = numMethodsRemoved + numMethodsAdded + numMethodsChanged;
        this.h_.writeText("  <TD ALIGN=\"right\">" + numMethods + "</TD>");
        this.h_.writeText("</TR>");
        numRemoved += numMethodsRemoved;
        numAdded += numMethodsAdded;
        numChanged += numMethodsChanged;
        this.h_.writeText("<TR>");
        this.h_.writeText("  <TD>Fields</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numFieldsRemoved + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numFieldsAdded + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numFieldsChanged + "</TD>");
        int numFields = numFieldsRemoved + numFieldsAdded + numFieldsChanged;
        this.h_.writeText("  <TD ALIGN=\"right\">" + numFields + "</TD>");
        this.h_.writeText("</TR>");
        this.h_.writeText("<TR>");
        this.h_.writeText("  <TD><b>Total</b></TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + (numRemoved += numFieldsRemoved) + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + (numAdded += numFieldsAdded) + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + (numChanged += numFieldsChanged) + "</TD>");
        int total = numRemoved + numAdded + numChanged;
        this.h_.writeText("  <TD ALIGN=\"right\">" + total + "</TD>");
        this.h_.writeText("</TR>");
        this.h_.writeText("</TABLE>");
    }
}

