/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jdiff.APIDiff;
import jdiff.ClassAPI;
import jdiff.ClassDiff;
import jdiff.ConstructorAPI;
import jdiff.FieldAPI;
import jdiff.HTMLReportGenerator;
import jdiff.Index;
import jdiff.JDiff;
import jdiff.MemberDiff;
import jdiff.MethodAPI;
import jdiff.PackageAPI;
import jdiff.PackageDiff;

public class HTMLIndexes {
    private HTMLReportGenerator h_ = null;
    public static boolean logMissingSinces = true;
    public static PrintWriter missingSincesFile = null;
    private List allNames = null;
    private List packageNames = null;
    private List classNames = null;
    private List ctorNames = null;
    private List methNames = null;
    private List fieldNames = null;
    private boolean isAllNames = false;
    private boolean atLeastOneRemoval = false;
    private boolean atLeastOneAddition = false;
    private boolean atLeastOneChange = false;
    private final int INDENT_SIZE = 2;

    public HTMLIndexes(HTMLReportGenerator h) {
        this.h_ = h;
    }

    public void emitAllBottomLeftFiles(String packagesIndexName, String classesIndexName, String constructorsIndexName, String methodsIndexName, String fieldsIndexName, String allDiffsIndexName, APIDiff apiDiff) {
        this.emitBottomLeftFile(packagesIndexName, apiDiff, 3, "Package");
        this.emitBottomLeftFile(classesIndexName, apiDiff, 3, "Class");
        this.emitBottomLeftFile(constructorsIndexName, apiDiff, 3, "Constructor");
        this.emitBottomLeftFile(methodsIndexName, apiDiff, 3, "Method");
        this.emitBottomLeftFile(fieldsIndexName, apiDiff, 3, "Field");
        this.emitBottomLeftFile(allDiffsIndexName, apiDiff, 3, "All");
        for (int indexType = 0; indexType < 3; ++indexType) {
            this.emitBottomLeftFile(packagesIndexName, apiDiff, indexType, "Package");
            this.emitBottomLeftFile(classesIndexName, apiDiff, indexType, "Class");
            this.emitBottomLeftFile(constructorsIndexName, apiDiff, indexType, "Constructor");
            this.emitBottomLeftFile(methodsIndexName, apiDiff, indexType, "Method");
            this.emitBottomLeftFile(fieldsIndexName, apiDiff, indexType, "Field");
            this.emitBottomLeftFile(allDiffsIndexName, apiDiff, indexType, "All");
        }
        if (missingSincesFile != null) {
            missingSincesFile.close();
        }
    }

    public void emitBottomLeftFile(String indexBaseName, APIDiff apiDiff, int indexType, String programElementType) {
        String filename = indexBaseName;
        try {
            String title = "Indexes";
            if (indexType == 0) {
                filename = filename + "_removals" + HTMLReportGenerator.reportFileExt;
                title = programElementType + " Removals Index";
            } else if (indexType == 1) {
                filename = filename + "_additions" + HTMLReportGenerator.reportFileExt;
                title = programElementType + " Additions Index";
            } else if (indexType == 2) {
                filename = filename + "_changes" + HTMLReportGenerator.reportFileExt;
                title = programElementType + " Changes Index";
            } else if (indexType == 3) {
                filename = filename + "_all" + HTMLReportGenerator.reportFileExt;
                title = programElementType + " Differences Index";
            }
            FileOutputStream fos = new FileOutputStream(filename);
            HTMLReportGenerator.reportFile = new PrintWriter(fos);
            this.h_.writeStartHTMLHeader();
            this.h_.writeHTMLTitle(title);
            this.h_.writeStyleSheetRef();
            this.h_.writeText("</HEAD>");
            this.h_.writeText("<BODY>");
            if (programElementType.compareTo("Package") == 0) {
                this.emitPackagesIndex(apiDiff, indexType);
            } else if (programElementType.compareTo("Class") == 0) {
                this.emitClassesIndex(apiDiff, indexType);
            } else if (programElementType.compareTo("Constructor") == 0) {
                this.emitConstructorsIndex(apiDiff, indexType);
            } else if (programElementType.compareTo("Method") == 0) {
                this.emitMethodsIndex(apiDiff, indexType);
            } else if (programElementType.compareTo("Field") == 0) {
                this.emitFieldsIndex(apiDiff, indexType);
            } else if (programElementType.compareTo("All") == 0) {
                this.emitAllDiffsIndex(apiDiff, indexType);
            } else {
                System.out.println("Error: unknown program element type.");
                System.exit(3);
            }
            this.h_.writeHTMLFooter();
            HTMLReportGenerator.reportFile.close();
        }
        catch (IOException e) {
            System.out.println("IO Error while attempting to create " + filename);
            System.out.println("Error: " + e.getMessage());
            System.exit(1);
        }
    }

    private void generateLetterIndex(List list, char currChar, boolean larger) {
        if (larger) {
            return;
        }
        int size = -2;
        if (larger) {
            size = -1;
        }
        Iterator iter = null;
        iter = this.isAllNames ? this.allNames.iterator() : list.iterator();
        char oldsw = '\u0000';
        while (iter.hasNext()) {
            Index entry = (Index)iter.next();
            char sw = entry.name_.charAt(0);
            char swu = Character.toUpperCase(sw);
            if (swu == Character.toUpperCase(oldsw)) continue;
            if (Character.toUpperCase(sw) != Character.toUpperCase(currChar)) {
                if (swu == '_') {
                    this.h_.writeText("<a href=\"#" + swu + "\"><font size=\"" + size + "\">" + "underscore" + "</font></a> ");
                } else {
                    this.h_.writeText("<a href=\"#" + swu + "\"><font size=\"" + size + "\">" + swu + "</font></a> ");
                }
            }
            oldsw = sw;
        }
        this.h_.writeText(" <a href=\"#topheader\"><font size=\"" + size + "\">TOP</font></a>");
        this.h_.writeText("<p><div style=\"line-height:1.5em;color:black\">");
    }

    private void emitIndexHeader(String indexName, int indexType, boolean hasRemovals, boolean hasAdditions, boolean hasChanges) {
        String linkIndexName = indexName.toLowerCase();
        boolean isAllDiffs = false;
        if (indexName.compareTo("All Differences") == 0) {
            linkIndexName = "alldiffs";
            isAllDiffs = true;
        }
        this.h_.writeText("<a NAME=\"topheader\"></a>");
        this.h_.writeText("<table summary=\"Index for " + indexName + "\" width=\"100%\" class=\"index\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
        this.h_.writeText("  <tr>");
        this.h_.writeText("  <th class=\"indexHeader\">");
        this.h_.writeText("    Filter the Index:");
        this.h_.writeText("  </th>");
        this.h_.writeText("  </tr>");
        this.h_.writeText("  <tr>");
        this.h_.writeText("  <td class=\"indexText\" style=\"line-height:1.5em;padding-left:2em;\">");
        if (indexType == 3) {
            this.h_.writeText("<b>" + indexName + "</b>");
        } else if (isAllDiffs) {
            this.h_.writeText("<a href=\"" + linkIndexName + "_index_all" + HTMLReportGenerator.reportFileExt + "\" class=\"hiddenlink\">" + indexName + "</a>");
        } else {
            this.h_.writeText("<a href=\"" + linkIndexName + "_index_all" + HTMLReportGenerator.reportFileExt + "\" class=\"staysblack\">All " + indexName + "</a>");
        }
        this.h_.writeText("  <br>");
        if (hasRemovals) {
            if (indexType == 0) {
                this.h_.writeText("<b>Removals</b>");
            } else {
                this.h_.writeText("<A HREF=\"" + linkIndexName + "_index_removals" + HTMLReportGenerator.reportFileExt + "\" class=\"hiddenlink\">Removals</A>");
            }
        } else {
            this.h_.writeText("<font color=\"#999999\">Removals</font>");
        }
        this.h_.writeText("  <br>");
        if (hasAdditions) {
            if (indexType == 1) {
                this.h_.writeText("<b>Additions</b>");
            } else {
                this.h_.writeText("<A HREF=\"" + linkIndexName + "_index_additions" + HTMLReportGenerator.reportFileExt + "\"class=\"hiddenlink\">Additions</A>");
            }
        } else {
            this.h_.writeText("<font color=\"#999999\">Additions</font>");
        }
        this.h_.writeText("  <br>");
        if (hasChanges) {
            if (indexType == 2) {
                this.h_.writeText("<b>Changes</b>");
            } else {
                this.h_.writeText("<A HREF=\"" + linkIndexName + "_index_changes" + HTMLReportGenerator.reportFileExt + "\"class=\"hiddenlink\">Changes</A>");
            }
        } else {
            this.h_.writeText("<font color=\"#999999\">Changes</font>");
        }
        this.h_.writeText("  </td>");
        this.h_.writeText("  </tr>");
        this.h_.writeText("</table>");
        this.h_.writeText("<font size=\"-2\"><strong>Bold</strong>&nbsp;indicates&nbsp;New;&nbsp;<strike>Strike</strike>&nbsp;indicates&nbsp;deleted</font>");
        this.h_.writeText("  </br>");
    }

    public void emitPackagesIndex(APIDiff apiDiff, int indexType) {
        Object pkg;
        this.packageNames = new ArrayList();
        boolean hasRemovals = false;
        if (apiDiff.packagesRemoved.size() != 0) {
            hasRemovals = true;
        }
        boolean hasAdditions = false;
        if (apiDiff.packagesAdded.size() != 0) {
            hasAdditions = true;
        }
        boolean hasChanges = false;
        if (apiDiff.packagesChanged.size() != 0) {
            hasChanges = true;
        }
        this.recordDiffs(hasRemovals, hasAdditions, hasChanges);
        Iterator iter = apiDiff.packagesRemoved.iterator();
        while ((indexType == 3 || indexType == 0) && iter.hasNext()) {
            pkg = (PackageAPI)iter.next();
            this.packageNames.add(new Index(((PackageAPI)pkg).name_, 0));
        }
        iter = apiDiff.packagesAdded.iterator();
        while ((indexType == 3 || indexType == 1) && iter.hasNext()) {
            pkg = (PackageAPI)iter.next();
            this.packageNames.add(new Index(((PackageAPI)pkg).name_, 1));
        }
        iter = apiDiff.packagesChanged.iterator();
        while ((indexType == 3 || indexType == 2) && iter.hasNext()) {
            pkg = (PackageDiff)iter.next();
            this.packageNames.add(new Index(((PackageDiff)pkg).name_, 2));
        }
        Collections.sort(this.packageNames);
        this.emitIndexHeader("Packages", indexType, hasRemovals, hasAdditions, hasChanges);
        this.h_.writeText("<br>");
        iter = this.packageNames.iterator();
        char oldsw = '\u0000';
        while (iter.hasNext()) {
            Index pkg2 = (Index)iter.next();
            oldsw = this.emitPackageIndexEntry(pkg2, oldsw);
        }
    }

    public char emitPackageIndexEntry(Index pkg, char oldsw) {
        char res = oldsw;
        char sw = pkg.name_.charAt(0);
        if (Character.toUpperCase(sw) != Character.toUpperCase(oldsw)) {
            res = sw;
            this.h_.writeText("<A NAME=\"" + Character.toUpperCase(res) + "\"></A>");
        }
        if (pkg.changeType_ == 0) {
            this.h_.writeText("<A HREF=\"" + HTMLReportGenerator.reportFileName + "-summary" + HTMLReportGenerator.reportFileExt + "#" + pkg.name_ + "\" class=\"hiddenlink\" target=\"rightframe\"><strike>" + pkg.name_ + "</strike></A><br>");
        } else if (pkg.changeType_ == 1) {
            this.h_.writeText("<A HREF=\"" + HTMLReportGenerator.reportFileName + "-summary" + HTMLReportGenerator.reportFileExt + "#" + pkg.name_ + "\" class=\"hiddenlink\" target=\"rightframe\"><b>" + pkg.name_ + "</b></A><br>");
        } else if (pkg.changeType_ == 2) {
            this.h_.writeText("<A HREF=\"pkg_" + pkg.name_ + HTMLReportGenerator.reportFileExt + "\" class=\"hiddenlink\" target=\"rightframe\">" + pkg.name_ + "</A><br>");
        }
        return res;
    }

    public void emitIndexEntries(Iterator iter) {
        char oldsw = '\u0000';
        int multipleMarker = 0;
        Index currIndex = null;
        while (iter.hasNext()) {
            Index nextIndex = (Index)iter.next();
            if (currIndex == null) {
                currIndex = nextIndex;
                continue;
            }
            if (nextIndex.name_.compareTo(currIndex.name_) == 0) {
                if (multipleMarker == 0) {
                    multipleMarker = 1;
                } else if (multipleMarker == 1) {
                    multipleMarker = 2;
                }
                oldsw = this.emitIndexEntry(currIndex, oldsw, multipleMarker);
            } else {
                if (multipleMarker == 1) {
                    multipleMarker = 2;
                }
                oldsw = this.emitIndexEntry(currIndex, oldsw, multipleMarker);
                multipleMarker = 0;
            }
            currIndex = nextIndex;
        }
        if (multipleMarker == 1) {
            multipleMarker = 2;
        }
        if (currIndex != null) {
            oldsw = this.emitIndexEntry(currIndex, oldsw, multipleMarker);
        }
    }

    public void emitMissingSinces(Iterator iter) {
        if (missingSincesFile == null) {
            String sinceFileName = HTMLReportGenerator.outputDir + JDiff.DIR_SEP + "missingSinces.txt";
            try {
                FileOutputStream fos = new FileOutputStream(sinceFileName);
                missingSincesFile = new PrintWriter(fos);
            }
            catch (IOException e) {
                System.out.println("IO Error while attempting to create " + sinceFileName);
                System.out.println("Error: " + e.getMessage());
                System.exit(1);
            }
        }
        while (iter.hasNext()) {
            Index currIndex = (Index)iter.next();
            if (currIndex.changeType_ != 1) continue;
            String programElementType = currIndex.ename_;
            String details = null;
            if (programElementType.compareTo("class") == 0) {
                details = currIndex.pkgName_ + "." + currIndex.name_;
                details = currIndex.isInterface_ ? details + " Interface" : details + " Class";
            } else if (programElementType.compareTo("constructor") == 0) {
                details = currIndex.pkgName_ + "." + currIndex.name_ + " Constructor (" + currIndex.type_ + ")";
            } else if (programElementType.compareTo("method") == 0) {
                details = currIndex.pkgName_ + "." + currIndex.className_ + " " + "Method " + currIndex.name_ + "(" + currIndex.type_ + ")";
            } else if (programElementType.compareTo("field") == 0) {
                details = currIndex.pkgName_ + "." + currIndex.className_ + " " + "Field " + currIndex.name_;
            } else {
                System.out.println("Error: unknown program element type");
                System.exit(3);
            }
            if (currIndex.doc_ == null) {
                if (logMissingSinces) {
                    missingSincesFile.println("NO DOC BLOCK: " + details);
                    continue;
                }
                System.out.println("Warning: the doc block for the new element: " + details + " is missing, so there is no @since tag");
                continue;
            }
            if (currIndex.doc_.indexOf("@since") != -1) {
                if (!logMissingSinces) continue;
                missingSincesFile.println("OK: " + details);
                continue;
            }
            if (logMissingSinces) {
                missingSincesFile.println("MISSING @SINCE TAG: " + details);
                continue;
            }
            System.out.println("Warning: the doc block for the new element: " + details + " is missing an @since tag");
        }
    }

    public char emitIndexEntry(Index currIndex, char oldsw, int multipleMarker) {
        String programElementType = currIndex.ename_;
        if (programElementType.compareTo("class") == 0) {
            return this.emitClassIndexEntry(currIndex, oldsw, multipleMarker);
        }
        if (programElementType.compareTo("constructor") == 0) {
            return this.emitCtorIndexEntry(currIndex, oldsw, multipleMarker);
        }
        if (programElementType.compareTo("method") == 0) {
            return this.emitMethodIndexEntry(currIndex, oldsw, multipleMarker);
        }
        if (programElementType.compareTo("field") == 0) {
            return this.emitFieldIndexEntry(currIndex, oldsw, multipleMarker);
        }
        System.out.println("Error: unknown program element type");
        System.exit(3);
        return '\u0000';
    }

    public void emitClassesIndex(APIDiff apiDiff, int indexType) {
        this.classNames = new ArrayList();
        boolean hasRemovals = false;
        boolean hasAdditions = false;
        boolean hasChanges = false;
        for (PackageDiff pkgDiff : apiDiff.packagesChanged) {
            Object cls;
            if (pkgDiff.classesRemoved.size() != 0) {
                hasRemovals = true;
            }
            if (pkgDiff.classesAdded.size() != 0) {
                hasAdditions = true;
            }
            if (pkgDiff.classesChanged.size() != 0) {
                hasChanges = true;
            }
            this.recordDiffs(hasRemovals, hasAdditions, hasChanges);
            String pkgName = pkgDiff.name_;
            Iterator iterClass = pkgDiff.classesRemoved.iterator();
            while ((indexType == 3 || indexType == 0) && iterClass.hasNext()) {
                cls = (ClassAPI)iterClass.next();
                this.classNames.add(new Index(((ClassAPI)cls).name_, 0, pkgName, ((ClassAPI)cls).isInterface_));
            }
            iterClass = pkgDiff.classesAdded.iterator();
            while ((indexType == 3 || indexType == 1) && iterClass.hasNext()) {
                cls = (ClassAPI)iterClass.next();
                Index idx = new Index(((ClassAPI)cls).name_, 1, pkgName, ((ClassAPI)cls).isInterface_);
                idx.doc_ = ((ClassAPI)cls).doc_;
                this.classNames.add(idx);
            }
            iterClass = pkgDiff.classesChanged.iterator();
            while ((indexType == 3 || indexType == 2) && iterClass.hasNext()) {
                cls = (ClassDiff)iterClass.next();
                this.classNames.add(new Index(((ClassDiff)cls).name_, 2, pkgName, ((ClassDiff)cls).isInterface_));
            }
        }
        Collections.sort(this.classNames);
        this.emitIndexHeader("Classes", indexType, hasRemovals, hasAdditions, hasChanges);
        this.emitIndexEntries(this.classNames.iterator());
        if (indexType == 1) {
            this.emitMissingSinces(this.classNames.iterator());
        }
    }

    public char emitClassIndexEntry(Index cls, char oldsw, int multipleMarker) {
        char res = oldsw;
        String className = cls.pkgName_ + "." + cls.name_;
        String classRef = cls.pkgName_ + "." + cls.name_;
        boolean isInterface = cls.isInterface_;
        char sw = cls.name_.charAt(0);
        if (Character.toUpperCase(sw) != Character.toUpperCase(oldsw)) {
            res = sw;
            this.h_.writeText("<A NAME=\"" + Character.toUpperCase(res) + "\"></A>");
            if (sw == '_') {
                this.h_.writeText("<br><b>underscore</b>&nbsp;");
            } else {
                this.h_.writeText("<br><font size=\"+2\">" + Character.toUpperCase(sw) + "</font>&nbsp;");
            }
            this.generateLetterIndex(this.classNames, sw, false);
        }
        if (multipleMarker == 1) {
            this.h_.writeText("<i>" + cls.name_ + "</i><br>");
        }
        if (multipleMarker != 0) {
            this.h_.indent(2);
        }
        if (cls.changeType_ == 0) {
            this.h_.writeText("<A HREF=\"pkg_" + cls.pkgName_ + HTMLReportGenerator.reportFileExt + "#" + cls.name_ + "\" class=\"hiddenlink\" target=\"rightframe\"><strike>" + cls.name_ + "</strike></A><br>");
        } else if (cls.changeType_ == 1) {
            String cn = cls.name_;
            if (multipleMarker != 0) {
                cn = cls.pkgName_;
            }
            if (isInterface) {
                this.h_.writeText("<A HREF=\"pkg_" + cls.pkgName_ + HTMLReportGenerator.reportFileExt + "#" + cls.name_ + "\" class=\"hiddenlink\" target=\"rightframe\"><b><i>" + cn + "</i></b></A><br>");
            } else {
                this.h_.writeText("<A HREF=\"pkg_" + cls.pkgName_ + HTMLReportGenerator.reportFileExt + "#" + cls.name_ + "\" class=\"hiddenlink\" target=\"rightframe\"><b>" + cn + "</b></A><br>");
            }
        } else if (cls.changeType_ == 2) {
            String cn = cls.name_;
            if (multipleMarker != 0) {
                cn = cls.pkgName_;
            }
            if (isInterface) {
                this.h_.writeText("<A HREF=\"" + classRef + HTMLReportGenerator.reportFileExt + "\" class=\"hiddenlink\" target=\"rightframe\"><i>" + cn + "</i></A><br>");
            } else {
                this.h_.writeText("<A HREF=\"" + classRef + HTMLReportGenerator.reportFileExt + "\" class=\"hiddenlink\" target=\"rightframe\">" + cn + "</A><br>");
            }
        }
        return res;
    }

    public void emitConstructorsIndex(APIDiff apiDiff, int indexType) {
        this.ctorNames = new ArrayList();
        boolean hasRemovals = false;
        boolean hasAdditions = false;
        boolean hasChanges = false;
        for (PackageDiff pkgDiff : apiDiff.packagesChanged) {
            String pkgName = pkgDiff.name_;
            for (ClassDiff classDiff : pkgDiff.classesChanged) {
                Object ctor;
                if (classDiff.ctorsRemoved.size() != 0) {
                    hasRemovals = true;
                }
                if (classDiff.ctorsAdded.size() != 0) {
                    hasAdditions = true;
                }
                if (classDiff.ctorsChanged.size() != 0) {
                    hasChanges = true;
                }
                this.recordDiffs(hasRemovals, hasAdditions, hasChanges);
                String className = classDiff.name_;
                Iterator iterCtor = classDiff.ctorsRemoved.iterator();
                while ((indexType == 3 || indexType == 0) && iterCtor.hasNext()) {
                    ctor = (ConstructorAPI)iterCtor.next();
                    this.ctorNames.add(new Index(className, 0, pkgName, ((ConstructorAPI)ctor).type_));
                }
                iterCtor = classDiff.ctorsAdded.iterator();
                while ((indexType == 3 || indexType == 1) && iterCtor.hasNext()) {
                    ctor = (ConstructorAPI)iterCtor.next();
                    Index idx = new Index(className, 1, pkgName, ((ConstructorAPI)ctor).type_);
                    idx.doc_ = ((ConstructorAPI)ctor).doc_;
                    this.ctorNames.add(idx);
                }
                iterCtor = classDiff.ctorsChanged.iterator();
                while ((indexType == 3 || indexType == 2) && iterCtor.hasNext()) {
                    ctor = (MemberDiff)iterCtor.next();
                    this.ctorNames.add(new Index(className, 2, pkgName, ((MemberDiff)ctor).newType_));
                }
            }
        }
        Collections.sort(this.ctorNames);
        this.emitIndexHeader("Constructors", indexType, hasRemovals, hasAdditions, hasChanges);
        this.emitIndexEntries(this.ctorNames.iterator());
        if (indexType == 1) {
            this.emitMissingSinces(this.ctorNames.iterator());
        }
    }

    public char emitCtorIndexEntry(Index ctor, char oldsw, int multipleMarker) {
        char res = oldsw;
        String className = ctor.pkgName_ + "." + ctor.name_;
        String memberRef = ctor.pkgName_ + "." + ctor.name_;
        String type = ctor.type_;
        if (type.compareTo("void") == 0) {
            type = "";
        }
        String shownType = HTMLReportGenerator.simpleName(type);
        char sw = ctor.name_.charAt(0);
        if (Character.toUpperCase(sw) != Character.toUpperCase(oldsw)) {
            res = sw;
            this.h_.writeText("<A NAME=\"" + Character.toUpperCase(res) + "\"></A>");
            if (sw == '_') {
                this.h_.writeText("<br><b>underscore</b>&nbsp;");
            } else {
                this.h_.writeText("<br><font size=\"+2\">" + Character.toUpperCase(sw) + "</font>&nbsp;");
            }
            this.generateLetterIndex(this.ctorNames, sw, false);
        }
        if (multipleMarker == 1) {
            this.h_.writeText("<i>" + ctor.name_ + "</i><br>");
        }
        if (multipleMarker != 0) {
            this.h_.indent(2);
        }
        if (ctor.changeType_ == 0) {
            String commentID = className + ".ctor_removed(" + type + ")";
            this.h_.writeText("<nobr><A HREF=\"" + memberRef + HTMLReportGenerator.reportFileExt + "#" + commentID + "\" class=\"hiddenlink\" target=\"rightframe\"><strike>" + ctor.name_ + "</strike>");
            HTMLReportGenerator.emitTypeWithParens(shownType, false);
            this.h_.writeText("</A></nobr>&nbsp;constructor<br>");
        } else if (ctor.changeType_ == 1) {
            String commentID = className + ".ctor_added(" + type + ")";
            this.h_.writeText("<nobr><A HREF=\"" + memberRef + HTMLReportGenerator.reportFileExt + "#" + commentID + "\" class=\"hiddenlink\" target=\"rightframe\"><b>" + ctor.name_ + "</b>");
            HTMLReportGenerator.emitTypeWithParens(shownType, false);
            this.h_.writeText("</A></nobr>&nbsp;constructor<br>");
        } else if (ctor.changeType_ == 2) {
            String commentID = className + ".ctor_changed(" + type + ")";
            this.h_.writeText("<nobr><A HREF=\"" + memberRef + HTMLReportGenerator.reportFileExt + "#" + commentID + "\" class=\"hiddenlink\" target=\"rightframe\">" + ctor.name_);
            HTMLReportGenerator.emitTypeWithParens(shownType, false);
            this.h_.writeText("</A></nobr>&nbsp;constructor<br>");
        }
        return res;
    }

    public void emitMethodsIndex(APIDiff apiDiff, int indexType) {
        this.methNames = new ArrayList();
        boolean hasRemovals = false;
        boolean hasAdditions = false;
        boolean hasChanges = false;
        for (PackageDiff pkgDiff : apiDiff.packagesChanged) {
            String pkgName = pkgDiff.name_;
            for (ClassDiff classDiff : pkgDiff.classesChanged) {
                Object meth;
                if (classDiff.methodsRemoved.size() != 0) {
                    hasRemovals = true;
                }
                if (classDiff.methodsAdded.size() != 0) {
                    hasAdditions = true;
                }
                if (classDiff.methodsChanged.size() != 0) {
                    hasChanges = true;
                }
                this.recordDiffs(hasRemovals, hasAdditions, hasChanges);
                String className = classDiff.name_;
                Iterator iterMeth = classDiff.methodsRemoved.iterator();
                while ((indexType == 3 || indexType == 0) && iterMeth.hasNext()) {
                    meth = (MethodAPI)iterMeth.next();
                    this.methNames.add(new Index(((MethodAPI)meth).name_, 0, pkgName, className, ((MethodAPI)meth).getSignature()));
                }
                iterMeth = classDiff.methodsAdded.iterator();
                while ((indexType == 3 || indexType == 1) && iterMeth.hasNext()) {
                    meth = (MethodAPI)iterMeth.next();
                    Index idx = new Index(((MethodAPI)meth).name_, 1, pkgName, className, ((MethodAPI)meth).getSignature());
                    idx.doc_ = ((MethodAPI)meth).doc_;
                    this.methNames.add(idx);
                }
                iterMeth = classDiff.methodsChanged.iterator();
                while ((indexType == 3 || indexType == 2) && iterMeth.hasNext()) {
                    meth = (MemberDiff)iterMeth.next();
                    this.methNames.add(new Index(((MemberDiff)meth).name_, 2, pkgName, className, ((MemberDiff)meth).newSignature_));
                }
            }
        }
        Collections.sort(this.methNames);
        this.emitIndexHeader("Methods", indexType, hasRemovals, hasAdditions, hasChanges);
        this.emitIndexEntries(this.methNames.iterator());
        if (indexType == 1) {
            this.emitMissingSinces(this.methNames.iterator());
        }
    }

    public char emitMethodIndexEntry(Index meth, char oldsw, int multipleMarker) {
        char res = oldsw;
        String className = meth.pkgName_ + "." + meth.className_;
        String memberRef = meth.pkgName_ + "." + meth.className_;
        String type = meth.type_;
        if (type.compareTo("void") == 0) {
            type = "";
        }
        String shownType = HTMLReportGenerator.simpleName(type);
        char sw = meth.name_.charAt(0);
        if (Character.toUpperCase(sw) != Character.toUpperCase(oldsw)) {
            res = sw;
            this.h_.writeText("<A NAME=\"" + Character.toUpperCase(res) + "\"></A>");
            if (sw == '_') {
                this.h_.writeText("<br><b>underscore</b>&nbsp;");
            } else {
                this.h_.writeText("<br><font size=\"+2\">" + Character.toUpperCase(sw) + "</font>&nbsp;");
            }
            this.generateLetterIndex(this.methNames, sw, false);
        }
        if (multipleMarker == 1) {
            this.h_.writeText("<i>" + meth.name_ + "</i><br>");
        }
        if (multipleMarker != 0) {
            this.h_.indent(2);
        }
        if (meth.changeType_ == 0) {
            String commentID = className + "." + meth.name_ + "_removed(" + type + ")";
            if (multipleMarker == 0) {
                this.h_.writeText("<nobr><A HREF=\"" + memberRef + HTMLReportGenerator.reportFileExt + "#" + commentID + "\" class=\"hiddenlink\" target=\"rightframe\"><strike>" + meth.name_ + "</strike>");
                HTMLReportGenerator.emitTypeWithParens(shownType, false);
            } else {
                this.h_.writeText("<nobr><A HREF=\"" + memberRef + HTMLReportGenerator.reportFileExt + "#" + commentID + "\" class=\"hiddenlink\" target=\"rightframe\">type&nbsp;<strike>");
                HTMLReportGenerator.emitTypeWithParens(shownType, false);
                this.h_.writeText("</strike>&nbsp;in&nbsp;" + className);
            }
            this.h_.writeText("</A></nobr><br>");
        } else if (meth.changeType_ == 1) {
            String commentID = className + "." + meth.name_ + "_added(" + type + ")";
            if (multipleMarker == 0) {
                this.h_.writeText("<nobr><A HREF=\"" + memberRef + HTMLReportGenerator.reportFileExt + "#" + commentID + "\" class=\"hiddenlink\" target=\"rightframe\"><b>" + meth.name_ + "</b>");
                HTMLReportGenerator.emitTypeWithParens(shownType, false);
            } else {
                this.h_.writeText("<nobr><A HREF=\"" + memberRef + HTMLReportGenerator.reportFileExt + "#" + commentID + "\" class=\"hiddenlink\" target=\"rightframe\">type&nbsp;<b>");
                HTMLReportGenerator.emitTypeWithParens(shownType, false);
                this.h_.writeText("</b>&nbsp;in&nbsp;" + className);
            }
            this.h_.writeText("</A></nobr><br>");
        } else if (meth.changeType_ == 2) {
            String commentID = className + "." + meth.name_ + "_changed(" + type + ")";
            if (multipleMarker == 0) {
                this.h_.writeText("<nobr><A HREF=\"" + memberRef + HTMLReportGenerator.reportFileExt + "#" + commentID + "\" class=\"hiddenlink\" target=\"rightframe\">" + meth.name_);
                HTMLReportGenerator.emitTypeWithParens(shownType, false);
            } else {
                this.h_.writeText("<nobr><A HREF=\"" + memberRef + HTMLReportGenerator.reportFileExt + "#" + commentID + "\" class=\"hiddenlink\" target=\"rightframe\">type&nbsp;");
                HTMLReportGenerator.emitTypeWithParens(shownType, false);
                this.h_.writeText("&nbsp;in&nbsp;" + className);
            }
            this.h_.writeText("</A></nobr><br>");
        }
        return res;
    }

    public void emitFieldsIndex(APIDiff apiDiff, int indexType) {
        this.fieldNames = new ArrayList();
        boolean hasRemovals = false;
        boolean hasAdditions = false;
        boolean hasChanges = false;
        for (PackageDiff pkgDiff : apiDiff.packagesChanged) {
            String pkgName = pkgDiff.name_;
            for (ClassDiff classDiff : pkgDiff.classesChanged) {
                Object fld;
                if (classDiff.fieldsRemoved.size() != 0) {
                    hasRemovals = true;
                }
                if (classDiff.fieldsAdded.size() != 0) {
                    hasAdditions = true;
                }
                if (classDiff.fieldsChanged.size() != 0) {
                    hasChanges = true;
                }
                this.recordDiffs(hasRemovals, hasAdditions, hasChanges);
                String className = classDiff.name_;
                Iterator iterField = classDiff.fieldsRemoved.iterator();
                while ((indexType == 3 || indexType == 0) && iterField.hasNext()) {
                    fld = (FieldAPI)iterField.next();
                    this.fieldNames.add(new Index(((FieldAPI)fld).name_, 0, pkgName, className, ((FieldAPI)fld).type_, true));
                }
                iterField = classDiff.fieldsAdded.iterator();
                while ((indexType == 3 || indexType == 1) && iterField.hasNext()) {
                    fld = (FieldAPI)iterField.next();
                    Index idx = new Index(((FieldAPI)fld).name_, 1, pkgName, className, ((FieldAPI)fld).type_, true);
                    idx.doc_ = ((FieldAPI)fld).doc_;
                    this.fieldNames.add(idx);
                }
                iterField = classDiff.fieldsChanged.iterator();
                while ((indexType == 3 || indexType == 2) && iterField.hasNext()) {
                    fld = (MemberDiff)iterField.next();
                    this.fieldNames.add(new Index(((MemberDiff)fld).name_, 2, pkgName, className, ((MemberDiff)fld).newType_, true));
                }
            }
        }
        Collections.sort(this.fieldNames);
        this.emitIndexHeader("Fields", indexType, hasRemovals, hasAdditions, hasChanges);
        this.emitIndexEntries(this.fieldNames.iterator());
        if (indexType == 1) {
            this.emitMissingSinces(this.fieldNames.iterator());
        }
    }

    public char emitFieldIndexEntry(Index fld, char oldsw, int multipleMarker) {
        char res = oldsw;
        String className = fld.pkgName_ + "." + fld.className_;
        String memberRef = fld.pkgName_ + "." + fld.className_;
        String type = fld.type_;
        if (type.compareTo("void") == 0) {
            type = "";
        }
        String shownType = HTMLReportGenerator.simpleName(type);
        char sw = fld.name_.charAt(0);
        if (Character.toUpperCase(sw) != Character.toUpperCase(oldsw)) {
            res = sw;
            this.h_.writeText("<A NAME=\"" + Character.toUpperCase(res) + "\"></A>");
            if (sw == '_') {
                this.h_.writeText("<br><b>underscore</b>&nbsp;");
            } else {
                this.h_.writeText("<br><font size=\"+2\">" + Character.toUpperCase(sw) + "</font>&nbsp;");
            }
            this.generateLetterIndex(this.fieldNames, sw, false);
        }
        if (multipleMarker == 1) {
            this.h_.writeText("<i>" + fld.name_ + "</i><br>");
        }
        if (multipleMarker != 0) {
            this.h_.writeText("&nbsp;in&nbsp;");
        }
        if (fld.changeType_ == 0) {
            String commentID = className + "." + fld.name_;
            if (multipleMarker == 0) {
                this.h_.writeText("<nobr><A HREF=\"" + memberRef + HTMLReportGenerator.reportFileExt + "#" + commentID + "\" class=\"hiddenlink\" target=\"rightframe\"><strike>" + fld.name_ + "</strike></A>");
                this.h_.writeText("</nobr><br>");
            } else {
                this.h_.writeText("<nobr><A HREF=\"" + memberRef + HTMLReportGenerator.reportFileExt + "#" + commentID + "\" class=\"hiddenlink\" target=\"rightframe\"><strike>" + className + "</strike></A>");
                this.h_.writeText("</nobr><br>");
            }
        } else if (fld.changeType_ == 1) {
            String commentID = className + "." + fld.name_;
            if (multipleMarker == 0) {
                this.h_.writeText("<nobr><A HREF=\"" + memberRef + HTMLReportGenerator.reportFileExt + "#" + commentID + "\" class=\"hiddenlink\" target=\"rightframe\">" + fld.name_ + "</A>");
                this.h_.writeText("</nobr><br>");
            } else {
                this.h_.writeText("<nobr><A HREF=\"" + memberRef + HTMLReportGenerator.reportFileExt + "#" + commentID + "\" class=\"hiddenlink\" target=\"rightframe\">" + className + "</A>");
                this.h_.writeText("</nobr><br>");
            }
        } else if (fld.changeType_ == 2) {
            String commentID = className + "." + fld.name_;
            if (multipleMarker == 0) {
                this.h_.writeText("<nobr><A HREF=\"" + memberRef + HTMLReportGenerator.reportFileExt + "#" + commentID + "\" class=\"hiddenlink\" target=\"rightframe\">" + fld.name_ + "</A>");
                this.h_.writeText("</nobr><br>");
            } else {
                this.h_.writeText("<nobr><A HREF=\"" + memberRef + HTMLReportGenerator.reportFileExt + "#" + commentID + "\" class=\"hiddenlink\" target=\"rightframe\">" + className + "</A>");
                this.h_.writeText("</nobr><br>");
            }
        }
        return res;
    }

    public void emitAllDiffsIndex(APIDiff apiDiff, int indexType) {
        this.allNames = new ArrayList();
        this.allNames.addAll(this.packageNames);
        this.allNames.addAll(this.classNames);
        this.allNames.addAll(this.ctorNames);
        this.allNames.addAll(this.methNames);
        this.allNames.addAll(this.fieldNames);
        Collections.sort(this.allNames);
        this.emitIndexHeader("All Differences", indexType, this.atLeastOneRemoval, this.atLeastOneAddition, this.atLeastOneChange);
        this.isAllNames = true;
        Iterator iter = this.allNames.iterator();
        char oldsw = '\u0000';
        int multipleMarker = 0;
        Index currIndex = null;
        while (iter.hasNext()) {
            Index nextIndex = (Index)iter.next();
            if (currIndex == null) {
                currIndex = nextIndex;
                continue;
            }
            if (nextIndex.name_.compareTo(currIndex.name_) == 0) {
                if (multipleMarker == 0) {
                    multipleMarker = 1;
                } else if (multipleMarker == 1) {
                    multipleMarker = 2;
                }
                oldsw = this.emitIndexEntryForAny(currIndex, oldsw, multipleMarker);
            } else {
                if (multipleMarker == 1) {
                    multipleMarker = 2;
                }
                oldsw = this.emitIndexEntryForAny(currIndex, oldsw, multipleMarker);
                multipleMarker = 0;
            }
            currIndex = nextIndex;
        }
        if (multipleMarker == 1) {
            multipleMarker = 2;
        }
        if (currIndex != null) {
            oldsw = this.emitIndexEntryForAny(currIndex, oldsw, multipleMarker);
        }
        this.isAllNames = false;
    }

    public char emitIndexEntryForAny(Index currIndex, char oldsw, int multipleMarker) {
        if (currIndex.ename_.compareTo("package") == 0) {
            this.h_.writeText("<!-- Package " + currIndex.name_ + " -->");
            return this.emitPackageIndexEntry(currIndex, oldsw);
        }
        if (currIndex.ename_.compareTo("class") == 0) {
            this.h_.writeText("<!-- Class " + currIndex.name_ + " -->");
            return this.emitClassIndexEntry(currIndex, oldsw, multipleMarker);
        }
        if (currIndex.ename_.compareTo("constructor") == 0) {
            this.h_.writeText("<!-- Constructor " + currIndex.name_ + " -->");
            return this.emitCtorIndexEntry(currIndex, oldsw, multipleMarker);
        }
        if (currIndex.ename_.compareTo("method") == 0) {
            this.h_.writeText("<!-- Method " + currIndex.name_ + " -->");
            return this.emitMethodIndexEntry(currIndex, oldsw, multipleMarker);
        }
        if (currIndex.ename_.compareTo("field") == 0) {
            this.h_.writeText("<!-- Field " + currIndex.name_ + " -->");
            return this.emitFieldIndexEntry(currIndex, oldsw, multipleMarker);
        }
        return '\u0000';
    }

    private void recordDiffs(boolean hasRemovals, boolean hasAdditions, boolean hasChanges) {
        if (hasRemovals) {
            this.atLeastOneRemoval = true;
        }
        if (hasAdditions) {
            this.atLeastOneAddition = true;
        }
        if (hasChanges) {
            this.atLeastOneChange = true;
        }
    }
}

