/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.regex.Pattern;

public class Eclipse {
    public static void generateFrom(Configuration c) throws IOException {
        StringBuilder classpath = new StringBuilder();
        classpath.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n");
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        File precedence = new File("path-precedence");
        if (precedence.exists()) {
            Configuration.parseFile(precedence, patterns);
        } else {
            patterns.add(Pattern.compile("^(?!out/)"));
        }
        patterns.add(Pattern.compile(".*"));
        ArrayList<Bucket> buckets = new ArrayList<Bucket>(patterns.size());
        for (Pattern pattern : patterns) {
            buckets.add(new Bucket(pattern));
        }
        block1: for (File sourceRoot : c.sourceRoots) {
            String path = sourceRoot.getPath().substring(2);
            for (Bucket bucket : buckets) {
                if (!bucket.matches(path)) continue;
                bucket.sourceRoots.add(sourceRoot);
                continue block1;
            }
        }
        for (Bucket bucket : buckets) {
            for (File sourceRoot : bucket.sourceRoots) {
                classpath.append("  <classpathentry kind=\"src\"");
                CharSequence excluding = Eclipse.constructExcluding(sourceRoot, c);
                if (excluding.length() > 0) {
                    classpath.append(" excluding=\"").append(excluding).append("\"");
                }
                classpath.append(" path=\"").append(Eclipse.trimmed(sourceRoot)).append("\"/>\n");
            }
        }
        for (File jar : c.jarFiles) {
            classpath.append("  <classpathentry kind=\"lib\" path=\"").append(Eclipse.trimmed(jar)).append("\"/>\n");
        }
        classpath.append("  <classpathentry kind=\"output\" path=\"out/eclipse\"/>\n");
        classpath.append("</classpath>\n");
        Files.toFile(classpath.toString(), new File(".classpath"));
    }

    private static CharSequence constructExcluding(File sourceRoot, Configuration c) {
        File excludedDir;
        String excludedPath;
        StringBuilder classpath = new StringBuilder();
        String path = sourceRoot.getPath();
        SortedSet<File> nextRoots = c.sourceRoots.tailSet(sourceRoot);
        int count = 0;
        for (File nextRoot : nextRoots) {
            if (count == 0) {
                ++count;
                continue;
            }
            String nextPath = nextRoot.getPath();
            if (!nextPath.startsWith(path)) break;
            if (count > 1) {
                classpath.append('|');
            }
            classpath.append(nextPath.substring(path.length() + 1)).append('/');
            ++count;
        }
        SortedSet<File> excludedDirs = c.excludedDirs.tailSet(sourceRoot);
        Iterator i$ = excludedDirs.iterator();
        while (i$.hasNext() && (excludedPath = (excludedDir = (File)i$.next()).getPath()).startsWith(path)) {
            if (count > 1) {
                classpath.append('|');
            }
            classpath.append(excludedPath.substring(path.length() + 1)).append('/');
            ++count;
        }
        return classpath;
    }

    private static String trimmed(File file) {
        return file.getPath().substring(2);
    }

    private static class Bucket {
        private final Pattern pattern;
        private final List<File> sourceRoots = new ArrayList<File>();

        private Bucket(Pattern pattern) {
            this.pattern = pattern;
        }

        private boolean matches(String path) {
            return this.pattern.matcher(path).find();
        }
    }
}

