/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    public final SortedSet<File> sourceRoots;
    public final List<File> jarFiles;
    public final SortedSet<File> excludedDirs;
    public final File toolDirectory = new File("development/tools/idegen");
    private static final String EXCLUDED_PATHS = "excluded-paths";

    public Configuration() throws IOException {
        if (!this.toolDirectory.isDirectory()) {
            throw new AssertionError((Object)"Not in root directory.");
        }
        Stopwatch stopwatch = new Stopwatch();
        Excludes excludes = this.readExcludes();
        stopwatch.reset("Read excludes");
        ArrayList<File> jarFiles = new ArrayList<File>(500);
        TreeSet<File> excludedDirs = new TreeSet<File>();
        TreeSet<File> sourceRoots = new TreeSet<File>();
        Configuration.traverse(new File("."), sourceRoots, jarFiles, excludedDirs, excludes);
        stopwatch.reset("Traversed tree");
        Log.debug(sourceRoots.size() + " source roots");
        Log.debug(jarFiles.size() + " jar files");
        Log.debug(excludedDirs.size() + " excluded dirs");
        this.sourceRoots = Collections.unmodifiableSortedSet(sourceRoots);
        this.jarFiles = Collections.unmodifiableList(jarFiles);
        this.excludedDirs = Collections.unmodifiableSortedSet(excludedDirs);
    }

    private Excludes readExcludes() throws IOException {
        File localExcludes;
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        File globalExcludes = new File(this.toolDirectory, EXCLUDED_PATHS);
        Configuration.parseFile(globalExcludes, patterns);
        File googleExcludes = new File("./vendor/google/excluded-paths");
        if (googleExcludes.exists()) {
            Configuration.parseFile(googleExcludes, patterns);
        }
        if ((localExcludes = new File(EXCLUDED_PATHS)).exists()) {
            Configuration.parseFile(localExcludes, patterns);
        }
        return new Excludes(patterns);
    }

    private static void traverse(File directory, Set<File> sourceRoots, Collection<File> jarFiles, Collection<File> excludedDirs, Excludes excludes) throws IOException {
        boolean firstJavaFile = true;
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String path = file.getPath().substring(2);
            if (path.endsWith(".java")) {
                if (!firstJavaFile) continue;
                firstJavaFile = false;
                File sourceRoot = Configuration.rootOf(file);
                if (sourceRoot == null) continue;
                sourceRoots.add(sourceRoot);
                continue;
            }
            if (path.endsWith(".jar")) {
                if (!excludes.exclude(path)) {
                    jarFiles.add(file);
                    continue;
                }
                Log.debug("Skipped: " + file);
                continue;
            }
            if (!file.isDirectory()) continue;
            if (excludes.exclude(path)) {
                Log.debug("Excluding: " + path);
                excludedDirs.add(file);
                continue;
            }
            Configuration.traverse(file, sourceRoots, jarFiles, excludedDirs, excludes);
        }
    }

    private static File rootOf(File javaFile) throws IOException {
        String packageName = Configuration.parsePackageName(javaFile);
        if (packageName == null) {
            return null;
        }
        String packagePath = packageName.replace('.', File.separatorChar);
        File parent = javaFile.getParentFile();
        String parentPath = parent.getPath();
        if (!parentPath.endsWith(packagePath)) {
            return null;
        }
        return new File(parentPath.substring(0, parentPath.length() - packagePath.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String parsePackageName(File file) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                String trimmed = line.trim();
                if (!trimmed.startsWith("package")) continue;
                String string = trimmed.substring(8, trimmed.length() - 1);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            in.close();
        }
    }

    public SortedSet<File> excludesUnderSourceRoots() {
        TreeSet<File> picked = new TreeSet<File>();
        for (File sourceRoot : this.sourceRoots) {
            File file;
            String sourcePath = sourceRoot.getPath() + "/";
            SortedSet<File> tailSet = this.excludedDirs.tailSet(sourceRoot);
            Iterator i$ = tailSet.iterator();
            while (i$.hasNext() && (file = (File)i$.next()).getPath().startsWith(sourcePath)) {
                picked.add(file);
            }
        }
        return picked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseFile(File file, Collection<Pattern> patterns) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                String trimmed = line.trim();
                if (trimmed.length() <= 0 || trimmed.startsWith("#")) continue;
                patterns.add(Pattern.compile(trimmed));
            }
        }
        finally {
            in.close();
        }
    }
}

