/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.ui.model;

import java.text.NumberFormat;
import javax.swing.table.DefaultTableModel;

public class ProfilesTableModel
extends DefaultTableModel {
    private static final String[] NAMES = new String[]{"measure", "layout", "draw"};
    private final double[] profiles;
    private final NumberFormat formatter;

    public ProfilesTableModel(double[] profiles) {
        this.profiles = profiles;
        this.formatter = NumberFormat.getNumberInstance();
    }

    public int getRowCount() {
        return this.profiles == null ? 0 : this.profiles.length;
    }

    public Object getValueAt(int row, int column) {
        if (this.profiles == null) {
            return "";
        }
        if (column == 0) {
            return NAMES[row];
        }
        return this.formatter.format(this.profiles[row]) + "";
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        return column == 0 ? "Operation" : "Duration (ms)";
    }

    public boolean isCellEditable(int arg0, int arg1) {
        return false;
    }

    public void setValueAt(Object arg0, int arg1, int arg2) {
    }
}

