/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.scene;

import com.android.ddmlib.IDevice;
import com.android.hierarchyviewer.device.DeviceBridge;
import com.android.hierarchyviewer.device.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;

public class WindowsLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Window[] loadWindows(IDevice device, int protocol, int server) {
        Socket socket = null;
        BufferedReader in = null;
        BufferedWriter out = null;
        System.out.println("protocol = " + protocol);
        System.out.println("version = " + server);
        try {
            String line;
            ArrayList<Window> windows = new ArrayList<Window>();
            socket = new Socket();
            socket.connect(new InetSocketAddress("127.0.0.1", DeviceBridge.getDeviceLocalPort(device)));
            out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out.write("LIST");
            out.newLine();
            out.flush();
            while ((line = in.readLine()) != null && !"DONE.".equalsIgnoreCase(line)) {
                int index = line.indexOf(32);
                if (index == -1) continue;
                String windowId = line.substring(0, index);
                int id = server > 2 ? (int)Long.parseLong(windowId, 16) : Integer.parseInt(windowId, 16);
                Window w = new Window(line.substring(index + 1), id);
                windows.add(w);
            }
            Window[] windowArray = windows.toArray(new Window[windows.size()]);
            return windowArray;
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return new Window[0];
    }
}

