/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.scene;

import com.android.ddmlib.IDevice;
import com.android.hierarchyviewer.device.DeviceBridge;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;

public class VersionLoader {
    public static int loadServerVersion(IDevice device) {
        return VersionLoader.loadVersion(device, "SERVER");
    }

    public static int loadProtocolVersion(IDevice device) {
        return VersionLoader.loadVersion(device, "PROTOCOL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int loadVersion(IDevice device, String command) {
        Socket socket = null;
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress("127.0.0.1", DeviceBridge.getDeviceLocalPort(device)));
            out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out.write(command);
            out.newLine();
            out.flush();
            int n = Integer.parseInt(in.readLine());
            return n;
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return 2;
    }
}

