/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.scene;

import com.android.ddmlib.IDevice;
import com.android.hierarchyviewer.device.DeviceBridge;
import com.android.hierarchyviewer.device.Window;
import com.android.hierarchyviewer.ui.util.PsdFile;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.imageio.ImageIO;

public class CaptureLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveLayers(IDevice device, Window window, File file) {
        Socket socket = null;
        FilterInputStream in = null;
        BufferedWriter out = null;
        boolean result = false;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress("127.0.0.1", DeviceBridge.getDeviceLocalPort(device)));
            out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
            out.write("CAPTURE_LAYERS " + window.encode());
            out.newLine();
            out.flush();
            int width = ((DataInputStream)in).readInt();
            int height = ((DataInputStream)in).readInt();
            PsdFile psd = new PsdFile(width, height);
            while (CaptureLoader.readLayer((DataInputStream)in, psd)) {
            }
            psd.write(new FileOutputStream(file));
            result = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    private static boolean readLayer(DataInputStream in, PsdFile psd) {
        try {
            if (in.read() == 2) {
                System.out.println("Found end of layers list");
                return false;
            }
            String name = in.readUTF();
            System.out.println("name = " + name);
            boolean visible = in.read() == 1;
            int x = in.readInt();
            int y = in.readInt();
            int dataSize = in.readInt();
            byte[] data = new byte[dataSize];
            for (int read = 0; read < dataSize; read += in.read(data, read, dataSize - read)) {
            }
            ByteArrayInputStream arrayIn = new ByteArrayInputStream(data);
            BufferedImage chunk = ImageIO.read(arrayIn);
            BufferedImage image = new BufferedImage(chunk.getWidth(), chunk.getHeight(), 2);
            Graphics2D g = image.createGraphics();
            g.drawImage(chunk, null, 0, 0);
            g.dispose();
            psd.addLayer(name, image, new Point(x, y), visible);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image loadCapture(IDevice device, Window window, String params) {
        Socket socket = null;
        BufferedInputStream in = null;
        BufferedWriter out = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress("127.0.0.1", DeviceBridge.getDeviceLocalPort(device)));
            out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            in = new BufferedInputStream(socket.getInputStream());
            out.write("CAPTURE " + window.encode() + " " + params);
            out.newLine();
            out.flush();
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }
}

