/*
 * Decompiled with CFR 0.152.
 */
package com.android.eventanalyzer;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.log.EventContainer;
import com.android.ddmlib.log.EventLogParser;
import com.android.ddmlib.log.InvalidTypeException;
import com.android.ddmlib.log.LogReceiver;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;

public class EventAnalyzer
implements LogReceiver.ILogListener {
    private static final int TAG_ACTIVITY_LAUNCH_TIME = 30009;
    private static final char DATA_SEPARATOR = ',';
    private static final String CVS_EXT = ".csv";
    private static final String TAG_FILE_EXT = ".tag";
    private EventLogParser mParser;
    private TreeMap<String, ArrayList<Long>> mLaunchMap = new TreeMap();
    String mInputTextFile = null;
    String mInputBinaryFile = null;
    String mInputDevice = null;
    String mInputFolder = null;
    String mAlternateTagFile = null;
    String mOutputFile = null;

    public static void main(String[] args) {
        new EventAnalyzer().run(args);
    }

    private void run(String[] args) {
        File outputParent;
        if (args.length == 0) {
            EventAnalyzer.printUsageAndQuit();
        }
        int index = 0;
        do {
            String argument;
            if ("-s".equals(argument = args[index++])) {
                this.checkInputValidity("-s");
                if (index == args.length) {
                    EventAnalyzer.printUsageAndQuit();
                }
                this.mInputDevice = args[index++];
                continue;
            }
            if ("-fb".equals(argument)) {
                this.checkInputValidity("-fb");
                if (index == args.length) {
                    EventAnalyzer.printUsageAndQuit();
                }
                this.mInputBinaryFile = args[index++];
                continue;
            }
            if ("-ft".equals(argument)) {
                this.checkInputValidity("-ft");
                if (index == args.length) {
                    EventAnalyzer.printUsageAndQuit();
                }
                this.mInputTextFile = args[index++];
                continue;
            }
            if ("-F".equals(argument)) {
                this.checkInputValidity("-F");
                if (index == args.length) {
                    EventAnalyzer.printUsageAndQuit();
                }
                this.mInputFolder = args[index++];
                continue;
            }
            if ("-t".equals(argument)) {
                if (index == args.length) {
                    EventAnalyzer.printUsageAndQuit();
                }
                this.mAlternateTagFile = args[index++];
                continue;
            }
            this.mOutputFile = argument;
            if (index >= args.length) continue;
            EventAnalyzer.printAndExit("Too many arguments!", false);
        } while (index < args.length);
        if (this.mInputTextFile == null && this.mInputBinaryFile == null && this.mInputFolder == null && this.mInputDevice == null) {
            EventAnalyzer.printUsageAndQuit();
        }
        if ((outputParent = new File(this.mOutputFile).getParentFile()) == null || !outputParent.isDirectory()) {
            EventAnalyzer.printAndExit(String.format("%1$s is not a valid ouput file", this.mOutputFile), false);
        }
        Log.setLogOutput((Log.ILogOutput)new Log.ILogOutput(){

            public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message) {
            }

            public void printLog(Log.LogLevel logLevel, String tag, String message) {
            }
        });
        try {
            if (this.mInputBinaryFile != null) {
                this.parseBinaryLogFile();
            } else if (this.mInputTextFile != null) {
                this.parseTextLogFile(this.mInputTextFile);
            } else if (this.mInputFolder != null) {
                this.parseFolder(this.mInputFolder);
            } else if (this.mInputDevice != null) {
                this.parseLogFromDevice();
            }
            this.analyzeData();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseBinaryLogFile() throws IOException {
        int count;
        this.mParser = new EventLogParser();
        String tagFile = this.mInputBinaryFile + TAG_FILE_EXT;
        if (!this.mParser.init(tagFile)) {
            if (this.mAlternateTagFile != null) {
                if (!this.mParser.init(this.mAlternateTagFile)) {
                    EventAnalyzer.printAndExit("Failed to get event tags from " + this.mAlternateTagFile, false);
                }
            } else {
                EventAnalyzer.printAndExit("Failed to get event tags from " + tagFile, false);
            }
        }
        LogReceiver receiver = new LogReceiver((LogReceiver.ILogListener)this);
        byte[] buffer = new byte[256];
        FileInputStream fis = new FileInputStream(this.mInputBinaryFile);
        while ((count = fis.read(buffer)) != -1) {
            receiver.parseNewData(buffer, 0, count);
        }
    }

    private void parseTextLogFile(String filePath) throws IOException {
        String line;
        this.mParser = new EventLogParser();
        String tagFile = filePath + TAG_FILE_EXT;
        if (!this.mParser.init(tagFile)) {
            if (this.mAlternateTagFile != null) {
                if (!this.mParser.init(this.mAlternateTagFile)) {
                    EventAnalyzer.printAndExit("Failed to get event tags from " + this.mAlternateTagFile, false);
                }
            } else {
                EventAnalyzer.printAndExit("Failed to get event tags from " + tagFile, false);
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
        while ((line = reader.readLine()) != null) {
            this.processEvent(this.mParser.parse(line));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseLogFromDevice() throws IOException {
        AndroidDebugBridge.init((boolean)false);
        try {
            IDevice[] devices;
            AndroidDebugBridge bridge = AndroidDebugBridge.createBridge();
            int count = 0;
            while (!bridge.hasInitialDeviceList()) {
                try {
                    Thread.sleep(100L);
                    ++count;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (count <= 100) continue;
                EventAnalyzer.printAndExit("Timeout getting device list!", true);
            }
            for (IDevice device : devices = bridge.getDevices()) {
                if (!device.getSerialNumber().equals(this.mInputDevice)) continue;
                this.grabLogFrom(device);
                return;
            }
            System.err.println("Could not find " + this.mInputDevice);
        }
        finally {
            AndroidDebugBridge.terminate();
        }
    }

    private void parseFolder(String folderPath) {
        String[] files;
        File f = new File(folderPath);
        if (!f.isDirectory()) {
            EventAnalyzer.printAndExit(String.format("%1$s is not a valid folder", folderPath), false);
        }
        for (String file : files = f.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !(name = name.toLowerCase()).endsWith(EventAnalyzer.TAG_FILE_EXT);
            }
        })) {
            try {
                f = new File(folderPath + File.separator + file);
                if (f.isDirectory()) {
                    this.parseFolder(f.getAbsolutePath());
                    continue;
                }
                this.parseTextLogFile(f.getAbsolutePath());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private void grabLogFrom(IDevice device) throws IOException {
        this.mParser = new EventLogParser();
        if (!this.mParser.init(device)) {
            EventAnalyzer.printAndExit("Failed to get event-log-tags from " + device.getSerialNumber(), true);
        }
        LogReceiver receiver = new LogReceiver((LogReceiver.ILogListener)this);
        device.runEventLogService(receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeData() throws IOException {
        BufferedWriter writer = null;
        try {
            ArrayList<Long> list;
            if (!this.mOutputFile.toLowerCase().endsWith(CVS_EXT)) {
                this.mOutputFile = this.mOutputFile + CVS_EXT;
            }
            writer = new BufferedWriter(new FileWriter(this.mOutputFile));
            StringBuilder builder = new StringBuilder();
            Set<String> activities = this.mLaunchMap.keySet();
            for (String activity : activities) {
                builder.append(activity).append(',');
            }
            writer.write(builder.append('\n').toString());
            boolean moreValues = true;
            int index = 0;
            while (moreValues) {
                moreValues = false;
                builder.setLength(0);
                for (String activity : activities) {
                    list = this.mLaunchMap.get(activity);
                    if (index < list.size()) {
                        moreValues = true;
                        builder.append(list.get(index)).append(',');
                        continue;
                    }
                    builder.append(',');
                }
                if (moreValues) {
                    writer.write(builder.append('\n').toString());
                }
                ++index;
            }
            for (String activity : activities) {
                builder.setLength(0);
                builder.append(activity).append(',');
                list = this.mLaunchMap.get(activity);
                Collections.sort(list);
                builder.append(list.get(0)).append(',');
                builder.append(list.get(list.size() - 1)).append(',');
                builder.append(list.get(list.size() / 2)).append(',');
                long total = 0L;
                for (Long value : list) {
                    total += value.longValue();
                }
                builder.append(total / (long)list.size()).append(',');
                writer.write(builder.append('\n').toString());
            }
        }
        finally {
            writer.close();
        }
    }

    public void newData(byte[] data, int offset, int length) {
    }

    public void newEntry(LogReceiver.LogEntry entry) {
        this.processEvent(this.mParser.parse(entry));
    }

    private void processEvent(EventContainer event) {
        if (event != null && event.mTag == 30009) {
            try {
                String name = event.getValueAsString(0);
                Object value = event.getValue(1);
                if (value instanceof Long) {
                    this.addLaunchTime(name, (Long)value);
                }
            }
            catch (InvalidTypeException invalidTypeException) {
                // empty catch block
            }
        }
    }

    private void addLaunchTime(String name, Long value) {
        ArrayList<Long> list = this.mLaunchMap.get(name);
        if (list == null) {
            list = new ArrayList();
            this.mLaunchMap.put(name, list);
        }
        list.add(value);
    }

    private void checkInputValidity(String option) {
        if (this.mInputTextFile != null || this.mInputBinaryFile != null) {
            EventAnalyzer.printAndExit(String.format("ERROR: %1$s cannot be used with an input file.", option), false);
        } else if (this.mInputFolder != null) {
            EventAnalyzer.printAndExit(String.format("ERROR: %1$s cannot be used with an input file.", option), false);
        } else if (this.mInputDevice != null) {
            EventAnalyzer.printAndExit(String.format("ERROR: %1$s cannot be used with an input device serial number.", option), false);
        }
    }

    private static void printUsageAndQuit() {
        System.out.println("Usage:");
        System.out.println("   eventanalyzer [-t <TAG_FILE>] <SOURCE> <OUTPUT>");
        System.out.println("");
        System.out.println("Possible sources:");
        System.out.println("   -fb <file>    The path to a binary event log, gathered by dumpeventlog");
        System.out.println("   -ft <file>    The path to a text event log, gathered by adb logcat -b events");
        System.out.println("   -F <folder>   The path to a folder containing multiple text log files.");
        System.out.println("   -s <serial>   The serial number of the Device to grab the event log from.");
        System.out.println("Options:");
        System.out.println("   -t <file>     The path to tag file to use in case the one associated with");
        System.out.println("                 the source is missing");
        System.exit(1);
    }

    private static void printAndExit(String message, boolean terminate) {
        System.out.println(message);
        if (terminate) {
            AndroidDebugBridge.terminate();
        }
        System.exit(1);
    }
}

