/*
 * Decompiled with CFR 0.152.
 */
package com.android.dumpeventlog;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.log.LogReceiver;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class DumpEventLog {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: dumpeventlog <device s/n> <filepath>");
            return;
        }
        Log.setLogOutput((Log.ILogOutput)new Log.ILogOutput(){

            public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message) {
            }

            public void printLog(Log.LogLevel logLevel, String tag, String message) {
            }
        });
        AndroidDebugBridge.init((boolean)false);
        try {
            IDevice[] devices;
            AndroidDebugBridge bridge = AndroidDebugBridge.createBridge();
            int count = 0;
            while (!bridge.hasInitialDeviceList()) {
                try {
                    Thread.sleep(100L);
                    ++count;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (count <= 100) continue;
                System.err.println("Timeout getting device list!");
                return;
            }
            for (IDevice device : devices = bridge.getDevices()) {
                if (!device.getSerialNumber().equals(args[0])) continue;
                try {
                    DumpEventLog.grabLogFrom(device, args[1]);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            System.err.println("Could not find " + args[0]);
        }
        finally {
            AndroidDebugBridge.terminate();
        }
    }

    private static void grabLogFrom(IDevice device, String filePath) throws IOException {
        LogWriter writer = new LogWriter(filePath);
        LogReceiver receiver = new LogReceiver((LogReceiver.ILogListener)writer);
        writer.setReceiver(receiver);
        device.runEventLogService(receiver);
        writer.done();
    }

    private static class LogWriter
    implements LogReceiver.ILogListener {
        private FileOutputStream mOutputStream;
        private LogReceiver mReceiver;

        public LogWriter(String filePath) throws IOException {
            this.mOutputStream = new FileOutputStream(filePath);
        }

        public void newData(byte[] data, int offset, int length) {
            try {
                this.mOutputStream.write(data, offset, length);
            }
            catch (IOException e) {
                if (this.mReceiver != null) {
                    this.mReceiver.cancel();
                }
                System.out.println(e);
            }
        }

        public void newEntry(LogReceiver.LogEntry entry) {
        }

        public void setReceiver(LogReceiver receiver) {
            this.mReceiver = receiver;
        }

        public void done() throws IOException {
            this.mOutputStream.close();
        }
    }
}

