/*
 * Decompiled with CFR 0.152.
 */
import org.clearsilver.HDF;

public class TagInfo {
    private String mName;
    private String mText;
    private String mKind;
    private SourcePositionInfo mPosition;

    TagInfo(String n, String k, String t, SourcePositionInfo sp) {
        this.mName = n;
        this.mText = t;
        this.mKind = k;
        this.mPosition = sp;
    }

    String name() {
        return this.mName;
    }

    String text() {
        return this.mText;
    }

    String kind() {
        return this.mKind;
    }

    SourcePositionInfo position() {
        return this.mPosition;
    }

    void setKind(String kind) {
        this.mKind = kind;
    }

    public void makeHDF(HDF data, String base) {
        data.setValue(base + ".name", this.name());
        data.setValue(base + ".text", this.text());
        data.setValue(base + ".kind", this.kind());
    }

    public static void makeHDF(HDF data, String base, TagInfo[] tags) {
        TagInfo.makeHDF(data, base, tags, null, 0, 0);
    }

    public static void makeHDF(HDF data, String base, InheritedTags tags) {
        TagInfo.makeHDF(data, base, tags.tags(), tags.inherited(), 0, 0);
    }

    private static int makeHDF(HDF data, String base, TagInfo[] tags, InheritedTags inherited, int j, int depth) {
        int len = tags.length;
        if (len == 0 && inherited != null) {
            j = TagInfo.makeHDF(data, base, inherited.tags(), inherited.inherited(), j, depth + 1);
        } else {
            int i = 0;
            while (i < len) {
                TagInfo t = tags[i];
                if (inherited != null && t.name().equals("@inheritDoc")) {
                    j = TagInfo.makeHDF(data, base, inherited.tags(), inherited.inherited(), j, depth + 1);
                } else {
                    if (t.name().equals("@inheritDoc")) {
                        Errors.error(Errors.BAD_INHERITDOC, t.mPosition, "@inheritDoc on class/method that is not inherited");
                    }
                    t.makeHDF(data, base + "." + j);
                }
                ++i;
                ++j;
            }
        }
        return j;
    }
}

