/*
 * Decompiled with CFR 0.152.
 */
import com.android.apicheck.ApiCheck;
import com.android.apicheck.ApiInfo;
import com.android.apicheck.ClassInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.clearsilver.HDF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinceTagger {
    private final Map<String, String> xmlToName = new LinkedHashMap<String, String>();

    public void addVersion(String file, String name) {
        this.xmlToName.put(file, name);
    }

    public void tagAll(ClassInfo[] classDocs) {
        for (Map.Entry<String, String> versionSpec : this.xmlToName.entrySet()) {
            String xmlFile = versionSpec.getKey();
            String versionName = versionSpec.getValue();
            ApiInfo specApi = new ApiCheck().parseApi(xmlFile);
            this.applyVersionsFromSpec(versionName, specApi, classDocs);
        }
        if (!this.xmlToName.isEmpty()) {
            this.warnForMissingVersions(classDocs);
        }
    }

    public void writeVersionNames(HDF data) {
        int index = 1;
        for (String version : this.xmlToName.values()) {
            data.setValue("since." + index + ".name", version);
            ++index;
        }
    }

    private void applyVersionsFromSpec(String versionName, ApiInfo specApi, ClassInfo[] classDocs) {
        for (ClassInfo classDoc : classDocs) {
            ClassInfo classSpec;
            com.android.apicheck.PackageInfo packageSpec = (com.android.apicheck.PackageInfo)specApi.getPackages().get(classDoc.containingPackage().name());
            if (packageSpec == null || (classSpec = (ClassInfo)packageSpec.allClasses().get(classDoc.name())) == null) continue;
            this.versionPackage(versionName, classDoc.containingPackage());
            this.versionClass(versionName, classDoc);
            this.versionConstructors(versionName, classSpec, classDoc);
            this.versionFields(versionName, classSpec, classDoc);
            this.versionMethods(versionName, classSpec, classDoc);
        }
    }

    private void versionPackage(String versionName, PackageInfo doc) {
        if (doc.getSince() == null) {
            doc.setSince(versionName);
        }
    }

    private void versionClass(String versionName, ClassInfo doc) {
        if (doc.getSince() == null) {
            doc.setSince(versionName);
        }
    }

    private void versionConstructors(String versionName, ClassInfo spec, ClassInfo doc) {
        for (MethodInfo constructor : doc.constructors()) {
            if (constructor.getSince() != null || !spec.allConstructors().containsKey(constructor.getHashableName())) continue;
            constructor.setSince(versionName);
        }
    }

    private void versionFields(String versionName, ClassInfo spec, ClassInfo doc) {
        for (FieldInfo field : doc.fields()) {
            if (field.getSince() != null || !spec.allFields().containsKey(field.name())) continue;
            field.setSince(versionName);
        }
    }

    private void versionMethods(String versionName, ClassInfo spec, ClassInfo doc) {
        block0: for (MethodInfo method : doc.methods()) {
            if (method.getSince() != null) continue;
            for (ClassInfo superclass : spec.hierarchy()) {
                if (!superclass.allMethods().containsKey(method.getHashableName())) continue;
                method.setSince(versionName);
                continue block0;
            }
        }
    }

    private void warnForMissingVersions(ClassInfo[] classDocs) {
        for (ClassInfo claz : classDocs) {
            if (!this.checkLevelRecursive(claz)) continue;
            if (claz.getSince() == null) {
                Errors.error(Errors.NO_SINCE_DATA, claz.position(), "XML missing class " + claz.qualifiedName());
            }
            for (FieldInfo field : this.missingVersions(claz.fields())) {
                Errors.error(Errors.NO_SINCE_DATA, field.position(), "XML missing field " + claz.qualifiedName() + "#" + field.name());
            }
            for (MethodInfo constructor : this.missingVersions(claz.constructors())) {
                Errors.error(Errors.NO_SINCE_DATA, constructor.position(), "XML missing constructor " + claz.qualifiedName() + "#" + constructor.getHashableName());
            }
            for (MethodInfo method : this.missingVersions(claz.methods())) {
                Errors.error(Errors.NO_SINCE_DATA, method.position(), "XML missing method " + claz.qualifiedName() + "#" + method.getHashableName());
            }
        }
    }

    private <T extends MemberInfo> Iterable<T> missingVersions(T[] all) {
        List result = Collections.emptyList();
        for (T t : all) {
            if (((DocInfo)t).getSince() != null || ((DocInfo)t).isHidden() || !this.checkLevelRecursive(((MemberInfo)t).realContainingClass())) continue;
            if (result.isEmpty()) {
                result = new ArrayList();
            }
            result.add(t);
        }
        return result;
    }

    private boolean checkLevelRecursive(ClassInfo claz) {
        for (ClassInfo c = claz; c != null; c = c.containingClass()) {
            if (c.checkLevel()) continue;
            return false;
        }
        return true;
    }
}

