/*
 * Decompiled with CFR 0.152.
 */
import com.sun.javadoc.PackageDoc;
import java.util.ArrayList;
import java.util.Comparator;
import org.clearsilver.HDF;

public class PackageInfo
extends DocInfo
implements ContainerInfo {
    public static final Comparator<PackageInfo> comparator = new Comparator<PackageInfo>(){

        @Override
        public int compare(PackageInfo a, PackageInfo b) {
            return a.name().compareTo(b.name());
        }
    };
    private String mName;
    private PackageDoc mPackage;
    private ClassInfo[] mInterfaces;
    private ClassInfo[] mOrdinaryClasses;
    private ClassInfo[] mEnums;
    private ClassInfo[] mExceptions;
    private ClassInfo[] mErrors;

    public PackageInfo(PackageDoc pkg, String name, SourcePositionInfo position) {
        super(pkg.getRawCommentText(), position);
        this.mName = name;
        if (pkg == null) {
            throw new RuntimeException("pkg is null");
        }
        this.mPackage = pkg;
    }

    public String htmlPage() {
        String s = this.mName;
        s = s.replace('.', '/');
        s = s + "/package-summary.html";
        s = "reference/" + s;
        return s;
    }

    public String fullDescriptionHtmlPage() {
        String s = this.mName;
        s = s.replace('.', '/');
        s = s + "/package-descr.html";
        s = "reference/" + s;
        return s;
    }

    public ContainerInfo parent() {
        return null;
    }

    public boolean isHidden() {
        return this.comment().isHidden();
    }

    public boolean checkLevel() {
        return !this.isHidden();
    }

    public String name() {
        return this.mName;
    }

    public String qualifiedName() {
        return this.mName;
    }

    public TagInfo[] inlineTags() {
        return this.comment().tags();
    }

    public TagInfo[] firstSentenceTags() {
        return this.comment().briefTags();
    }

    public static ClassInfo[] filterHidden(ClassInfo[] classes) {
        ArrayList<ClassInfo> out = new ArrayList<ClassInfo>();
        for (ClassInfo cl : classes) {
            if (cl.isHidden()) continue;
            out.add(cl);
        }
        return out.toArray(new ClassInfo[0]);
    }

    public void makeLink(HDF data, String base) {
        if (this.checkLevel()) {
            data.setValue(base + ".link", this.htmlPage());
        }
        data.setValue(base + ".name", this.name());
        data.setValue(base + ".since", this.getSince());
    }

    public void makeClassLinkListHDF(HDF data, String base) {
        this.makeLink(data, base);
        ClassInfo.makeLinkListHDF(data, base + ".interfaces", this.interfaces());
        ClassInfo.makeLinkListHDF(data, base + ".classes", this.ordinaryClasses());
        ClassInfo.makeLinkListHDF(data, base + ".enums", this.enums());
        ClassInfo.makeLinkListHDF(data, base + ".exceptions", this.exceptions());
        ClassInfo.makeLinkListHDF(data, base + ".errors", this.errors());
        data.setValue(base + ".since", this.getSince());
    }

    public ClassInfo[] interfaces() {
        if (this.mInterfaces == null) {
            this.mInterfaces = ClassInfo.sortByName(PackageInfo.filterHidden(Converter.convertClasses(this.mPackage.interfaces())));
        }
        return this.mInterfaces;
    }

    public ClassInfo[] ordinaryClasses() {
        if (this.mOrdinaryClasses == null) {
            this.mOrdinaryClasses = ClassInfo.sortByName(PackageInfo.filterHidden(Converter.convertClasses(this.mPackage.ordinaryClasses())));
        }
        return this.mOrdinaryClasses;
    }

    public ClassInfo[] enums() {
        if (this.mEnums == null) {
            this.mEnums = ClassInfo.sortByName(PackageInfo.filterHidden(Converter.convertClasses(this.mPackage.enums())));
        }
        return this.mEnums;
    }

    public ClassInfo[] exceptions() {
        if (this.mExceptions == null) {
            this.mExceptions = ClassInfo.sortByName(PackageInfo.filterHidden(Converter.convertClasses(this.mPackage.exceptions())));
        }
        return this.mExceptions;
    }

    public ClassInfo[] errors() {
        if (this.mErrors == null) {
            this.mErrors = ClassInfo.sortByName(PackageInfo.filterHidden(Converter.convertClasses(this.mPackage.errors())));
        }
        return this.mErrors;
    }

    public int hashCode() {
        return this.mName.hashCode();
    }
}

