/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import org.clearsilver.HDF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavTree {
    public static void writeNavTree(String dir) {
        ArrayList<Node> children = new ArrayList<Node>();
        for (PackageInfo pkg : DroidDoc.choosePackages()) {
            children.add(NavTree.makePackageNode(pkg));
        }
        Node node = new Node("Reference", dir + "packages.html", children, null);
        StringBuilder buf = new StringBuilder();
        node.renderChildren(buf);
        HDF data = DroidDoc.makeHDF();
        data.setValue("reference_tree", buf.toString());
        ClearPage.write(data, "navtree_data.cs", "navtree_data.js");
    }

    private static Node makePackageNode(PackageInfo pkg) {
        ArrayList<Node> children = new ArrayList<Node>();
        children.add(new Node("Description", pkg.fullDescriptionHtmlPage(), null, null));
        NavTree.addClassNodes(children, "Interfaces", pkg.interfaces());
        NavTree.addClassNodes(children, "Classes", pkg.ordinaryClasses());
        NavTree.addClassNodes(children, "Enums", pkg.enums());
        NavTree.addClassNodes(children, "Exceptions", pkg.exceptions());
        NavTree.addClassNodes(children, "Errors", pkg.errors());
        return new Node(pkg.name(), pkg.htmlPage(), children, pkg.getSince());
    }

    private static void addClassNodes(ArrayList<Node> parent, String label, ClassInfo[] classes) {
        ArrayList<Node> children = new ArrayList<Node>();
        for (ClassInfo cl : classes) {
            if (!cl.checkLevel()) continue;
            children.add(new Node(cl.name(), cl.htmlPage(), null, cl.getSince()));
        }
        if (children.size() > 0) {
            parent.add(new Node(label, null, children, null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node {
        private String mLabel;
        private String mLink;
        ArrayList<Node> mChildren;
        private String mSince;

        Node(String label, String link, ArrayList<Node> children, String since) {
            this.mLabel = label;
            this.mLink = link;
            this.mChildren = children;
            this.mSince = since;
        }

        static void renderString(StringBuilder buf, String s) {
            if (s == null) {
                buf.append("null");
            } else {
                buf.append('\"');
                int N = s.length();
                for (int i = 0; i < N; ++i) {
                    char c = s.charAt(i);
                    if (c >= ' ' && c <= '~' && c != '\"' && c != '\\') {
                        buf.append(c);
                        continue;
                    }
                    buf.append("\\u");
                    boolean j = false;
                    while (i < 4) {
                        char x = (char)(c & 0xF);
                        x = x > '\n' ? (char)(x - 10 + 97) : (char)(x + 48);
                        buf.append(x);
                        c = (char)(c >> 4);
                        ++i;
                    }
                }
                buf.append('\"');
            }
        }

        void renderChildren(StringBuilder buf) {
            ArrayList<Node> list = this.mChildren;
            if (list == null || list.size() == 0) {
                buf.append("null");
            } else {
                buf.append("[ ");
                int N = list.size();
                for (int i = 0; i < N; ++i) {
                    list.get(i).render(buf);
                    if (i == N - 1) continue;
                    buf.append(", ");
                }
                buf.append(" ]\n");
            }
        }

        void render(StringBuilder buf) {
            buf.append("[ ");
            Node.renderString(buf, this.mLabel);
            buf.append(", ");
            Node.renderString(buf, this.mLink);
            buf.append(", ");
            this.renderChildren(buf);
            buf.append(", ");
            Node.renderString(buf, this.mSince);
            buf.append(" ]");
        }
    }
}

