/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import org.clearsilver.HDF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo
extends MemberInfo {
    public static final Comparator<MethodInfo> comparator = new Comparator<MethodInfo>(){

        @Override
        public int compare(MethodInfo a, MethodInfo b) {
            return a.name().compareTo(b.name());
        }
    };
    private String mFlatSignature;
    private MethodInfo mOverriddenMethod;
    private TypeInfo mReturnType;
    private boolean mIsAnnotationElement;
    private boolean mIsAbstract;
    private boolean mIsSynchronized;
    private boolean mIsNative;
    private boolean mIsVarargs;
    private boolean mDeprecatedKnown;
    private boolean mIsDeprecated;
    private ParameterInfo[] mParameters;
    private ClassInfo[] mThrownExceptions;
    private String[] mParamStrings;
    ThrowsTagInfo[] mThrowsTags;
    private ParamTagInfo[] mParamTags;
    private TypeInfo[] mTypeParameters;
    private AnnotationValueInfo mDefaultAnnotationElementValue;
    private String mReasonOpened;

    private static void addInterfaces(ClassInfo[] ifaces, ArrayList<ClassInfo> queue) {
        for (ClassInfo i : ifaces) {
            queue.add(i);
        }
        for (ClassInfo i : ifaces) {
            MethodInfo.addInterfaces(i.interfaces(), queue);
        }
    }

    public MethodInfo findOverriddenMethod(String name, String signature) {
        if (this.mReturnType == null) {
            return null;
        }
        if (this.mOverriddenMethod != null) {
            return this.mOverriddenMethod;
        }
        ArrayList<ClassInfo> queue = new ArrayList<ClassInfo>();
        MethodInfo.addInterfaces(this.containingClass().interfaces(), queue);
        for (ClassInfo iface : queue) {
            for (MethodInfo me : iface.methods()) {
                if (!me.name().equals(name) || !me.signature().equals(signature) || me.inlineTags().tags() == null || me.inlineTags().tags().length <= 0) continue;
                return me;
            }
        }
        return null;
    }

    private static void addRealInterfaces(ClassInfo[] ifaces, ArrayList<ClassInfo> queue) {
        for (ClassInfo i : ifaces) {
            queue.add(i);
            if (i.realSuperclass() == null || !i.realSuperclass().isAbstract()) continue;
            queue.add(i.superclass());
        }
        for (ClassInfo i : ifaces) {
            MethodInfo.addInterfaces(i.realInterfaces(), queue);
        }
    }

    public MethodInfo findRealOverriddenMethod(String name, String signature, HashSet notStrippable) {
        if (this.mReturnType == null) {
            return null;
        }
        if (this.mOverriddenMethod != null) {
            return this.mOverriddenMethod;
        }
        ArrayList<ClassInfo> queue = new ArrayList<ClassInfo>();
        if (this.containingClass().realSuperclass() != null && this.containingClass().realSuperclass().isAbstract()) {
            queue.add(this.containingClass());
        }
        MethodInfo.addInterfaces(this.containingClass().realInterfaces(), queue);
        for (ClassInfo iface : queue) {
            for (MethodInfo me : iface.methods()) {
                if (!me.name().equals(name) || !me.signature().equals(signature) || me.inlineTags().tags() == null || me.inlineTags().tags().length <= 0 || !notStrippable.contains(me.containingClass())) continue;
                return me;
            }
        }
        return null;
    }

    public MethodInfo findSuperclassImplementation(HashSet notStrippable) {
        if (this.mReturnType == null) {
            return null;
        }
        if (this.mOverriddenMethod != null && this.signature().equals(this.mOverriddenMethod.signature())) {
            return this.mOverriddenMethod;
        }
        ArrayList<ClassInfo> queue = new ArrayList<ClassInfo>();
        if (this.containingClass().realSuperclass() != null && this.containingClass().realSuperclass().isAbstract()) {
            queue.add(this.containingClass());
        }
        MethodInfo.addInterfaces(this.containingClass().realInterfaces(), queue);
        for (ClassInfo iface : queue) {
            for (MethodInfo me : iface.methods()) {
                if (!me.name().equals(this.name()) || !me.signature().equals(this.signature()) || !notStrippable.contains(me.containingClass())) continue;
                return me;
            }
        }
        return null;
    }

    public ClassInfo findRealOverriddenClass(String name, String signature) {
        if (this.mReturnType == null) {
            return null;
        }
        if (this.mOverriddenMethod != null) {
            return this.mOverriddenMethod.mRealContainingClass;
        }
        ArrayList<ClassInfo> queue = new ArrayList<ClassInfo>();
        if (this.containingClass().realSuperclass() != null && this.containingClass().realSuperclass().isAbstract()) {
            queue.add(this.containingClass());
        }
        MethodInfo.addInterfaces(this.containingClass().realInterfaces(), queue);
        for (ClassInfo iface : queue) {
            for (MethodInfo me : iface.methods()) {
                if (!me.name().equals(name) || !me.signature().equals(signature) || me.inlineTags().tags() == null || me.inlineTags().tags().length <= 0) continue;
                return iface;
            }
        }
        return null;
    }

    public boolean isDeprecated() {
        boolean deprecated = false;
        if (!this.mDeprecatedKnown) {
            boolean commentDeprecated = this.comment().deprecatedTags().length > 0;
            boolean annotationDeprecated = false;
            for (AnnotationInstanceInfo annotation : this.annotations()) {
                if (!annotation.type().qualifiedName().equals("java.lang.Deprecated")) continue;
                annotationDeprecated = true;
                break;
            }
            if (commentDeprecated != annotationDeprecated) {
                Errors.error(Errors.DEPRECATION_MISMATCH, this.position(), "Method " + this.mContainingClass.qualifiedName() + "." + this.name() + ": @Deprecated annotation and @deprecated doc tag do not match");
            }
            this.mIsDeprecated = commentDeprecated | annotationDeprecated;
            this.mDeprecatedKnown = true;
        }
        return this.mIsDeprecated;
    }

    public TypeInfo[] getTypeParameters() {
        return this.mTypeParameters;
    }

    public MethodInfo cloneForClass(ClassInfo newContainingClass) {
        MethodInfo result = new MethodInfo(this.getRawCommentText(), this.mTypeParameters, this.name(), this.signature(), newContainingClass, this.realContainingClass(), this.isPublic(), this.isProtected(), this.isPackagePrivate(), this.isPrivate(), this.isFinal(), this.isStatic(), this.isSynthetic(), this.mIsAbstract, this.mIsSynchronized, this.mIsNative, this.mIsAnnotationElement, this.kind(), this.mFlatSignature, this.mOverriddenMethod, this.mReturnType, this.mParameters, this.mThrownExceptions, this.position(), this.annotations());
        result.init(this.mDefaultAnnotationElementValue);
        return result;
    }

    public MethodInfo(String rawCommentText, TypeInfo[] typeParameters, String name, String signature, ClassInfo containingClass, ClassInfo realContainingClass, boolean isPublic, boolean isProtected, boolean isPackagePrivate, boolean isPrivate, boolean isFinal, boolean isStatic, boolean isSynthetic, boolean isAbstract, boolean isSynchronized, boolean isNative, boolean isAnnotationElement, String kind, String flatSignature, MethodInfo overriddenMethod, TypeInfo returnType, ParameterInfo[] parameters, ClassInfo[] thrownExceptions, SourcePositionInfo position, AnnotationInstanceInfo[] annotations) {
        super(rawCommentText, name, signature, containingClass, realContainingClass, isPublic, isProtected, isPackagePrivate, isPrivate, name.equals("values") && containingClass.isEnum() ? true : isFinal, isStatic, isSynthetic, kind, position, annotations);
        if (containingClass.isInterface()) {
            isAbstract = true;
        }
        this.mReasonOpened = "0:0";
        this.mIsAnnotationElement = isAnnotationElement;
        this.mTypeParameters = typeParameters;
        this.mIsAbstract = isAbstract;
        this.mIsSynchronized = isSynchronized;
        this.mIsNative = isNative;
        this.mFlatSignature = flatSignature;
        this.mOverriddenMethod = overriddenMethod;
        this.mReturnType = returnType;
        this.mParameters = parameters;
        this.mThrownExceptions = thrownExceptions;
    }

    public void init(AnnotationValueInfo defaultAnnotationElementValue) {
        this.mDefaultAnnotationElementValue = defaultAnnotationElementValue;
    }

    public boolean isAbstract() {
        return this.mIsAbstract;
    }

    public boolean isSynchronized() {
        return this.mIsSynchronized;
    }

    public boolean isNative() {
        return this.mIsNative;
    }

    public String flatSignature() {
        return this.mFlatSignature;
    }

    public InheritedTags inlineTags() {
        return new InlineTags();
    }

    public InheritedTags firstSentenceTags() {
        return new FirstSentenceTags();
    }

    public InheritedTags returnTags() {
        return new ReturnTags();
    }

    public TypeInfo returnType() {
        return this.mReturnType;
    }

    public String prettySignature() {
        String s = "(";
        int N = this.mParameters.length;
        for (int i = 0; i < N; ++i) {
            ParameterInfo p = this.mParameters[i];
            TypeInfo t = p.type();
            s = t.isPrimitive() ? s + t.simpleTypeName() : s + t.asClassInfo().name();
            if (i == N - 1) continue;
            s = s + ',';
        }
        s = s + ')';
        return s;
    }

    public String getHashableName() {
        StringBuilder result = new StringBuilder();
        result.append(this.name());
        for (int p = 0; p < this.mParameters.length; ++p) {
            result.append(":");
            if (p == this.mParameters.length - 1 && this.isVarArgs()) {
                result.append(this.mParameters[p].type().fullNameNoDimension(this.typeVariables())).append("...");
                continue;
            }
            result.append(this.mParameters[p].type().fullName(this.typeVariables()));
        }
        return result.toString();
    }

    private boolean inList(ClassInfo item, ThrowsTagInfo[] list) {
        int len = list.length;
        String qn = item.qualifiedName();
        for (int i = 0; i < len; ++i) {
            ClassInfo ex = list[i].exception();
            if (ex == null || !ex.qualifiedName().equals(qn)) continue;
            return true;
        }
        return false;
    }

    public ThrowsTagInfo[] throwsTags() {
        if (this.mThrowsTags == null) {
            ThrowsTagInfo[] documented = this.comment().throwsTags();
            ArrayList<ThrowsTagInfo> rv = new ArrayList<ThrowsTagInfo>();
            int len = documented.length;
            for (int i = 0; i < len; ++i) {
                rv.add(documented[i]);
            }
            for (ClassInfo cl : this.mThrownExceptions) {
                if (documented != null && this.inList(cl, documented)) continue;
                rv.add(new ThrowsTagInfo("@throws", "@throws", cl.qualifiedName(), cl, "", this.containingClass(), this.position()));
            }
            this.mThrowsTags = rv.toArray(new ThrowsTagInfo[rv.size()]);
        }
        return this.mThrowsTags;
    }

    private static int indexOfParam(String name, String[] list) {
        int N = list.length;
        for (int i = 0; i < N; ++i) {
            if (!name.equals(list[i])) continue;
            return i;
        }
        return -1;
    }

    public ParamTagInfo[] paramTags() {
        if (this.mParamTags == null) {
            int N = this.mParameters.length;
            String[] names = new String[N];
            String[] comments = new String[N];
            SourcePositionInfo[] positions = new SourcePositionInfo[N];
            for (int i = 0; i < N; ++i) {
                names[i] = this.mParameters[i].name();
                comments[i] = "";
                positions[i] = this.mParameters[i].position();
            }
            for (ParamTagInfo tag : this.comment().paramTags()) {
                int index = MethodInfo.indexOfParam(tag.parameterName(), names);
                if (index >= 0) {
                    comments[index] = tag.parameterComment();
                    positions[index] = tag.position();
                    continue;
                }
                Errors.error(Errors.UNKNOWN_PARAM_TAG_NAME, tag.position(), "@param tag with name that doesn't match the parameter list: '" + tag.parameterName() + "'");
            }
            MethodInfo overridden = this.findOverriddenMethod(this.name(), this.signature());
            if (overridden != null) {
                ParamTagInfo[] maternal = overridden.paramTags();
                for (int i = 0; i < N; ++i) {
                    if (!comments[i].equals("")) continue;
                    comments[i] = maternal[i].parameterComment();
                    positions[i] = maternal[i].position();
                }
            }
            this.mParamTags = new ParamTagInfo[N];
            for (int i = 0; i < N; ++i) {
                this.mParamTags[i] = new ParamTagInfo("@param", "@param", names[i] + " " + comments[i], this.parent(), positions[i]);
                if (!comments[i].equals("")) continue;
                Errors.error(Errors.UNDOCUMENTED_PARAMETER, positions[i], "Undocumented parameter '" + names[i] + "' on method '" + this.name() + "'");
            }
        }
        return this.mParamTags;
    }

    public SeeTagInfo[] seeTags() {
        SeeTagInfo[] result = this.comment().seeTags();
        if (result == null && this.mOverriddenMethod != null) {
            result = this.mOverriddenMethod.seeTags();
        }
        return result;
    }

    public TagInfo[] deprecatedTags() {
        TagInfo[] result = this.comment().deprecatedTags();
        if (result.length == 0 && this.comment().undeprecateTags().length == 0 && this.mOverriddenMethod != null) {
            result = this.mOverriddenMethod.deprecatedTags();
        }
        return result;
    }

    public ParameterInfo[] parameters() {
        return this.mParameters;
    }

    public boolean matchesParams(String[] params, String[] dimensions) {
        if (this.mParamStrings == null) {
            ParameterInfo[] mine = this.mParameters;
            int len = mine.length;
            if (len != params.length) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                TypeInfo t = mine[i].type();
                if (!t.dimension().equals(dimensions[i])) {
                    return false;
                }
                String qn = t.qualifiedTypeName();
                String s = params[i];
                int slen = s.length();
                int qnlen = qn.length();
                if (qn.equals(s) || slen + 1 < qnlen && qn.charAt(qnlen - slen - 1) == '.' && qn.endsWith(s)) continue;
                return false;
            }
        }
        return true;
    }

    public void makeHDF(HDF data, String base) {
        data.setValue(base + ".kind", this.kind());
        data.setValue(base + ".name", this.name());
        data.setValue(base + ".href", this.htmlPage());
        data.setValue(base + ".anchor", this.anchor());
        if (this.mReturnType != null) {
            this.returnType().makeHDF(data, base + ".returnType", false, this.typeVariables());
            data.setValue(base + ".abstract", this.mIsAbstract ? "abstract" : "");
        }
        data.setValue(base + ".synchronized", this.mIsSynchronized ? "synchronized" : "");
        data.setValue(base + ".final", this.isFinal() ? "final" : "");
        data.setValue(base + ".static", this.isStatic() ? "static" : "");
        TagInfo.makeHDF(data, base + ".shortDescr", this.firstSentenceTags());
        TagInfo.makeHDF(data, base + ".descr", this.inlineTags());
        TagInfo.makeHDF(data, base + ".deprecated", this.deprecatedTags());
        TagInfo.makeHDF(data, base + ".seeAlso", this.seeTags());
        data.setValue(base + ".since", this.getSince());
        ParamTagInfo.makeHDF(data, base + ".paramTags", this.paramTags());
        AttrTagInfo.makeReferenceHDF(data, base + ".attrRefs", this.comment().attrTags());
        ThrowsTagInfo.makeHDF(data, base + ".throws", this.throwsTags());
        ParameterInfo.makeHDF(data, base + ".params", this.parameters(), this.isVarArgs(), this.typeVariables());
        if (this.isProtected()) {
            data.setValue(base + ".scope", "protected");
        } else if (this.isPublic()) {
            data.setValue(base + ".scope", "public");
        }
        TagInfo.makeHDF(data, base + ".returns", this.returnTags());
        if (this.mTypeParameters != null) {
            TypeInfo.makeHDF(data, base + ".generic.typeArguments", this.mTypeParameters, false);
        }
    }

    public HashSet<String> typeVariables() {
        HashSet<String> result = TypeInfo.typeVariables(this.mTypeParameters);
        for (ClassInfo cl = this.containingClass(); cl != null; cl = cl.containingClass()) {
            TypeInfo[] types = cl.asTypeInfo().typeArguments();
            if (types == null) continue;
            TypeInfo.typeVariables(types, result);
        }
        return result;
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    public ClassInfo[] thrownExceptions() {
        return this.mThrownExceptions;
    }

    public String typeArgumentsName(HashSet<String> typeVars) {
        if (this.mTypeParameters == null || this.mTypeParameters.length == 0) {
            return "";
        }
        return TypeInfo.typeArgumentsName(this.mTypeParameters, typeVars);
    }

    public boolean isAnnotationElement() {
        return this.mIsAnnotationElement;
    }

    public AnnotationValueInfo defaultAnnotationElementValue() {
        return this.mDefaultAnnotationElementValue;
    }

    public void setVarargs(boolean set) {
        this.mIsVarargs = set;
    }

    public boolean isVarArgs() {
        return this.mIsVarargs;
    }

    public String toString() {
        return this.name();
    }

    public void setReason(String reason) {
        this.mReasonOpened = reason;
    }

    public String getReason() {
        return this.mReasonOpened;
    }

    private class ReturnTags
    implements InheritedTags {
        private ReturnTags() {
        }

        public TagInfo[] tags() {
            return MethodInfo.this.comment().returnTags();
        }

        public InheritedTags inherited() {
            MethodInfo m = MethodInfo.this.findOverriddenMethod(MethodInfo.this.name(), MethodInfo.this.signature());
            if (m != null) {
                return m.returnTags();
            }
            return null;
        }
    }

    private class FirstSentenceTags
    implements InheritedTags {
        private FirstSentenceTags() {
        }

        public TagInfo[] tags() {
            return MethodInfo.this.comment().briefTags();
        }

        public InheritedTags inherited() {
            MethodInfo m = MethodInfo.this.findOverriddenMethod(MethodInfo.this.name(), MethodInfo.this.signature());
            if (m != null) {
                return m.firstSentenceTags();
            }
            return null;
        }
    }

    private class InlineTags
    implements InheritedTags {
        private InlineTags() {
        }

        public TagInfo[] tags() {
            return MethodInfo.this.comment().tags();
        }

        public InheritedTags inherited() {
            MethodInfo m = MethodInfo.this.findOverriddenMethod(MethodInfo.this.name(), MethodInfo.this.signature());
            if (m != null) {
                return m.inlineTags();
            }
            return null;
        }
    }
}

