/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;
import java.util.TreeSet;
import org.clearsilver.HDF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hierarchy {
    public static void makeHierarchy(HDF hdf, ClassInfo[] classes) {
        HashMap<String, TreeSet<String>> nodes = new HashMap<String, TreeSet<String>>();
        for (ClassInfo cl : classes) {
            ClassInfo superclass;
            String sname;
            String name = cl.qualifiedName();
            TreeSet<String> me = nodes.get(name);
            if (me == null) {
                me = new TreeSet();
                nodes.put(name, me);
            }
            String string = sname = (superclass = cl.superclass()) != null ? superclass.qualifiedName() : null;
            if (sname == null) continue;
            TreeSet<String> s = nodes.get(sname);
            if (s == null) {
                s = new TreeSet();
                nodes.put(sname, s);
            }
            s.add(name);
        }
        int depth = Hierarchy.depth(nodes, "java.lang.Object");
        hdf.setValue("classes.0", "");
        hdf.setValue("colspan", "" + depth);
        Hierarchy.recurse(nodes, "java.lang.Object", hdf.getObj("classes.0"), depth, depth);
    }

    private static int depth(HashMap<String, TreeSet<String>> nodes, String name) {
        int d = 0;
        TreeSet<String> derived = nodes.get(name);
        if (derived != null && derived.size() > 0) {
            for (String s : derived) {
                int n = Hierarchy.depth(nodes, s);
                if (n <= d) continue;
                d = n;
            }
        }
        return d + 1;
    }

    private static boolean exists(ClassInfo cl) {
        return cl != null && !cl.isHidden() && cl.isIncluded();
    }

    private static void recurse(HashMap<String, TreeSet<String>> nodes, String name, HDF hdf, int totalDepth, int remainingDepth) {
        hdf.setValue("indent", "" + (totalDepth - remainingDepth - 1));
        hdf.setValue("colspan", "" + remainingDepth);
        ClassInfo cl = Converter.obtainClass(name);
        hdf.setValue("class.label", cl.name());
        hdf.setValue("class.qualified", cl.qualifiedName());
        if (cl.checkLevel()) {
            hdf.setValue("class.link", cl.htmlPage());
        }
        if (Hierarchy.exists(cl)) {
            hdf.setValue("exists", "1");
        }
        int i = 0;
        for (ClassInfo iface : cl.interfaces()) {
            hdf.setValue("interfaces." + i + ".class.label", iface.name());
            hdf.setValue("interfaces." + i + ".class.qualified", iface.qualifiedName());
            if (iface.checkLevel()) {
                hdf.setValue("interfaces." + i + ".class.link", iface.htmlPage());
            }
            if (Hierarchy.exists(cl)) {
                hdf.setValue("interfaces." + i + ".exists", "1");
            }
            ++i;
        }
        TreeSet<String> derived = nodes.get(name);
        if (derived != null && derived.size() > 0) {
            hdf.setValue("derived", "");
            HDF children = hdf.getObj("derived");
            i = 0;
            --remainingDepth;
            for (String s : derived) {
                String index = "" + i;
                children.setValue(index, "");
                Hierarchy.recurse(nodes, s, children.getObj(index), totalDepth, remainingDepth);
                ++i;
            }
        }
        nodes.remove(name);
    }
}

