/*
 * Decompiled with CFR 0.152.
 */
import java.util.Comparator;
import org.clearsilver.HDF;

public class FieldInfo
extends MemberInfo {
    public static final Comparator<FieldInfo> comparator = new Comparator<FieldInfo>(){

        @Override
        public int compare(FieldInfo a, FieldInfo b) {
            return a.name().compareTo(b.name());
        }
    };
    boolean mIsTransient;
    boolean mIsVolatile;
    boolean mDeprecatedKnown;
    boolean mIsDeprecated;
    TypeInfo mType;
    Object mConstantValue;

    public FieldInfo(String name, ClassInfo containingClass, ClassInfo realContainingClass, boolean isPublic, boolean isProtected, boolean isPackagePrivate, boolean isPrivate, boolean isFinal, boolean isStatic, boolean isTransient, boolean isVolatile, boolean isSynthetic, TypeInfo type, String rawCommentText, Object constantValue, SourcePositionInfo position, AnnotationInstanceInfo[] annotations) {
        super(rawCommentText, name, null, containingClass, realContainingClass, isPublic, isProtected, isPackagePrivate, isPrivate, isFinal, isStatic, isSynthetic, FieldInfo.chooseKind(isFinal, isStatic), position, annotations);
        this.mIsTransient = isTransient;
        this.mIsVolatile = isVolatile;
        this.mType = type;
        this.mConstantValue = constantValue;
    }

    public FieldInfo cloneForClass(ClassInfo newContainingClass) {
        return new FieldInfo(this.name(), newContainingClass, this.realContainingClass(), this.isPublic(), this.isProtected(), this.isPackagePrivate(), this.isPrivate(), this.isFinal(), this.isStatic(), this.isTransient(), this.isVolatile(), this.isSynthetic(), this.mType, this.getRawCommentText(), this.mConstantValue, this.position(), this.annotations());
    }

    static String chooseKind(boolean isFinal, boolean isStatic) {
        if (isStatic && isFinal) {
            return "constant";
        }
        return "field";
    }

    public TypeInfo type() {
        return this.mType;
    }

    public boolean isConstant() {
        return this.isStatic() && this.isFinal();
    }

    public TagInfo[] firstSentenceTags() {
        return this.comment().briefTags();
    }

    public TagInfo[] inlineTags() {
        return this.comment().tags();
    }

    public Object constantValue() {
        return this.mConstantValue;
    }

    public String constantLiteralValue() {
        return FieldInfo.constantLiteralValue(this.mConstantValue);
    }

    public boolean isDeprecated() {
        boolean deprecated = false;
        if (!this.mDeprecatedKnown) {
            boolean commentDeprecated = this.comment().deprecatedTags().length > 0;
            boolean annotationDeprecated = false;
            for (AnnotationInstanceInfo annotation : this.annotations()) {
                if (!annotation.type().qualifiedName().equals("java.lang.Deprecated")) continue;
                annotationDeprecated = true;
                break;
            }
            if (commentDeprecated != annotationDeprecated) {
                Errors.error(Errors.DEPRECATION_MISMATCH, this.position(), "Field " + this.mContainingClass.qualifiedName() + "." + this.name() + ": @Deprecated annotation and @deprecated comment do not match");
            }
            this.mIsDeprecated = commentDeprecated | annotationDeprecated;
            this.mDeprecatedKnown = true;
        }
        return this.mIsDeprecated;
    }

    public static String constantLiteralValue(Object val) {
        String str = null;
        if (val != null) {
            Float fl;
            Double dbl;
            str = val instanceof Boolean || val instanceof Byte || val instanceof Short || val instanceof Integer ? val.toString() : (val instanceof Double ? ((dbl = (Double)val).toString().equals("Infinity") ? "(1.0 / 0.0)" : (dbl.toString().equals("-Infinity") ? "(-1.0 / 0.0)" : (dbl.isNaN() ? "(0.0 / 0.0)" : dbl.toString()))) : (val instanceof Long ? val.toString() + "L" : (val instanceof Float ? ((fl = (Float)val).toString().equals("Infinity") ? "(1.0f / 0.0f)" : (fl.toString().equals("-Infinity") ? "(-1.0f / 0.0f)" : (fl.isNaN() ? "(0.0f / 0.0f)" : val.toString() + "f"))) : (val instanceof Character ? String.format("'\\u%04x'", val) : (val instanceof String ? "\"" + FieldInfo.javaEscapeString((String)val) + "\"" : "<<<<" + val.toString() + ">>>>")))));
        }
        if (str == null) {
            str = "null";
        }
        return str;
    }

    public static String javaEscapeString(String str) {
        String result = "";
        int N = str.length();
        for (int i = 0; i < N; ++i) {
            char c = str.charAt(i);
            result = c == '\\' ? result + "\\\\" : (c == '\t' ? result + "\\t" : (c == '\b' ? result + "\\b" : (c == '\r' ? result + "\\r" : (c == '\n' ? result + "\\n" : (c == '\f' ? result + "\\f" : (c == '\'' ? result + "\\'" : (c == '\"' ? result + "\\\"" : (c >= ' ' && c <= '~' ? result + c : result + String.format("\\u%04x", new Integer(c))))))))));
        }
        return result;
    }

    public void makeHDF(HDF data, String base) {
        data.setValue(base + ".kind", this.kind());
        this.type().makeHDF(data, base + ".type");
        data.setValue(base + ".name", this.name());
        data.setValue(base + ".href", this.htmlPage());
        data.setValue(base + ".anchor", this.anchor());
        TagInfo.makeHDF(data, base + ".shortDescr", this.firstSentenceTags());
        TagInfo.makeHDF(data, base + ".descr", this.inlineTags());
        TagInfo.makeHDF(data, base + ".deprecated", this.comment().deprecatedTags());
        TagInfo.makeHDF(data, base + ".seeAlso", this.comment().seeTags());
        data.setValue(base + ".since", this.getSince());
        data.setValue(base + ".final", this.isFinal() ? "final" : "");
        data.setValue(base + ".static", this.isStatic() ? "static" : "");
        if (this.isPublic()) {
            data.setValue(base + ".scope", "public");
        } else if (this.isProtected()) {
            data.setValue(base + ".scope", "protected");
        } else if (this.isPackagePrivate()) {
            data.setValue(base + ".scope", "");
        } else if (this.isPrivate()) {
            data.setValue(base + ".scope", "private");
        }
        Object val = this.mConstantValue;
        if (val != null) {
            String dec = null;
            String hex = null;
            String str = null;
            if (val instanceof Boolean) {
                str = ((Boolean)val).toString();
            } else if (val instanceof Byte) {
                dec = String.format("%d", val);
                hex = String.format("0x%02x", val);
            } else if (val instanceof Character) {
                dec = String.format("'%c'", val);
                hex = String.format("0x%04x", val);
            } else if (val instanceof Double) {
                str = ((Double)val).toString();
            } else if (val instanceof Float) {
                str = ((Float)val).toString();
            } else if (val instanceof Integer) {
                dec = String.format("%d", val);
                hex = String.format("0x%08x", val);
            } else if (val instanceof Long) {
                dec = String.format("%d", val);
                hex = String.format("0x%016x", val);
            } else if (val instanceof Short) {
                dec = String.format("%d", val);
                hex = String.format("0x%04x", val);
            } else {
                str = val instanceof String ? "\"" + (String)val + "\"" : "";
            }
            if (dec != null && hex != null) {
                data.setValue(base + ".constantValue.dec", DroidDoc.escape(dec));
                data.setValue(base + ".constantValue.hex", DroidDoc.escape(hex));
            } else {
                data.setValue(base + ".constantValue.str", DroidDoc.escape(str));
                data.setValue(base + ".constantValue.isString", "1");
            }
        }
    }

    public boolean isExecutable() {
        return false;
    }

    public boolean isTransient() {
        return this.mIsTransient;
    }

    public boolean isVolatile() {
        return this.mIsVolatile;
    }
}

