/*
 * Decompiled with CFR 0.152.
 */
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.clearsilver.HDF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroidDoc {
    private static final String SDK_CONSTANT_ANNOTATION = "android.annotation.SdkConstant";
    private static final String SDK_CONSTANT_TYPE_ACTIVITY_ACTION = "android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION";
    private static final String SDK_CONSTANT_TYPE_BROADCAST_ACTION = "android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION";
    private static final String SDK_CONSTANT_TYPE_SERVICE_ACTION = "android.annotation.SdkConstant.SdkConstantType.SERVICE_INTENT_ACTION";
    private static final String SDK_CONSTANT_TYPE_CATEGORY = "android.annotation.SdkConstant.SdkConstantType.INTENT_CATEGORY";
    private static final String SDK_CONSTANT_TYPE_FEATURE = "android.annotation.SdkConstant.SdkConstantType.FEATURE";
    private static final String SDK_WIDGET_ANNOTATION = "android.annotation.Widget";
    private static final String SDK_LAYOUT_ANNOTATION = "android.annotation.Layout";
    private static final int TYPE_NONE = 0;
    private static final int TYPE_WIDGET = 1;
    private static final int TYPE_LAYOUT = 2;
    private static final int TYPE_LAYOUT_PARAM = 3;
    public static final int SHOW_PUBLIC = 1;
    public static final int SHOW_PROTECTED = 3;
    public static final int SHOW_PACKAGE = 7;
    public static final int SHOW_PRIVATE = 15;
    public static final int SHOW_HIDDEN = 31;
    public static int showLevel = 3;
    public static final String javadocDir = "reference/";
    public static String htmlExtension;
    public static RootDoc root;
    public static ArrayList<String[]> mHDFData;
    public static Map<Character, String> escapeChars;
    public static String title;
    public static SinceTagger sinceTagger;
    public static HashSet<String> knownTags;
    private static boolean parseComments;
    private static boolean generateDocs;
    private static PackageInfo[] sVisiblePackages;

    public static boolean parseComments() {
        return generateDocs || parseComments;
    }

    public static boolean checkLevel(int level) {
        return (showLevel & level) == level;
    }

    public static boolean checkLevel(boolean pub, boolean prot, boolean pkgp, boolean priv, boolean hidden) {
        boolean level = false;
        if (hidden && !DroidDoc.checkLevel(31)) {
            return false;
        }
        if (pub && DroidDoc.checkLevel(1)) {
            return true;
        }
        if (prot && DroidDoc.checkLevel(3)) {
            return true;
        }
        if (pkgp && DroidDoc.checkLevel(7)) {
            return true;
        }
        return priv && DroidDoc.checkLevel(15);
    }

    public static boolean start(RootDoc r) {
        String[][] options;
        String keepListFile = null;
        String proofreadFile = null;
        String todoFile = null;
        String sdkValuePath = null;
        ArrayList<SampleCode> sampleCodes = new ArrayList<SampleCode>();
        String stubsDir = null;
        boolean apiXML = false;
        boolean offlineMode = false;
        String apiFile = null;
        String debugStubsFile = "";
        HashSet<String> stubPackages = null;
        ArrayList<String> knownTagsFiles = new ArrayList<String>();
        root = r;
        for (String[] a : options = r.options()) {
            if (a[0].equals("-d")) {
                ClearPage.outputDir = a[1];
                continue;
            }
            if (a[0].equals("-templatedir")) {
                ClearPage.addTemplateDir(a[1]);
                continue;
            }
            if (a[0].equals("-hdf")) {
                mHDFData.add(new String[]{a[1], a[2]});
                continue;
            }
            if (a[0].equals("-knowntags")) {
                knownTagsFiles.add(a[1]);
                continue;
            }
            if (a[0].equals("-toroot")) {
                ClearPage.toroot = a[1];
                continue;
            }
            if (a[0].equals("-samplecode")) {
                sampleCodes.add(new SampleCode(a[1], a[2], a[3]));
                continue;
            }
            if (a[0].equals("-htmldir")) {
                ClearPage.htmlDirs.add(a[1]);
                continue;
            }
            if (a[0].equals("-title")) {
                title = a[1];
                continue;
            }
            if (a[0].equals("-werror")) {
                Errors.setWarningsAreErrors(true);
                continue;
            }
            if (a[0].equals("-error") || a[0].equals("-warning") || a[0].equals("-hide")) {
                try {
                    int level = -1;
                    if (a[0].equals("-error")) {
                        level = Errors.ERROR;
                    } else if (a[0].equals("-warning")) {
                        level = Errors.WARNING;
                    } else if (a[0].equals("-hide")) {
                        level = Errors.HIDDEN;
                    }
                    Errors.setErrorLevel(Integer.parseInt(a[1]), level);
                    continue;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (a[0].equals("-keeplist")) {
                keepListFile = a[1];
                continue;
            }
            if (a[0].equals("-proofread")) {
                proofreadFile = a[1];
                continue;
            }
            if (a[0].equals("-todo")) {
                todoFile = a[1];
                continue;
            }
            if (a[0].equals("-public")) {
                showLevel = 1;
                continue;
            }
            if (a[0].equals("-protected")) {
                showLevel = 3;
                continue;
            }
            if (a[0].equals("-package")) {
                showLevel = 7;
                continue;
            }
            if (a[0].equals("-private")) {
                showLevel = 15;
                continue;
            }
            if (a[0].equals("-hidden")) {
                showLevel = 31;
                continue;
            }
            if (a[0].equals("-stubs")) {
                stubsDir = a[1];
                continue;
            }
            if (a[0].equals("-stubpackages")) {
                stubPackages = new HashSet<String>();
                for (String pkg : a[1].split(":")) {
                    stubPackages.add(pkg);
                }
                continue;
            }
            if (a[0].equals("-sdkvalues")) {
                sdkValuePath = a[1];
                continue;
            }
            if (a[0].equals("-apixml")) {
                apiXML = true;
                apiFile = a[1];
                continue;
            }
            if (a[0].equals("-nodocs")) {
                generateDocs = false;
                continue;
            }
            if (a[0].equals("-parsecomments")) {
                parseComments = true;
                continue;
            }
            if (a[0].equals("-since")) {
                sinceTagger.addVersion(a[1], a[2]);
                continue;
            }
            if (!a[0].equals("-offlinemode")) continue;
            offlineMode = true;
        }
        if (!DroidDoc.readKnownTagsFiles(knownTags, knownTagsFiles)) {
            return false;
        }
        if (!DroidDoc.readTemplateSettings()) {
            return false;
        }
        Converter.makeInfo(r);
        if (generateDocs) {
            long startTime = System.nanoTime();
            sinceTagger.tagAll(Converter.rootClasses());
            if (proofreadFile != null) {
                Proofread.initProofread(proofreadFile);
            }
            if (todoFile != null) {
                TodoFile.writeTodoFile(todoFile);
            }
            if (!ClearPage.htmlDirs.isEmpty()) {
                DroidDoc.writeHTMLPages();
            }
            NavTree.writeNavTree(javadocDir);
            DroidDoc.writePackages(javadocDir + (!ClearPage.htmlDirs.isEmpty() ? "packages" + htmlExtension : "index" + htmlExtension));
            DroidDoc.writeClassLists();
            DroidDoc.writeClasses();
            DroidDoc.writeHierarchy();
            DroidDoc.writeLists();
            if (keepListFile != null) {
                DroidDoc.writeKeepList(keepListFile);
            }
            for (SampleCode sc : sampleCodes) {
                sc.write(offlineMode);
            }
            DroidDoc.writeIndex();
            Proofread.finishProofread(proofreadFile);
            if (sdkValuePath != null) {
                DroidDoc.writeSdkValues(sdkValuePath);
            }
            long time = System.nanoTime() - startTime;
            System.out.println("DroidDoc took " + time / 1000000000L + " sec. to write docs to " + ClearPage.outputDir);
        }
        if (stubsDir != null) {
            Stubs.writeStubs(stubsDir, apiXML, apiFile, stubPackages);
        }
        Errors.printErrors();
        return !Errors.hadError;
    }

    private static void writeIndex() {
        HDF data = DroidDoc.makeHDF();
        ClearPage.write(data, "index.cs", "reference/index" + htmlExtension);
    }

    private static boolean readTemplateSettings() {
        HDF data = DroidDoc.makeHDF();
        htmlExtension = data.getValue("template.extension", ".html");
        int i = 0;
        while (true) {
            String k = data.getValue("template.escape." + i + ".key", "");
            String v = data.getValue("template.escape." + i + ".value", "");
            if ("".equals(k)) break;
            if (k.length() != 1) {
                System.err.println("template.escape." + i + ".key must have a length of 1: " + k);
                return false;
            }
            escapeChars.put(Character.valueOf(k.charAt(0)), v);
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean readKnownTagsFiles(HashSet<String> knownTags, ArrayList<String> knownTagsFiles) {
        for (String fn : knownTagsFiles) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(fn));
                int lineno = 0;
                boolean fail = false;
                while (true) {
                    ++lineno;
                    String line = in.readLine();
                    if (line == null) break;
                    if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                    String[] words = line.split("\\s+", 2);
                    if (words.length == 2 && words[1].charAt(0) != '#') {
                        System.err.println(fn + ":" + lineno + ": Only one tag allowed per line: " + line);
                        fail = true;
                        continue;
                    }
                    knownTags.add(words[0]);
                }
                if (!fail) continue;
                boolean line = false;
                return line;
            }
            catch (IOException ex) {
                System.err.println("Error reading file: " + fn + " (" + ex.getMessage() + ")");
                boolean bl = false;
                return bl;
            }
            finally {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return true;
    }

    public static String escape(String s) {
        if (escapeChars.size() == 0) {
            return s;
        }
        StringBuffer b = null;
        int begin = 0;
        int N = s.length();
        for (int i = 0; i < N; ++i) {
            char c = s.charAt(i);
            String mapped = escapeChars.get(Character.valueOf(c));
            if (mapped == null) continue;
            if (b == null) {
                b = new StringBuffer(s.length() + mapped.length());
            }
            if (begin != i) {
                b.append(s.substring(begin, i));
            }
            b.append(mapped);
            begin = i + 1;
        }
        if (b != null) {
            if (begin != N) {
                b.append(s.substring(begin, N));
            }
            return b.toString();
        }
        return s;
    }

    public static void setPageTitle(HDF data, String title) {
        String s = title;
        if (DroidDoc.title.length() > 0) {
            s = s + " - " + DroidDoc.title;
        }
        data.setValue("page.title", s);
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static int optionLength(String option) {
        if (option.equals("-d")) {
            return 2;
        }
        if (option.equals("-templatedir")) {
            return 2;
        }
        if (option.equals("-hdf")) {
            return 3;
        }
        if (option.equals("-knowntags")) {
            return 2;
        }
        if (option.equals("-toroot")) {
            return 2;
        }
        if (option.equals("-samplecode")) {
            return 4;
        }
        if (option.equals("-htmldir")) {
            return 2;
        }
        if (option.equals("-title")) {
            return 2;
        }
        if (option.equals("-werror")) {
            return 1;
        }
        if (option.equals("-hide")) {
            return 2;
        }
        if (option.equals("-warning")) {
            return 2;
        }
        if (option.equals("-error")) {
            return 2;
        }
        if (option.equals("-keeplist")) {
            return 2;
        }
        if (option.equals("-proofread")) {
            return 2;
        }
        if (option.equals("-todo")) {
            return 2;
        }
        if (option.equals("-public")) {
            return 1;
        }
        if (option.equals("-protected")) {
            return 1;
        }
        if (option.equals("-package")) {
            return 1;
        }
        if (option.equals("-private")) {
            return 1;
        }
        if (option.equals("-hidden")) {
            return 1;
        }
        if (option.equals("-stubs")) {
            return 2;
        }
        if (option.equals("-stubpackages")) {
            return 2;
        }
        if (option.equals("-sdkvalues")) {
            return 2;
        }
        if (option.equals("-apixml")) {
            return 2;
        }
        if (option.equals("-nodocs")) {
            return 1;
        }
        if (option.equals("-parsecomments")) {
            return 1;
        }
        if (option.equals("-since")) {
            return 3;
        }
        if (option.equals("-offlinemode")) {
            return 1;
        }
        return 0;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter r) {
        for (String[] a : options) {
            if (!a[0].equals("-error") && !a[0].equals("-warning") && !a[0].equals("-hide")) continue;
            try {
                Integer.parseInt(a[1]);
            }
            catch (NumberFormatException e) {
                r.printError("bad -" + a[0] + " value must be a number: " + a[1]);
                return false;
            }
        }
        return true;
    }

    public static HDF makeHDF() {
        HDF data = new HDF();
        for (String[] stringArray : mHDFData) {
            data.setValue(stringArray[0], stringArray[1]);
        }
        try {
            for (String string : ClearPage.hdfFiles) {
                data.readFile(string);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return data;
    }

    public static HDF makePackageHDF() {
        HDF data = DroidDoc.makeHDF();
        ClassInfo[] classes = Converter.rootClasses();
        TreeMap<String, PackageInfo> sorted = new TreeMap<String, PackageInfo>();
        for (ClassInfo cl : classes) {
            PackageInfo pkg = cl.containingPackage();
            String name = pkg == null ? "" : pkg.name();
            sorted.put(name, pkg);
        }
        int i = 0;
        for (String s : sorted.keySet()) {
            PackageInfo pkg = (PackageInfo)sorted.get(s);
            if (pkg.isHidden()) continue;
            Boolean allHidden = true;
            ClassInfo[] classesToCheck = null;
            for (int pass = 0; pass < 5; ++pass) {
                switch (pass) {
                    case 0: {
                        classesToCheck = pkg.ordinaryClasses();
                        break;
                    }
                    case 1: {
                        classesToCheck = pkg.enums();
                        break;
                    }
                    case 2: {
                        classesToCheck = pkg.errors();
                        break;
                    }
                    case 3: {
                        classesToCheck = pkg.exceptions();
                        break;
                    }
                    case 4: {
                        classesToCheck = pkg.interfaces();
                        break;
                    }
                    default: {
                        System.err.println("Error reading package: " + pkg.name());
                    }
                }
                for (ClassInfo cl : classesToCheck) {
                    if (cl.isHidden()) continue;
                    allHidden = false;
                    break;
                }
                if (!allHidden.booleanValue()) break;
            }
            if (allHidden.booleanValue()) continue;
            data.setValue("reference", "true");
            data.setValue("docs.packages." + i + ".name", s);
            data.setValue("docs.packages." + i + ".link", pkg.htmlPage());
            data.setValue("docs.packages." + i + ".since", pkg.getSince());
            TagInfo.makeHDF(data, "docs.packages." + i + ".shortDescr", pkg.firstSentenceTags());
            ++i;
        }
        sinceTagger.writeVersionNames(data);
        return data;
    }

    public static void writeDirectory(File dir, String relative) {
        for (File f : dir.listFiles()) {
            if (f.isFile()) {
                String templ = relative + f.getName();
                int len = templ.length();
                if (len > 3 && ".cs".equals(templ.substring(len - 3))) {
                    HDF data = DroidDoc.makeHDF();
                    String filename = templ.substring(0, len - 3) + htmlExtension;
                    ClearPage.write(data, templ, filename);
                    continue;
                }
                if (len > 3 && ".jd".equals(templ.substring(len - 3))) {
                    String filename = templ.substring(0, len - 3) + htmlExtension;
                    DocFile.writePage(f.getAbsolutePath(), relative, filename);
                    continue;
                }
                ClearPage.copyFile(f, templ);
                continue;
            }
            if (!f.isDirectory()) continue;
            DroidDoc.writeDirectory(f, relative + f.getName() + "/");
        }
    }

    public static void writeHTMLPages() {
        for (String htmlDir : ClearPage.htmlDirs) {
            File f = new File(htmlDir);
            if (!f.isDirectory()) {
                System.err.println("htmlDir not a directory: " + htmlDir);
                continue;
            }
            DroidDoc.writeDirectory(f, "");
        }
    }

    public static void writeLists() {
        PackageInfo pkg;
        HDF data = DroidDoc.makeHDF();
        ClassInfo[] classes = Converter.rootClasses();
        TreeMap<String, DocInfo> sorted = new TreeMap<String, DocInfo>();
        for (ClassInfo cl : classes) {
            if (cl.isHidden()) continue;
            sorted.put(cl.qualifiedName(), cl);
            pkg = cl.containingPackage();
            String name = pkg == null ? "" : pkg.name();
            sorted.put(name, pkg);
        }
        int i = 0;
        for (String s : sorted.keySet()) {
            data.setValue("docs.pages." + i + ".id", "" + i);
            data.setValue("docs.pages." + i + ".label", s);
            Object o = sorted.get(s);
            if (o instanceof PackageInfo) {
                pkg = (PackageInfo)o;
                data.setValue("docs.pages." + i + ".link", pkg.htmlPage());
                data.setValue("docs.pages." + i + ".type", "package");
            } else if (o instanceof ClassInfo) {
                ClassInfo cl = (ClassInfo)o;
                data.setValue("docs.pages." + i + ".link", cl.htmlPage());
                data.setValue("docs.pages." + i + ".type", "class");
            }
            ++i;
        }
        ClearPage.write(data, "lists.cs", "reference/lists.js");
    }

    public static void cantStripThis(ClassInfo cl, HashSet<ClassInfo> notStrippable) {
        if (!notStrippable.add(cl)) {
            return;
        }
        ClassInfo supr = cl.superclass();
        if (supr != null) {
            DroidDoc.cantStripThis(supr, notStrippable);
        }
        for (ClassInfo iface : cl.interfaces()) {
            DroidDoc.cantStripThis(iface, notStrippable);
        }
    }

    private static String getPrintableName(ClassInfo cl) {
        ClassInfo containingClass = cl.containingClass();
        if (containingClass != null) {
            String baseName = cl.name();
            baseName = baseName.substring(baseName.lastIndexOf(46) + 1);
            return DroidDoc.getPrintableName(containingClass) + '$' + baseName;
        }
        return cl.qualifiedName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeKeepList(String filename) {
        HashSet<ClassInfo> notStrippable = new HashSet<ClassInfo>();
        Object[] all = Converter.allClasses();
        Arrays.sort(all);
        for (Object cl : all) {
            if (!((ClassInfo)cl).isPublic() || ((ClassInfo)cl).isHidden()) continue;
            DroidDoc.cantStripThis((ClassInfo)cl, notStrippable);
        }
        PrintStream stream = null;
        try {
            stream = new PrintStream(filename);
            for (ClassInfo cl : notStrippable) {
                stream.println(DroidDoc.getPrintableName(cl));
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("error writing file: " + filename);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static PackageInfo[] choosePackages() {
        if (sVisiblePackages != null) {
            return sVisiblePackages;
        }
        ClassInfo[] classes = Converter.rootClasses();
        TreeMap<String, PackageInfo> sorted = new TreeMap<String, PackageInfo>();
        for (ClassInfo cl : classes) {
            PackageInfo pkg = cl.containingPackage();
            String name = pkg == null ? "" : pkg.name();
            sorted.put(name, pkg);
        }
        ArrayList<PackageInfo> result = new ArrayList<PackageInfo>();
        for (String s : sorted.keySet()) {
            PackageInfo pkg = (PackageInfo)sorted.get(s);
            if (pkg.isHidden()) continue;
            Boolean allHidden = true;
            ClassInfo[] classesToCheck = null;
            for (int pass = 0; pass < 5; ++pass) {
                switch (pass) {
                    case 0: {
                        classesToCheck = pkg.ordinaryClasses();
                        break;
                    }
                    case 1: {
                        classesToCheck = pkg.enums();
                        break;
                    }
                    case 2: {
                        classesToCheck = pkg.errors();
                        break;
                    }
                    case 3: {
                        classesToCheck = pkg.exceptions();
                        break;
                    }
                    case 4: {
                        classesToCheck = pkg.interfaces();
                        break;
                    }
                    default: {
                        System.err.println("Error reading package: " + pkg.name());
                    }
                }
                for (ClassInfo cl : classesToCheck) {
                    if (cl.isHidden()) continue;
                    allHidden = false;
                    break;
                }
                if (!allHidden.booleanValue()) break;
            }
            if (allHidden.booleanValue()) continue;
            result.add(pkg);
        }
        sVisiblePackages = result.toArray(new PackageInfo[result.size()]);
        return sVisiblePackages;
    }

    public static void writePackages(String filename) {
        HDF data = DroidDoc.makePackageHDF();
        int i = 0;
        for (PackageInfo pkg : DroidDoc.choosePackages()) {
            DroidDoc.writePackage(pkg);
            data.setValue("docs.packages." + i + ".name", pkg.name());
            data.setValue("docs.packages." + i + ".link", pkg.htmlPage());
            TagInfo.makeHDF(data, "docs.packages." + i + ".shortDescr", pkg.firstSentenceTags());
            ++i;
        }
        DroidDoc.setPageTitle(data, "Package Index");
        TagInfo.makeHDF(data, "root.descr", Converter.convertTags(root.inlineTags(), null));
        ClearPage.write(data, "packages.cs", filename);
        ClearPage.write(data, "package-list.cs", "reference/package-list");
        Proofread.writePackages(filename, Converter.convertTags(root.inlineTags(), null));
    }

    public static void writePackage(PackageInfo pkg) {
        HDF data = DroidDoc.makePackageHDF();
        String name = pkg.name();
        data.setValue("package.name", name);
        data.setValue("package.since", pkg.getSince());
        data.setValue("package.descr", "...description...");
        DroidDoc.makeClassListHDF(data, "package.interfaces", ClassInfo.sortByName(pkg.interfaces()));
        DroidDoc.makeClassListHDF(data, "package.classes", ClassInfo.sortByName(pkg.ordinaryClasses()));
        DroidDoc.makeClassListHDF(data, "package.enums", ClassInfo.sortByName(pkg.enums()));
        DroidDoc.makeClassListHDF(data, "package.exceptions", ClassInfo.sortByName(pkg.exceptions()));
        DroidDoc.makeClassListHDF(data, "package.errors", ClassInfo.sortByName(pkg.errors()));
        TagInfo.makeHDF(data, "package.shortDescr", pkg.firstSentenceTags());
        TagInfo.makeHDF(data, "package.descr", pkg.inlineTags());
        String filename = pkg.htmlPage();
        DroidDoc.setPageTitle(data, name);
        ClearPage.write(data, "package.cs", filename);
        filename = pkg.fullDescriptionHtmlPage();
        DroidDoc.setPageTitle(data, name + " Details");
        ClearPage.write(data, "package-descr.cs", filename);
        Proofread.writePackage(filename, pkg.inlineTags());
    }

    public static void writeClassLists() {
        String s;
        int i;
        HDF data = DroidDoc.makePackageHDF();
        ClassInfo[] classes = PackageInfo.filterHidden(Converter.convertClasses(root.classes()));
        if (classes.length == 0) {
            return;
        }
        Object[] sorted = new Sorter[classes.length];
        for (i = 0; i < sorted.length; ++i) {
            ClassInfo cl = classes[i];
            String name = cl.name();
            sorted[i] = new Sorter(name, cl);
        }
        Arrays.sort(sorted);
        int firstMatch = 0;
        String lastName = ((Sorter)sorted[0]).label;
        for (i = 1; i < sorted.length; ++i) {
            s = ((Sorter)sorted[i]).label;
            if (lastName.equals(s)) continue;
            if (firstMatch != i - 1) {
                for (int j = firstMatch; j < i; ++j) {
                    PackageInfo pkg = ((ClassInfo)((Sorter)sorted[j]).data).containingPackage();
                    if (pkg == null) continue;
                    ((Sorter)sorted[j]).label = ((Sorter)sorted[j]).label + " (" + pkg.name() + ")";
                }
            }
            firstMatch = i;
            lastName = s;
        }
        Arrays.sort(sorted);
        for (i = 0; i < sorted.length; ++i) {
            s = ((Sorter)sorted[i]).label;
            ClassInfo cl = (ClassInfo)((Sorter)sorted[i]).data;
            char first = Character.toUpperCase(s.charAt(0));
            cl.makeShortDescrHDF(data, "docs.classes." + first + '.' + i);
        }
        DroidDoc.setPageTitle(data, "Class Index");
        ClearPage.write(data, "classes.cs", "reference/classes" + htmlExtension);
    }

    public static void writeHierarchy() {
        ClassInfo[] classes = Converter.rootClasses();
        ArrayList<ClassInfo> info = new ArrayList<ClassInfo>();
        for (ClassInfo cl : classes) {
            if (cl.isHidden()) continue;
            info.add(cl);
        }
        HDF data = DroidDoc.makePackageHDF();
        Hierarchy.makeHierarchy(data, info.toArray(new ClassInfo[info.size()]));
        DroidDoc.setPageTitle(data, "Class Hierarchy");
        ClearPage.write(data, "hierarchy.cs", "reference/hierarchy" + htmlExtension);
    }

    public static void writeClasses() {
        ClassInfo[] classes;
        for (ClassInfo cl : classes = Converter.rootClasses()) {
            HDF data = DroidDoc.makePackageHDF();
            if (cl.isHidden()) continue;
            DroidDoc.writeClass(cl, data);
        }
    }

    public static void writeClass(ClassInfo cl, HDF data) {
        cl.makeHDF(data);
        DroidDoc.setPageTitle(data, cl.name());
        ClearPage.write(data, "class.cs", cl.htmlPage());
        Proofread.writeClass(cl.htmlPage(), cl);
    }

    public static void makeClassListHDF(HDF data, String base, ClassInfo[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            ClassInfo cl = classes[i];
            if (cl.isHidden()) continue;
            cl.makeShortDescrHDF(data, base + "." + i);
        }
    }

    public static String linkTarget(String source, String target) {
        int same;
        String[] src = source.split("/");
        String[] tgt = target.split("/");
        int srclen = src.length;
        int tgtlen = tgt.length;
        for (same = 0; same < srclen - 1 && same < tgtlen - 1 && src[same].equals(tgt[same]); ++same) {
        }
        String s = "";
        int up = srclen - same - 1;
        for (int i = 0; i < up; ++i) {
            s = s + "../";
        }
        int N = tgtlen - 1;
        for (int i = same; i < N; ++i) {
            s = s + tgt[i] + '/';
        }
        s = s + tgt[tgtlen - 1];
        return s;
    }

    private static boolean hasHideAnnotation(Doc doc) {
        String comment = doc.getRawCommentText();
        return comment.indexOf("@hide") != -1 || comment.indexOf("@pending") != -1;
    }

    private static boolean isHidden(Doc doc) {
        if (doc instanceof MemberDoc) {
            return DroidDoc.hasHideAnnotation(doc);
        }
        if (doc instanceof ClassDoc) {
            ClassDoc classDoc = (ClassDoc)doc;
            if (DroidDoc.hasHideAnnotation((Doc)classDoc.containingPackage())) {
                return true;
            }
            ClassDoc current = classDoc;
            do {
                if (!DroidDoc.hasHideAnnotation((Doc)current)) continue;
                return true;
            } while ((current = current.containingClass()) != null);
        }
        return false;
    }

    private static Object filterHidden(Object o, Class<?> expected) {
        if (o == null) {
            return null;
        }
        Class<?> type = o.getClass();
        if (type.getName().startsWith("com.sun.")) {
            return Proxy.newProxyInstance(type.getClassLoader(), type.getInterfaces(), (InvocationHandler)new HideHandler(o));
        }
        if (o instanceof Object[]) {
            Class<?> componentType = expected.getComponentType();
            Object[] array = (Object[])o;
            ArrayList<Object> list = new ArrayList<Object>(array.length);
            for (Object entry : array) {
                if (entry instanceof Doc && DroidDoc.isHidden((Doc)entry)) continue;
                list.add(DroidDoc.filterHidden(entry, componentType));
            }
            return list.toArray((Object[])Array.newInstance(componentType, list.size()));
        }
        return o;
    }

    public static String scope(Scoped scoped) {
        if (scoped.isPublic()) {
            return "public";
        }
        if (scoped.isProtected()) {
            return "protected";
        }
        if (scoped.isPackagePrivate()) {
            return "";
        }
        if (scoped.isPrivate()) {
            return "private";
        }
        throw new RuntimeException("invalid scope for object " + scoped);
    }

    private static void writeSdkValues(String output) {
        ClassInfo[] classes;
        ArrayList<String> activityActions = new ArrayList<String>();
        ArrayList<String> broadcastActions = new ArrayList<String>();
        ArrayList<String> serviceActions = new ArrayList<String>();
        ArrayList<String> categories = new ArrayList<String>();
        ArrayList<String> features = new ArrayList<String>();
        ArrayList<ClassInfo> layouts = new ArrayList<ClassInfo>();
        ArrayList<ClassInfo> widgets = new ArrayList<ClassInfo>();
        ArrayList<ClassInfo> layoutParams = new ArrayList<ClassInfo>();
        block5: for (ClassInfo clazz : classes = Converter.allClasses()) {
            PackageInfo pckg;
            String packageName;
            FieldInfo[] fields;
            block6: for (FieldInfo field : fields = clazz.allSelfFields()) {
                AnnotationInstanceInfo[] annotations;
                Object cValue = field.constantValue();
                if (cValue == null || (annotations = field.annotations()).length <= 0) continue;
                for (AnnotationInstanceInfo annotation : annotations) {
                    if (!SDK_CONSTANT_ANNOTATION.equals(annotation.type().qualifiedName())) continue;
                    AnnotationValueInfo[] values = annotation.elementValues();
                    if (values.length <= 0) continue block6;
                    String type = values[0].valueString();
                    if (SDK_CONSTANT_TYPE_ACTIVITY_ACTION.equals(type)) {
                        activityActions.add(cValue.toString());
                        continue block6;
                    }
                    if (SDK_CONSTANT_TYPE_BROADCAST_ACTION.equals(type)) {
                        broadcastActions.add(cValue.toString());
                        continue block6;
                    }
                    if (SDK_CONSTANT_TYPE_SERVICE_ACTION.equals(type)) {
                        serviceActions.add(cValue.toString());
                        continue block6;
                    }
                    if (SDK_CONSTANT_TYPE_CATEGORY.equals(type)) {
                        categories.add(cValue.toString());
                        continue block6;
                    }
                    if (!SDK_CONSTANT_TYPE_FEATURE.equals(type)) continue block6;
                    features.add(cValue.toString());
                    continue block6;
                }
            }
            if (clazz.isHidden() || !clazz.isPublic() || clazz.isAbstract()) continue;
            boolean annotated = false;
            AnnotationInstanceInfo[] annotations = clazz.annotations();
            if (annotations.length > 0) {
                for (AnnotationInstanceInfo annotation : annotations) {
                    if (SDK_WIDGET_ANNOTATION.equals(annotation.type().qualifiedName())) {
                        widgets.add(clazz);
                        annotated = true;
                        break;
                    }
                    if (!SDK_LAYOUT_ANNOTATION.equals(annotation.type().qualifiedName())) continue;
                    layouts.add(clazz);
                    annotated = true;
                    break;
                }
            }
            if (annotated || !"android.widget".equals(packageName = (pckg = clazz.containingPackage()).name()) && !"android.view".equals(packageName)) continue;
            int type = DroidDoc.checkInheritance(clazz);
            switch (type) {
                case 1: {
                    widgets.add(clazz);
                    continue block5;
                }
                case 2: {
                    layouts.add(clazz);
                    continue block5;
                }
                case 3: {
                    layoutParams.add(clazz);
                }
            }
        }
        Collections.sort(activityActions);
        DroidDoc.writeValues(output + "/activity_actions.txt", activityActions);
        Collections.sort(broadcastActions);
        DroidDoc.writeValues(output + "/broadcast_actions.txt", broadcastActions);
        Collections.sort(serviceActions);
        DroidDoc.writeValues(output + "/service_actions.txt", serviceActions);
        Collections.sort(categories);
        DroidDoc.writeValues(output + "/categories.txt", categories);
        Collections.sort(features);
        DroidDoc.writeValues(output + "/features.txt", features);
        int i = 0;
        while (i < layoutParams.size()) {
            ClassInfo layoutParamClass = (ClassInfo)layoutParams.get(i);
            ClassInfo containingClass = layoutParamClass.containingClass();
            if (containingClass == null || layouts.indexOf(containingClass) == -1) {
                layoutParams.remove(i);
                continue;
            }
            ++i;
        }
        DroidDoc.writeClasses(output + "/widgets.txt", widgets, layouts, layoutParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeValues(String pathname, ArrayList<String> values) {
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(pathname, false);
            bw = new BufferedWriter(fw);
            for (String value : values) {
                bw.append(value).append('\n');
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {}
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeClasses(String pathname, ArrayList<ClassInfo> widgets, ArrayList<ClassInfo> layouts, ArrayList<ClassInfo> layoutParams) {
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(pathname, false);
            bw = new BufferedWriter(fw);
            for (ClassInfo clazz : widgets) {
                DroidDoc.writeClass(bw, clazz, 'W');
            }
            for (ClassInfo clazz : layoutParams) {
                DroidDoc.writeClass(bw, clazz, 'P');
            }
            for (ClassInfo clazz : layouts) {
                DroidDoc.writeClass(bw, clazz, 'L');
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {}
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static void writeClass(BufferedWriter writer, ClassInfo clazz, char prefix) throws IOException {
        writer.append(prefix).append(clazz.qualifiedName());
        ClassInfo superClass = clazz;
        while ((superClass = superClass.superclass()) != null) {
            writer.append(' ').append(superClass.qualifiedName());
        }
        writer.append('\n');
    }

    private static int checkInheritance(ClassInfo clazz) {
        if ("android.view.ViewGroup".equals(clazz.qualifiedName())) {
            return 2;
        }
        if ("android.view.View".equals(clazz.qualifiedName())) {
            return 1;
        }
        if ("android.view.ViewGroup.LayoutParams".equals(clazz.qualifiedName())) {
            return 3;
        }
        ClassInfo parent = clazz.superclass();
        if (parent != null) {
            return DroidDoc.checkInheritance(parent);
        }
        return 0;
    }

    static {
        mHDFData = new ArrayList();
        escapeChars = new HashMap<Character, String>();
        title = "";
        sinceTagger = new SinceTagger();
        knownTags = new HashSet();
        parseComments = false;
        generateDocs = true;
        sVisiblePackages = null;
    }

    private static class HideHandler
    implements InvocationHandler {
        private final Object target;

        public HideHandler(Object target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (args != null && (methodName.equals("compareTo") || methodName.equals("equals") || methodName.equals("overrides") || methodName.equals("subclassOf"))) {
                args[0] = HideHandler.unwrap(args[0]);
            }
            if (methodName.equals("getRawCommentText")) {
                return this.filterComment((String)method.invoke(this.target, args));
            }
            if (proxy instanceof Type && methodName.equals("toString")) {
                return ((String)method.invoke(this.target, args)).replace("&", "&amp;");
            }
            try {
                return DroidDoc.filterHidden(method.invoke(this.target, args), method.getReturnType());
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private String filterComment(String s) {
            if (s == null) {
                return null;
            }
            s = s.trim();
            while (s.length() >= 5 && s.charAt(s.length() - 5) == '{') {
                s = s + "&nbsp;";
            }
            return s;
        }

        private static Object unwrap(Object proxy) {
            if (proxy instanceof Proxy) {
                return ((HideHandler)Proxy.getInvocationHandler((Object)proxy)).target;
            }
            return proxy;
        }
    }
}

