/*
 * Decompiled with CFR 0.152.
 */
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class Converter {
    private static RootDoc root;
    private static ClassInfo[] mRootClasses;
    private static ArrayList<ClassNeedingInit> mClassesNeedingInit;
    private static Cache mClasses;
    private static Cache mMethods;
    private static Cache mFields;
    private static Cache mPackagees;
    private static Cache mTypes;
    private static Cache mMembers;
    private static Cache mAnnotationInstances;
    private static HashMap<AnnotationValue, AnnotationValueInfo> mAnnotationValues;
    private static HashSet<AnnotationValue> mAnnotationValuesNeedingInit;

    public static void makeInfo(RootDoc r) {
        int i;
        root = r;
        ClassDoc[] classDocs = r.classes();
        int N = classDocs.length;
        for (i = 0; i < N; ++i) {
            Converter.obtainClass(classDocs[i]);
        }
        ArrayList<ClassInfo> classesNeedingInit2 = new ArrayList<ClassInfo>();
        while (mClassesNeedingInit.size() > 0) {
            i = mClassesNeedingInit.size() - 1;
            ClassNeedingInit clni = mClassesNeedingInit.get(i);
            mClassesNeedingInit.remove(i);
            Converter.initClass(clni.c, clni.cl);
            classesNeedingInit2.add(clni.cl);
        }
        mClassesNeedingInit = null;
        for (ClassInfo cl : classesNeedingInit2) {
            cl.init2();
        }
        Converter.finishAnnotationValueInit();
        mRootClasses = Converter.convertClasses(r.classes());
    }

    public static ClassInfo[] rootClasses() {
        return mRootClasses;
    }

    public static ClassInfo[] allClasses() {
        return (ClassInfo[])mClasses.all();
    }

    private static void initClass(ClassDoc c, ClassInfo cl) {
        Object[] annotationElements = c instanceof AnnotationTypeDoc ? ((AnnotationTypeDoc)c).elements() : new MethodDoc[]{};
        cl.init(Converter.obtainType((Type)c), Converter.convertClasses(c.interfaces()), Converter.convertTypes(c.interfaceTypes()), Converter.convertClasses(c.innerClasses()), Converter.convertMethods(c.constructors(false)), Converter.convertMethods(c.methods(false)), Converter.convertMethods(annotationElements), Converter.convertFields(c.fields(false)), Converter.convertFields(c.enumConstants()), Converter.obtainPackage(c.containingPackage()), Converter.obtainClass(c.containingClass()), Converter.obtainClass(c.superclass()), Converter.obtainType(c.superclassType()), Converter.convertAnnotationInstances(c.annotations()));
        cl.setHiddenMethods(Converter.getHiddenMethods(c.methods(false)));
        cl.setNonWrittenConstructors(Converter.convertNonWrittenConstructors(c.constructors(false)));
        cl.init3(Converter.convertTypes((Type[])c.typeParameters()), Converter.convertClasses(c.innerClasses(false)));
    }

    public static ClassInfo obtainClass(String className) {
        return Converter.obtainClass(root.classNamed(className));
    }

    public static PackageInfo obtainPackage(String packageName) {
        return Converter.obtainPackage(root.packageNamed(packageName));
    }

    private static TagInfo convertTag(Tag tag) {
        return new TextTagInfo(tag.name(), tag.kind(), tag.text(), Converter.convertSourcePosition(tag.position()));
    }

    private static ThrowsTagInfo convertThrowsTag(ThrowsTag tag, ContainerInfo base) {
        return new ThrowsTagInfo(tag.name(), tag.text(), tag.kind(), Converter.obtainClass(tag.exception()), tag.exceptionComment(), base, Converter.convertSourcePosition(tag.position()));
    }

    private static ParamTagInfo convertParamTag(ParamTag tag, ContainerInfo base) {
        return new ParamTagInfo(tag.name(), tag.kind(), tag.text(), tag.isTypeParameter(), tag.parameterComment(), tag.parameterName(), base, Converter.convertSourcePosition(tag.position()));
    }

    private static SeeTagInfo convertSeeTag(SeeTag tag, ContainerInfo base) {
        return new SeeTagInfo(tag.name(), tag.kind(), tag.text(), base, Converter.convertSourcePosition(tag.position()));
    }

    private static SourcePositionInfo convertSourcePosition(SourcePosition sp) {
        if (sp == null) {
            return null;
        }
        return new SourcePositionInfo(sp.file().toString(), sp.line(), sp.column());
    }

    public static TagInfo[] convertTags(Tag[] tags, ContainerInfo base) {
        int len = tags.length;
        TagInfo[] out = new TagInfo[len];
        for (int i = 0; i < len; ++i) {
            Tag t = tags[i];
            out[i] = t instanceof SeeTag ? Converter.convertSeeTag((SeeTag)t, base) : (t instanceof ThrowsTag ? Converter.convertThrowsTag((ThrowsTag)t, base) : (t instanceof ParamTag ? Converter.convertParamTag((ParamTag)t, base) : Converter.convertTag(t)));
        }
        return out;
    }

    public static ClassInfo[] convertClasses(ClassDoc[] classes) {
        if (classes == null) {
            return null;
        }
        int N = classes.length;
        ClassInfo[] result = new ClassInfo[N];
        for (int i = 0; i < N; ++i) {
            result[i] = Converter.obtainClass(classes[i]);
        }
        return result;
    }

    private static ParameterInfo convertParameter(Parameter p, SourcePosition pos) {
        if (p == null) {
            return null;
        }
        ParameterInfo pi = new ParameterInfo(p.name(), p.typeName(), Converter.obtainType(p.type()), Converter.convertSourcePosition(pos));
        return pi;
    }

    private static ParameterInfo[] convertParameters(Parameter[] p, MemberDoc m) {
        SourcePosition pos = m.position();
        int len = p.length;
        ParameterInfo[] q = new ParameterInfo[len];
        for (int i = 0; i < len; ++i) {
            q[i] = Converter.convertParameter(p[i], pos);
        }
        return q;
    }

    private static TypeInfo[] convertTypes(Type[] p) {
        if (p == null) {
            return null;
        }
        int len = p.length;
        TypeInfo[] q = new TypeInfo[len];
        for (int i = 0; i < len; ++i) {
            q[i] = Converter.obtainType(p[i]);
        }
        return q;
    }

    private Converter() {
    }

    static ClassInfo obtainClass(ClassDoc o) {
        return (ClassInfo)mClasses.obtain(o);
    }

    private static MethodInfo[] getHiddenMethods(MethodDoc[] methods) {
        if (methods == null) {
            return null;
        }
        ArrayList<MethodInfo> out = new ArrayList<MethodInfo>();
        int N = methods.length;
        for (int i = 0; i < N; ++i) {
            MethodInfo m = Converter.obtainMethod(methods[i]);
            if (!m.isHidden()) continue;
            out.add(m);
        }
        return out.toArray(new MethodInfo[out.size()]);
    }

    private static MethodInfo[] convertMethods(MethodDoc[] methods) {
        if (methods == null) {
            return null;
        }
        ArrayList<MethodInfo> out = new ArrayList<MethodInfo>();
        int N = methods.length;
        for (int i = 0; i < N; ++i) {
            MethodInfo m = Converter.obtainMethod(methods[i]);
            if (!m.checkLevel()) continue;
            out.add(m);
        }
        return out.toArray(new MethodInfo[out.size()]);
    }

    private static MethodInfo[] convertMethods(ConstructorDoc[] methods) {
        if (methods == null) {
            return null;
        }
        ArrayList<MethodInfo> out = new ArrayList<MethodInfo>();
        int N = methods.length;
        for (int i = 0; i < N; ++i) {
            MethodInfo m = Converter.obtainMethod(methods[i]);
            if (!m.checkLevel()) continue;
            out.add(m);
        }
        return out.toArray(new MethodInfo[out.size()]);
    }

    private static MethodInfo[] convertNonWrittenConstructors(ConstructorDoc[] methods) {
        if (methods == null) {
            return null;
        }
        ArrayList<MethodInfo> out = new ArrayList<MethodInfo>();
        int N = methods.length;
        for (int i = 0; i < N; ++i) {
            MethodInfo m = Converter.obtainMethod(methods[i]);
            if (m.checkLevel()) continue;
            out.add(m);
        }
        return out.toArray(new MethodInfo[out.size()]);
    }

    private static MethodInfo obtainMethod(MethodDoc o) {
        return (MethodInfo)mMethods.obtain(o);
    }

    private static MethodInfo obtainMethod(ConstructorDoc o) {
        return (MethodInfo)mMethods.obtain(o);
    }

    private static FieldInfo[] convertFields(FieldDoc[] fields) {
        if (fields == null) {
            return null;
        }
        ArrayList<FieldInfo> out = new ArrayList<FieldInfo>();
        int N = fields.length;
        for (int i = 0; i < N; ++i) {
            FieldInfo f = Converter.obtainField(fields[i]);
            if (!f.checkLevel()) continue;
            out.add(f);
        }
        return out.toArray(new FieldInfo[out.size()]);
    }

    private static FieldInfo obtainField(FieldDoc o) {
        return (FieldInfo)mFields.obtain(o);
    }

    private static FieldInfo obtainField(ConstructorDoc o) {
        return (FieldInfo)mFields.obtain(o);
    }

    private static PackageInfo obtainPackage(PackageDoc o) {
        return (PackageInfo)mPackagees.obtain(o);
    }

    private static TypeInfo obtainType(Type o) {
        return (TypeInfo)mTypes.obtain(o);
    }

    private static MemberInfo obtainMember(MemberDoc o) {
        return (MemberInfo)mMembers.obtain(o);
    }

    private static AnnotationInstanceInfo[] convertAnnotationInstances(AnnotationDesc[] orig) {
        int len = orig.length;
        AnnotationInstanceInfo[] out = new AnnotationInstanceInfo[len];
        for (int i = 0; i < len; ++i) {
            out[i] = Converter.obtainAnnotationInstance(orig[i]);
        }
        return out;
    }

    private static AnnotationInstanceInfo obtainAnnotationInstance(AnnotationDesc o) {
        return (AnnotationInstanceInfo)mAnnotationInstances.obtain(o);
    }

    private static AnnotationValueInfo obtainAnnotationValue(AnnotationValue o, MethodInfo element) {
        if (o == null) {
            return null;
        }
        AnnotationValueInfo v = mAnnotationValues.get(o);
        if (v != null) {
            return v;
        }
        v = new AnnotationValueInfo(element);
        mAnnotationValues.put(o, v);
        if (mAnnotationValuesNeedingInit != null) {
            mAnnotationValuesNeedingInit.add(o);
        } else {
            Converter.initAnnotationValue(o, v);
        }
        return v;
    }

    private static void initAnnotationValue(AnnotationValue o, AnnotationValueInfo v) {
        AnnotationValueInfo[] converted;
        Object orig = o.value();
        if (orig instanceof Type) {
            converted = Converter.obtainType((Type)orig);
        } else if (orig instanceof FieldDoc) {
            converted = Converter.obtainField((FieldDoc)orig);
        } else if (orig instanceof AnnotationDesc) {
            converted = Converter.obtainAnnotationInstance((AnnotationDesc)orig);
        } else if (orig instanceof AnnotationValue[]) {
            AnnotationValue[] old = (AnnotationValue[])orig;
            AnnotationValueInfo[] array = new AnnotationValueInfo[old.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Converter.obtainAnnotationValue(old[i], null);
            }
            converted = array;
        } else {
            converted = orig;
        }
        v.init(converted);
    }

    private static void finishAnnotationValueInit() {
        int depth = 0;
        while (mAnnotationValuesNeedingInit.size() > 0) {
            HashSet<AnnotationValue> set = mAnnotationValuesNeedingInit;
            mAnnotationValuesNeedingInit = new HashSet();
            for (AnnotationValue o : set) {
                AnnotationValueInfo v = mAnnotationValues.get(o);
                Converter.initAnnotationValue(o, v);
            }
            ++depth;
        }
        mAnnotationValuesNeedingInit = null;
    }

    static {
        mClassesNeedingInit = new ArrayList();
        mClasses = new Cache(){

            protected Object make(Object o) {
                ClassDoc c = (ClassDoc)o;
                ClassInfo cl = new ClassInfo(c, c.getRawCommentText(), Converter.convertSourcePosition(c.position()), c.isPublic(), c.isProtected(), c.isPackagePrivate(), c.isPrivate(), c.isStatic(), c.isInterface(), c.isAbstract(), c.isOrdinaryClass(), c.isException(), c.isError(), c.isEnum(), c instanceof AnnotationTypeDoc, c.isFinal(), c.isIncluded(), c.name(), c.qualifiedName(), c.qualifiedTypeName(), c.isPrimitive());
                if (mClassesNeedingInit != null) {
                    mClassesNeedingInit.add(new ClassNeedingInit(c, cl));
                }
                return cl;
            }

            protected void made(Object o, Object r) {
                if (mClassesNeedingInit == null) {
                    Converter.initClass((ClassDoc)o, (ClassInfo)r);
                    ((ClassInfo)r).init2();
                }
            }

            ClassInfo[] all() {
                return this.mCache.values().toArray(new ClassInfo[this.mCache.size()]);
            }
        };
        mMethods = new Cache(){

            protected Object make(Object o) {
                if (o instanceof AnnotationTypeElementDoc) {
                    AnnotationTypeElementDoc m = (AnnotationTypeElementDoc)o;
                    MethodInfo result = new MethodInfo(m.getRawCommentText(), Converter.convertTypes((Type[])m.typeParameters()), m.name(), m.signature(), Converter.obtainClass(m.containingClass()), Converter.obtainClass(m.containingClass()), m.isPublic(), m.isProtected(), m.isPackagePrivate(), m.isPrivate(), m.isFinal(), m.isStatic(), m.isSynthetic(), m.isAbstract(), m.isSynchronized(), m.isNative(), true, "annotationElement", m.flatSignature(), Converter.obtainMethod(m.overriddenMethod()), Converter.obtainType(m.returnType()), Converter.convertParameters(m.parameters(), (MemberDoc)m), Converter.convertClasses(m.thrownExceptions()), Converter.convertSourcePosition(m.position()), Converter.convertAnnotationInstances(m.annotations()));
                    result.setVarargs(m.isVarArgs());
                    result.init(Converter.obtainAnnotationValue(m.defaultValue(), result));
                    return result;
                }
                if (o instanceof MethodDoc) {
                    MethodDoc m = (MethodDoc)o;
                    MethodInfo result = new MethodInfo(m.getRawCommentText(), Converter.convertTypes((Type[])m.typeParameters()), m.name(), m.signature(), Converter.obtainClass(m.containingClass()), Converter.obtainClass(m.containingClass()), m.isPublic(), m.isProtected(), m.isPackagePrivate(), m.isPrivate(), m.isFinal(), m.isStatic(), m.isSynthetic(), m.isAbstract(), m.isSynchronized(), m.isNative(), false, "method", m.flatSignature(), Converter.obtainMethod(m.overriddenMethod()), Converter.obtainType(m.returnType()), Converter.convertParameters(m.parameters(), (MemberDoc)m), Converter.convertClasses(m.thrownExceptions()), Converter.convertSourcePosition(m.position()), Converter.convertAnnotationInstances(m.annotations()));
                    result.setVarargs(m.isVarArgs());
                    result.init(null);
                    return result;
                }
                ConstructorDoc m = (ConstructorDoc)o;
                MethodInfo result = new MethodInfo(m.getRawCommentText(), Converter.convertTypes((Type[])m.typeParameters()), m.name(), m.signature(), Converter.obtainClass(m.containingClass()), Converter.obtainClass(m.containingClass()), m.isPublic(), m.isProtected(), m.isPackagePrivate(), m.isPrivate(), m.isFinal(), m.isStatic(), m.isSynthetic(), false, m.isSynchronized(), m.isNative(), false, "constructor", m.flatSignature(), null, null, Converter.convertParameters(m.parameters(), (MemberDoc)m), Converter.convertClasses(m.thrownExceptions()), Converter.convertSourcePosition(m.position()), Converter.convertAnnotationInstances(m.annotations()));
                result.setVarargs(m.isVarArgs());
                result.init(null);
                return result;
            }
        };
        mFields = new Cache(){

            protected Object make(Object o) {
                FieldDoc f = (FieldDoc)o;
                return new FieldInfo(f.name(), Converter.obtainClass(f.containingClass()), Converter.obtainClass(f.containingClass()), f.isPublic(), f.isProtected(), f.isPackagePrivate(), f.isPrivate(), f.isFinal(), f.isStatic(), f.isTransient(), f.isVolatile(), f.isSynthetic(), Converter.obtainType(f.type()), f.getRawCommentText(), f.constantValue(), Converter.convertSourcePosition(f.position()), Converter.convertAnnotationInstances(f.annotations()));
            }
        };
        mPackagees = new Cache(){

            protected Object make(Object o) {
                PackageDoc p = (PackageDoc)o;
                return new PackageInfo(p, p.name(), Converter.convertSourcePosition(p.position()));
            }
        };
        mTypes = new Cache(){

            protected Object make(Object o) {
                Type t = (Type)o;
                String simpleTypeName = t instanceof ClassDoc ? ((ClassDoc)t).name() : t.simpleTypeName();
                TypeInfo ti = new TypeInfo(t.isPrimitive(), t.dimension(), simpleTypeName, t.qualifiedTypeName(), Converter.obtainClass(t.asClassDoc()));
                return ti;
            }

            protected void made(Object o, Object r) {
                Type t = (Type)o;
                TypeInfo ti = (TypeInfo)r;
                if (t.asParameterizedType() != null) {
                    ti.setTypeArguments(Converter.convertTypes(t.asParameterizedType().typeArguments()));
                } else if (t instanceof ClassDoc) {
                    ti.setTypeArguments(Converter.convertTypes((Type[])((ClassDoc)t).typeParameters()));
                } else if (t.asTypeVariable() != null) {
                    ti.setBounds(null, Converter.convertTypes(t.asTypeVariable().bounds()));
                    ti.setIsTypeVariable(true);
                } else if (t.asWildcardType() != null) {
                    ti.setIsWildcard(true);
                    ti.setBounds(Converter.convertTypes(t.asWildcardType().superBounds()), Converter.convertTypes(t.asWildcardType().extendsBounds()));
                }
            }

            protected Object keyFor(Object o) {
                Type t = (Type)o;
                String keyString = o.getClass().getName() + "/" + o.toString() + "/";
                if (t.asParameterizedType() != null) {
                    keyString = keyString + t.asParameterizedType().toString() + "/";
                    if (t.asParameterizedType().typeArguments() != null) {
                        for (Type ty : t.asParameterizedType().typeArguments()) {
                            keyString = keyString + ty.toString() + "/";
                        }
                    }
                } else {
                    keyString = keyString + "NoParameterizedType//";
                }
                if (t.asTypeVariable() != null) {
                    keyString = keyString + t.asTypeVariable().toString() + "/";
                    if (t.asTypeVariable().bounds() != null) {
                        for (Type ty : t.asTypeVariable().bounds()) {
                            keyString = keyString + ty.toString() + "/";
                        }
                    }
                } else {
                    keyString = keyString + "NoTypeVariable//";
                }
                if (t.asWildcardType() != null) {
                    keyString = keyString + t.asWildcardType().toString() + "/";
                    if (t.asWildcardType().superBounds() != null) {
                        for (Type ty : t.asWildcardType().superBounds()) {
                            keyString = keyString + ty.toString() + "/";
                        }
                    }
                    if (t.asWildcardType().extendsBounds() != null) {
                        for (Type ty : t.asWildcardType().extendsBounds()) {
                            keyString = keyString + ty.toString() + "/";
                        }
                    }
                } else {
                    keyString = keyString + "NoWildCardType//";
                }
                return keyString;
            }
        };
        mMembers = new Cache(){

            protected Object make(Object o) {
                if (o instanceof MethodDoc) {
                    return Converter.obtainMethod((MethodDoc)o);
                }
                if (o instanceof ConstructorDoc) {
                    return Converter.obtainMethod((ConstructorDoc)o);
                }
                if (o instanceof FieldDoc) {
                    return Converter.obtainField((FieldDoc)o);
                }
                return null;
            }
        };
        mAnnotationInstances = new Cache(){

            protected Object make(Object o) {
                AnnotationDesc a = (AnnotationDesc)o;
                ClassInfo annotationType = Converter.obtainClass((ClassDoc)a.annotationType());
                AnnotationDesc.ElementValuePair[] ev = a.elementValues();
                AnnotationValueInfo[] elementValues = new AnnotationValueInfo[ev.length];
                for (int i = 0; i < ev.length; ++i) {
                    elementValues[i] = Converter.obtainAnnotationValue(ev[i].value(), Converter.obtainMethod((MethodDoc)ev[i].element()));
                }
                return new AnnotationInstanceInfo(annotationType, elementValues);
            }
        };
        mAnnotationValues = new HashMap();
        mAnnotationValuesNeedingInit = new HashSet();
    }

    private static abstract class Cache {
        protected HashMap<Object, Object> mCache = new HashMap();

        private Cache() {
        }

        void put(Object key, Object value) {
            this.mCache.put(key, value);
        }

        Object obtain(Object o) {
            if (o == null) {
                return null;
            }
            Object k = this.keyFor(o);
            Object r = this.mCache.get(k);
            if (r == null) {
                r = this.make(o);
                this.mCache.put(k, r);
                this.made(o, r);
            }
            return r;
        }

        protected abstract Object make(Object var1);

        protected void made(Object o, Object r) {
        }

        protected Object keyFor(Object o) {
            return o;
        }

        Object[] all() {
            return null;
        }
    }

    private static class ClassNeedingInit {
        ClassDoc c;
        ClassInfo cl;

        ClassNeedingInit(ClassDoc c, ClassInfo cl) {
            this.c = c;
            this.cl = cl;
        }
    }
}

