/*
 * Decompiled with CFR 0.152.
 */
import com.sun.javadoc.ClassDoc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.clearsilver.HDF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo
extends DocInfo
implements ContainerInfo,
Comparable,
Scoped {
    public static final Comparator<ClassInfo> comparator = new Comparator<ClassInfo>(){

        @Override
        public int compare(ClassInfo a, ClassInfo b) {
            return a.name().compareTo(b.name());
        }
    };
    public static final Comparator<ClassInfo> qualifiedComparator = new Comparator<ClassInfo>(){

        @Override
        public int compare(ClassInfo a, ClassInfo b) {
            return a.qualifiedName().compareTo(b.qualifiedName());
        }
    };
    private ClassDoc mClass;
    private boolean mIsPublic;
    private boolean mIsProtected;
    private boolean mIsPackagePrivate;
    private boolean mIsPrivate;
    private boolean mIsStatic;
    private boolean mIsInterface;
    private boolean mIsAbstract;
    private boolean mIsOrdinaryClass;
    private boolean mIsException;
    private boolean mIsError;
    private boolean mIsEnum;
    private boolean mIsAnnotation;
    private boolean mIsFinal;
    private boolean mIsIncluded;
    private String mName;
    private String mQualifiedName;
    private String mQualifiedTypeName;
    private boolean mIsPrimitive;
    private TypeInfo mTypeInfo;
    private String[] mNameParts;
    private ClassInfo[] mRealInterfaces;
    private ClassInfo[] mInterfaces;
    private TypeInfo[] mRealInterfaceTypes;
    private ClassInfo[] mInnerClasses;
    private MethodInfo[] mAllConstructors;
    private MethodInfo[] mAllSelfMethods;
    private MethodInfo[] mAnnotationElements;
    private FieldInfo[] mAllSelfFields;
    private FieldInfo[] mEnumConstants;
    private PackageInfo mContainingPackage;
    private ClassInfo mContainingClass;
    private ClassInfo mRealSuperclass;
    private TypeInfo mRealSuperclassType;
    private ClassInfo mSuperclass;
    private AnnotationInstanceInfo[] mAnnotations;
    private boolean mSuperclassInit;
    private boolean mDeprecatedKnown;
    private MethodInfo[] mConstructors;
    private ClassInfo[] mRealInnerClasses;
    private MethodInfo[] mSelfMethods;
    private FieldInfo[] mSelfFields;
    private AttributeInfo[] mSelfAttributes;
    private MethodInfo[] mMethods;
    private FieldInfo[] mFields;
    private TypeInfo[] mTypeParameters;
    private MethodInfo[] mHiddenMethods;
    private int mHidden = -1;
    private int mCheckLevel = -1;
    private String mReasonIncluded;
    private MethodInfo[] mNonWrittenConstructors;
    private boolean mIsDeprecated;

    public ClassInfo(ClassDoc cl, String rawCommentText, SourcePositionInfo position, boolean isPublic, boolean isProtected, boolean isPackagePrivate, boolean isPrivate, boolean isStatic, boolean isInterface, boolean isAbstract, boolean isOrdinaryClass, boolean isException, boolean isError, boolean isEnum, boolean isAnnotation, boolean isFinal, boolean isIncluded, String name, String qualifiedName, String qualifiedTypeName, boolean isPrimitive) {
        super(rawCommentText, position);
        this.mClass = cl;
        this.mIsPublic = isPublic;
        this.mIsProtected = isProtected;
        this.mIsPackagePrivate = isPackagePrivate;
        this.mIsPrivate = isPrivate;
        this.mIsStatic = isStatic;
        this.mIsInterface = isInterface;
        this.mIsAbstract = isAbstract;
        this.mIsOrdinaryClass = isOrdinaryClass;
        this.mIsException = isException;
        this.mIsError = isError;
        this.mIsEnum = isEnum;
        this.mIsAnnotation = isAnnotation;
        this.mIsFinal = isFinal;
        this.mIsIncluded = isIncluded;
        this.mName = name;
        this.mQualifiedName = qualifiedName;
        this.mQualifiedTypeName = qualifiedTypeName;
        this.mIsPrimitive = isPrimitive;
        this.mNameParts = name.split("\\.");
    }

    public void init(TypeInfo typeInfo, ClassInfo[] interfaces, TypeInfo[] interfaceTypes, ClassInfo[] innerClasses, MethodInfo[] constructors, MethodInfo[] methods, MethodInfo[] annotationElements, FieldInfo[] fields, FieldInfo[] enumConstants, PackageInfo containingPackage, ClassInfo containingClass, ClassInfo superclass, TypeInfo superclassType, AnnotationInstanceInfo[] annotations) {
        this.mTypeInfo = typeInfo;
        this.mRealInterfaces = interfaces;
        this.mRealInterfaceTypes = interfaceTypes;
        this.mInnerClasses = innerClasses;
        this.mAllConstructors = constructors;
        this.mAllSelfMethods = methods;
        this.mAnnotationElements = annotationElements;
        this.mAllSelfFields = fields;
        this.mEnumConstants = enumConstants;
        this.mContainingPackage = containingPackage;
        this.mContainingClass = containingClass;
        this.mRealSuperclass = superclass;
        this.mRealSuperclassType = superclassType;
        this.mAnnotations = annotations;
        this.mSuperclassInit = false;
        this.mConstructors = null;
        this.mMethods = null;
        this.mSelfMethods = null;
        this.mFields = null;
        this.mSelfFields = null;
        this.mSelfAttributes = null;
        this.mDeprecatedKnown = false;
        Arrays.sort(this.mEnumConstants, FieldInfo.comparator);
        Arrays.sort(this.mInnerClasses, comparator);
    }

    public void init2() {
        this.selfAttributes();
    }

    public void init3(TypeInfo[] types, ClassInfo[] realInnerClasses) {
        this.mTypeParameters = types;
        this.mRealInnerClasses = realInnerClasses;
    }

    public ClassInfo[] getRealInnerClasses() {
        return this.mRealInnerClasses;
    }

    public TypeInfo[] getTypeParameters() {
        return this.mTypeParameters;
    }

    @Override
    public boolean checkLevel() {
        int val = this.mCheckLevel;
        if (val >= 0) {
            return val != 0;
        }
        boolean v = DroidDoc.checkLevel(this.mIsPublic, this.mIsProtected, this.mIsPackagePrivate, this.mIsPrivate, this.isHidden());
        this.mCheckLevel = v ? 1 : 0;
        return v;
    }

    public int compareTo(Object that) {
        if (that instanceof ClassInfo) {
            return this.mQualifiedName.compareTo(((ClassInfo)that).mQualifiedName);
        }
        return this.hashCode() - that.hashCode();
    }

    @Override
    public ContainerInfo parent() {
        return this;
    }

    @Override
    public boolean isPublic() {
        return this.mIsPublic;
    }

    @Override
    public boolean isProtected() {
        return this.mIsProtected;
    }

    @Override
    public boolean isPackagePrivate() {
        return this.mIsPackagePrivate;
    }

    @Override
    public boolean isPrivate() {
        return this.mIsPrivate;
    }

    public boolean isStatic() {
        return this.mIsStatic;
    }

    public boolean isInterface() {
        return this.mIsInterface;
    }

    public boolean isAbstract() {
        return this.mIsAbstract;
    }

    public PackageInfo containingPackage() {
        return this.mContainingPackage;
    }

    public ClassInfo containingClass() {
        return this.mContainingClass;
    }

    public boolean isOrdinaryClass() {
        return this.mIsOrdinaryClass;
    }

    public boolean isException() {
        return this.mIsException;
    }

    public boolean isError() {
        return this.mIsError;
    }

    public boolean isEnum() {
        return this.mIsEnum;
    }

    public boolean isAnnotation() {
        return this.mIsAnnotation;
    }

    public boolean isFinal() {
        return this.mIsFinal;
    }

    public boolean isIncluded() {
        return this.mIsIncluded;
    }

    public HashSet<String> typeVariables() {
        HashSet<String> result = TypeInfo.typeVariables(this.mTypeInfo.typeArguments());
        for (ClassInfo cl = this.containingClass(); cl != null; cl = cl.containingClass()) {
            TypeInfo[] types = cl.asTypeInfo().typeArguments();
            if (types == null) continue;
            TypeInfo.typeVariables(types, result);
        }
        return result;
    }

    private static void gatherHiddenInterfaces(ClassInfo cl, HashSet<ClassInfo> interfaces) {
        for (ClassInfo iface : cl.mRealInterfaces) {
            if (iface.checkLevel()) {
                interfaces.add(iface);
                continue;
            }
            ClassInfo.gatherHiddenInterfaces(iface, interfaces);
        }
    }

    public ClassInfo[] interfaces() {
        if (this.mInterfaces == null) {
            if (this.checkLevel()) {
                HashSet<ClassInfo> interfaces = new HashSet<ClassInfo>();
                ClassInfo superclass = this.mRealSuperclass;
                while (superclass != null && !superclass.checkLevel()) {
                    ClassInfo.gatherHiddenInterfaces(superclass, interfaces);
                    superclass = superclass.mRealSuperclass;
                }
                ClassInfo.gatherHiddenInterfaces(this, interfaces);
                this.mInterfaces = interfaces.toArray(new ClassInfo[interfaces.size()]);
            } else {
                this.mInterfaces = this.mRealInterfaces;
            }
            Arrays.sort(this.mInterfaces, qualifiedComparator);
        }
        return this.mInterfaces;
    }

    public ClassInfo[] realInterfaces() {
        return this.mRealInterfaces;
    }

    TypeInfo[] realInterfaceTypes() {
        return this.mRealInterfaceTypes;
    }

    public String name() {
        return this.mName;
    }

    public String[] nameParts() {
        return this.mNameParts;
    }

    public String leafName() {
        return this.mNameParts[this.mNameParts.length - 1];
    }

    @Override
    public String qualifiedName() {
        return this.mQualifiedName;
    }

    public String qualifiedTypeName() {
        return this.mQualifiedTypeName;
    }

    public boolean isPrimitive() {
        return this.mIsPrimitive;
    }

    public MethodInfo[] allConstructors() {
        return this.mAllConstructors;
    }

    public MethodInfo[] constructors() {
        if (this.mConstructors == null) {
            MethodInfo[] methods = this.mAllConstructors;
            ArrayList<MethodInfo> ctors = new ArrayList<MethodInfo>();
            for (int i = 0; i < methods.length; ++i) {
                MethodInfo m = methods[i];
                if (m.isHidden()) continue;
                ctors.add(m);
            }
            this.mConstructors = ctors.toArray(new MethodInfo[ctors.size()]);
            Arrays.sort(this.mConstructors, MethodInfo.comparator);
        }
        return this.mConstructors;
    }

    public ClassInfo[] innerClasses() {
        return this.mInnerClasses;
    }

    public TagInfo[] inlineTags() {
        return this.comment().tags();
    }

    public TagInfo[] firstSentenceTags() {
        return this.comment().briefTags();
    }

    public boolean isDeprecated() {
        boolean deprecated = false;
        if (!this.mDeprecatedKnown) {
            boolean commentDeprecated = this.comment().deprecatedTags().length > 0;
            boolean annotationDeprecated = false;
            for (AnnotationInstanceInfo annotation : this.annotations()) {
                if (!annotation.type().qualifiedName().equals("java.lang.Deprecated")) continue;
                annotationDeprecated = true;
                break;
            }
            if (commentDeprecated != annotationDeprecated) {
                Errors.error(Errors.DEPRECATION_MISMATCH, this.position(), "Class " + this.qualifiedName() + ": @Deprecated annotation and @deprecated comment do not match");
            }
            this.mIsDeprecated = commentDeprecated | annotationDeprecated;
            this.mDeprecatedKnown = true;
        }
        return this.mIsDeprecated;
    }

    public TagInfo[] deprecatedTags() {
        return this.comment().deprecatedTags();
    }

    public MethodInfo[] methods() {
        if (this.mMethods == null) {
            MethodInfo[] methods;
            ClassInfo[] ifaces;
            TreeMap<String, MethodInfo> all = new TreeMap<String, MethodInfo>();
            for (ClassInfo iface : ifaces = this.interfaces()) {
                MethodInfo[] inhereted;
                if (iface == null) continue;
                for (MethodInfo method : inhereted = iface.methods()) {
                    String key = method.name() + method.signature();
                    all.put(key, method);
                }
            }
            ClassInfo superclass = this.superclass();
            if (superclass != null) {
                MethodInfo[] inhereted;
                for (MethodInfo method : inhereted = superclass.methods()) {
                    String key = method.name() + method.signature();
                    all.put(key, method);
                }
            }
            for (MethodInfo method : methods = this.selfMethods()) {
                String key = method.name() + method.signature();
                MethodInfo old = all.put(key, method);
            }
            this.mMethods = all.values().toArray(new MethodInfo[all.size()]);
        }
        return this.mMethods;
    }

    public MethodInfo[] annotationElements() {
        return this.mAnnotationElements;
    }

    public AnnotationInstanceInfo[] annotations() {
        return this.mAnnotations;
    }

    private static void addFields(ClassInfo cl, TreeMap<String, FieldInfo> all) {
        for (FieldInfo f : cl.fields()) {
            all.put(f.name(), f);
        }
    }

    public FieldInfo[] fields() {
        if (this.mFields == null) {
            TreeMap<String, FieldInfo> all = new TreeMap<String, FieldInfo>();
            ClassInfo[] interfaces = this.interfaces();
            int N = interfaces.length;
            for (int i = 0; i < N; ++i) {
                ClassInfo.addFields(interfaces[i], all);
            }
            ClassInfo superclass = this.superclass();
            if (superclass != null) {
                ClassInfo.addFields(superclass, all);
            }
            for (FieldInfo f : this.selfFields()) {
                if (f.isHidden()) continue;
                String key = f.name();
                all.put(key, f);
            }
            this.mFields = all.values().toArray(new FieldInfo[0]);
        }
        return this.mFields;
    }

    public void gatherFields(ClassInfo owner, ClassInfo cl, HashMap<String, FieldInfo> fields) {
        FieldInfo[] flds;
        for (FieldInfo f : flds = cl.selfFields()) {
            if (!f.checkLevel()) continue;
            fields.put(f.name(), f.cloneForClass(owner));
        }
    }

    public FieldInfo[] selfFields() {
        if (this.mSelfFields == null) {
            HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
            if (this.mRealSuperclass != null && !this.mRealSuperclass.checkLevel()) {
                this.gatherFields(this, this.mRealSuperclass, fields);
            }
            for (ClassInfo iface : this.mRealInterfaces) {
                if (iface.checkLevel()) continue;
                this.gatherFields(this, iface, fields);
            }
            FieldInfo[] selfFields = this.mAllSelfFields;
            for (int i = 0; i < selfFields.length; ++i) {
                FieldInfo f = selfFields[i];
                if (f.isHidden()) continue;
                fields.put(f.name(), f);
            }
            this.mSelfFields = fields.values().toArray(new FieldInfo[fields.size()]);
            Arrays.sort(this.mSelfFields, FieldInfo.comparator);
        }
        return this.mSelfFields;
    }

    public FieldInfo[] allSelfFields() {
        return this.mAllSelfFields;
    }

    public void gatherMethods(ClassInfo owner, ClassInfo cl, HashMap<String, MethodInfo> methods) {
        MethodInfo[] meth;
        for (MethodInfo m : meth = cl.selfMethods()) {
            if (!m.checkLevel()) continue;
            methods.put(m.name() + m.signature(), m.cloneForClass(owner));
        }
    }

    public MethodInfo[] selfMethods() {
        if (this.mSelfMethods == null) {
            HashMap<String, MethodInfo> methods = new HashMap<String, MethodInfo>();
            if (this.mRealSuperclass != null && !this.mRealSuperclass.checkLevel()) {
                this.gatherMethods(this, this.mRealSuperclass, methods);
            }
            for (ClassInfo iface : this.mRealInterfaces) {
                if (iface.checkLevel()) continue;
                this.gatherMethods(this, iface, methods);
            }
            MethodInfo[] selfMethods = this.mAllSelfMethods;
            for (int i = 0; i < selfMethods.length; ++i) {
                MethodInfo m = selfMethods[i];
                if (!m.checkLevel()) continue;
                methods.put(m.name() + m.signature(), m);
            }
            this.mSelfMethods = methods.values().toArray(new MethodInfo[methods.size()]);
            Arrays.sort(this.mSelfMethods, MethodInfo.comparator);
        }
        return this.mSelfMethods;
    }

    public MethodInfo[] allSelfMethods() {
        return this.mAllSelfMethods;
    }

    public void addMethod(MethodInfo method) {
        MethodInfo[] methods = new MethodInfo[this.mAllSelfMethods.length + 1];
        int i = 0;
        MethodInfo[] arr$ = this.mAllSelfMethods;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            MethodInfo m;
            methods[i] = m = arr$[i$];
            ++i;
        }
        methods[i] = method;
        this.mAllSelfMethods = methods;
    }

    public AttributeInfo[] selfAttributes() {
        if (this.mSelfAttributes == null) {
            AttributeInfo attr;
            FieldInfo field;
            TreeMap<FieldInfo, AttributeInfo> attrs = new TreeMap<FieldInfo, AttributeInfo>();
            for (AttrTagInfo attrTagInfo : this.comment().attrTags()) {
                FieldInfo field2 = attrTagInfo.reference();
                if (field2 == null) continue;
                AttributeInfo attr2 = (AttributeInfo)attrs.get(field2);
                if (attr2 == null) {
                    attr2 = new AttributeInfo(this, field2);
                    attrs.put(field2, attr2);
                }
                attrTagInfo.setAttribute(attr2);
            }
            for (MethodInfo methodInfo : this.selfMethods()) {
                for (AttrTagInfo tag : methodInfo.comment().attrTags()) {
                    field = tag.reference();
                    if (field == null) continue;
                    attr = (AttributeInfo)attrs.get(field);
                    if (attr == null) {
                        attr = new AttributeInfo(this, field);
                        attrs.put(field, attr);
                    }
                    tag.setAttribute(attr);
                    attr.methods.add(methodInfo);
                }
            }
            for (MethodInfo methodInfo : this.constructors()) {
                for (AttrTagInfo tag : methodInfo.comment().attrTags()) {
                    field = tag.reference();
                    if (field == null) continue;
                    attr = (AttributeInfo)attrs.get(field);
                    if (attr == null) {
                        attr = new AttributeInfo(this, field);
                        attrs.put(field, attr);
                    }
                    tag.setAttribute(attr);
                    attr.methods.add(methodInfo);
                }
            }
            this.mSelfAttributes = attrs.values().toArray(new AttributeInfo[attrs.size()]);
            Arrays.sort(this.mSelfAttributes, AttributeInfo.comparator);
        }
        return this.mSelfAttributes;
    }

    public FieldInfo[] enumConstants() {
        return this.mEnumConstants;
    }

    public ClassInfo superclass() {
        if (!this.mSuperclassInit) {
            if (this.checkLevel()) {
                ClassInfo superclass = this.mRealSuperclass;
                while (superclass != null && !superclass.checkLevel()) {
                    superclass = superclass.mRealSuperclass;
                }
                this.mSuperclass = superclass;
            } else {
                this.mSuperclass = this.mRealSuperclass;
            }
        }
        return this.mSuperclass;
    }

    public ClassInfo realSuperclass() {
        return this.mRealSuperclass;
    }

    public TypeInfo superclassType() {
        return this.mRealSuperclassType;
    }

    public TypeInfo asTypeInfo() {
        return this.mTypeInfo;
    }

    TypeInfo[] interfaceTypes() {
        ClassInfo[] infos = this.interfaces();
        int len = infos.length;
        TypeInfo[] types = new TypeInfo[len];
        for (int i = 0; i < len; ++i) {
            types[i] = infos[i].asTypeInfo();
        }
        return types;
    }

    public String htmlPage() {
        String s = this.containingPackage().name();
        s = s.replace('.', '/');
        s = s + '/';
        s = s + this.name();
        s = s + ".html";
        s = "reference/" + s;
        return s;
    }

    public boolean isDerivedFrom(ClassInfo cl) {
        ClassInfo dad = this.superclass();
        if (dad != null) {
            if (dad.equals(cl)) {
                return true;
            }
            if (dad.isDerivedFrom(cl)) {
                return true;
            }
        }
        for (ClassInfo iface : this.interfaces()) {
            if (iface.equals(cl)) {
                return true;
            }
            if (!iface.isDerivedFrom(cl)) continue;
            return true;
        }
        return false;
    }

    public void makeKeywordEntries(List<KeywordEntry> keywords) {
        if (!this.checkLevel()) {
            return;
        }
        String htmlPage = this.htmlPage();
        String qualifiedName = this.qualifiedName();
        keywords.add(new KeywordEntry(this.name(), htmlPage, "class in " + this.containingPackage().name()));
        FieldInfo[] fields = this.selfFields();
        FieldInfo[] enumConstants = this.enumConstants();
        MethodInfo[] ctors = this.constructors();
        MethodInfo[] methods = this.selfMethods();
        for (FieldInfo fieldInfo : this.enumConstants()) {
            if (!fieldInfo.checkLevel()) continue;
            keywords.add(new KeywordEntry(fieldInfo.name(), htmlPage + "#" + fieldInfo.anchor(), "enum constant in " + qualifiedName));
        }
        for (FieldInfo fieldInfo : fields) {
            if (!fieldInfo.isConstant() || !fieldInfo.checkLevel()) continue;
            keywords.add(new KeywordEntry(fieldInfo.name(), htmlPage + "#" + fieldInfo.anchor(), "constant in " + qualifiedName));
        }
        for (FieldInfo fieldInfo : fields) {
            if (fieldInfo.isConstant() || !fieldInfo.checkLevel()) continue;
            keywords.add(new KeywordEntry(fieldInfo.name(), htmlPage + "#" + fieldInfo.anchor(), "field in " + qualifiedName));
        }
        for (MemberInfo memberInfo : ctors) {
            if (!memberInfo.isPublic() || !memberInfo.checkLevel()) continue;
            keywords.add(new KeywordEntry(memberInfo.name() + ((MethodInfo)memberInfo).prettySignature(), htmlPage + "#" + memberInfo.anchor(), "constructor in " + qualifiedName));
        }
        if (DroidDoc.checkLevel(3)) {
            for (MemberInfo memberInfo : ctors) {
                if (!memberInfo.isProtected() || !memberInfo.checkLevel()) continue;
                keywords.add(new KeywordEntry(memberInfo.name() + ((MethodInfo)memberInfo).prettySignature(), htmlPage + "#" + memberInfo.anchor(), "constructor in " + qualifiedName));
            }
        }
        if (DroidDoc.checkLevel(7)) {
            for (MemberInfo memberInfo : ctors) {
                if (!memberInfo.isPackagePrivate() || !memberInfo.checkLevel()) continue;
                keywords.add(new KeywordEntry(memberInfo.name() + ((MethodInfo)memberInfo).prettySignature(), htmlPage + "#" + memberInfo.anchor(), "constructor in " + qualifiedName));
            }
        }
        if (DroidDoc.checkLevel(15)) {
            for (MemberInfo memberInfo : ctors) {
                if (!memberInfo.isPrivate() || !memberInfo.checkLevel()) continue;
                keywords.add(new KeywordEntry(memberInfo.name() + ((MethodInfo)memberInfo).prettySignature(), htmlPage + "#" + memberInfo.anchor(), "constructor in " + qualifiedName));
            }
        }
        for (MemberInfo memberInfo : methods) {
            if (!memberInfo.isPublic() || !memberInfo.checkLevel()) continue;
            keywords.add(new KeywordEntry(memberInfo.name() + ((MethodInfo)memberInfo).prettySignature(), htmlPage + "#" + memberInfo.anchor(), "method in " + qualifiedName));
        }
        if (DroidDoc.checkLevel(3)) {
            for (MemberInfo memberInfo : methods) {
                if (!memberInfo.isProtected() || !memberInfo.checkLevel()) continue;
                keywords.add(new KeywordEntry(memberInfo.name() + ((MethodInfo)memberInfo).prettySignature(), htmlPage + "#" + memberInfo.anchor(), "method in " + qualifiedName));
            }
        }
        if (DroidDoc.checkLevel(7)) {
            for (MemberInfo memberInfo : methods) {
                if (!memberInfo.isPackagePrivate() || !memberInfo.checkLevel()) continue;
                keywords.add(new KeywordEntry(memberInfo.name() + ((MethodInfo)memberInfo).prettySignature(), htmlPage + "#" + memberInfo.anchor(), "method in " + qualifiedName));
            }
        }
        if (DroidDoc.checkLevel(15)) {
            for (MemberInfo memberInfo : methods) {
                if (!memberInfo.isPrivate() || !memberInfo.checkLevel()) continue;
                keywords.add(new KeywordEntry(memberInfo.name() + ((MethodInfo)memberInfo).prettySignature(), htmlPage + "#" + memberInfo.anchor(), "method in " + qualifiedName));
            }
        }
    }

    public void makeLink(HDF data, String base) {
        data.setValue(base + ".label", this.name());
        if (!this.isPrimitive() && this.isIncluded() && this.checkLevel()) {
            data.setValue(base + ".link", this.htmlPage());
        }
    }

    public static void makeLinkListHDF(HDF data, String base, ClassInfo[] classes) {
        int N = classes.length;
        for (int i = 0; i < N; ++i) {
            ClassInfo cl = classes[i];
            if (!cl.checkLevel()) continue;
            cl.asTypeInfo().makeHDF(data, base + "." + i);
        }
    }

    public void makeShortDescrHDF(HDF data, String base) {
        this.mTypeInfo.makeHDF(data, base + ".type");
        data.setValue(base + ".kind", this.kind());
        TagInfo.makeHDF(data, base + ".shortDescr", this.firstSentenceTags());
        TagInfo.makeHDF(data, base + ".deprecated", this.deprecatedTags());
        data.setValue(base + ".since", this.getSince());
    }

    public void makeHDF(HDF data) {
        int i;
        ClassInfo supr;
        String kind;
        String name = this.name();
        String qualified = this.qualifiedName();
        AttributeInfo[] selfAttributes = this.selfAttributes();
        MethodInfo[] methods = this.selfMethods();
        FieldInfo[] fields = this.selfFields();
        FieldInfo[] enumConstants = this.enumConstants();
        MethodInfo[] ctors = this.constructors();
        ClassInfo[] inners = this.innerClasses();
        this.mTypeInfo.makeHDF(data, "class.type");
        this.mTypeInfo.makeQualifiedHDF(data, "class.qualifiedType");
        data.setValue("class.name", name);
        data.setValue("class.qualified", qualified);
        String scope = "";
        if (this.isProtected()) {
            data.setValue("class.scope", "protected");
        } else if (this.isPublic()) {
            data.setValue("class.scope", "public");
        }
        if (this.isStatic()) {
            data.setValue("class.static", "static");
        }
        if (this.isFinal()) {
            data.setValue("class.final", "final");
        }
        if (this.isAbstract() && !this.isInterface()) {
            data.setValue("class.abstract", "abstract");
        }
        if ((kind = this.kind()) != null) {
            data.setValue("class.kind", kind);
        }
        data.setValue("class.since", this.getSince());
        this.containingPackage().makeClassLinkListHDF(data, "class.package");
        Vector<ClassInfo> superClasses = new Vector<ClassInfo>();
        superClasses.add(this);
        for (supr = this.superclass(); supr != null; supr = supr.superclass()) {
            superClasses.add(supr);
        }
        int n = superClasses.size();
        for (i = 0; i < n; ++i) {
            supr = (ClassInfo)superClasses.elementAt(n - i - 1);
            supr.asTypeInfo().makeQualifiedHDF(data, "class.inheritance." + i + ".class");
            supr.asTypeInfo().makeHDF(data, "class.inheritance." + i + ".short_class");
            int j = 0;
            for (TypeInfo t : supr.interfaceTypes()) {
                t.makeHDF(data, "class.inheritance." + i + ".interfaces." + j);
                ++j;
            }
        }
        TagInfo.makeHDF(data, "class.descr", this.inlineTags());
        TagInfo.makeHDF(data, "class.seeAlso", this.comment().seeTags());
        TagInfo.makeHDF(data, "class.deprecated", this.deprecatedTags());
        TreeMap<String, ClassInfo> direct = new TreeMap<String, ClassInfo>();
        TreeMap<String, ClassInfo> indirect = new TreeMap<String, ClassInfo>();
        ClassInfo[] all = Converter.rootClasses();
        for (ClassInfo classInfo : all) {
            if (classInfo.superclass() != null && classInfo.superclass().equals(this)) {
                direct.put(classInfo.name(), classInfo);
                continue;
            }
            if (!classInfo.isDerivedFrom(this)) continue;
            indirect.put(classInfo.name(), classInfo);
        }
        i = 0;
        for (ClassInfo cl : direct.values()) {
            if (cl.checkLevel()) {
                cl.makeShortDescrHDF(data, "class.subclasses.direct." + i);
            }
            ++i;
        }
        i = 0;
        for (ClassInfo cl : indirect.values()) {
            if (cl.checkLevel()) {
                cl.makeShortDescrHDF(data, "class.subclasses.indirect." + i);
            }
            ++i;
        }
        i = 0;
        for (ClassInfo classInfo : inners) {
            if (classInfo.checkLevel()) {
                classInfo.makeShortDescrHDF(data, "class.inners." + i);
            }
            ++i;
        }
        i = 0;
        for (DocInfo docInfo : enumConstants) {
            if (!((FieldInfo)docInfo).isConstant()) continue;
            ((FieldInfo)docInfo).makeHDF(data, "class.enumConstants." + i);
            ++i;
        }
        i = 0;
        for (DocInfo docInfo : fields) {
            if (!((FieldInfo)docInfo).isConstant()) continue;
            ((FieldInfo)docInfo).makeHDF(data, "class.constants." + i);
            ++i;
        }
        i = 0;
        for (DocInfo docInfo : fields) {
            if (((FieldInfo)docInfo).isConstant()) continue;
            ((FieldInfo)docInfo).makeHDF(data, "class.fields." + i);
            ++i;
        }
        i = 0;
        for (DocInfo docInfo : ctors) {
            if (!((MemberInfo)docInfo).isPublic()) continue;
            ((MethodInfo)docInfo).makeHDF(data, "class.ctors.public." + i);
            ++i;
        }
        if (DroidDoc.checkLevel(3)) {
            i = 0;
            for (DocInfo docInfo : ctors) {
                if (!((MemberInfo)docInfo).isProtected()) continue;
                ((MethodInfo)docInfo).makeHDF(data, "class.ctors.protected." + i);
                ++i;
            }
        }
        if (DroidDoc.checkLevel(7)) {
            i = 0;
            for (DocInfo docInfo : ctors) {
                if (!((MemberInfo)docInfo).isPackagePrivate()) continue;
                ((MethodInfo)docInfo).makeHDF(data, "class.ctors.package." + i);
                ++i;
            }
        }
        if (DroidDoc.checkLevel(15)) {
            i = 0;
            for (DocInfo docInfo : ctors) {
                if (!((MemberInfo)docInfo).isPrivate()) continue;
                ((MethodInfo)docInfo).makeHDF(data, "class.ctors.private." + i);
                ++i;
            }
        }
        i = 0;
        for (DocInfo docInfo : methods) {
            if (!((MemberInfo)docInfo).isPublic()) continue;
            ((MethodInfo)docInfo).makeHDF(data, "class.methods.public." + i);
            ++i;
        }
        if (DroidDoc.checkLevel(3)) {
            i = 0;
            for (MethodInfo methodInfo : methods) {
                if (!methodInfo.isProtected()) continue;
                methodInfo.makeHDF(data, "class.methods.protected." + i);
                ++i;
            }
        }
        if (DroidDoc.checkLevel(7)) {
            i = 0;
            for (MethodInfo methodInfo : methods) {
                if (!methodInfo.isPackagePrivate()) continue;
                methodInfo.makeHDF(data, "class.methods.package." + i);
                ++i;
            }
        }
        if (DroidDoc.checkLevel(15)) {
            i = 0;
            for (MethodInfo methodInfo : methods) {
                if (!methodInfo.isPrivate()) continue;
                methodInfo.makeHDF(data, "class.methods.private." + i);
                ++i;
            }
        }
        i = 0;
        for (AttributeInfo attributeInfo : selfAttributes) {
            if (!attributeInfo.checkLevel()) continue;
            attributeInfo.makeHDF(data, "class.attrs." + i);
            ++i;
        }
        TreeSet<ClassInfo> interfaces = new TreeSet<ClassInfo>();
        ClassInfo.addInterfaces(this.interfaces(), interfaces);
        ClassInfo cl = this.superclass();
        i = 0;
        while (cl != null) {
            ClassInfo.addInterfaces(cl.interfaces(), interfaces);
            ClassInfo.makeInheritedHDF(data, i, cl);
            cl = cl.superclass();
            ++i;
        }
        for (ClassInfo classInfo : interfaces) {
            ClassInfo.makeInheritedHDF(data, i, classInfo);
            ++i;
        }
    }

    private static void addInterfaces(ClassInfo[] ifaces, Set<ClassInfo> out) {
        for (ClassInfo cl : ifaces) {
            out.add(cl);
            ClassInfo.addInterfaces(cl.interfaces(), out);
        }
    }

    private static void makeInheritedHDF(HDF data, int index, ClassInfo cl) {
        String kind;
        String base = "class.inherited." + index;
        data.setValue(base + ".qualified", cl.qualifiedName());
        if (cl.checkLevel()) {
            data.setValue(base + ".link", cl.htmlPage());
        }
        if ((kind = cl.kind()) != null) {
            data.setValue(base + ".kind", kind);
        }
        if (cl.mIsIncluded) {
            data.setValue(base + ".included", "true");
        }
        int i = 0;
        for (AttributeInfo attributeInfo : cl.selfAttributes()) {
            attributeInfo.makeHDF(data, base + ".attrs." + i);
            ++i;
        }
        i = 0;
        for (MethodInfo methodInfo : cl.selfMethods()) {
            methodInfo.makeHDF(data, base + ".methods." + i);
            ++i;
        }
        i = 0;
        for (FieldInfo fieldInfo : cl.selfFields()) {
            if (fieldInfo.isConstant()) continue;
            fieldInfo.makeHDF(data, base + ".fields." + i);
            ++i;
        }
        i = 0;
        for (FieldInfo fieldInfo : cl.selfFields()) {
            if (!fieldInfo.isConstant()) continue;
            fieldInfo.makeHDF(data, base + ".constants." + i);
            ++i;
        }
    }

    @Override
    public boolean isHidden() {
        int val = this.mHidden;
        if (val >= 0) {
            return val != 0;
        }
        boolean v = this.isHiddenImpl();
        this.mHidden = v ? 1 : 0;
        return v;
    }

    public boolean isHiddenImpl() {
        for (ClassInfo cl = this; cl != null; cl = cl.containingClass()) {
            PackageInfo pkg = cl.containingPackage();
            if (pkg != null && pkg.isHidden()) {
                return true;
            }
            if (!cl.comment().isHidden()) continue;
            return true;
        }
        return false;
    }

    private MethodInfo matchMethod(MethodInfo[] methods, String name, String[] params, String[] dimensions) {
        for (MethodInfo method : methods) {
            if (!method.name().equals(name)) continue;
            if (params == null) {
                return method;
            }
            if (!method.matchesParams(params, dimensions)) continue;
            return method;
        }
        return null;
    }

    public MethodInfo findMethod(String name, String[] params, String[] dimensions) {
        MethodInfo rv = this.matchMethod(this.methods(), name, params, dimensions);
        if (rv != null) {
            return rv;
        }
        rv = this.matchMethod(this.constructors(), name, params, dimensions);
        if (rv != null) {
            return rv;
        }
        ClassInfo containing = this.containingClass();
        if (containing != null) {
            return containing.findMethod(name, params, dimensions);
        }
        return null;
    }

    private ClassInfo searchInnerClasses(String[] nameParts, int index) {
        ClassInfo[] inners;
        String part = nameParts[index];
        for (ClassInfo in : inners = this.mInnerClasses) {
            String[] innerParts = in.nameParts();
            if (!part.equals(innerParts[innerParts.length - 1])) continue;
            if (index == nameParts.length - 1) {
                return in;
            }
            return in.searchInnerClasses(nameParts, index + 1);
        }
        return null;
    }

    public ClassInfo extendedFindClass(String className) {
        return this.searchInnerClasses(className.split("\\."), 0);
    }

    public ClassInfo findClass(String className) {
        return Converter.obtainClass(this.mClass.findClass(className));
    }

    public ClassInfo findInnerClass(String className) {
        String[] nodes = className.split("\\.");
        ClassDoc cl = this.mClass;
        for (String n : nodes) {
            if ((cl = cl.findClass(n)) != null) continue;
            return null;
        }
        return Converter.obtainClass(cl);
    }

    public FieldInfo findField(String name) {
        for (FieldInfo f : this.fields()) {
            if (!f.name().equals(name)) continue;
            return f;
        }
        for (FieldInfo f : this.enumConstants()) {
            if (!f.name().equals(name)) continue;
            return f;
        }
        ClassInfo containing = this.containingClass();
        if (containing != null) {
            return containing.findField(name);
        }
        return null;
    }

    public static ClassInfo[] sortByName(ClassInfo[] classes) {
        int i;
        Object[] sorted = new Sorter[classes.length];
        for (i = 0; i < sorted.length; ++i) {
            ClassInfo cl = classes[i];
            sorted[i] = new Sorter(cl.name(), cl);
        }
        Arrays.sort(sorted);
        ClassInfo[] rv = new ClassInfo[classes.length];
        for (i = 0; i < rv.length; ++i) {
            rv[i] = (ClassInfo)((Sorter)sorted[i]).data;
        }
        return rv;
    }

    public boolean equals(ClassInfo that) {
        if (that != null) {
            return this.qualifiedName().equals(that.qualifiedName());
        }
        return false;
    }

    public void setNonWrittenConstructors(MethodInfo[] nonWritten) {
        this.mNonWrittenConstructors = nonWritten;
    }

    public MethodInfo[] getNonWrittenConstructors() {
        return this.mNonWrittenConstructors;
    }

    public String kind() {
        if (this.isOrdinaryClass()) {
            return "class";
        }
        if (this.isInterface()) {
            return "interface";
        }
        if (this.isEnum()) {
            return "enum";
        }
        if (this.isError()) {
            return "class";
        }
        if (this.isException()) {
            return "class";
        }
        if (this.isAnnotation()) {
            return "@interface";
        }
        return null;
    }

    public void setHiddenMethods(MethodInfo[] mInfo) {
        this.mHiddenMethods = mInfo;
    }

    public MethodInfo[] getHiddenMethods() {
        return this.mHiddenMethods;
    }

    public String toString() {
        return this.qualifiedName();
    }

    public void setReasonIncluded(String reason) {
        this.mReasonIncluded = reason;
    }

    public String getReasonIncluded() {
        return this.mReasonIncluded;
    }
}

