/*
 * Decompiled with CFR 0.152.
 */
package com.android.dexdeps;

import com.android.dexdeps.ClassRef;
import com.android.dexdeps.DexData;
import com.android.dexdeps.FieldRef;
import com.android.dexdeps.MethodRef;

public class Output {
    private static final String IN0 = "";
    private static final String IN1 = "  ";
    private static final String IN2 = "    ";
    private static final String IN3 = "      ";
    private static final String IN4 = "        ";

    public static void generate(DexData dexData, String format) {
        if (format.equals("brief")) {
            Output.printBrief(dexData);
        } else if (format.equals("xml")) {
            Output.printXml(dexData);
        } else {
            throw new RuntimeException("unknown output format");
        }
    }

    static void printBrief(DexData dexData) {
        ClassRef[] externClassRefs = dexData.getExternalReferences();
        Output.printClassRefs(externClassRefs);
        Output.printFieldRefs(externClassRefs);
        Output.printMethodRefs(externClassRefs);
    }

    static void printClassRefs(ClassRef[] classes) {
        System.out.println("Classes:");
        for (int i = 0; i < classes.length; ++i) {
            ClassRef ref = classes[i];
            System.out.println(Output.descriptorToDot(ref.getName()));
        }
    }

    static void printFieldRefs(ClassRef[] classes) {
        System.out.println("\nFields:");
        for (int i = 0; i < classes.length; ++i) {
            FieldRef[] fields = classes[i].getFieldArray();
            for (int j = 0; j < fields.length; ++j) {
                FieldRef ref = fields[j];
                System.out.println(Output.descriptorToDot(ref.getDeclClassName()) + "." + ref.getName() + " : " + ref.getTypeName());
            }
        }
    }

    static void printMethodRefs(ClassRef[] classes) {
        System.out.println("\nMethods:");
        for (int i = 0; i < classes.length; ++i) {
            MethodRef[] methods = classes[i].getMethodArray();
            for (int j = 0; j < methods.length; ++j) {
                MethodRef ref = methods[j];
                System.out.println(Output.descriptorToDot(ref.getDeclClassName()) + "." + ref.getName() + " : " + ref.getDescriptor());
            }
        }
    }

    static void printXml(DexData dexData) {
        ClassRef[] externClassRefs = dexData.getExternalReferences();
        System.out.println("<external>");
        String prevPackage = null;
        for (int i = 0; i < externClassRefs.length; ++i) {
            ClassRef cref = externClassRefs[i];
            String declClassName = cref.getName();
            String className = Output.classNameOnly(declClassName);
            String packageName = Output.packageNameOnly(declClassName);
            if (!packageName.equals(prevPackage)) {
                if (prevPackage != null) {
                    System.out.println("  </package>");
                }
                System.out.println("  <package name=\"" + packageName + "\">");
                prevPackage = packageName;
            }
            System.out.println("    <class name=\"" + className + "\">");
            Output.printXmlFields(cref);
            Output.printXmlMethods(cref);
            System.out.println("    </class>");
        }
        if (prevPackage != null) {
            System.out.println("  </package>");
        }
        System.out.println("</external>");
    }

    private static void printXmlFields(ClassRef cref) {
        FieldRef[] fields = cref.getFieldArray();
        for (int i = 0; i < fields.length; ++i) {
            FieldRef fref = fields[i];
            System.out.println("      <field name=\"" + fref.getName() + "\" type=\"" + Output.descriptorToDot(fref.getTypeName()) + "\"/>");
        }
    }

    private static void printXmlMethods(ClassRef cref) {
        MethodRef[] methods = cref.getMethodArray();
        for (int i = 0; i < methods.length; ++i) {
            MethodRef mref = methods[i];
            String declClassName = mref.getDeclClassName();
            boolean constructor = mref.getName().equals("<init>");
            if (constructor) {
                System.out.println("      <constructor name=\"" + Output.classNameOnly(declClassName) + "\">");
            } else {
                System.out.println("      <method name=\"" + mref.getName() + "\" return=\"" + Output.descriptorToDot(mref.getReturnTypeName()) + "\">");
            }
            String[] args = mref.getArgumentTypeNames();
            for (int j = 0; j < args.length; ++j) {
                System.out.println("        <parameter type=\"" + Output.descriptorToDot(args[j]) + "\"/>");
            }
            if (constructor) {
                System.out.println("      </constructor>");
                continue;
            }
            System.out.println("      </method>");
        }
    }

    static String primitiveTypeLabel(char typeChar) {
        switch (typeChar) {
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
        }
        System.err.println("Unexpected class char " + typeChar);
        assert (false);
        return "UNKNOWN";
    }

    static String descriptorToDot(String descr) {
        int i;
        int targetLen;
        int offset = 0;
        int arrayDepth = 0;
        for (targetLen = descr.length(); targetLen > 1 && descr.charAt(offset) == '['; --targetLen) {
            ++offset;
        }
        arrayDepth = offset;
        if (targetLen == 1) {
            descr = Output.primitiveTypeLabel(descr.charAt(offset));
            offset = 0;
            targetLen = descr.length();
        } else if (targetLen >= 2 && descr.charAt(offset) == 'L' && descr.charAt(offset + targetLen - 1) == ';') {
            targetLen -= 2;
            ++offset;
        }
        char[] buf = new char[targetLen + arrayDepth * 2];
        for (i = 0; i < targetLen; ++i) {
            char ch = descr.charAt(offset + i);
            buf[i] = ch == '/' ? 46 : (int)ch;
        }
        while (arrayDepth-- > 0) {
            buf[i++] = 91;
            buf[i++] = 93;
        }
        assert (i == buf.length);
        return new String(buf);
    }

    static String classNameOnly(String typeName) {
        String dotted = Output.descriptorToDot(typeName);
        int start = dotted.lastIndexOf(".");
        if (start < 0) {
            return dotted;
        }
        return dotted.substring(start + 1);
    }

    static String packageNameOnly(String typeName) {
        String dotted = Output.descriptorToDot(typeName);
        int end = dotted.lastIndexOf(".");
        if (end < 0) {
            return IN0;
        }
        return dotted.substring(0, end);
    }
}

