/*
 * Decompiled with CFR 0.152.
 */
package com.android.dexdeps;

import com.android.dexdeps.DexData;
import com.android.dexdeps.DexDataException;
import com.android.dexdeps.Output;
import com.android.dexdeps.UsageException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class Main {
    private static final String CLASSES_DEX = "classes.dex";
    private String mInputFileName;
    private String mOutputFormat = "xml";

    public static void main(String[] args) {
        Main main = new Main();
        main.run(args);
    }

    void run(String[] args) {
        try {
            this.parseArgs(args);
            RandomAccessFile raf = this.openInputFile();
            DexData dexData = new DexData(raf);
            dexData.load();
            Output.generate(dexData, this.mOutputFormat);
        }
        catch (UsageException ue) {
            this.usage();
            System.exit(2);
        }
        catch (IOException ioe) {
            if (ioe.getMessage() != null) {
                System.err.println("Failed: " + ioe);
            }
            System.exit(1);
        }
        catch (DexDataException dde) {
            System.exit(1);
        }
    }

    RandomAccessFile openInputFile() throws IOException {
        RandomAccessFile raf = this.openInputFileAsZip();
        if (raf == null) {
            File inputFile = new File(this.mInputFileName);
            raf = new RandomAccessFile(inputFile, "r");
        }
        return raf;
    }

    RandomAccessFile openInputFileAsZip() throws IOException {
        int actual;
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(this.mInputFileName);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Unable to open '" + this.mInputFileName + "': " + fnfe.getMessage());
            throw fnfe;
        }
        catch (ZipException ze) {
            return null;
        }
        ZipEntry entry = zipFile.getEntry(CLASSES_DEX);
        if (entry == null) {
            System.err.println("Unable to find 'classes.dex' in '" + this.mInputFileName + "'");
            zipFile.close();
            throw new ZipException();
        }
        InputStream zis = zipFile.getInputStream(entry);
        File tempFile = File.createTempFile("dexdeps", ".dex");
        RandomAccessFile raf = new RandomAccessFile(tempFile, "rw");
        tempFile.delete();
        byte[] copyBuf = new byte[32768];
        while ((actual = zis.read(copyBuf)) != -1) {
            raf.write(copyBuf, 0, actual);
        }
        zis.close();
        raf.seek(0L);
        return raf;
    }

    void parseArgs(String[] args) {
        String arg;
        int idx;
        for (idx = 0; idx < args.length && !(arg = args[idx]).equals("--") && arg.startsWith("--"); ++idx) {
            if (arg.startsWith("--format=")) {
                this.mOutputFormat = arg.substring(arg.indexOf(61) + 1);
                if (this.mOutputFormat.equals("brief") || this.mOutputFormat.equals("xml")) continue;
                System.err.println("Unknown format '" + this.mOutputFormat + "'");
                throw new UsageException();
            }
            System.err.println("Unknown option '" + arg + "'");
            throw new UsageException();
        }
        if (idx != args.length - 1) {
            throw new UsageException();
        }
        this.mInputFileName = args[idx];
    }

    void usage() {
        System.err.println("DEX dependency scanner v1.1");
        System.err.println("Copyright (C) 2009 The Android Open Source Project\n");
        System.err.println("Usage: dexdeps [options] <file.{dex,apk,jar}>");
        System.err.println("Options:");
        System.err.println("  --format={xml,brief}");
    }
}

