/*
 * Decompiled with CFR 0.152.
 */
package dex.structure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DexEncodedValueType {
    VALUE_BYTE(0),
    VALUE_SHORT(2),
    VALUE_CHAR(3),
    VALUE_INT(4),
    VALUE_LONG(6),
    VALUE_FLOAT(16),
    VALUE_DOUBLE(17),
    VALUE_STRING(23),
    VALUE_TYPE(24),
    VALUE_FIELD(25),
    VALUE_METHOD(26),
    VALUE_ENUM(27),
    VALUE_ARRAY(28),
    VALUE_ANNOTATION(29),
    VALUE_NULL(30),
    VALUE_BOOLEAN(31);

    private byte value;

    private DexEncodedValueType(byte value) {
        this.value = value;
    }

    public static DexEncodedValueType get(byte value) {
        for (DexEncodedValueType type : DexEncodedValueType.values()) {
            if (type.value != (value & 0x1F)) continue;
            return type;
        }
        throw new IllegalArgumentException("Type does not exist!");
    }

    public static byte valueArg(byte value) {
        return (byte)(value >>> 5);
    }
}

