/*
 * Decompiled with CFR 0.152.
 */
package dex.reader;

import dex.reader.DexAnnotationImpl;
import dex.reader.DexBuffer;
import dex.reader.DexFileReader;
import dex.structure.DexAnnotation;
import dex.structure.DexParameter;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DexParameterImpl
implements DexParameter {
    private final String typeName;
    private final Integer annotationOffset;
    private Set<DexAnnotation> annotations;
    private final DexBuffer buffer;
    private final int[] typeIds;
    private final String[] stringPool;
    private final DexFileReader.FieldIdItem[] fieldIdItems;

    public DexParameterImpl(DexBuffer buffer, String typeName, Integer annotationOffset, int[] typeIds, String[] stringPool, DexFileReader.FieldIdItem[] fieldIdItems) {
        this.buffer = buffer;
        this.typeName = typeName;
        this.annotationOffset = annotationOffset;
        this.typeIds = typeIds;
        this.stringPool = stringPool;
        this.fieldIdItems = fieldIdItems;
        this.parseAnnotations();
    }

    private void parseAnnotations() {
        this.annotations = new HashSet<DexAnnotation>();
        if (this.annotationOffset != null) {
            this.buffer.setPosition(this.annotationOffset);
            int size = this.buffer.readUInt();
            for (int i = 0; i < size; ++i) {
                this.annotations.add(new DexAnnotationImpl(this.buffer.createCopy(), this.buffer.readUInt(), this.typeIds, this.stringPool, this.fieldIdItems));
            }
        }
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public Set<DexAnnotation> getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return this.getTypeName();
    }
}

